/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.impl;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.IDirectPositionIterator;
import com.mapinfo.midev.geometry.IDirectPositionList;
import com.mapinfo.midev.geometry.IDirectPositionMutator;
import com.mapinfo.midev.geometry.MValue;
import com.mapinfo.midev.util.ArgumentValidator;
import java.util.ConcurrentModificationException;

public final class XYDirectPositionArray
implements IDirectPositionList {
    private double[] m_x;
    private double[] m_y;
    private int m_size = 0;
    private long m_modCount = 0L;
    private static final int CAPACITY_GROWTH_FACTOR = 2;
    private static final int CAPACITY_MINIMUM = 16;

    public XYDirectPositionArray() {
        this(0);
    }

    public XYDirectPositionArray(int initialSize) {
        this.initializeCapacity(initialSize);
    }

    public XYDirectPositionArray(DirectPosition ... dpArray) {
        this.initializeCapacity(dpArray.length);
        for (DirectPosition dp : dpArray) {
            this._add(dp.getX(), dp.getY());
        }
        this.m_size = dpArray.length;
    }

    public XYDirectPositionArray(XYDirectPositionArray dpa) {
        this.initializeFromDirectPositionArray(dpa);
    }

    private void initializeFromDirectPositionArray(XYDirectPositionArray dpa) {
        this.initializeCapacity(dpa.m_size);
        this.m_size = dpa.m_size;
        System.arraycopy(dpa.m_x, 0, this.m_x, 0, this.m_size);
        System.arraycopy(dpa.m_y, 0, this.m_y, 0, this.m_size);
    }

    public XYDirectPositionArray(IDirectPositionList dplist) {
        if (dplist instanceof XYDirectPositionArray) {
            this.initializeFromDirectPositionArray((XYDirectPositionArray)dplist);
        } else {
            this.initializeCapacity(dplist.size());
            DirectPosition dp = new DirectPosition();
            IDirectPositionIterator i = dplist.getDirectPositionIterator();
            while (i.hasNext()) {
                i.nextDirectPosition(dp);
                this._add(dp.getX(), dp.getY());
            }
            this.m_size = dplist.size();
        }
    }

    public XYDirectPositionArray(double[] xArray, double[] yArray, int length) {
        this.initializeCapacity(length);
        System.arraycopy(xArray, 0, this.m_x, 0, length);
        System.arraycopy(yArray, 0, this.m_y, 0, length);
        this.m_size = length;
    }

    @Override
    public IDirectPositionIterator getDirectPositionIterator() {
        return new DPIterator(this.m_modCount);
    }

    @Override
    public DirectPosition getDirectPosition(int index, DirectPosition dp) {
        this.verifyIndex(index, false);
        dp.set(this.m_x[index], this.m_y[index], Double.NaN, null);
        return dp;
    }

    @Override
    public int size() {
        return this.m_size;
    }

    @Override
    public void remove(int index) {
        this.verifyIndex(index, false);
        ++this.m_modCount;
        int srcPos = index + 1;
        int length = this.m_size - index - 1;
        if (length != 0) {
            System.arraycopy(this.m_x, srcPos, this.m_x, index, length);
            System.arraycopy(this.m_y, srcPos, this.m_y, index, length);
        }
        --this.m_size;
    }

    public double getX(int index) {
        this.verifyIndex(index, false);
        return this.m_x[index];
    }

    public double getY(int index) {
        this.verifyIndex(index, false);
        return this.m_y[index];
    }

    public double getZ(int index) {
        return Double.NaN;
    }

    public MValue getM(int index) {
        return null;
    }

    @Override
    public void set(int index, DirectPosition dp) {
        this.set(index, dp.getX(), dp.getY(), dp.getZ(), dp.getM());
    }

    @Override
    public void set(int index, double x, double y) {
        this.verifyIndex(index, false);
        this._set(index, x, y);
    }

    @Override
    public void set(int index, double x, double y, double z) throws UnsupportedOperationException {
        this.set(index, x, y);
    }

    @Override
    public void set(int index, double x, double y, MValue m) throws UnsupportedOperationException {
        this.set(index, x, y);
    }

    @Override
    public void set(int index, double x, double y, double z, MValue m) throws UnsupportedOperationException {
        this.set(index, x, y);
    }

    private void verifyIndex(int index, boolean upperBoundInclusive) {
        if (upperBoundInclusive) {
            ArgumentValidator.assertNotOutOfRange((String)"index", (double)index, (double)0.0, (double)this.m_size);
        } else {
            ArgumentValidator.assertNotOutOfRangeMinimum((String)"index", (double)index, (double)0.0);
            ArgumentValidator.assertNotOutOfRangeStrictMaximum((String)"index", (double)index, (double)this.m_size);
        }
    }

    private void _set(int index, double x, double y) {
        this.m_x[index] = x;
        this.m_y[index] = y;
    }

    @Override
    public void add(int index, DirectPosition dp) {
        this.add(index, dp.getX(), dp.getY(), dp.getZ(), dp.getM());
    }

    @Override
    public void add(int index, double x, double y) {
        this.verifyIndex(index, true);
        ++this.m_modCount;
        this.ensureCapacity(this.m_size + 1);
        this.shiftRight(index, 1);
        ++this.m_size;
        this._set(index, x, y);
    }

    @Override
    public void add(int index, double x, double y, double z) throws UnsupportedOperationException {
        this.add(index, x, y);
    }

    @Override
    public void add(int index, double x, double y, MValue m) throws UnsupportedOperationException {
        this.add(index, x, y);
    }

    @Override
    public void add(int index, double x, double y, double z, MValue m) throws UnsupportedOperationException {
        this.add(index, x, y);
    }

    private void initializeCapacity(int initialCapacity) {
        this.m_x = new double[initialCapacity];
        this.m_y = new double[initialCapacity];
    }

    private void ensureCapacity(int requiredCapacity) {
        if (requiredCapacity <= this.m_x.length) {
            return;
        }
        int newCapacity = this.m_x.length;
        while (requiredCapacity > newCapacity) {
            int num = 2 * newCapacity;
            newCapacity = Math.max(num, 16);
        }
        if (newCapacity > this.m_x.length) {
            double[] tmp = new double[newCapacity];
            System.arraycopy(this.m_x, 0, tmp, 0, this.m_size);
            this.m_x = tmp;
            tmp = new double[newCapacity];
            System.arraycopy(this.m_y, 0, tmp, 0, this.m_size);
            this.m_y = tmp;
        }
    }

    private void shiftRight(int index, int count) {
        int destIndex = index + count;
        int len = this.m_size - index;
        if (len != 0) {
            System.arraycopy(this.m_x, index, this.m_x, destIndex, len);
            System.arraycopy(this.m_y, index, this.m_y, destIndex, len);
        }
    }

    @Override
    public int indexOf(DirectPosition dp) {
        int index = -1;
        DirectPosition dpTmp = new DirectPosition();
        for (int k = 0; k < this.m_size && index == -1; ++k) {
            dpTmp.set(this.m_x[k], this.m_y[k], Double.NaN, null);
            if (!dp.equals((Object)dpTmp)) continue;
            index = k;
        }
        return index;
    }

    @Override
    public int lastIndexOf(DirectPosition dp) {
        int index = -1;
        DirectPosition dpTmp = new DirectPosition();
        for (int k = this.m_size - 1; k >= 0 && index == -1; --k) {
            dpTmp.set(this.m_x[k], this.m_y[k], Double.NaN, null);
            if (!dp.equals((Object)dpTmp)) continue;
            index = k;
        }
        return index;
    }

    @Override
    public void add(DirectPosition dp) {
        this.add(dp.getX(), dp.getY());
    }

    @Override
    public void add(double x, double y) {
        ++this.m_modCount;
        this.ensureCapacity(this.m_size + 1);
        this._add(x, y);
    }

    @Override
    public void add(double x, double y, double z) throws UnsupportedOperationException {
        this.add(x, y);
    }

    @Override
    public void add(double x, double y, MValue m) throws UnsupportedOperationException {
        this.add(x, y);
    }

    @Override
    public void add(double x, double y, double z, MValue m) throws UnsupportedOperationException {
        this.add(x, y);
    }

    private void _add(double x, double y) {
        this.m_x[this.m_size] = x;
        this.m_y[this.m_size] = y;
        ++this.m_size;
    }

    @Override
    public boolean contains(DirectPosition dp) {
        return this.indexOf(dp) != -1;
    }

    public void addAll(int index, IDirectPositionList dpl) {
        this.verifyIndex(index, true);
        this.ensureCapacity(this.m_size + dpl.size());
        ++this.m_modCount;
        this.shiftRight(index, dpl.size());
        this.m_size += dpl.size();
        IDirectPositionIterator iter = dpl.getDirectPositionIterator();
        DirectPosition dp = new DirectPosition();
        int pos = index;
        while (iter.hasNext()) {
            iter.nextDirectPosition(dp);
            this._set(pos++, dp.getX(), dp.getY());
        }
    }

    @Override
    public void addAll(IDirectPositionList dpl) {
        if (dpl.isEmpty()) {
            return;
        }
        this.ensureCapacity(this.m_size + dpl.size());
        ++this.m_modCount;
        if (dpl instanceof XYDirectPositionArray) {
            XYDirectPositionArray dpa = (XYDirectPositionArray)dpl;
            System.arraycopy(dpa.m_x, 0, this.m_x, this.m_size, dpa.m_size);
            System.arraycopy(dpa.m_y, 0, this.m_y, this.m_size, dpa.m_size);
            this.m_size += dpa.size();
        }
        DirectPosition dp = new DirectPosition();
        IDirectPositionIterator dpIter = dpl.getDirectPositionIterator();
        while (dpIter.hasNext()) {
            dp = dpIter.nextDirectPosition(dp);
            this._add(dp.getX(), dp.getY());
        }
    }

    @Override
    public void clear() {
        this.m_size = 0;
        ++this.m_modCount;
    }

    @Override
    public boolean isEmpty() {
        return this.m_size == 0;
    }

    @Override
    public void applyMutator(IDirectPositionMutator dpm) {
        DirectPosition dp = new DirectPosition();
        for (int k = 0; k < this.m_size; ++k) {
            dp.setXY(this.m_x[k], this.m_y[k]);
            dpm.transform(dp, dp);
            this._set(k, dp.getX(), dp.getY());
        }
    }

    public XYDirectPositionArray getCopy() {
        return new XYDirectPositionArray(this);
    }

    public XYDirectPositionArray getCopy(IDirectPositionMutator dpMutator) {
        XYDirectPositionArray dpa = new XYDirectPositionArray(this);
        dpa.change(dpMutator);
        return dpa;
    }

    void change(IDirectPositionMutator dpMutator) {
        DirectPosition dp = new DirectPosition();
        for (int k = 0; k < this.m_size; ++k) {
            dp.setXY(this.m_x[k], this.m_y[k]);
            dp = dpMutator.transform(dp, dp);
            this._set(k, dp.getX(), dp.getY());
        }
    }

    @Override
    public boolean zSet() {
        return false;
    }

    @Override
    public boolean zAllSet() {
        return false;
    }

    @Override
    public boolean mSet() {
        return false;
    }

    @Override
    public boolean mAllSet() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public XYDirectPositionArray reverse() {
        double[] x = new double[this.size()];
        double[] y = new double[this.size()];
        int left = 0;
        for (int right = this.size() - 1; left < right; ++left, --right) {
            x[left] = this.m_x[right];
            x[right] = this.m_x[left];
            y[left] = this.m_y[right];
            y[right] = this.m_y[left];
        }
        if (this.size() % 2 != 0) {
            int index = this.size() / 2;
            x[index] = this.m_x[index];
            y[index] = this.m_y[index];
        }
        return new XYDirectPositionArray(x, y, this.size());
    }

    private final class DPIterator
    implements IDirectPositionIterator {
        final long m_expectedModCount;
        int m_next = 0;

        public DPIterator(long modCount) {
            this.m_expectedModCount = modCount;
        }

        @Override
        public boolean hasNext() {
            return this.m_next < XYDirectPositionArray.this.m_size;
        }

        @Override
        public DirectPosition nextDirectPosition(DirectPosition dp) throws ConcurrentModificationException {
            if (this.m_expectedModCount != XYDirectPositionArray.this.m_modCount) {
                throw new ConcurrentModificationException();
            }
            dp.set(XYDirectPositionArray.this.m_x[this.m_next], XYDirectPositionArray.this.m_y[this.m_next], Double.NaN, null);
            ++this.m_next;
            return dp;
        }
    }
}

