/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.jts;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.IDirectPositionIterator;
import com.mapinfo.midev.geometry.IDirectPositionList;
import com.mapinfo.midev.geometry.IDirectPositionMutator;
import com.mapinfo.midev.geometry.MValue;
import com.mapinfo.midev.geometry.impl.DirectPositionArray;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;

class DirectPositionSequence
implements CoordinateSequence,
IDirectPositionList {
    private final IDirectPositionList m_dpList;
    private final DirectPosition m_tmp = new DirectPosition();

    public DirectPositionSequence(IDirectPositionList dpList) {
        this.m_dpList = dpList;
    }

    IDirectPositionList getDirectPositionList() {
        return this.m_dpList;
    }

    public int getDimension() {
        int result = 2;
        if (this.m_dpList.zSet()) {
            ++result;
        }
        if (this.m_dpList.mSet()) {
            ++result;
        }
        return result;
    }

    public Coordinate getCoordinate(int i) {
        this.m_dpList.getDirectPosition(i, this.m_tmp);
        return new Coordinate(this.m_tmp.getX(), this.m_tmp.getY(), this.m_tmp.getZ());
    }

    public Coordinate getCoordinateCopy(int i) {
        return this.getCoordinate(i);
    }

    public void getCoordinate(int i, Coordinate coordinate) {
        this.m_dpList.getDirectPosition(i, this.m_tmp);
        coordinate.x = this.m_tmp.getX();
        coordinate.y = this.m_tmp.getY();
        coordinate.z = this.m_tmp.getZ();
    }

    public double getX(int i) {
        this.m_dpList.getDirectPosition(i, this.m_tmp);
        return this.m_tmp.getX();
    }

    public double getY(int i) {
        this.m_dpList.getDirectPosition(i, this.m_tmp);
        return this.m_tmp.getY();
    }

    public double getOrdinate(int index, int ordinateIndex) {
        this.m_dpList.getDirectPosition(index, this.m_tmp);
        switch (ordinateIndex) {
            case 0: {
                return this.m_tmp.getX();
            }
            case 1: {
                return this.m_tmp.getY();
            }
            case 2: {
                return this.m_tmp.getZ();
            }
            case 3: {
                return this.m_tmp.mSet() ? this.m_tmp.getM().getDouble() : Double.NaN;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int size() {
        return this.m_dpList.size();
    }

    public void setOrdinate(int index, int ordinateIndex, double value) {
        this.m_dpList.getDirectPosition(index, this.m_tmp);
        switch (ordinateIndex) {
            case 0: {
                this.m_tmp.setX(value);
                break;
            }
            case 1: {
                this.m_tmp.setY(value);
                break;
            }
            case 2: {
                this.m_tmp.setZ(value);
                break;
            }
            case 3: {
                this.m_tmp.setM(new MValue(value));
            }
        }
        this.m_dpList.set(index, this.m_tmp);
    }

    public Coordinate[] toCoordinateArray() {
        Coordinate[] result = new Coordinate[this.m_dpList.size()];
        int index = 0;
        IDirectPositionIterator i = this.m_dpList.getDirectPositionIterator();
        while (i.hasNext()) {
            i.nextDirectPosition(this.m_tmp);
            result[index++] = new Coordinate(this.m_tmp.getX(), this.m_tmp.getY(), this.m_tmp.getZ());
        }
        return result;
    }

    public Envelope expandEnvelope(Envelope envelope) {
        IDirectPositionIterator i = this.m_dpList.getDirectPositionIterator();
        while (i.hasNext()) {
            i.nextDirectPosition(this.m_tmp);
            envelope.expandToInclude(this.m_tmp.getX(), this.m_tmp.getY());
        }
        return envelope;
    }

    public Object clone() {
        return new DirectPositionSequence(new DirectPositionArray(this.m_dpList));
    }

    @Override
    public void add(DirectPosition dp) {
        this.m_dpList.add(dp);
    }

    @Override
    public void add(int index, DirectPosition dp) {
        this.m_dpList.add(index, dp);
    }

    @Override
    public void add(int index, double x, double y) {
        this.m_dpList.add(index, x, y);
    }

    @Override
    public void add(int index, double x, double y, MValue m) {
        this.m_dpList.add(index, x, y, m);
    }

    @Override
    public void add(int index, double x, double y, double z) {
        this.m_dpList.add(index, x, y, z);
    }

    @Override
    public void add(int index, double x, double y, double z, MValue m) {
        this.m_dpList.add(index, x, y, z, m);
    }

    @Override
    public void add(double x, double y) {
        this.m_dpList.add(x, y);
    }

    @Override
    public void add(double x, double y, MValue m) {
        this.m_dpList.add(x, y, m);
    }

    @Override
    public void add(double x, double y, double z) {
        this.m_dpList.add(x, y, z);
    }

    @Override
    public void add(double x, double y, double z, MValue m) {
        this.m_dpList.add(x, y, z, m);
    }

    @Override
    public void addAll(IDirectPositionList dpl) {
        this.m_dpList.addAll(dpl);
    }

    @Override
    public void applyMutator(IDirectPositionMutator dpm) {
        this.m_dpList.applyMutator(dpm);
    }

    @Override
    public void clear() {
        this.m_dpList.clear();
    }

    @Override
    public boolean contains(DirectPosition dp) {
        return this.m_dpList.contains(dp);
    }

    @Override
    public DirectPosition getDirectPosition(int i, DirectPosition dp) {
        return this.m_dpList.getDirectPosition(i, dp);
    }

    @Override
    public IDirectPositionIterator getDirectPositionIterator() {
        return this.m_dpList.getDirectPositionIterator();
    }

    @Override
    public int indexOf(DirectPosition dp) {
        return this.m_dpList.indexOf(dp);
    }

    @Override
    public boolean isEmpty() {
        return this.m_dpList.isEmpty();
    }

    @Override
    public boolean isReadOnly() {
        return this.m_dpList.isReadOnly();
    }

    @Override
    public int lastIndexOf(DirectPosition dp) {
        return this.m_dpList.lastIndexOf(dp);
    }

    @Override
    public boolean mAllSet() {
        return this.m_dpList.mAllSet();
    }

    @Override
    public boolean mSet() {
        return this.m_dpList.mSet();
    }

    @Override
    public void remove(int index) {
        this.m_dpList.remove(index);
    }

    @Override
    public void set(int index, DirectPosition dp) {
        this.m_dpList.set(index, dp);
    }

    @Override
    public void set(int index, double x, double y) {
        this.m_dpList.set(index, x, y);
    }

    @Override
    public void set(int index, double x, double y, MValue m) {
        this.m_dpList.set(index, x, y, m);
    }

    @Override
    public void set(int index, double x, double y, double z) {
        this.m_dpList.set(index, x, y, z);
    }

    @Override
    public void set(int index, double x, double y, double z, MValue m) {
        this.m_dpList.set(index, x, y, z, m);
    }

    @Override
    public boolean zAllSet() {
        return this.m_dpList.zAllSet();
    }

    @Override
    public boolean zSet() {
        return this.m_dpList.zSet();
    }

    @Override
    public IDirectPositionList reverse() {
        return new DirectPositionSequence(this.m_dpList.reverse());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DirectPositionSequence)) {
            return false;
        }
        DirectPositionSequence that = (DirectPositionSequence)obj;
        return this.m_dpList.equals(that.getDirectPositionList());
    }

    public int hashCode() {
        return this.m_dpList.hashCode();
    }
}

