/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations;

import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.geometry.GeometryType;
import com.mapinfo.midev.geometry.GeometryUtilities;
import com.mapinfo.midev.geometry.ICurve;
import com.mapinfo.midev.geometry.ICurveSegment;
import com.mapinfo.midev.geometry.IDirectPositionList;
import com.mapinfo.midev.geometry.IFeatureGeometry;
import com.mapinfo.midev.geometry.IGeometry;
import com.mapinfo.midev.geometry.ILegacyArc;
import com.mapinfo.midev.geometry.ILegacyEllipse;
import com.mapinfo.midev.geometry.ILegacyRoundedRectangle;
import com.mapinfo.midev.geometry.IMultiCurve;
import com.mapinfo.midev.geometry.IMultiFeatureGeometry;
import com.mapinfo.midev.geometry.IMultiPolygon;
import com.mapinfo.midev.geometry.IPolygon;
import com.mapinfo.midev.geometry.IRing;
import com.mapinfo.midev.geometry.InvalidGeometryException;
import com.mapinfo.midev.geometry.MeasurementUtilities;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.UnsupportedGeometryOperationException;
import com.mapinfo.midev.geometry.impl.GeometryFactory;
import com.mapinfo.midev.geometry.impl.MultiFeatureGeometry;
import com.mapinfo.midev.geometry.impl.MultiPolygon;
import com.mapinfo.midev.geometry.jts.JTSGeometryConvertor;
import com.mapinfo.midev.geometry.operations.ClosestPoints;
import com.mapinfo.midev.geometry.operations.DifferenceGeometryOperation;
import com.mapinfo.midev.geometry.operations.GeometryOperationsUtilities;
import com.mapinfo.midev.geometry.operations.Intersection;
import com.mapinfo.midev.geometry.operations.contains.ContainsOp;
import com.mapinfo.midev.geometry.operations.distance.DistanceOp;
import com.mapinfo.midev.geometry.operations.intersects.IntersectsOp;
import com.mapinfo.midev.geometry.operations.s2.Buffer;
import com.mapinfo.midev.geometry.operations.s2.Combine;
import com.mapinfo.midev.geometry.operations.s2.ConvexHull;
import com.mapinfo.midev.unit.Area;
import com.mapinfo.midev.unit.AreaUnit;
import com.mapinfo.midev.unit.ComputationType;
import com.mapinfo.midev.unit.Length;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.unit.Offset;
import com.mapinfo.midev.util.PrivateAPI;
import com.mapinfo.midev.util.PublicAPI;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.TopologyException;
import com.vividsolutions.jts.operation.predicate.RectangleIntersects;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import com.vividsolutions.jts.operation.valid.TopologyValidationError;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.collections4.CollectionUtils;

@PublicAPI
public final class GeometryOperations {
    public static final int DEFAULT_BUFFER_RESOLUTION = 12;
    private static final MultiFeatureComparator OVERLAPS_COMPARATOR = new MultiFeatureComparator(new OverlapsComparator());
    private static final MultiFeatureComparator CROSSES_COMPARATOR = new MultiFeatureComparator(new CrossesComparator());
    private static final MultiFeatureComparator TOUCHES_COMPARATOR = new MultiFeatureComparator(new TouchesComparator());
    private static final DifferenceGeometryOperation DIFF_GEOM_OPERATION = new DifferenceGeometryOperation();

    private GeometryOperations() {
    }

    @PrivateAPI
    public static Envelope bufferEnvelope(Envelope env, Offset distance) {
        DirectPosition center = env.getCenter();
        double width = env.getExtentX() == 0.0 ? 0.0 : MeasurementUtilities.length(new DirectPosition(env.getURX(), center.getY()), new DirectPosition(env.getLLX(), center.getY()), env.getSpatialInfo().getCoordSys()).getValue(distance.getUnit());
        double height = env.getExtentY() == 0.0 ? 0.0 : MeasurementUtilities.length(new DirectPosition(center.getX(), env.getURY()), new DirectPosition(center.getX(), env.getLLY()), env.getSpatialInfo().getCoordSys()).getValue(distance.getUnit());
        Offset newWidth = new Offset(width + 2.0 * distance.getValue(), distance.getUnit());
        Offset newHeight = new Offset(height + 2.0 * distance.getValue(), distance.getUnit());
        return GeometryOperations.createEnvelope(center, env.getSpatialInfo().getCoordSys(), newWidth, newHeight);
    }

    private static Envelope createEnvelope(DirectPosition center, CoordSys csys, Offset width, Offset height) {
        DirectPosition pt1 = center.getCopy();
        DirectPosition pt2 = center.getCopy();
        DirectPosition pt3 = center.getCopy();
        DirectPosition pt4 = center.getCopy();
        GeometryOperationsUtilities.adjustPointsUsingDistance(pt1, pt2, csys, width, true, true);
        GeometryOperationsUtilities.adjustPointsUsingDistance(pt3, pt4, csys, height, true, false);
        return new Envelope(pt1.getX(), pt3.getY(), pt2.getX(), pt4.getY(), SpatialInfo.create(csys));
    }

    public static Area area(IGeometry geom, ComputationType model) {
        if (model == null) {
            model = GeometryUtilities.getDefaultComputationType(geom.getCoordSys());
        }
        switch (geom.getType()) {
            case CURVE: 
            case LEGACY_ARC: 
            case LEGACY_TEXT: 
            case LINE_STRING: 
            case MULTI_CURVE: 
            case MULTI_POINT: 
            case POINT: {
                return new Area(0.0, AreaUnit.SQUARE_METER, model);
            }
            case ELLIPSE: 
            case MULTI_POLYGON: 
            case POLYGON: 
            case RING: 
            case RECTANGLE: {
                return geom.getArea(model);
            }
            case ROUNDED_RECTANGLE: {
                return ((ILegacyRoundedRectangle)geom).asRectangle().getArea(model);
            }
            case MULTI_FEATURE_GEOMETRY: {
                return ((IMultiFeatureGeometry)geom).getAllPolygons().getArea(model);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static IFeatureGeometry buffer(IGeometry g, Offset distance, int resolution) {
        return GeometryOperations.buffer(g, distance, resolution, GeometryUtilities.getDefaultComputationType(g.getCoordSys()));
    }

    @PrivateAPI
    public static IFeatureGeometry buffer(IGeometry g, Offset distance, int resolution, ComputationType computationType) {
        MeasurementUtilities.checkComputationType(g.getCoordSys(), computationType);
        Buffer buffer = new Buffer(g.getSpatialInfo(), distance, resolution, computationType);
        buffer.add(g);
        return buffer.result();
    }

    public static IFeatureGeometry buffer(IGeometry g, Offset distance) {
        return GeometryOperations.buffer(g, distance, 12);
    }

    @PrivateAPI
    public static DirectPosition centerOfGravity(IGeometry g, ComputationType model) {
        Point p = JTSGeometryConvertor.convert(g).getCentroid();
        return new DirectPosition(p.getX(), p.getY());
    }

    public static IFeatureGeometry convexHull(IGeometry g) {
        ConvexHull convexHull = new ConvexHull(g.getSpatialInfo());
        convexHull.add(g);
        return convexHull.result();
    }

    public static Length distance(IGeometry first, IGeometry second, ComputationType model) {
        return DistanceOp.distance(first, second, model);
    }

    public static Length distanceToEdge(IGeometry first, IGeometry second, ComputationType model) {
        return DistanceOp.distanceToEdge(first, second, model);
    }

    public static ClosestPoints closestPoints(IGeometry first, IGeometry second) {
        DistanceOp.Result result = new DistanceOp(first).calculate(second);
        return new ClosestPoints(result);
    }

    public static ClosestPoints closestPoints(IGeometry first, IGeometry second, ComputationType model) {
        DistanceOp.Result result = new DistanceOp(first, model).calculate(second);
        return new ClosestPoints(result);
    }

    public static Length distance(IGeometry first, IGeometry second) {
        return DistanceOp.distance(first, second);
    }

    public static IFeatureGeometry intersection(IGeometry first, IGeometry second) {
        if (first == null || second == null) {
            return null;
        }
        if (!GeometryOperations.envelopesIntersect(first, second)) {
            return new MultiFeatureGeometry(first.getSpatialInfo());
        }
        Intersection intersection = new Intersection(new GeometryFactory(first.getSpatialInfo()));
        intersection.add(first);
        intersection.add(second);
        return intersection.result();
    }

    @PrivateAPI
    public static IFeatureGeometry clip(IGeometry geometry, Envelope env) {
        Geometry geom;
        if (!geometry.getEnvelope().intersects(env)) {
            return new MultiFeatureGeometry(env.getSpatialInfo());
        }
        if (env.contains(geometry.getEnvelope())) {
            return GeometryUtilities.convertToFeatureGeometry(geometry);
        }
        if (geometry.getType() == GeometryType.MULTI_FEATURE_GEOMETRY) {
            IMultiFeatureGeometry mfg2 = (IMultiFeatureGeometry)geometry;
            ArrayList<IFeatureGeometry> newGeometries = new ArrayList<IFeatureGeometry>(mfg2.getFeatureGeometryCount());
            for (IFeatureGeometry fg : mfg2) {
                newGeometries.add(GeometryOperations.clip(fg, env));
            }
            return new GeometryFactory(env.getSpatialInfo()).newMultiFeatureGeometry(newGeometries);
        }
        geometry = GeometryUtilities.convertIfNecessary(geometry, env.getSpatialInfo().getCoordSys());
        Geometry geometryJTS = JTSGeometryConvertor.convert(geometry);
        try {
            geom = geometryJTS.intersection((Geometry)JTSGeometryConvertor.convert(env));
        }
        catch (TopologyException e) {
            return null;
        }
        IFeatureGeometry featureGeometry = JTSGeometryConvertor.convert(geom, env.getSpatialInfo());
        return featureGeometry;
    }

    @PrivateAPI
    public static IMultiPolygon newMultiPolygon(Iterable<IRing> rings) {
        class RingWithArea {
            private final IRing m_ring;
            private final double m_area;

            public RingWithArea(IRing ring) {
                this.m_ring = ring;
                this.m_area = Math.abs(MeasurementUtilities.signedCartesianArea(ring.asLineString().getControlPoints(), ring.getStartPosition()));
            }

            public IRing getRing() {
                return this.m_ring;
            }

            public double getArea() {
                return this.m_area;
            }
        }
        ArrayList<RingWithArea> ringList = new ArrayList<RingWithArea>();
        SpatialInfo spatialInfo = null;
        for (IRing ring : rings) {
            if (spatialInfo == null) {
                spatialInfo = ring.getSpatialInfo();
            }
            ringList.add(new RingWithArea(ring));
        }
        GeometryFactory geometryFactory = new GeometryFactory(spatialInfo);
        Collections.sort(ringList, new Comparator<RingWithArea>(){

            @Override
            public int compare(RingWithArea r1, RingWithArea r2) {
                double area2;
                double area1 = r1.getArea();
                if (area1 < (area2 = r2.getArea())) {
                    return 1;
                }
                if (area1 > area2) {
                    return -1;
                }
                return 0;
            }
        });
        ArrayList<com.mapinfo.midev.geometry.impl.Polygon> polyList = new ArrayList<com.mapinfo.midev.geometry.impl.Polygon>(ringList.size());
        DirectPosition halfWay = new DirectPosition();
        DirectPosition tmp = new DirectPosition();
        for (RingWithArea ring : ringList) {
            IDirectPositionList pos = ring.getRing().asLineString().getControlPoints();
            int holeOf = -1;
            for (int polyNum = 0; holeOf < 0 && polyNum < polyList.size(); ++polyNum) {
                com.mapinfo.midev.geometry.impl.Polygon poly = (com.mapinfo.midev.geometry.impl.Polygon)polyList.get(polyNum);
                boolean possibleHoleOfPoly = true;
                for (int i = 0; possibleHoleOfPoly && i < pos.size(); ++i) {
                    if (!poly.contains(pos.getDirectPosition(i, tmp))) {
                        possibleHoleOfPoly = false;
                        continue;
                    }
                    if (i <= 0) continue;
                    halfWay.setX((pos.getDirectPosition(i - 1, tmp).getX() + pos.getDirectPosition(i, tmp).getX()) / 2.0);
                    halfWay.setY((pos.getDirectPosition(i - 1, tmp).getY() + pos.getDirectPosition(i, tmp).getY()) / 2.0);
                    if (poly.contains(halfWay)) continue;
                    possibleHoleOfPoly = false;
                }
                if (!possibleHoleOfPoly) continue;
                holeOf = polyNum;
            }
            if (holeOf < 0) {
                polyList.add(geometryFactory.newPolygon(ring.getRing()));
                continue;
            }
            IPolygon poly = (IPolygon)polyList.get(holeOf);
            ArrayList<IRing> holeList = new ArrayList<IRing>(poly.getInteriorRingCount() + 1);
            holeList.add(ring.getRing());
            CollectionUtils.addAll(holeList, poly.getInteriorRingIterator());
            polyList.set(holeOf, geometryFactory.newPolygon(poly.getExteriorRing(), holeList));
        }
        return new MultiPolygon(spatialInfo, polyList);
    }

    public static Length length(IGeometry geom, ComputationType model) {
        Length result;
        if (model == null) {
            model = GeometryUtilities.getDefaultComputationType(geom.getCoordSys());
        }
        switch (geom.getType()) {
            case LEGACY_TEXT: 
            case ELLIPSE: 
            case MULTI_POLYGON: 
            case POLYGON: 
            case RING: 
            case RECTANGLE: 
            case ROUNDED_RECTANGLE: {
                return new Length(0.0, LinearUnit.METER, model);
            }
            case CURVE: 
            case LINE_STRING: {
                result = ((ICurveSegment)geom).getLength(model);
                break;
            }
            case LEGACY_ARC: {
                result = GeometryOperations.length(((ILegacyArc)geom).asMultiCurve(), model);
                break;
            }
            case MULTI_CURVE: {
                IMultiCurve mc = (IMultiCurve)geom;
                LengthAccumulator distance = new LengthAccumulator();
                for (ICurve c : mc) {
                    distance.add(c.getLength(model));
                }
                result = distance.getLength(model);
                break;
            }
            case MULTI_FEATURE_GEOMETRY: {
                IMultiFeatureGeometry mfg = (IMultiFeatureGeometry)geom;
                LengthAccumulator distance = new LengthAccumulator();
                for (IFeatureGeometry fg : mfg) {
                    distance.add(GeometryOperations.length(fg, model));
                }
                result = distance.getLength(model);
                break;
            }
            case MULTI_POINT: 
            case POINT: {
                result = new Length(0.0, LinearUnit.METER, model);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return result;
    }

    public static Length perimeter(IGeometry geom, ComputationType model) {
        Length result;
        if (model == null) {
            model = GeometryUtilities.getDefaultComputationType(geom.getCoordSys());
        }
        if (geom.isEmpty()) {
            return new Length(0.0, LinearUnit.METER, model);
        }
        switch (geom.getType()) {
            case ELLIPSE: {
                result = GeometryOperations.perimeter(((ILegacyEllipse)geom).asMultiPolygon(), model);
                break;
            }
            case LEGACY_TEXT: {
                throw new UnsupportedGeometryOperationException(geom.getType().toString());
            }
            case MULTI_POLYGON: {
                IMultiPolygon mp = (IMultiPolygon)geom;
                LengthAccumulator total = new LengthAccumulator();
                for (IPolygon poly : mp) {
                    total.add(poly.getPerimeter(model));
                }
                result = total.getLength(model);
                break;
            }
            case POLYGON: 
            case RECTANGLE: {
                result = geom.getPerimeter(model);
                break;
            }
            case RING: {
                result = MeasurementUtilities.perimeter((IRing)geom, model);
                break;
            }
            case ROUNDED_RECTANGLE: {
                result = GeometryOperations.perimeter(((ILegacyRoundedRectangle)geom).asRectangle(), model);
                break;
            }
            case MULTI_FEATURE_GEOMETRY: {
                IMultiFeatureGeometry mfg = (IMultiFeatureGeometry)geom;
                LengthAccumulator total = new LengthAccumulator();
                for (IFeatureGeometry fg : mfg) {
                    total.add(GeometryOperations.perimeter(fg, model));
                }
                result = total.getLength(model);
                break;
            }
            case CURVE: 
            case LEGACY_ARC: 
            case LINE_STRING: 
            case MULTI_CURVE: 
            case MULTI_POINT: 
            case POINT: {
                result = new Length(0.0, LinearUnit.METER, model);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return result;
    }

    public static IFeatureGeometry union(IGeometry first, IGeometry second) {
        if (first == null) {
            if (second == null) {
                return null;
            }
            return GeometryUtilities.formFeatureGeometry(new GeometryFactory(second.getSpatialInfo()), Collections.singletonList(second));
        }
        if (second == null) {
            return GeometryUtilities.formFeatureGeometry(new GeometryFactory(first.getSpatialInfo()), Collections.singletonList(first));
        }
        Combine unioner = new Combine(first.getSpatialInfo());
        unioner.add(first);
        unioner.add(second);
        return unioner.result();
    }

    public static IFeatureGeometry union(Iterable<? extends IGeometry> geomList) {
        IGeometry firstGeom = geomList.iterator().next();
        Combine unioner = new Combine(firstGeom.getSpatialInfo());
        unioner.addMultiple(geomList);
        return unioner.result();
    }

    @PrivateAPI
    public static IFeatureGeometry difference(IGeometry first, IGeometry second) {
        return DIFF_GEOM_OPERATION.difference(first, second);
    }

    @PrivateAPI
    public static IFeatureGeometry symDifference(IGeometry first, IGeometry second) {
        second = GeometryUtilities.convertIfNecessary(second, first.getCoordSys());
        Geometry firstJTS = JTSGeometryConvertor.convert(first);
        Geometry secondJTS = JTSGeometryConvertor.convert(second);
        return JTSGeometryConvertor.convert(firstJTS.symDifference(secondJTS), first.getSpatialInfo());
    }

    @PrivateAPI
    public static boolean crosses(IGeometry first, IGeometry second) {
        return CROSSES_COMPARATOR.compare(first, second);
    }

    @PrivateAPI
    public static boolean equalsGeometry(IGeometry first, IGeometry second) {
        Geometry secondJTS;
        if (!GeometryOperations.envelopesIntersect(first, second)) {
            return false;
        }
        Geometry firstJTS = JTSGeometryConvertor.convert(first);
        return firstJTS.covers(secondJTS = JTSGeometryConvertor.convert(second = GeometryUtilities.convertIfNecessary(second, first.getCoordSys()))) && secondJTS.covers(firstJTS);
    }

    public static boolean disjoint(IGeometry first, IGeometry second) {
        return !GeometryOperations.intersects(first, second);
    }

    public static boolean intersects(IGeometry first, IGeometry second) {
        return IntersectsOp.intersects(first, second);
    }

    public static boolean overlaps(IGeometry first, IGeometry second) {
        return OVERLAPS_COMPARATOR.compare(first, second);
    }

    @PrivateAPI
    public static boolean touches(IGeometry first, IGeometry second) {
        return TOUCHES_COMPARATOR.compare(first, second);
    }

    public static boolean intersects(Envelope env, IGeometry second) {
        IMultiFeatureGeometry mfg2;
        if (!env.intersects(second.getEnvelope())) {
            return false;
        }
        if (second.getType() == GeometryType.MULTI_FEATURE_GEOMETRY) {
            mfg2 = (IMultiFeatureGeometry)second;
        } else {
            GeometryFactory geomFactory = new GeometryFactory(second.getSpatialInfo());
            mfg2 = geomFactory.newMultiFeatureGeometry(second);
        }
        for (IFeatureGeometry fg : mfg2) {
            Geometry b1 = JTSGeometryConvertor.convert(fg);
            if (!RectangleIntersects.intersects((Polygon)JTSGeometryConvertor.convert(env = GeometryUtilities.convertIfNecessary(env, fg.getSpatialInfo())), (Geometry)b1)) continue;
            return true;
        }
        return false;
    }

    public static boolean within(IGeometry first, IGeometry second) {
        return ContainsOp.contains(second, first);
    }

    @PrivateAPI
    public static void assertValidGeometry(IGeometry geom) throws InvalidGeometryException {
        Geometry firstJTS = JTSGeometryConvertor.convert(geom);
        IsValidOp validOp = new IsValidOp(firstJTS);
        TopologyValidationError err = validOp.getValidationError();
        if (err != null) {
            throw new InvalidGeometryException(err.toString());
        }
    }

    @PrivateAPI
    public static boolean envelopesIntersect(IGeometry first, IGeometry second) {
        return first.getEnvelope().intersects(second.getEnvelope());
    }

    static class MultiFeatureComparator {
        private IGeometryComparator m_comparator;

        MultiFeatureComparator(IGeometryComparator comparator) {
            this.m_comparator = comparator;
        }

        boolean compare(IGeometry first, IGeometry second) {
            if (!GeometryOperations.envelopesIntersect(first, second)) {
                return false;
            }
            if (first.getType() == GeometryType.MULTI_FEATURE_GEOMETRY) {
                IMultiFeatureGeometry mfg1 = (IMultiFeatureGeometry)first;
                if (second.getType() == GeometryType.MULTI_FEATURE_GEOMETRY) {
                    IMultiFeatureGeometry mfg2 = (IMultiFeatureGeometry)second;
                    for (IFeatureGeometry fg1 : mfg1) {
                        for (IFeatureGeometry fg2 : mfg2) {
                            if (!this.compare(fg1, fg2)) continue;
                            return true;
                        }
                    }
                    return false;
                }
                for (IFeatureGeometry fg : mfg1) {
                    if (!this.compare(fg, second)) continue;
                    return true;
                }
                return false;
            }
            if (second.getType() == GeometryType.MULTI_FEATURE_GEOMETRY) {
                IMultiFeatureGeometry mfg2 = (IMultiFeatureGeometry)second;
                for (IFeatureGeometry fg : mfg2) {
                    if (!this.compare(first, fg)) continue;
                    return true;
                }
                return false;
            }
            return this.m_comparator.compares(first, second);
        }
    }

    static interface IGeometryComparator {
        public boolean compares(IGeometry var1, IGeometry var2);
    }

    private static class LengthAccumulator {
        private double m_distance = 0.0;
        private LinearUnit m_unit = null;

        private LengthAccumulator() {
        }

        private void add(Length l) {
            if (this.m_unit == null || this.m_distance == 0.0) {
                this.m_distance = l.getValue();
                this.m_unit = l.getUnit();
            } else {
                this.m_distance += l.getValue(this.m_unit);
            }
        }

        private Length getLength(ComputationType ct) {
            if (this.m_unit == null) {
                this.m_unit = LinearUnit.METER;
            }
            return new Length(this.m_distance, this.m_unit, ct);
        }
    }

    private static class TouchesComparator
    implements IGeometryComparator {
        private TouchesComparator() {
        }

        @Override
        public boolean compares(IGeometry first, IGeometry second) {
            Geometry firstJTS = JTSGeometryConvertor.convert(first);
            second = GeometryUtilities.convertIfNecessary(second, first.getCoordSys());
            Geometry secondJTS = JTSGeometryConvertor.convert(second);
            return firstJTS.touches(secondJTS);
        }
    }

    private static class OverlapsComparator
    implements IGeometryComparator {
        private OverlapsComparator() {
        }

        @Override
        public boolean compares(IGeometry first, IGeometry second) {
            Geometry firstJTS = JTSGeometryConvertor.convert(first);
            second = GeometryUtilities.convertIfNecessary(second, first.getCoordSys());
            Geometry secondJTS = JTSGeometryConvertor.convert(second);
            return firstJTS.overlaps(secondJTS);
        }
    }

    private static class CrossesComparator
    implements IGeometryComparator {
        private CrossesComparator() {
        }

        @Override
        public boolean compares(IGeometry first, IGeometry second) {
            second = GeometryUtilities.convertIfNecessary(second, first.getCoordSys());
            Geometry firstJTS = JTSGeometryConvertor.convert(first);
            Geometry secondJTS = JTSGeometryConvertor.convert(second);
            return firstJTS.crosses(secondJTS);
        }
    }
}

