/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.cartesian.contains;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.GeometryType;
import com.mapinfo.midev.geometry.IGeometry;
import com.mapinfo.midev.geometry.IMultiPolygon;
import com.mapinfo.midev.geometry.IPoint;
import com.mapinfo.midev.geometry.IPolygon;
import com.mapinfo.midev.geometry.IRing;
import com.mapinfo.midev.geometry.operations.cartesian.contains.LineContainsLine;
import com.mapinfo.midev.geometry.operations.cartesian.contains.PolygonContainsEdge;
import com.mapinfo.midev.geometry.operations.cartesian.contains.PolygonContainsPoint;
import com.mapinfo.midev.geometry.operations.cartesian.contains.RingContainsPoint;
import com.mapinfo.midev.geometry.operations.edge.Edge;
import com.mapinfo.midev.geometry.operations.edge.prepared.GeometryOperationsHelper;
import com.mapinfo.midev.geometry.operations.edge.prepared.RingGroup;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class CartesianContains {
    private CartesianContains() {
    }

    public static boolean contains(IMultiPolygon left, DirectPosition pt) {
        return PolygonContainsPoint.contains(left, pt);
    }

    public static boolean contains(IPolygon left, DirectPosition pt) {
        return PolygonContainsPoint.contains(left, pt);
    }

    public static boolean contains(IRing left, DirectPosition pt) {
        return RingContainsPoint.containsWithBoundary(left, pt);
    }

    public static boolean contains(IGeometry left, IGeometry right) {
        Edge rightEdge;
        Iterator i;
        Iterator i2;
        if (!left.getEnvelope().intersects(right.getEnvelope())) {
            return false;
        }
        if (right.getType() == GeometryType.POINT) {
            DirectPosition rightPt = ((IPoint)right).getDirectPosition();
            switch (left.getType()) {
                case RING: {
                    return CartesianContains.contains((IRing)left, rightPt);
                }
                case POLYGON: {
                    return CartesianContains.contains((IPolygon)left, rightPt);
                }
                case MULTI_POLYGON: {
                    return CartesianContains.contains((IMultiPolygon)left, rightPt);
                }
            }
        }
        GeometryOperationsHelper leftHelper = GeometryOperationsHelper.getInstance(left, false);
        GeometryOperationsHelper rightHelper = GeometryOperationsHelper.getInstance(right, false);
        LinkedList<DirectPosition> rightPoints = new LinkedList<DirectPosition>(rightHelper.getPoints());
        LinkedList<Edge> rightEdges = new LinkedList<Edge>(rightHelper.getLineAndAreaEdges(true));
        List<RingGroup> leftArea = leftHelper.getArea();
        if (!rightPoints.isEmpty()) {
            i2 = rightPoints.iterator();
            while (i2.hasNext()) {
                DirectPosition pt = (DirectPosition)i2.next();
                if (!PolygonContainsPoint.contains(leftArea, pt)) continue;
                i2.remove();
            }
        }
        if (!rightEdges.isEmpty()) {
            i2 = rightEdges.iterator();
            while (i2.hasNext()) {
                Edge edge = (Edge)i2.next();
                if (!PolygonContainsEdge.contains(leftArea, edge)) continue;
                i2.remove();
            }
        }
        if (!rightPoints.isEmpty() || !rightEdges.isEmpty()) {
            List<Edge> leftEdges = leftHelper.getLineAndAreaEdges(true);
            i = rightPoints.iterator();
            block7: while (i.hasNext()) {
                DirectPosition pt = (DirectPosition)i.next();
                for (Edge leftEdge : leftEdges) {
                    if (!leftEdge.intersects(pt, 0.0)) continue;
                    i.remove();
                    continue block7;
                }
            }
            i = rightEdges.iterator();
            while (i.hasNext()) {
                rightEdge = (Edge)i.next();
                if (!LineContainsLine.contains(leftEdges, rightEdge)) continue;
                i.remove();
            }
        }
        if (!rightPoints.isEmpty() || !rightEdges.isEmpty()) {
            List<DirectPosition> leftPoints = leftHelper.getPoints();
            i = rightPoints.iterator();
            block10: while (i.hasNext()) {
                DirectPosition rightPt = (DirectPosition)i.next();
                for (DirectPosition leftPt : leftPoints) {
                    if (!leftPt.equalsXY(rightPt)) continue;
                    i.remove();
                    continue block10;
                }
            }
            i = rightEdges.iterator();
            block12: while (i.hasNext()) {
                rightEdge = (Edge)i.next();
                if (!rightEdge.getPoint1().equalsXY(rightEdge.getPoint2())) continue;
                for (DirectPosition leftPt : leftPoints) {
                    if (!leftPt.equalsXY(rightEdge.getPoint1())) continue;
                    i.remove();
                    continue block12;
                }
            }
        }
        return rightPoints.isEmpty() && rightEdges.isEmpty();
    }
}

