/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.cartesian.contains;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.ICurveSegment;
import com.mapinfo.midev.geometry.IDirectPositionIterator;
import com.mapinfo.midev.geometry.operations.edge.Edge;
import com.mapinfo.midev.geometry.operations.edge.EdgeFactory;
import java.util.ArrayList;
import java.util.List;

public final class LineContainsLine {
    private LineContainsLine() {
    }

    public static boolean contains(List<Edge> leftEdges, Edge right) {
        if ((leftEdges = LineContainsLine.cleanContiguousEdges(leftEdges)).isEmpty()) {
            return false;
        }
        for (Edge left : leftEdges) {
            if (!left.intersects(right.getPoint1(), 0.0) || !left.intersects(right.getPoint2(), 0.0)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(List<Edge> leftEdges, ICurveSegment right) {
        if ((leftEdges = LineContainsLine.cleanContiguousEdges(leftEdges)).isEmpty() || right.isEmpty()) {
            return false;
        }
        IDirectPositionIterator i = right.getControlPointIterator();
        DirectPosition prevPt = new DirectPosition();
        DirectPosition curPt = new DirectPosition();
        i.nextDirectPosition(prevPt);
        int index = LineContainsLine.findIntersectingEdge(leftEdges, prevPt);
        if (index == -1) {
            return false;
        }
        Edge curEdge = leftEdges.get(index);
        while (i.hasNext()) {
            i.nextDirectPosition(curPt);
            if (!curEdge.intersects(curPt, 0.0)) {
                if (prevPt.equalsXY(curEdge.getPoint1()) || prevPt.equalsXY(curEdge.getPoint2())) {
                    Edge nextEdge;
                    Edge prevEdge;
                    boolean found = false;
                    if (index != 0 && (prevEdge = leftEdges.get(index - 1)).intersects(curPt, 0.0)) {
                        found = true;
                        curEdge = prevEdge;
                        --index;
                    }
                    if (!found && index != leftEdges.size() - 1 && (nextEdge = leftEdges.get(index + 1)).intersects(curPt, 0.0)) {
                        found = true;
                        curEdge = nextEdge;
                        ++index;
                    }
                    if (!found) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            prevPt.set(curPt);
        }
        return true;
    }

    private static List<Edge> cleanContiguousEdges(List<Edge> edges) {
        ArrayList<Edge> result = new ArrayList<Edge>(edges.size());
        double prevSlope = Double.NaN;
        EdgeFactory edgeFactory = new EdgeFactory(true);
        for (Edge edge : edges) {
            double slope = LineContainsLine.slope(edge);
            if (edge.getPoint1().equalsXY(edge.getPoint2())) continue;
            if (result.isEmpty()) {
                prevSlope = slope;
                result.add(edge);
                continue;
            }
            if (Double.compare(prevSlope, slope) == 0) {
                Edge left = (Edge)result.get(result.size() - 1);
                Edge newEdge = edgeFactory.newEdge(left.getPoint1(), edge.getPoint2());
                result.set(result.size() - 1, newEdge);
                continue;
            }
            result.add(edge);
        }
        return result;
    }

    private static double slope(Edge edge) {
        return (edge.getPoint2().getY() - edge.getPoint1().getY()) / (edge.getPoint2().getX() - edge.getPoint1().getX());
    }

    private static int findIntersectingEdge(List<Edge> edgeList, DirectPosition pt) {
        int result = 0;
        for (Edge edge : edgeList) {
            if (edge.intersects(pt, 0.0)) {
                return result;
            }
            ++result;
        }
        return -1;
    }
}

