/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.cartesian.contains;

import com.mapinfo.midev.geometry.IMultiPolygon;
import com.mapinfo.midev.geometry.IPolygon;
import com.mapinfo.midev.geometry.IRing;
import com.mapinfo.midev.geometry.operations.cartesian.contains.RingContainsPoint;
import com.mapinfo.midev.geometry.operations.cartesian.intersects.RingIntersectsLine;
import com.mapinfo.midev.geometry.operations.edge.Edge;
import com.mapinfo.midev.geometry.operations.edge.prepared.RingGroup;
import java.util.List;

final class PolygonContainsEdge {
    private PolygonContainsEdge() {
    }

    public static boolean contains(IMultiPolygon polygon, Edge edge) {
        return PolygonContainsEdge.contains(RingGroup.getInstance(polygon, false), edge);
    }

    public static boolean contains(IPolygon polygon, Edge edge) {
        return PolygonContainsEdge.contains(RingGroup.getInstance(polygon, false), edge);
    }

    public static boolean contains(List<RingGroup> ringGroupList, Edge edge) {
        for (RingGroup ringGroup : ringGroupList) {
            if (!PolygonContainsEdge.contains(ringGroup, edge)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(RingGroup polygon, Edge edge) {
        if (!PolygonContainsEdge.containsWithBoundary(polygon.getOuterRing(), edge)) {
            return false;
        }
        for (IRing ring : polygon.getInnerRings()) {
            if (!RingIntersectsLine.intersectsInterior(ring, edge)) continue;
            return false;
        }
        return true;
    }

    private static boolean containsWithBoundary(IRing ring, Edge edge) {
        boolean crossesBoundary = RingIntersectsLine.crossesBoundary(ring, edge);
        if (crossesBoundary) {
            return RingContainsPoint.containsWithBoundary(ring, edge.getPoint1()) && RingContainsPoint.containsWithBoundary(ring, edge.getPoint2());
        }
        return RingContainsPoint.containsWithBoundary(ring, edge.getPoint1());
    }
}

