/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.cartesian.intersects;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.ICurveSegment;
import com.mapinfo.midev.geometry.IDirectPositionIterator;
import com.mapinfo.midev.geometry.operations.cartesian.intersects.PointOnLine;

public final class LineIntersectsPoint {
    private LineIntersectsPoint() {
    }

    public static boolean intersects(Iterable<ICurveSegment> curveSegments, DirectPosition dp) {
        for (ICurveSegment curveSegment : curveSegments) {
            if (!LineIntersectsPoint.intersects(curveSegment, dp)) continue;
            return true;
        }
        return false;
    }

    public static boolean intersects(ICurveSegment curveSegment, DirectPosition dp) {
        if (curveSegment.isEmpty() || !curveSegment.getEnvelope().contains(dp)) {
            return false;
        }
        IDirectPositionIterator i = curveSegment.getControlPoints().getDirectPositionIterator();
        DirectPosition pt = i.nextDirectPosition(new DirectPosition());
        PointOnLine pointOnLine = new PointOnLine(pt, dp, 0.0);
        while (i.hasNext()) {
            i.nextDirectPosition(pt);
            if (!pointOnLine.pointOnLine(pt)) continue;
            return true;
        }
        return false;
    }
}

