/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.cartesian.intersects;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.geometry.ICurveSegment;
import com.mapinfo.midev.geometry.IRing;
import com.mapinfo.midev.geometry.operations.cartesian.contains.LineContainsLine;
import com.mapinfo.midev.geometry.operations.cartesian.contains.RingContainsPoint;
import com.mapinfo.midev.geometry.operations.cartesian.intersects.LineIntersectsLine;
import com.mapinfo.midev.geometry.operations.cartesian.intersects.LineIntersectsPoint;
import com.mapinfo.midev.geometry.operations.edge.CartesianOps;
import com.mapinfo.midev.geometry.operations.edge.Edge;
import com.mapinfo.midev.geometry.operations.edge.EdgeList;
import com.mapinfo.midev.geometry.operations.edge.prepared.GeometryOperationsHelper;
import com.mapinfo.midev.geometry.operations.edge.prepared.IPreparedGeometry;
import com.mapinfo.midev.geometry.operations.rtree.EdgeIntersectsWidget;
import com.mapinfo.midev.util.DoubleRect;

public final class RingIntersectsLine {
    private RingIntersectsLine() {
    }

    public static boolean intersects(IRing ring, Edge edge) {
        if (RingIntersectsLine.crossesBoundary(ring, edge)) {
            return true;
        }
        return RingContainsPoint.insideOrPartialBoundary(ring, edge.getPoint1());
    }

    private static boolean intersects(Envelope envelope, DoubleRect doubleRect) {
        return envelope.getLLX() <= doubleRect.getMaxX() && envelope.getURX() >= doubleRect.getMinX() && envelope.getLLY() <= doubleRect.getMaxY() && envelope.getURY() >= doubleRect.getMinY();
    }

    public static boolean intersectsInterior(IRing ring, Edge edge) {
        boolean insidePt2;
        if (!RingIntersectsLine.intersects(ring.getEnvelope(), edge.getBounds())) {
            return false;
        }
        boolean borderContainsPt1 = LineIntersectsPoint.intersects(ring, edge.getPoint1());
        boolean borderContainsPt2 = LineIntersectsPoint.intersects(ring, edge.getPoint2());
        boolean maybeInsidePt1 = RingContainsPoint.insideOrPartialBoundary(ring, edge.getPoint1());
        boolean maybeInsidePt2 = RingContainsPoint.insideOrPartialBoundary(ring, edge.getPoint2());
        boolean insidePt1 = maybeInsidePt1 && !borderContainsPt1;
        boolean bl = insidePt2 = maybeInsidePt2 && !borderContainsPt2;
        if (insidePt1 || insidePt2) {
            return true;
        }
        EdgeList leftEdges = GeometryOperationsHelper.getInstance(ring, false).getEdges(true);
        if (borderContainsPt1 && borderContainsPt2 && LineContainsLine.contains(leftEdges.getEdges(), edge)) {
            return false;
        }
        DirectPosition intersection = null;
        for (Edge leftEdge : leftEdges) {
            DirectPosition pt;
            CartesianOps.EdgeIntersectsRelation relation = CartesianOps.relate(leftEdge, edge, 0.0);
            if (!relation.isIntersects() || (pt = relation.getIntersectionPoint()) == null) continue;
            if (intersection == null) {
                intersection = pt;
                continue;
            }
            if (intersection.equalsXY(pt)) continue;
            return true;
        }
        return false;
    }

    public static boolean crossesBoundary(IRing ring, Edge edge) {
        if (ring instanceof IPreparedGeometry && ((IPreparedGeometry)((Object)ring)).getHelper().isIndexed()) {
            EdgeIntersectsWidget widget = new EdgeIntersectsWidget(edge, 0.0);
            ((IPreparedGeometry)((Object)ring)).getHelper().getIndexedEdges(true).search(edge.getBounds(), widget);
            return widget.intersects();
        }
        for (ICurveSegment cs : ring) {
            if (!LineIntersectsLine.intersects(cs, edge)) continue;
            return true;
        }
        return false;
    }
}

