/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.contains;

import com.mapinfo.midev.geometry.GeometryUtilities;
import com.mapinfo.midev.geometry.IGeometry;
import com.mapinfo.midev.geometry.operations.cartesian.contains.CartesianContains;
import com.mapinfo.midev.geometry.operations.edge.prepared.IPreparedGeometry;
import com.mapinfo.midev.geometry.operations.edge.prepared.PreparedGeometryFactory;

public final class ContainsOp {
    private final IPreparedGeometry m_geometry;

    public ContainsOp(IGeometry geometry) {
        this.m_geometry = PreparedGeometryFactory.prepare(geometry, true);
    }

    public boolean contains(IGeometry geometry) {
        return ContainsOp.contains(this.m_geometry, geometry);
    }

    public static boolean contains(IGeometry left, IGeometry right) {
        right = GeometryUtilities.convertIfNecessary(right, left.getCoordSys());
        return CartesianContains.contains(left, right);
    }
}

