/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.distance;

import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.transform.CoordTransform;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.GeometryType;
import com.mapinfo.midev.geometry.GeometryUtilities;
import com.mapinfo.midev.geometry.ICurve;
import com.mapinfo.midev.geometry.IDirectPositionIterator;
import com.mapinfo.midev.geometry.IDirectPositionList;
import com.mapinfo.midev.geometry.IFeatureGeometry;
import com.mapinfo.midev.geometry.IGeometry;
import com.mapinfo.midev.geometry.IMultiFeatureGeometry;
import com.mapinfo.midev.geometry.IPoint;
import com.mapinfo.midev.geometry.InvalidGeometryOperationException;
import com.mapinfo.midev.geometry.MeasurementUtilities;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.impl.DirectPositionArray;
import com.mapinfo.midev.geometry.impl.GeometryFactory;
import com.mapinfo.midev.geometry.impl.LineString;
import com.mapinfo.midev.geometry.impl.MultiCurve;
import com.mapinfo.midev.geometry.operations.cartesian.contains.CartesianContains;
import com.mapinfo.midev.geometry.operations.edge.CartesianOps;
import com.mapinfo.midev.geometry.operations.edge.DistanceResult;
import com.mapinfo.midev.geometry.operations.edge.Edge;
import com.mapinfo.midev.geometry.operations.edge.EdgeFactory;
import com.mapinfo.midev.geometry.operations.edge.EdgeList;
import com.mapinfo.midev.geometry.operations.edge.SphericalOps;
import com.mapinfo.midev.geometry.operations.edge.prepared.GeometryOperationsHelper;
import com.mapinfo.midev.geometry.operations.edge.prepared.IPreparedGeometry;
import com.mapinfo.midev.geometry.operations.edge.prepared.PreparedGeometryFactory;
import com.mapinfo.midev.geometry.operations.rtree.GeometryRTree;
import com.mapinfo.midev.geometry.operations.rtree.JordanWidget;
import com.mapinfo.midev.geometry.operations.rtree.TreeNode;
import com.mapinfo.midev.geometry.operations.rtree.TreeNodeOp;
import com.mapinfo.midev.geometry.util.GeometryVisitor;
import com.mapinfo.midev.geometry.util.IGeometryVisitor;
import com.mapinfo.midev.geometry.util.VisitorResult;
import com.mapinfo.midev.unit.ComputationType;
import com.mapinfo.midev.unit.Length;
import com.mapinfo.midev.util.DoubleRect;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public final class DistanceOp {
    private final IGeometry m_geometry;
    private final SpatialInfo m_originalSpatialInfo;
    private final ComputationType m_model;

    public DistanceOp(IGeometry geometry) {
        this(geometry, null);
    }

    public DistanceOp(IGeometry geometry, ComputationType model) {
        this.m_originalSpatialInfo = geometry.getSpatialInfo();
        this.m_model = (ComputationType)ObjectUtils.defaultIfNull((Object)model, (Object)GeometryUtilities.getDefaultComputationType(geometry.getCoordSys()));
        CoordSys normalizedCSys = CoordSysUtilities.normalizeForDistanceCalculation((CoordSys)geometry.getCoordSys(), (ComputationType)this.m_model);
        geometry = GeometryUtilities.convertIfNecessary(geometry, normalizedCSys);
        this.m_geometry = PreparedGeometryFactory.prepare(geometry, true);
    }

    public Result calculate(IGeometry geometry) {
        geometry = GeometryUtilities.convertIfNecessary(geometry, this.m_geometry.getCoordSys());
        return new Result(this.m_originalSpatialInfo, this.m_model, DistanceOp._distanceAsPoints(this.m_geometry, geometry, this.m_originalSpatialInfo.getCoordSys()));
    }

    public static Length distance(IGeometry first, IGeometry second) {
        return DistanceOp.distance(first, second, null);
    }

    public static Length distance(IGeometry first, IGeometry second, ComputationType model) {
        if (model == null) {
            model = GeometryUtilities.getDefaultComputationType(first.getCoordSys());
        }
        CoordSys normalizedCoordSys = CoordSysUtilities.normalizeForDistanceCalculation((CoordSys)first.getCoordSys(), (ComputationType)model);
        first = GeometryUtilities.convertIfNecessary(first, normalizedCoordSys);
        second = GeometryUtilities.convertIfNecessary(second, normalizedCoordSys);
        return DistanceOp._distance(first, second).getDistance(first.getCoordSys(), model);
    }

    public static Length distanceToEdge(IGeometry first, IGeometry second, ComputationType model) {
        Length result;
        if (model == ComputationType.CARTESIAN && !CoordSysUtilities.isProjected((CoordSys)first.getCoordSys())) {
            IGeometry tmp = first;
            first = second;
            second = tmp;
        }
        if (Double.compare((result = DistanceOp.distance(first, second, model)).getValue(), 0.0) == 0) {
            result = DistanceOp.distanceToEdgeInside(first, second, model);
        }
        return result;
    }

    public static Length distanceToEdgeInside(IGeometry first, IGeometry second, ComputationType model) {
        if (GeometryType.ALL_GEOMETRY_WITH_AREA_TYPE.contains((Object)first.getType())) {
            first = DistanceOp.linearize(first);
        }
        if (GeometryType.ALL_GEOMETRY_WITH_AREA_TYPE.contains((Object)second.getType())) {
            second = DistanceOp.linearize(second);
        }
        return DistanceOp.distance(first, second, model);
    }

    private static IFeatureGeometry linearize(IGeometry geometry) {
        GeometryFactory factory = new GeometryFactory(geometry.getSpatialInfo());
        if (geometry.getType() == GeometryType.MULTI_FEATURE_GEOMETRY) {
            ArrayList<IFeatureGeometry> featureGeometries = new ArrayList<IFeatureGeometry>();
            IMultiFeatureGeometry mfg = (IMultiFeatureGeometry)geometry;
            for (IFeatureGeometry featureGeometry : mfg) {
                if (GeometryType.ALL_GEOMETRY_WITH_AREA_TYPE.contains((Object)featureGeometry.getType())) {
                    featureGeometries.add(DistanceOp.linearize(featureGeometry));
                    continue;
                }
                featureGeometries.add(featureGeometry);
            }
            return factory.newMultiFeatureGeometry(featureGeometries);
        }
        return factory.newMultiCurve(DistanceOp.linearize(geometry, factory));
    }

    private static List<ICurve> linearize(IGeometry geometry, final GeometryFactory factory) {
        final ArrayList<ICurve> curves = new ArrayList<ICurve>();
        GeometryVisitor.visit(geometry, new IGeometryVisitor(){

            @Override
            public VisitorResult points(DirectPosition pt) {
                throw new IllegalArgumentException("Expected area geometry, found points.");
            }

            @Override
            public VisitorResult edges(IDirectPositionList pts) {
                curves.add(factory.newCurve(pts, GeometryType.LINE_STRING));
                return VisitorResult.CONTINUE;
            }
        });
        return curves;
    }

    public static Pair<DirectPosition, DirectPosition> distanceAsPoints(IGeometry first, IGeometry second) {
        return DistanceOp.distanceAsPoints(first, second, null);
    }

    public static Pair<DirectPosition, DirectPosition> distanceAsPoints(IGeometry first, IGeometry second, ComputationType model) {
        if (model == null) {
            model = GeometryUtilities.getDefaultComputationType(first.getCoordSys());
        }
        CoordSys resultCoordSys = first.getCoordSys();
        CoordSys normalizedCoordSys = CoordSysUtilities.normalizeForDistanceCalculation((CoordSys)first.getCoordSys(), (ComputationType)model);
        first = GeometryUtilities.convertIfNecessary(first, normalizedCoordSys);
        second = GeometryUtilities.convertIfNecessary(second, normalizedCoordSys);
        return DistanceOp._distanceAsPoints(first, second, resultCoordSys);
    }

    private static Pair<DirectPosition, DirectPosition> _distanceAsPoints(IGeometry first, IGeometry second, CoordSys resultCoordSys) {
        DistanceResult result = DistanceOp._distance(first, second);
        Pair<DirectPosition, DirectPosition> pts = result.getPoints();
        DirectPosition A = (DirectPosition)pts.getLeft();
        DirectPosition B = (DirectPosition)pts.getRight();
        if (resultCoordSys != null && !first.getCoordSys().equivalent(resultCoordSys)) {
            CoordTransform ct = first.getCoordSys().createCoordTransform(resultCoordSys);
            ct.transform(A, A);
            ct.transform(B, B);
        }
        return new ImmutablePair((Object)A, (Object)B);
    }

    private static DistanceResult _distance(IGeometry g1, IGeometry g2) {
        if (!g1.getCoordSys().equivalent(g2.getCoordSys())) {
            throw new InvalidGeometryOperationException("Coordinate systems disagree.");
        }
        CoordSys csys1 = g1.getCoordSys();
        boolean isCartesian = !CoordSysUtilities.isLongLat((CoordSys)csys1);
        EdgeFactory edgeFactory = new EdgeFactory(isCartesian);
        if (!csys1.equivalent(g1.getCoordSys())) {
            g1 = g1.getCopy(csys1);
            g2 = g2.getCopy(csys1);
        }
        if (g1.getType() == GeometryType.POINT) {
            return DistanceOp._distance((IPoint)g1, PreparedGeometryFactory.prepare(g2, true), edgeFactory);
        }
        if (g2.getType() == GeometryType.POINT) {
            return DistanceOp._distance((IPoint)g2, PreparedGeometryFactory.prepare(g1, true), edgeFactory);
        }
        GeometryRTree geoObj1 = GeometryOperationsHelper.getInstance(g1, true).getIndexedEdges(isCartesian);
        DirectPosition commonPt = new DirectPosition();
        if (GeometryType.ALL_GEOMETRY_WITH_AREA_TYPE.contains((Object)g1.getType()) && DistanceOp.regionApproxOverlaps(new PreparedRegion(g1, geoObj1, isCartesian), g2, commonPt)) {
            DistanceResult result = new DistanceResult();
            result.setA(commonPt);
            result.setB(commonPt);
            result.setProxyDistance2(0.0);
            return result;
        }
        if (GeometryType.ALL_GEOMETRY_WITH_AREA_TYPE.contains((Object)g2.getType()) && DistanceOp.regionApproxOverlaps(g2, g1, commonPt)) {
            DistanceResult result = new DistanceResult();
            result.setA(commonPt);
            result.setB(commonPt);
            result.setProxyDistance2(0.0);
            return result;
        }
        return DistanceOp._distance(geoObj1, g2, edgeFactory);
    }

    private static DistanceResult _distance(IPoint pt, IPreparedGeometry geometry, EdgeFactory edgeFactory) {
        DirectPosition dp1 = pt.getDirectPosition();
        if (geometry.getType() == GeometryType.POINT) {
            DirectPosition dp2 = ((IPoint)((Object)geometry)).getDirectPosition();
            return edgeFactory.isCartesian() ? CartesianOps.distance(dp1, dp2) : SphericalOps.distance(dp1, dp2);
        }
        if (CartesianContains.contains(geometry, pt)) {
            DistanceResult result = new DistanceResult();
            result.setA(dp1);
            result.setB(dp1);
            result.setProxyDistance2(0.0);
            return result;
        }
        Edge ptEdge = edgeFactory.newEdge(dp1, dp1);
        EdgeList edgeList = geometry.getHelper().getEdges(edgeFactory.isCartesian());
        DistanceResult prev = new DistanceResult();
        for (Edge edge : edgeList) {
            DistanceResult cur = edge.distance(ptEdge.getTransA());
            if (!(cur.getProxyDistance2() < prev.getProxyDistance2())) continue;
            prev.setProxyDistance2(cur.getProxyDistance2());
            prev.setA(dp1.getX(), dp1.getY());
            prev.setB(cur.getB(), !edgeList.isCartesian());
            if (!(prev.getProxyDistance2() <= 0.0)) continue;
            return prev;
        }
        return prev;
    }

    private static boolean regionApproxOverlaps(final IGeometry region, IGeometry vg, final DirectPosition commonPt) {
        if (!region.getEnvelope().intersects(vg.getEnvelope())) {
            return false;
        }
        final MutableBoolean overlaps = new MutableBoolean(false);
        GeometryVisitor.visit(vg, new IGeometryVisitor(){

            @Override
            public VisitorResult points(DirectPosition pt) {
                if (region.contains(pt)) {
                    if (commonPt != null) {
                        commonPt.setXY(pt.getX(), pt.getY());
                    }
                    overlaps.setTrue();
                    return VisitorResult.STOP;
                }
                return VisitorResult.CONTINUE;
            }

            @Override
            public VisitorResult edges(IDirectPositionList pts) {
                IDirectPositionIterator i = pts.getDirectPositionIterator();
                DirectPosition pt = new DirectPosition();
                while (i.hasNext()) {
                    i.nextDirectPosition(pt);
                    if (!region.contains(pt)) continue;
                    if (commonPt != null) {
                        commonPt.setXY(pt.getX(), pt.getY());
                    }
                    overlaps.setTrue();
                    return VisitorResult.STOP;
                }
                return VisitorResult.CONTINUE;
            }
        });
        return overlaps.booleanValue();
    }

    private static boolean regionApproxOverlaps(final PreparedRegion region, IGeometry geom, final DirectPosition commonPt) {
        if (!region.getRegion().getEnvelope().intersects(geom.getEnvelope())) {
            return false;
        }
        if (geom instanceof IPoint) {
            DirectPosition dp = ((IPoint)geom).getDirectPosition();
            DirectPosition ptPos = new DirectPosition(dp.getX(), dp.getY());
            if (region.contains(ptPos)) {
                commonPt.set(ptPos);
                return true;
            }
            return false;
        }
        final MutableBoolean overlaps = new MutableBoolean(false);
        GeometryVisitor.visit(geom, new IGeometryVisitor(){

            @Override
            public VisitorResult points(DirectPosition pt) {
                if (region.contains(pt)) {
                    if (commonPt != null) {
                        commonPt.set(pt);
                    }
                    overlaps.setTrue();
                    return VisitorResult.STOP;
                }
                return VisitorResult.CONTINUE;
            }

            @Override
            public VisitorResult edges(IDirectPositionList pts) {
                DirectPosition pt = pts.getDirectPosition(0, new DirectPosition());
                if (region.contains(pt)) {
                    if (commonPt != null) {
                        commonPt.set(pt);
                    }
                    overlaps.setTrue();
                    return VisitorResult.STOP;
                }
                return VisitorResult.CONTINUE;
            }
        });
        return overlaps.booleanValue();
    }

    private static DistanceResult _distance(GeometryRTree geo1, IGeometry geom2, EdgeFactory edgeFacory) {
        final TargetSearch targetWidget = new TargetSearch(geo1, edgeFacory);
        GeometryVisitor.visit(geom2, new IGeometryVisitor(){

            @Override
            public VisitorResult points(DirectPosition pt) {
                return this.visit(pt, pt);
            }

            @Override
            public VisitorResult edges(IDirectPositionList pts) {
                DirectPosition from = new DirectPosition();
                DirectPosition to = new DirectPosition();
                IDirectPositionIterator i = pts.getDirectPositionIterator();
                i.nextDirectPosition(from);
                while (i.hasNext()) {
                    i.nextDirectPosition(to);
                    if (this.visit(from, to) == VisitorResult.STOP) {
                        return VisitorResult.STOP;
                    }
                    from.set(to);
                }
                return VisitorResult.CONTINUE;
            }

            private VisitorResult visit(DirectPosition from, DirectPosition to) {
                targetWidget.sourceEdge = targetWidget.m_edgeFactory.newEdge(from, to);
                if (targetWidget.m_sourceSearchMbr.intersects(targetWidget.sourceEdge.getBounds())) {
                    DistanceOp.computeSearchMbr(targetWidget.m_searchMbr, targetWidget.sourceEdge.getBounds(), targetWidget.m_distance);
                    targetWidget.m_rtree.search(targetWidget.m_searchMbr, targetWidget);
                    if (targetWidget.m_found) {
                        return VisitorResult.STOP;
                    }
                }
                return VisitorResult.CONTINUE;
            }
        });
        return targetWidget.m_answer;
    }

    private static void computeSearchMbr(DoubleRect resultMbr, DoubleRect originalMbr, double dist) {
        resultMbr.setMinX(originalMbr.getMinX() - dist);
        resultMbr.setMinY(originalMbr.getMinY() - dist);
        resultMbr.setMaxX(originalMbr.getMaxX() + dist);
        resultMbr.setMaxY(originalMbr.getMaxY() + dist);
    }

    private static class TargetSearch
    implements TreeNodeOp {
        private final GeometryRTree m_rtree;
        private final EdgeFactory m_edgeFactory;
        private final DistanceResult m_answer;
        private double m_distance;
        private final DoubleRect m_searchMbr;
        private final DoubleRect m_sourceSearchMbr;
        private Edge sourceEdge;
        private boolean m_found = false;

        private TargetSearch(GeometryRTree rtree, EdgeFactory edgeFactory) {
            this.m_rtree = rtree;
            this.m_edgeFactory = edgeFactory;
            this.m_answer = new DistanceResult();
            this.m_searchMbr = new DoubleRect(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
            this.m_sourceSearchMbr = new DoubleRect(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
            this.m_distance = Double.POSITIVE_INFINITY;
        }

        @Override
        public VisitorResult call(Edge node) {
            DistanceResult newDist = node.distance(this.sourceEdge);
            if (newDist.getProxyDistance2() < this.m_answer.getProxyDistance2()) {
                this.m_answer.setProxyDistance2(newDist.getProxyDistance2());
                this.m_answer.setA(newDist.getA(), !this.m_rtree.isCartesian());
                this.m_answer.setB(newDist.getB(), !this.m_rtree.isCartesian());
                if (newDist.getProxyDistance2() <= 0.0) {
                    this.m_found = true;
                    return VisitorResult.STOP;
                }
                this.m_distance = Math.sqrt(newDist.getProxyDistance2());
                DistanceOp.computeSearchMbr(this.m_searchMbr, this.sourceEdge.getBounds(), this.m_distance);
                DistanceOp.computeSearchMbr(this.m_sourceSearchMbr, this.m_rtree.getRoot().getBounds(), this.m_distance);
            }
            return VisitorResult.CONTINUE;
        }

        @Override
        public int[] sortChild(TreeNode[] nodes) {
            double[] dist2 = new double[3];
            int count = 0;
            int best = 0;
            for (int i = 0; i < nodes.length; ++i) {
                dist2[i] = TargetSearch.distance2(nodes[i].getBounds(), this.sourceEdge.getBounds());
                if (dist2[i] < this.m_answer.getProxyDistance2()) {
                    ++count;
                }
                if (!(dist2[i] < dist2[best])) continue;
                best = i;
            }
            int[] order = new int[count];
            if (count > 0) {
                order[0] = best;
                int num = 1;
                for (int i = 0; i < nodes.length; ++i) {
                    if (i == best || !(dist2[i] < this.m_answer.getProxyDistance2())) continue;
                    order[num] = i;
                    ++num;
                }
            }
            return order;
        }

        private static double distance2(DoubleRect mbr1, DoubleRect mbr) {
            double result = 0.0;
            if (mbr.getMinX() > mbr1.getMaxX()) {
                result += (mbr1.getMaxX() - mbr.getMinX()) * (mbr1.getMaxX() - mbr.getMinX());
            } else if (mbr.getMaxX() < mbr1.getMinX()) {
                result += (mbr1.getMinX() - mbr.getMaxX()) * (mbr1.getMinX() - mbr.getMaxX());
            }
            if (mbr.getMinY() > mbr1.getMaxY()) {
                result += (mbr1.getMaxY() - mbr.getMinY()) * (mbr1.getMaxY() - mbr.getMinY());
            } else if (mbr.getMaxY() < mbr1.getMinY()) {
                result += (mbr1.getMinY() - mbr.getMaxY()) * (mbr1.getMinY() - mbr.getMaxY());
            }
            return result;
        }
    }

    private static class PreparedRegion {
        private final IGeometry m_region;
        private final GeometryRTree m_rtree;
        private final boolean m_isCartesian;

        public PreparedRegion(IGeometry region, GeometryRTree rtree, boolean isCartesian) {
            this.m_region = region;
            this.m_rtree = rtree;
            this.m_isCartesian = isCartesian;
        }

        public IGeometry getRegion() {
            return this.m_region;
        }

        private boolean contains(DirectPosition pos) {
            if (!this.m_region.getEnvelope().contains(pos)) {
                return false;
            }
            if (this.m_isCartesian) {
                DoubleRect searchMbr = new DoubleRect(pos, pos);
                searchMbr.setMinX(Double.NEGATIVE_INFINITY);
                JordanWidget counter = new JordanWidget(pos);
                this.m_rtree.search(searchMbr, counter);
                return (counter.getJordanCount() & 1) == 1;
            }
            DoubleRect searchMbr = new DoubleRect(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
            JordanWidget counter = new JordanWidget(pos);
            this.m_rtree.search(searchMbr, counter);
            return (counter.getJordanCount() & 1) == 1;
        }
    }

    public static class Result {
        private final SpatialInfo m_spatialInfo;
        private final ComputationType m_model;
        private final Pair<DirectPosition, DirectPosition> m_pts;
        private Length m_length = null;
        private IFeatureGeometry m_geometry = null;

        public Result(SpatialInfo spatialInfo, ComputationType model, Pair<DirectPosition, DirectPosition> pts) {
            this.m_spatialInfo = spatialInfo;
            this.m_model = model;
            this.m_pts = pts;
        }

        public Pair<DirectPosition, DirectPosition> getPts() {
            return this.m_pts;
        }

        public Length getLength() {
            if (this.m_length == null) {
                this.m_length = MeasurementUtilities.length((DirectPosition)this.m_pts.getLeft(), (DirectPosition)this.m_pts.getRight(), this.m_spatialInfo.getCoordSys(), this.m_model);
            }
            return this.m_length;
        }

        public IFeatureGeometry getGeometry() {
            if (this.m_geometry == null) {
                this.m_geometry = new MultiCurve(this.m_spatialInfo, new LineString(this.m_spatialInfo, new DirectPositionArray((DirectPosition)this.m_pts.getLeft(), (DirectPosition)this.m_pts.getRight())));
            }
            return this.m_geometry;
        }
    }
}

