/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.edge;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.ICurve;
import com.mapinfo.midev.geometry.ICurveSegment;
import com.mapinfo.midev.geometry.IDirectPositionIterator;
import com.mapinfo.midev.geometry.IFeatureGeometry;
import com.mapinfo.midev.geometry.IGeometry;
import com.mapinfo.midev.geometry.ILegacyArc;
import com.mapinfo.midev.geometry.ILegacyEllipse;
import com.mapinfo.midev.geometry.ILegacyRoundedRectangle;
import com.mapinfo.midev.geometry.ILegacyText;
import com.mapinfo.midev.geometry.ILineString;
import com.mapinfo.midev.geometry.IMultiCurve;
import com.mapinfo.midev.geometry.IMultiFeatureGeometry;
import com.mapinfo.midev.geometry.IMultiPoint;
import com.mapinfo.midev.geometry.IMultiPolygon;
import com.mapinfo.midev.geometry.IPoint;
import com.mapinfo.midev.geometry.IPolygon;
import com.mapinfo.midev.geometry.IRectangle;
import com.mapinfo.midev.geometry.IRing;
import com.mapinfo.midev.geometry.operations.edge.Edge;
import com.mapinfo.midev.geometry.operations.edge.EdgeList;
import java.util.Iterator;

public final class EdgeFactory {
    private final boolean m_isCartesian;

    public EdgeFactory(boolean isCartesian) {
        this.m_isCartesian = isCartesian;
    }

    public Edge newEdge(DirectPosition pt1, DirectPosition pt2) {
        return this.m_isCartesian ? new Edge.CartesianEdge(pt1, pt2) : new Edge.SphericalEdge(pt1, pt2);
    }

    public boolean isCartesian() {
        return this.m_isCartesian;
    }

    public EdgeList create(IGeometry geometry) {
        switch (geometry.getType()) {
            case POINT: {
                return this.create(((IPoint)geometry).getDirectPosition());
            }
            case MULTI_POINT: {
                return this.create((IMultiPoint)geometry);
            }
            case MULTI_CURVE: {
                return this.create((IMultiCurve)geometry);
            }
            case MULTI_POLYGON: {
                return this.create((IMultiPolygon)geometry);
            }
            case MULTI_FEATURE_GEOMETRY: {
                return this.create((IMultiFeatureGeometry)geometry);
            }
            case RECTANGLE: {
                return this.create(((IRectangle)geometry).asMultiPolygon());
            }
            case ROUNDED_RECTANGLE: {
                return this.create(((ILegacyRoundedRectangle)geometry).asMultiPolygon());
            }
            case ELLIPSE: {
                return this.create(((ILegacyEllipse)geometry).asMultiPolygon());
            }
            case LEGACY_TEXT: {
                DirectPosition pt = ((ILegacyText)geometry).getRepresentativePoint();
                return this.create(pt);
            }
            case LEGACY_ARC: {
                return this.create(((ILegacyArc)geometry).asMultiCurve());
            }
            case POLYGON: {
                return this.create((IPolygon)geometry);
            }
            case CURVE: {
                return this.create((ICurve)geometry);
            }
            case RING: {
                return this.create((IRing)geometry);
            }
            case LINE_STRING: {
                return this.create((ILineString)geometry);
            }
        }
        throw new IllegalArgumentException("Unsupported geometry type: " + (Object)((Object)geometry.getType()));
    }

    private EdgeList create(IMultiFeatureGeometry multiFeatureGeometry) {
        EdgeList result = new EdgeList(this.m_isCartesian);
        for (IFeatureGeometry g : multiFeatureGeometry) {
            result.addAll(this.create(g));
        }
        return result;
    }

    private EdgeList create(IMultiCurve multiCurve) {
        EdgeList result = new EdgeList(this.m_isCartesian);
        for (ICurve curveSegment : multiCurve) {
            result.addAll(this.create((Iterable<ICurveSegment>)curveSegment));
        }
        return result;
    }

    private EdgeList create(IMultiPolygon multiPolygon) {
        EdgeList result = new EdgeList(this.m_isCartesian);
        for (IPolygon polygon : multiPolygon) {
            result.addAll(this.create(polygon));
        }
        return result;
    }

    private EdgeList create(IPolygon polygon) {
        EdgeList result = new EdgeList(this.m_isCartesian);
        result.addAll(this.create((Iterable<ICurveSegment>)polygon.getExteriorRing()));
        Iterator<IRing> i = polygon.getInteriorRingIterator();
        while (i.hasNext()) {
            result.addAll(this.create((Iterable<ICurveSegment>)i.next()));
        }
        return result;
    }

    private EdgeList create(IRing ring) {
        return this.create((Iterable<ICurveSegment>)ring);
    }

    private EdgeList create(ICurve curve) {
        return this.create((Iterable<ICurveSegment>)curve);
    }

    private EdgeList create(Iterable<ICurveSegment> curveSegments) {
        EdgeList result = new EdgeList(this.m_isCartesian);
        for (ICurveSegment curveSegment : curveSegments) {
            result.addAll(this.create(curveSegment));
        }
        return result;
    }

    private EdgeList create(ICurveSegment curveSegment) {
        IDirectPositionIterator i = curveSegment.getControlPointIterator();
        DirectPosition left = new DirectPosition();
        DirectPosition right = new DirectPosition();
        EdgeList result = new EdgeList(this.m_isCartesian);
        if (i.hasNext()) {
            i.nextDirectPosition(left);
            while (i.hasNext()) {
                i.nextDirectPosition(right);
                result.add(this.newEdge(left, right));
                left.set(right);
            }
        }
        return result;
    }

    private EdgeList create(IMultiPoint multiPoint) {
        EdgeList result = new EdgeList(this.m_isCartesian);
        DirectPosition tmp = new DirectPosition();
        IDirectPositionIterator i = multiPoint.getDirectPositionIterator();
        while (i.hasNext()) {
            i.nextDirectPosition(tmp);
            result.add(this.newEdge(tmp, tmp));
        }
        return result;
    }

    private EdgeList create(DirectPosition point) {
        EdgeList result = new EdgeList(this.m_isCartesian);
        result.add(this.newEdge(point, point));
        return result;
    }
}

