/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.edge.prepared;

import com.mapinfo.midev.geometry.ICurve;
import com.mapinfo.midev.geometry.IGeometry;
import com.mapinfo.midev.geometry.ILegacyArc;
import com.mapinfo.midev.geometry.ILegacyEllipse;
import com.mapinfo.midev.geometry.ILegacyRoundedRectangle;
import com.mapinfo.midev.geometry.ILegacyText;
import com.mapinfo.midev.geometry.ILineString;
import com.mapinfo.midev.geometry.IMultiCurve;
import com.mapinfo.midev.geometry.IMultiFeatureGeometry;
import com.mapinfo.midev.geometry.IMultiPoint;
import com.mapinfo.midev.geometry.IMultiPolygon;
import com.mapinfo.midev.geometry.IPoint;
import com.mapinfo.midev.geometry.IPolygon;
import com.mapinfo.midev.geometry.IRectangle;
import com.mapinfo.midev.geometry.IRing;
import com.mapinfo.midev.geometry.operations.edge.prepared.GeometryOperationsHelper;
import com.mapinfo.midev.geometry.operations.edge.prepared.IPreparedGeometry;
import com.mapinfo.midev.geometry.operations.edge.prepared.PreparedCurve;
import com.mapinfo.midev.geometry.operations.edge.prepared.PreparedLegacyArc;
import com.mapinfo.midev.geometry.operations.edge.prepared.PreparedLegacyEllipse;
import com.mapinfo.midev.geometry.operations.edge.prepared.PreparedLegacyRoundedRectangle;
import com.mapinfo.midev.geometry.operations.edge.prepared.PreparedLegacyText;
import com.mapinfo.midev.geometry.operations.edge.prepared.PreparedLineString;
import com.mapinfo.midev.geometry.operations.edge.prepared.PreparedMultiCurve;
import com.mapinfo.midev.geometry.operations.edge.prepared.PreparedMultiFeatureGeometry;
import com.mapinfo.midev.geometry.operations.edge.prepared.PreparedMultiPoint;
import com.mapinfo.midev.geometry.operations.edge.prepared.PreparedMultiPolygon;
import com.mapinfo.midev.geometry.operations.edge.prepared.PreparedPoint;
import com.mapinfo.midev.geometry.operations.edge.prepared.PreparedPolygon;
import com.mapinfo.midev.geometry.operations.edge.prepared.PreparedRectangle;
import com.mapinfo.midev.geometry.operations.edge.prepared.PreparedRing;

public final class PreparedGeometryFactory {
    private PreparedGeometryFactory() {
    }

    public static IPreparedGeometry prepare(IGeometry geometry, boolean index) {
        if (geometry instanceof IPreparedGeometry) {
            return (IPreparedGeometry)geometry;
        }
        switch (geometry.getType()) {
            case MULTI_CURVE: {
                return PreparedGeometryFactory.prepare((IMultiCurve)geometry, index);
            }
            case MULTI_POLYGON: {
                return PreparedGeometryFactory.prepare((IMultiPolygon)geometry, index);
            }
            case POLYGON: {
                return PreparedGeometryFactory.prepare((IPolygon)geometry, index);
            }
            case RING: {
                return PreparedGeometryFactory.prepare((IRing)geometry, index);
            }
            case POINT: {
                return PreparedGeometryFactory.prepare((IPoint)geometry, index);
            }
            case LINE_STRING: {
                return PreparedGeometryFactory.prepare((ILineString)geometry, index);
            }
            case MULTI_POINT: {
                return PreparedGeometryFactory.prepare((IMultiPoint)geometry, index);
            }
            case CURVE: {
                return PreparedGeometryFactory.prepare((ICurve)geometry, index);
            }
            case LEGACY_ARC: {
                return PreparedGeometryFactory.prepare((ILegacyArc)geometry, index);
            }
            case ELLIPSE: {
                return PreparedGeometryFactory.prepare((ILegacyEllipse)geometry, index);
            }
            case RECTANGLE: {
                return PreparedGeometryFactory.prepare((IRectangle)geometry, index);
            }
            case ROUNDED_RECTANGLE: {
                return PreparedGeometryFactory.prepare((ILegacyRoundedRectangle)geometry, index);
            }
            case MULTI_FEATURE_GEOMETRY: {
                return PreparedGeometryFactory.prepare((IMultiFeatureGeometry)geometry, index);
            }
            case LEGACY_TEXT: {
                return PreparedGeometryFactory.prepare((ILegacyText)geometry, index);
            }
        }
        throw new IllegalArgumentException("Unable to prepare geometry type: " + (Object)((Object)geometry.getType()));
    }

    public static PreparedMultiCurve prepare(IMultiCurve geometry, boolean index) {
        return new PreparedMultiCurve(geometry, GeometryOperationsHelper.getInstance(geometry, index));
    }

    public static PreparedMultiPolygon prepare(IMultiPolygon geometry, boolean index) {
        return new PreparedMultiPolygon(geometry, GeometryOperationsHelper.getInstance(geometry, index));
    }

    public static PreparedPolygon prepare(IPolygon geometry, boolean index) {
        return new PreparedPolygon(geometry, GeometryOperationsHelper.getInstance(geometry, index));
    }

    public static PreparedRing prepare(IRing geometry, boolean index) {
        return new PreparedRing(geometry, GeometryOperationsHelper.getInstance(geometry, index));
    }

    public static PreparedPoint prepare(IPoint geometry, boolean index) {
        return new PreparedPoint(geometry, GeometryOperationsHelper.getInstance(geometry, index));
    }

    public static PreparedLineString prepare(ILineString geometry, boolean index) {
        return new PreparedLineString(geometry, GeometryOperationsHelper.getInstance(geometry, index));
    }

    public static PreparedMultiPoint prepare(IMultiPoint geometry, boolean index) {
        return new PreparedMultiPoint(geometry, GeometryOperationsHelper.getInstance(geometry, index));
    }

    public static PreparedCurve prepare(ICurve geometry, boolean index) {
        return new PreparedCurve(geometry, GeometryOperationsHelper.getInstance(geometry, index));
    }

    public static PreparedLegacyArc prepare(ILegacyArc geometry, boolean index) {
        return new PreparedLegacyArc(geometry, GeometryOperationsHelper.getInstance(geometry, index));
    }

    public static PreparedLegacyEllipse prepare(ILegacyEllipse geometry, boolean index) {
        return new PreparedLegacyEllipse(geometry, GeometryOperationsHelper.getInstance(geometry, index));
    }

    public static PreparedRectangle prepare(IRectangle geometry, boolean index) {
        return new PreparedRectangle(geometry, GeometryOperationsHelper.getInstance(geometry, index));
    }

    public static PreparedLegacyRoundedRectangle prepare(ILegacyRoundedRectangle geometry, boolean index) {
        return new PreparedLegacyRoundedRectangle(geometry, GeometryOperationsHelper.getInstance(geometry, index));
    }

    public static PreparedMultiFeatureGeometry prepare(IMultiFeatureGeometry geometry, boolean index) {
        return new PreparedMultiFeatureGeometry(geometry, GeometryOperationsHelper.getInstance(geometry, index));
    }

    public static PreparedLegacyText prepare(ILegacyText geometry, boolean index) {
        return new PreparedLegacyText(geometry, GeometryOperationsHelper.getInstance(geometry, index));
    }
}

