/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.intersects;

import com.mapinfo.midev.geometry.GeometryUtilities;
import com.mapinfo.midev.geometry.IGeometry;
import com.mapinfo.midev.geometry.operations.cartesian.intersects.CartesianIntersects;
import com.mapinfo.midev.geometry.operations.edge.prepared.IPreparedGeometry;
import com.mapinfo.midev.geometry.operations.edge.prepared.PreparedGeometryFactory;

public final class IntersectsOp {
    private final IPreparedGeometry m_geometry;

    public IntersectsOp(IGeometry geometry) {
        this.m_geometry = PreparedGeometryFactory.prepare(geometry, true);
    }

    public boolean intersects(IGeometry geometry) {
        return IntersectsOp.intersects(this.m_geometry, geometry);
    }

    public static boolean intersects(IGeometry left, IGeometry right) {
        right = GeometryUtilities.convertIfNecessary(right, left.getCoordSys());
        return CartesianIntersects.intersects(left, right);
    }
}

