/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.rtree;

import com.mapinfo.midev.geometry.operations.edge.Edge;
import com.mapinfo.midev.geometry.operations.rtree.TreeNode;
import com.mapinfo.midev.geometry.operations.rtree.TreeNodeOp;
import com.mapinfo.midev.geometry.util.VisitorResult;

public final class EdgeIntersectsWidget
implements TreeNodeOp {
    private static final int[] SORT_CHILD_ORDER = new int[]{0, 1, 2};
    private final Edge m_edge;
    private final double m_tolerance;
    private boolean m_intersects = false;

    public EdgeIntersectsWidget(Edge edge, double tolerance) {
        this.m_tolerance = tolerance;
        this.m_edge = edge;
    }

    public boolean intersects() {
        return this.m_intersects;
    }

    @Override
    public VisitorResult call(Edge node) {
        if (this.m_edge.intersects(node, this.m_tolerance)) {
            this.m_intersects = true;
            return VisitorResult.STOP;
        }
        return VisitorResult.CONTINUE;
    }

    @Override
    public int[] sortChild(TreeNode[] child) {
        return SORT_CHILD_ORDER;
    }
}

