/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.rtree;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.operations.cartesian.contains.RingContainsPoint;
import com.mapinfo.midev.geometry.operations.edge.Edge;
import com.mapinfo.midev.geometry.operations.rtree.TreeNode;
import com.mapinfo.midev.geometry.operations.rtree.TreeNodeOp;
import com.mapinfo.midev.geometry.util.VisitorResult;

public final class JordanWidget
implements TreeNodeOp {
    private static final int[] SORT_CHILD_ORDER = new int[]{0, 1, 2};
    private final double m_dpX;
    private final double m_dpY;
    private int m_jordanCount = 0;

    public JordanWidget(DirectPosition dp) {
        this.m_dpX = dp.getX();
        this.m_dpY = dp.getY();
    }

    public int getJordanCount() {
        return this.m_jordanCount;
    }

    @Override
    public VisitorResult call(Edge node) {
        if (RingContainsPoint.intersectLeftRay(node.getPoint1().getX(), node.getPoint1().getY(), node.getPoint2().getX(), node.getPoint2().getY(), this.m_dpX, this.m_dpY)) {
            ++this.m_jordanCount;
        }
        return VisitorResult.CONTINUE;
    }

    @Override
    public int[] sortChild(TreeNode[] child) {
        return SORT_CHILD_ORDER;
    }
}

