/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.rtree;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.operations.edge.Edge;
import com.mapinfo.midev.geometry.operations.rtree.TreeNode;
import com.mapinfo.midev.geometry.operations.rtree.TreeNodeOp;
import com.mapinfo.midev.geometry.util.VisitorResult;

public final class PointIntersectsWidget
implements TreeNodeOp {
    private static final int[] SORT_CHILD_ORDER = new int[]{0, 1, 2};
    private final DirectPosition m_dp;
    private final double m_tolerance;
    private boolean m_intersects = false;

    public PointIntersectsWidget(DirectPosition dp, double tolerance) {
        this.m_dp = dp;
        this.m_tolerance = tolerance;
    }

    public boolean intersects() {
        return this.m_intersects;
    }

    @Override
    public VisitorResult call(Edge node) {
        if (node.intersects(this.m_dp, this.m_tolerance)) {
            this.m_intersects = true;
            return VisitorResult.STOP;
        }
        return VisitorResult.CONTINUE;
    }

    @Override
    public int[] sortChild(TreeNode[] child) {
        return SORT_CHILD_ORDER;
    }
}

