/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.rtree;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.operations.edge.Edge;
import com.mapinfo.midev.geometry.operations.rtree.TreeNodeOp;
import com.mapinfo.midev.geometry.util.VisitorResult;
import com.mapinfo.midev.util.DoubleRect;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;

public final class TreeNode
implements Serializable {
    private static final int NUM_ATTEMPTS = 5;
    private static final int SMALL_ENOUGH = 5;
    private static final int MIN_REDUCTION = 2;
    private static final Random m_rand = new Random();
    private final DoubleRect m_bounds;
    private TreeNode[] m_children = null;
    private Edge[] m_datum;

    TreeNode(Edge[] datum, DoubleRect bounds) {
        this.m_datum = datum;
        this.m_bounds = bounds;
    }

    public DoubleRect getBounds() {
        return this.m_bounds;
    }

    private void computeMbr() {
        this.m_bounds.initBounds();
        if (this.m_children != null) {
            for (TreeNode node : this.m_children) {
                node.computeMbr();
                this.m_bounds.merge(node.m_bounds);
            }
        } else {
            for (Edge aDatum : this.m_datum) {
                this.m_bounds.merge(aDatum.getBounds());
            }
        }
    }

    VisitorResult searchNode(DoubleRect searchMbr, TreeNodeOp op) {
        block4: {
            if (!this.m_bounds.intersects(searchMbr)) break block4;
            if (this.m_children == null) {
                for (Edge datum : this.m_datum) {
                    if (op.call(datum) != VisitorResult.STOP) continue;
                    return VisitorResult.STOP;
                }
            } else {
                int[] childOrder;
                for (int child : childOrder = op.sortChild(this.m_children)) {
                    if (this.m_children[child].searchNode(searchMbr, op) != VisitorResult.STOP) continue;
                    return VisitorResult.STOP;
                }
            }
        }
        return VisitorResult.CONTINUE;
    }

    void trySplit() {
        if (this.m_datum == null || this.m_datum.length <= 5) {
            return;
        }
        int preferredAxis = 0;
        if (this.m_bounds.getMaxY() - this.m_bounds.getMinY() > this.m_bounds.getMaxX() - this.m_bounds.getMinX()) {
            preferredAxis = 1;
        }
        Splitter bestSplit = null;
        double best = Double.POSITIVE_INFINITY;
        int bestCount = 0;
        int tries = Math.min((int)Math.sqrt(this.m_datum.length), 5);
        for (int axisIncrement = 0; bestSplit == null && axisIncrement < 3; ++axisIncrement) {
            int axis = (preferredAxis + axisIncrement) % 3;
            for (int sample = 0; sample < tries; ++sample) {
                Edge e = this.m_datum[m_rand.nextInt(this.m_datum.length)];
                DirectPosition splitPt = e.getBounds().center();
                Splitter s = new Splitter(this, splitPt, axis);
                s.split(false);
                boolean badSplit = false;
                double maxBinWidth = 0.0;
                for (int i = 0; i < 3; ++i) {
                    if (s.m_binCount[i] > this.m_datum.length - 2) {
                        badSplit = true;
                    }
                    maxBinWidth = Math.max(maxBinWidth, s.m_binMbr[i].getMaxX() - s.m_binMbr[i].getMinX());
                    maxBinWidth = Math.max(maxBinWidth, s.m_binMbr[i].getMaxY() - s.m_binMbr[i].getMinY());
                }
                double score = maxBinWidth;
                if (!badSplit && (bestSplit == null || score < best)) {
                    bestCount = 1;
                    bestSplit = s;
                    best = score;
                    continue;
                }
                if (score != best) continue;
                ++bestCount;
                if (!(m_rand.nextDouble() < 1.0 / (double)bestCount)) continue;
                bestSplit = s;
                best = score;
            }
        }
        if (bestSplit == null) {
            return;
        }
        this.m_children = new TreeNode[]{new TreeNode(new Edge[bestSplit.m_binCount[0]], bestSplit.m_binMbr[0]), new TreeNode(new Edge[bestSplit.m_binCount[1]], bestSplit.m_binMbr[1]), new TreeNode(new Edge[bestSplit.m_binCount[2]], bestSplit.m_binMbr[2])};
        bestSplit.split(true);
        this.m_datum = null;
        for (int i = 0; i < 3; ++i) {
            this.m_children[i].trySplit();
        }
    }

    static /* synthetic */ Edge[] access$202(TreeNode x0, Edge[] x1) {
        x0.m_datum = x1;
        return x1;
    }

    private static class Splitter {
        private final TreeNode m_treeNode;
        private final DirectPosition m_split;
        private final int m_axis;
        private final int[] m_binCount = new int[3];
        private final DoubleRect[] m_binMbr = new DoubleRect[3];

        Splitter(TreeNode treeNode, DirectPosition splitPt, int splitAxis) {
            this.m_treeNode = treeNode;
            this.m_split = splitPt;
            this.m_axis = splitAxis;
            for (int i = 0; i < this.m_binMbr.length; ++i) {
                this.m_binMbr[i] = new DoubleRect();
            }
        }

        void split(boolean doIt) {
            Arrays.fill(this.m_binCount, 0);
            for (DoubleRect doubleRect : this.m_binMbr) {
                doubleRect.initBounds();
            }
            for (Edge edge : this.m_treeNode.m_datum) {
                int bin = 1;
                switch (this.m_axis) {
                    case 0: {
                        if (edge.getBounds().getMinX() > this.m_split.getX()) {
                            bin = 2;
                            break;
                        }
                        if (edge.getBounds().getMaxX() < this.m_split.getX()) {
                            bin = 0;
                            break;
                        }
                        bin = 1;
                        break;
                    }
                    case 1: {
                        bin = edge.getBounds().getMinY() > this.m_split.getY() ? 2 : (edge.getBounds().getMaxY() < this.m_split.getY() ? 0 : 1);
                    }
                }
                if (doIt) {
                    ((TreeNode)((TreeNode)this.m_treeNode).m_children[bin]).m_datum[this.m_binCount[bin]] = edge;
                }
                int n = bin;
                this.m_binCount[n] = this.m_binCount[n] + 1;
                this.m_binMbr[bin].merge(edge.getBounds());
            }
            if (doIt) {
                TreeNode.access$202(this.m_treeNode, null);
                for (TreeNode treeNode : this.m_treeNode.m_children) {
                    treeNode.computeMbr();
                }
            }
        }
    }
}

