/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.s2;

import com.mapinfo.midev.geometry.IFeatureGeometry;
import com.mapinfo.midev.geometry.IGeometry;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.operations.IAggregatedOperation;
import com.mapinfo.midev.geometry.operations.s2.BufferWidgetProvider;
import com.mapinfo.midev.geometry.operations.s2.Combine;
import com.mapinfo.midev.geometry.operations.s2.ComboMonitor;
import com.mapinfo.midev.geometry.operations.s2.Erase;
import com.mapinfo.midev.geometry.operations.s2.IBufferWidget;
import com.mapinfo.midev.geometry.operations.s2.IProgressMonitor;
import com.mapinfo.midev.geometry.operations.s2.InputType;
import com.mapinfo.midev.geometry.operations.s2.ProportionalMonitor;
import com.mapinfo.midev.geometry.operations.s2.S2Utilities;
import com.mapinfo.midev.geometry.operations.s2.util.Assert;
import com.mapinfo.midev.unit.ComputationType;
import com.mapinfo.midev.unit.Offset;

public final class Buffer
implements IAggregatedOperation {
    private IBufferWidget m_widget;
    private Combine m_combTargets;
    private Combine m_combCutters;
    private boolean m_cutterAdded;
    private int m_nGeomsAdded;
    private IProgressMonitor m_monitor;
    private ComboMonitor m_aggregatorMonitor;
    private Receiver m_receiver;

    public Buffer(SpatialInfo spatialInfo, Offset offset, int resolution, ComputationType computationType) {
        this(spatialInfo, BufferWidgetProvider.create(offset, resolution, spatialInfo.getCoordSys(), computationType));
    }

    public Buffer(SpatialInfo spatialInfo, IBufferWidget widget) {
        this(spatialInfo, widget, false);
    }

    private Buffer(SpatialInfo spatialInfo, IBufferWidget widget, boolean presorted) {
        this.m_widget = widget;
        this.m_combTargets = new Combine(spatialInfo, presorted);
        this.m_combCutters = new Combine(spatialInfo, presorted);
        this.m_cutterAdded = false;
        this.m_nGeomsAdded = 0;
        this.m_monitor = null;
        this.m_aggregatorMonitor = null;
        this.m_receiver = new Receiver(this.m_combTargets, this.m_combCutters, this.m_cutterAdded);
        this.initialize();
    }

    @Override
    public void add(IGeometry geom) {
        ++this.m_nGeomsAdded;
        double proportionThisAdd = 1.0 / (double)this.m_nGeomsAdded;
        ProportionalMonitor pmon = new ProportionalMonitor(this.m_aggregatorMonitor.getSubMonitor(1), 1.0 - proportionThisAdd, proportionThisAdd);
        boolean global = this.m_widget.objectOutputsMixable();
        this.m_receiver.setGlobal(global);
        this.m_widget.registerProgressMonitor(pmon);
        this.m_widget.registerOutput(this.m_receiver);
        this.m_widget.buffer(geom);
        if (!global) {
            this.m_receiver.flushLocal();
        }
        this.m_widget.registerProgressMonitor(null);
    }

    @Override
    public void addMultiple(Iterable<? extends IGeometry> geoms) {
        for (IGeometry iGeometry : geoms) {
            this.add(iGeometry);
        }
    }

    void clear() {
        this.m_combTargets.clear();
        this.m_combCutters.clear();
        this.initialize();
    }

    @Override
    public IFeatureGeometry result() {
        IFeatureGeometry result = this.m_cutterAdded ? Erase.erase(this.m_combTargets.result(), this.m_combCutters.result()) : this.m_combTargets.result();
        if (this.m_widget.outputPolygonsOnly()) {
            Assert.assertCondition(0 == S2Utilities.getAllPoints(result).size());
            Assert.assertCondition(0 == S2Utilities.getAllCurves(result).getCurveCount());
            result = S2Utilities.getAllPolygons(result);
        }
        this.clear();
        return result;
    }

    void registerProgressMonitor(IProgressMonitor monitor) {
        this.m_monitor = monitor;
        this.m_aggregatorMonitor.registerProgressMonitor(monitor);
    }

    private void initialize() {
        this.m_widget.registerOutput(this.m_receiver);
        this.m_receiver.flushLocal();
        this.m_receiver.setGlobal(true);
        this.m_nGeomsAdded = 0;
        this.m_combTargets.clear();
        this.m_combCutters.clear();
        this.m_aggregatorMonitor = null;
        this.m_aggregatorMonitor = new ComboMonitor(this.m_monitor, 2);
        this.m_combTargets.registerProgressMonitor(this.m_aggregatorMonitor.getSubMonitor(0));
        this.m_cutterAdded = false;
    }

    private static class Receiver
    implements IBufferWidget.BufferWidgetOutput {
        private final Combine m_targets;
        private final Combine m_cutters;
        private boolean m_cutterAdded;
        private boolean m_global;
        private final Combine m_localTargets;
        private final Combine m_localCutters;
        private boolean m_localCutterAdded;

        private Receiver(Combine targets, Combine cutters, boolean cutterAdded) {
            this.m_targets = targets;
            this.m_cutters = cutters;
            this.m_cutterAdded = cutterAdded;
            this.m_global = true;
            this.m_localTargets = new Combine(targets.getSpatialInfo());
            this.m_localCutters = new Combine(cutters.getSpatialInfo());
            this.m_localCutterAdded = false;
        }

        @Override
        public void add(IGeometry geom, boolean target, boolean clean, InputType model) {
            if (this.m_global) {
                if (target) {
                    this.m_targets.add(geom, clean, model);
                } else {
                    this.m_cutters.add(geom, clean, model);
                    this.m_cutterAdded = true;
                }
            } else if (target) {
                this.m_localTargets.add(geom, clean, model);
            } else {
                this.m_localCutters.add(geom, clean, model);
                this.m_localCutterAdded = true;
            }
        }

        public void setGlobal(boolean global) {
            this.m_global = global;
        }

        @Override
        public void flushLocal() {
            if (this.m_localCutterAdded) {
                this.m_targets.add(Erase.erase(this.m_localTargets.result(), this.m_localCutters.result()));
                this.m_localTargets.clear();
                this.m_localCutters.clear();
                this.m_localCutterAdded = false;
            } else {
                this.m_targets.add(this.m_localTargets.result());
                this.m_localTargets.clear();
            }
        }
    }
}

