/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.s2;

import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.geometry.operations.s2.FauxSphericalWidthProvider;
import com.mapinfo.midev.geometry.operations.s2.IBufferWidget;
import com.mapinfo.midev.geometry.operations.s2.LegacyBufferWidget;
import com.mapinfo.midev.geometry.operations.s2.StaticWidthProvider;
import com.mapinfo.midev.unit.ComputationType;
import com.mapinfo.midev.unit.Offset;

public final class BufferWidgetProvider {
    private BufferWidgetProvider() {
    }

    public static IBufferWidget create(Offset offset, int resolution, CoordSys coordSys, ComputationType computationType) {
        switch (computationType) {
            case SPHERICAL: {
                return new LegacyBufferWidget(new FauxSphericalWidthProvider(offset), resolution);
            }
            case CARTESIAN: {
                return new LegacyBufferWidget(new StaticWidthProvider(offset, coordSys), resolution);
            }
        }
        throw new UnsupportedOperationException("Unknown computation type: " + computationType);
    }
}

