/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.s2;

import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.geometry.GeometryUtilities;
import com.mapinfo.midev.geometry.IFeatureGeometry;
import com.mapinfo.midev.geometry.IGeometry;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.impl.MultiFeatureGeometry;
import com.mapinfo.midev.geometry.operations.IAggregatedOperation;
import com.mapinfo.midev.geometry.operations.s2.CutterType;
import com.mapinfo.midev.geometry.operations.s2.IProgressMonitor;
import com.mapinfo.midev.geometry.operations.s2.InputType;
import com.mapinfo.midev.geometry.operations.s2.PlaneSweepErase;
import com.mapinfo.midev.geometry.operations.s2.util.Assert;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class Combine
implements IAggregatedOperation {
    private static final int DEFAULT_MAXCLUSTER = 50;
    private static final int DEFAULT_MAXCOLLECT = 1000;
    private static final int ESTIMATED_WORK_LEVEL_MULTIPLIER = 3;
    private static final int OVERLAP_SEARCH_STEPSIZE = 10;
    private final SpatialInfo m_spatialInfo;
    private int m_prevOverlap;
    private final int m_maxCluster;
    private final int m_maxCollect;
    private final boolean m_alreadySorted;
    private final InputType m_orient;
    private List<GeomModel> m_geoms;
    private boolean m_geomsClean;
    private int m_totalWork;
    private Combine m_nextLevel;
    private IProgressMonitor m_monitor;
    private Combine m_parent;
    private final int m_minNumberToSort;
    private double m_nCombinesDone;
    private double m_estimatedRemainingCombines;

    public Combine(SpatialInfo spatialInfo) {
        this(spatialInfo, false);
    }

    Combine(SpatialInfo spatialInfo, boolean presorted) {
        this(spatialInfo, presorted, InputType.RingXOR, 50, 1000);
    }

    private Combine(SpatialInfo spatialInfo, boolean presorted, InputType orient, int maxCluster, int maxCollect) {
        this.m_spatialInfo = spatialInfo;
        this.m_prevOverlap = 0;
        this.m_maxCluster = maxCluster < 2 ? 2 : maxCluster;
        this.m_maxCollect = maxCollect < this.m_maxCluster ? maxCluster : maxCollect;
        this.m_alreadySorted = presorted;
        this.m_orient = orient;
        this.m_geoms = new ArrayList<GeomModel>();
        this.m_geomsClean = true;
        this.m_totalWork = 0;
        this.m_nextLevel = null;
        this.m_monitor = null;
        this.m_parent = null;
        this.m_minNumberToSort = Combine.calcMinNumberToSort(this.m_maxCluster);
        this.m_nCombinesDone = 0.0;
        this.m_estimatedRemainingCombines = 0.0;
        this.initialize();
    }

    public SpatialInfo getSpatialInfo() {
        return this.m_spatialInfo;
    }

    private static int calcMinNumberToSort(int maxCluster) {
        int minNumberToSort = (int)Math.sqrt(maxCluster);
        if (minNumberToSort < 3) {
            minNumberToSort = 3;
        }
        return minNumberToSort;
    }

    private void initialize() {
        this.m_geoms.clear();
        this.m_geomsClean = true;
        this.m_prevOverlap = 0;
        this.m_totalWork = 0;
        if (this.m_nextLevel != null) {
            this.m_nextLevel = null;
        }
        this.m_monitor = null;
        this.m_nCombinesDone = 0.0;
        this.m_estimatedRemainingCombines = 0.0;
    }

    private void spatialPartition(List<Integer> indexX, List<Integer> indexY, List<Boolean> whichList, boolean splitOnX, List<Integer> sortedResult) {
        int i;
        Assert.assertCondition(indexX.size() == indexY.size());
        int size = indexX.size();
        int half = (size + 1) / 2;
        if (size == 0) {
            return;
        }
        if (size == 1) {
            Assert.assertCondition(indexX.get(0).equals(indexY.get(0)));
            sortedResult.add(indexX.get(0));
            return;
        }
        if (splitOnX) {
            for (i = 0; i < size; ++i) {
                whichList.set(indexX.get(i), i < half);
            }
        } else {
            for (i = 0; i < size; ++i) {
                whichList.set(indexY.get(i), i < half);
            }
        }
        ArrayList<Integer> firstX = new ArrayList<Integer>(half);
        ArrayList<Integer> secondX = new ArrayList<Integer>(half);
        ArrayList<Integer> firstY = new ArrayList<Integer>(half);
        ArrayList<Integer> secondY = new ArrayList<Integer>(half);
        for (int i2 = 0; i2 < size; ++i2) {
            if (whichList.get(indexX.get(i2)).booleanValue()) {
                firstX.add(indexX.get(i2));
            } else {
                secondX.add(indexX.get(i2));
            }
            if (whichList.get(indexY.get(i2)).booleanValue()) {
                firstY.add(indexY.get(i2));
                continue;
            }
            secondY.add(indexY.get(i2));
        }
        this.spatialPartition(firstX, firstY, whichList, !splitOnX, sortedResult);
        firstX.clear();
        firstY.clear();
        this.spatialPartition(secondX, secondY, whichList, !splitOnX, sortedResult);
    }

    private void spatialSort() {
        ArrayList<Integer> sortedX = new ArrayList<Integer>(this.m_geoms.size());
        ArrayList<Integer> sortedY = new ArrayList<Integer>(this.m_geoms.size());
        ArrayList<Boolean> whichList = new ArrayList<Boolean>(this.m_geoms.size());
        for (int i = 0; i < this.m_geoms.size(); ++i) {
            sortedX.add(i);
            sortedY.add(i);
            whichList.add(Boolean.FALSE);
        }
        Collections.sort(sortedX, new Comparator<Integer>(){

            @Override
            public int compare(Integer a, Integer b) {
                double bX;
                double aX = ((GeomModel)Combine.this.m_geoms.get(a)).getGeometry().getEnvelope().getLLX() + ((GeomModel)Combine.this.m_geoms.get(a)).getGeometry().getEnvelope().getURX();
                return aX == (bX = ((GeomModel)Combine.this.m_geoms.get(b)).getGeometry().getEnvelope().getLLX() + ((GeomModel)Combine.this.m_geoms.get(b)).getGeometry().getEnvelope().getURX()) ? 0 : (aX < bX ? -1 : 1);
            }
        });
        Collections.sort(sortedY, new Comparator<Integer>(){

            @Override
            public int compare(Integer a, Integer b) {
                double bY;
                double aY = ((GeomModel)Combine.this.m_geoms.get(a)).getGeometry().getEnvelope().getLLY() + ((GeomModel)Combine.this.m_geoms.get(a)).getGeometry().getEnvelope().getURY();
                return aY == (bY = ((GeomModel)Combine.this.m_geoms.get(b)).getGeometry().getEnvelope().getLLY() + ((GeomModel)Combine.this.m_geoms.get(b)).getGeometry().getEnvelope().getURY()) ? 0 : (aY < bY ? -1 : 1);
            }
        });
        ArrayList<Integer> sortedResult = new ArrayList<Integer>(this.m_geoms.size());
        this.spatialPartition(sortedX, sortedY, whichList, true, sortedResult);
        Assert.assertCondition(sortedResult.size() == this.m_geoms.size());
        ArrayList<GeomModel> sortedGeoms = new ArrayList<GeomModel>(this.m_geoms.size());
        for (int i = 0; i < this.m_geoms.size(); ++i) {
            sortedGeoms.add(this.m_geoms.get((Integer)sortedResult.get(i)));
        }
        this.m_geoms = sortedGeoms;
    }

    private int estimatedIncrementalWork(int start, int index) {
        int oldPrevOverlap;
        Envelope geomEnv = this.m_geoms.get(index).getGeometry().getEnvelope();
        do {
            oldPrevOverlap = this.m_prevOverlap;
            this.m_prevOverlap = this.m_prevOverlap > start + 10 ? (this.m_prevOverlap -= 10) : start;
            while (this.m_prevOverlap < index && !geomEnv.intersects(this.m_geoms.get(this.m_prevOverlap).getGeometry().getEnvelope())) {
                ++this.m_prevOverlap;
            }
        } while (this.m_prevOverlap < oldPrevOverlap);
        return index - this.m_prevOverlap + 1;
    }

    private void processGeomsToNextLevel() {
        if (this.m_nextLevel == null) {
            this.m_nextLevel = new Combine(this.m_spatialInfo, this.m_alreadySorted, InputType.RingXOR, this.m_maxCluster, this.m_maxCollect);
            this.m_nextLevel.m_parent = this;
        }
        if (this.m_geoms.size() != 0) {
            if (this.m_geoms.size() == 1 && this.m_geomsClean) {
                this.m_nextLevel.add(this.m_geoms.get(0).getGeometry(), this.m_geomsClean, this.m_geoms.get(0).getType());
            } else if (this.m_alreadySorted || this.m_geoms.size() <= this.m_minNumberToSort) {
                this.m_estimatedRemainingCombines = 1.0;
                this.m_nextLevel.add(this.doCombine(0, this.m_geoms.size()), true);
            } else {
                this.spatialSort();
                int lastEnd = 0;
                this.m_totalWork = 0;
                this.m_prevOverlap = 0;
                for (int i = 0; i < this.m_geoms.size(); ++i) {
                    this.m_totalWork += this.estimatedIncrementalWork(lastEnd, i);
                    if (this.m_totalWork <= this.m_maxCluster) continue;
                    this.m_estimatedRemainingCombines = 1.0 + (double)(this.m_geoms.size() - i + (this.m_minNumberToSort - 1)) / (double)this.m_minNumberToSort;
                    this.m_nextLevel.add(this.doCombine(lastEnd, i), true);
                    lastEnd = i;
                    this.m_totalWork = 0;
                    this.m_prevOverlap = i;
                }
                if (lastEnd < this.m_geoms.size()) {
                    this.m_estimatedRemainingCombines = 1.0;
                    this.m_nextLevel.add(this.doCombine(lastEnd, this.m_geoms.size()), true);
                }
            }
        }
        this.m_geoms.clear();
        this.m_geomsClean = true;
        this.m_totalWork = 0;
        this.m_prevOverlap = 0;
        this.m_estimatedRemainingCombines = 0.0;
    }

    void clear() {
    }

    @Override
    public void add(IGeometry geom) {
        this.add(geom, false, this.m_orient);
    }

    @Override
    public void addMultiple(Iterable<? extends IGeometry> geoms) {
        for (IGeometry iGeometry : geoms) {
            this.add(iGeometry);
        }
    }

    private void add(IGeometry geom, boolean isClean) {
        this.add(geom, isClean, InputType.RingXOR);
    }

    void add(IGeometry geom, boolean isClean, InputType model) {
        if (geom.isEmpty()) {
            return;
        }
        this.m_geoms.add(new GeomModel(geom, model));
        this.m_geomsClean &= isClean;
        if (!this.m_alreadySorted) {
            this.m_estimatedRemainingCombines = (double)(this.m_geoms.size() + this.m_minNumberToSort - 1) / (double)this.m_minNumberToSort;
            if (this.m_geoms.size() >= this.m_maxCollect) {
                this.processGeomsToNextLevel();
            }
        } else {
            this.m_estimatedRemainingCombines = 1.0;
            this.m_totalWork += this.estimatedIncrementalWork(0, this.m_geoms.size() - 1);
            if (this.m_totalWork >= this.m_maxCluster) {
                this.processGeomsToNextLevel();
            }
        }
    }

    @Override
    public IFeatureGeometry result() {
        IFeatureGeometry result = new MultiFeatureGeometry(this.m_spatialInfo);
        boolean done = false;
        if (this.m_nextLevel == null) {
            if (this.m_geoms.size() == 0) {
                done = true;
            } else if (this.m_geoms.size() == 1 && this.m_geomsClean) {
                result = GeometryUtilities.convertToFeatureGeometry(this.m_geoms.get(0).getGeometry());
                done = true;
            }
        }
        if (!done) {
            this.processGeomsToNextLevel();
            result = this.m_nextLevel.result();
        }
        this.initialize();
        return result;
    }

    private Pair workEstimate(double fractionOfACombineDone) {
        Assert.assertCondition(0.0 <= fractionOfACombineDone);
        Assert.assertCondition(fractionOfACombineDone <= 1.0);
        double workDone = this.m_nCombinesDone + fractionOfACombineDone;
        double workRemaining = this.m_estimatedRemainingCombines - fractionOfACombineDone;
        if (this.m_nextLevel != null) {
            Pair levelWork = this.m_nextLevel.workEstimate(0.0);
            workDone += 3.0 * levelWork.getFirst();
            workRemaining += 3.0 * levelWork.getSecond();
        }
        return new Pair(workDone, workRemaining);
    }

    private void reportProgress(double fractionOfACombineDone) {
        if (this.m_monitor != null) {
            Pair estimate = this.workEstimate(fractionOfACombineDone);
            this.m_monitor.progress(estimate.getFirst(), estimate.getFirst() + estimate.getSecond());
        } else if (this.m_parent != null) {
            Assert.assertCondition(this.m_parent != this);
            this.m_parent.reportProgress(fractionOfACombineDone);
        }
    }

    private IFeatureGeometry doCombine(int start, int end) {
        this.reportProgress(0.0);
        PlaneSweepErase sweep = new PlaneSweepErase(this.m_spatialInfo, 0.0);
        Monitor sweepMonitor = new Monitor(this);
        sweep.registerProgressMonitor(sweepMonitor);
        for (int i = start; i < end; ++i) {
            sweep.addGeometry(this.m_geoms.get(i).getGeometry(), CutterType.NONE, this.m_geoms.get(i).getType());
        }
        IFeatureGeometry result = sweep.sweep();
        this.m_nCombinesDone += 1.0;
        return result;
    }

    public void registerProgressMonitor(IProgressMonitor monitor) {
        this.m_monitor = monitor;
    }

    private static final class Pair {
        private final double m_first;
        private final double m_second;

        private Pair(double first, double second) {
            this.m_first = first;
            this.m_second = second;
        }

        public double getFirst() {
            return this.m_first;
        }

        public double getSecond() {
            return this.m_second;
        }
    }

    private static final class Monitor
    implements IProgressMonitor {
        private final Combine m_parent;

        private Monitor(Combine parent) {
            this.m_parent = parent;
        }

        @Override
        public void progress(double workDone, double workEstimate) {
            this.m_parent.reportProgress(workDone / workEstimate);
        }
    }

    private static final class GeomModel {
        private final IGeometry m_geometry;
        private final InputType m_type;

        private GeomModel(IGeometry geometry, InputType type) {
            this.m_geometry = geometry;
            this.m_type = type;
        }

        public IGeometry getGeometry() {
            return this.m_geometry;
        }

        public InputType getType() {
            return this.m_type;
        }
    }
}

