/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.s2;

import com.mapinfo.midev.geometry.operations.s2.IProgressMonitor;

final class ComboMonitor {
    private final SubMonitor[] m_subMonitors;
    private final int m_n;
    private IProgressMonitor m_parent;

    public ComboMonitor(IProgressMonitor parent, int numSubMonitors) {
        this.m_parent = parent;
        this.m_n = numSubMonitors;
        this.m_subMonitors = new SubMonitor[this.m_n];
        for (int k = 0; k < this.m_n; ++k) {
            this.m_subMonitors[k] = new SubMonitor(this);
        }
    }

    public void reportProgress() {
        if (this.m_parent != null) {
            double total = 0.0;
            for (int k = 0; k < this.m_n; ++k) {
                total += this.m_subMonitors[k].m_percent;
            }
            this.m_parent.progress(total / (double)this.m_n, 1.0);
        }
    }

    IProgressMonitor getSubMonitor(int k) {
        return this.m_subMonitors[k];
    }

    void registerProgressMonitor(IProgressMonitor monitor) {
        this.m_parent = monitor;
    }

    private static class SubMonitor
    implements IProgressMonitor {
        private final ComboMonitor m_parent;
        private double m_percent;

        public SubMonitor(ComboMonitor parent) {
            this.m_parent = parent;
            this.m_percent = 0.0;
        }

        @Override
        public void progress(double workDone, double workEstimate) {
            this.m_percent = workDone / workEstimate;
            this.m_parent.reportProgress();
        }
    }
}

