/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.s2;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.GeometryType;
import com.mapinfo.midev.geometry.GeometryUtilities;
import com.mapinfo.midev.geometry.IDirectPositionList;
import com.mapinfo.midev.geometry.IFeatureGeometry;
import com.mapinfo.midev.geometry.IGeometry;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.impl.DirectPositionArray;
import com.mapinfo.midev.geometry.impl.GeometryFactory;
import com.mapinfo.midev.geometry.impl.MultiFeatureGeometry;
import com.mapinfo.midev.geometry.impl.Point;
import com.mapinfo.midev.geometry.operations.IAggregatedOperation;
import com.mapinfo.midev.geometry.operations.cartesian.Cartesian;
import com.mapinfo.midev.geometry.operations.s2.PointComparator;
import com.mapinfo.midev.geometry.operations.s2.util.Assert;
import java.util.Arrays;
import java.util.Comparator;

public final class ConvexHull
implements IAggregatedOperation {
    private final IDirectPositionList m_points = new DirectPositionArray();
    private final SpatialInfo m_spatialInfo;

    public ConvexHull(SpatialInfo spatialInfo) {
        this.m_spatialInfo = spatialInfo;
    }

    @Override
    public void add(IGeometry geom) {
        GeometryUtilities.getNodes(geom, this.m_points);
    }

    @Override
    public void addMultiple(Iterable<? extends IGeometry> geoms) {
        for (IGeometry iGeometry : geoms) {
            this.add(iGeometry);
        }
    }

    @Override
    public IFeatureGeometry result() throws UnsupportedOperationException {
        if (this.m_points.isEmpty()) {
            return new MultiFeatureGeometry(this.m_spatialInfo);
        }
        ConvexHull.compute(this.m_points);
        if (this.m_points.size() == 1) {
            return new Point(this.m_spatialInfo, this.m_points.getDirectPosition(0, new DirectPosition()));
        }
        if (this.m_points.size() <= 3) {
            return new GeometryFactory(this.m_spatialInfo).newMultiCurve(this.m_points, GeometryType.LINE_STRING);
        }
        return new GeometryFactory(this.m_spatialInfo).newMultiPolygon(this.m_points, GeometryType.LINE_STRING);
    }

    static void compute(final IDirectPositionList pts) {
        if (pts.size() == 0) {
            return;
        }
        Integer[] ptsindex = new Integer[pts.size()];
        for (int i = 0; i < pts.size(); ++i) {
            ptsindex[i] = i;
        }
        Arrays.sort(ptsindex, new Comparator<Integer>(){

            @Override
            public int compare(Integer a, Integer b) {
                return PointComparator.INSTANCE.compare(pts.getDirectPosition(a, new DirectPosition()), pts.getDirectPosition(b, new DirectPosition()));
            }
        });
        DirectPositionArray oldPts = new DirectPositionArray(pts);
        DirectPosition tmp = new DirectPosition();
        for (int i = 0; i < oldPts.size(); ++i) {
            pts.set(i, oldPts.getDirectPosition(ptsindex[i], tmp));
        }
        DirectPositionArray topEdge = new DirectPositionArray();
        DirectPositionArray bottomEdge = new DirectPositionArray();
        ConvexHull.compute(pts, topEdge, bottomEdge);
        DirectPosition lastTop = topEdge.getDirectPosition(topEdge.size() - 1, new DirectPosition());
        if (lastTop.equalsXY(bottomEdge.getDirectPosition(bottomEdge.size() - 1, new DirectPosition()))) {
            bottomEdge.remove(bottomEdge.size() - 1);
        }
        pts.clear();
        pts.addAll(topEdge);
        if (topEdge.size() == 1 && bottomEdge.size() < 2 || topEdge.size() == 2 && bottomEdge.size() < 2) {
            return;
        }
        int j = bottomEdge.size() - 1;
        DirectPosition tmp2 = new DirectPosition();
        for (int i = 0; i < bottomEdge.size(); ++i) {
            pts.add(bottomEdge.getDirectPosition(j--, tmp2));
        }
        Assert.assertCondition(pts.size() >= 4);
    }

    static void compute(IDirectPositionList sortedInput, IDirectPositionList topEdge, IDirectPositionList bottomEdge) {
        for (int i = 0; i < sortedInput.size(); ++i) {
            DirectPosition base;
            DirectPosition middle;
            DirectPosition newPos = sortedInput.getDirectPosition(i, new DirectPosition());
            boolean done = false;
            while (topEdge.size() >= 2 && !done) {
                middle = topEdge.getDirectPosition(topEdge.size() - 1, new DirectPosition());
                base = topEdge.getDirectPosition(topEdge.size() - 2, new DirectPosition());
                if (Cartesian.turn(base, middle, newPos) == Cartesian.Turn.CW) {
                    done = true;
                    continue;
                }
                topEdge.remove(topEdge.size() - 1);
            }
            if (topEdge.size() == 0 || !newPos.equalsXY(topEdge.getDirectPosition(topEdge.size() - 1, new DirectPosition()))) {
                topEdge.add(newPos);
            }
            done = false;
            while (bottomEdge.size() >= 2 && !done) {
                middle = bottomEdge.getDirectPosition(bottomEdge.size() - 1, new DirectPosition());
                base = bottomEdge.getDirectPosition(bottomEdge.size() - 2, new DirectPosition());
                if (Cartesian.turn(base, middle, newPos) == Cartesian.Turn.CCW) {
                    done = true;
                    continue;
                }
                bottomEdge.remove(bottomEdge.size() - 1);
            }
            if (bottomEdge.size() != 0 && newPos.equalsXY(bottomEdge.getDirectPosition(bottomEdge.size() - 1, new DirectPosition()))) continue;
            bottomEdge.add(newPos);
        }
    }
}

