/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.s2;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.ICurveSegment;
import com.mapinfo.midev.geometry.IDirectPositionList;
import com.mapinfo.midev.geometry.impl.DirectPositionArray;
import com.mapinfo.midev.geometry.impl.LineString;
import com.mapinfo.midev.geometry.impl.Polygon;
import com.mapinfo.midev.geometry.impl.Ring;
import com.mapinfo.midev.geometry.operations.s2.ConventionalBufferWidget;
import com.mapinfo.midev.geometry.operations.s2.ConvexHull;
import com.mapinfo.midev.geometry.operations.s2.InputType;
import com.mapinfo.midev.geometry.operations.s2.util.Assert;
import java.util.ArrayList;
import java.util.List;

public class LatLongBufferWidget
extends ConventionalBufferWidget {
    private static final double MAX_DIFF_MULTIPLIER = 0.8;
    private static final double MAX_SUBDIVIDE = 89.9;
    private double m_radius_meters;
    private final IDirectPositionList m_dirs = new DirectPositionArray();

    public LatLongBufferWidget(double width, int resolution) {
        this.setWidth(new ConventionalBufferWidget.XYWidth(width, width));
        this.setResolution(resolution);
    }

    static DirectPosition oneTrueOffset(DirectPosition center, DirectPosition unitDir, double radius_meters) {
        double cx = center.getX();
        double cy = center.getY();
        DirectPosition coord = new DirectPosition();
        coord.setZ(center.getZ());
        double cnty = Math.toRadians(cy);
        double c = radius_meters / 6370997.0;
        double sin_c = Math.sin(c);
        double cos_c = Math.cos(c);
        double sin_cnty = Math.sin(cnty);
        double cos_cnty = Math.cos(cnty);
        double x = unitDir.getX();
        double y = unitDir.getY();
        coord.setX(cx + 180.0 * Math.atan2(x * sin_c, cos_cnty * cos_c - y * sin_cnty * sin_c) / Math.PI);
        coord.setY(180.0 * Math.asin(cos_c * sin_cnty + y * sin_c * cos_cnty) / Math.PI);
        return coord;
    }

    @Override
    IDirectPositionList rawBuffer(DirectPosition pt) {
        double cx = pt.getX();
        double cy = pt.getY();
        if (cy > 90.0) {
            cy = 90.0;
        } else if (cy < -90.0) {
            cy = -90.0;
        }
        DirectPositionArray points = new DirectPositionArray(this.getResolution() + 1);
        DirectPosition coord = new DirectPosition();
        coord.setZ(pt.getZ());
        double cnty = Math.toRadians(cy);
        double c = this.m_radius_meters / 6370997.0;
        double sin_c = Math.sin(c);
        double cos_c = Math.cos(c);
        double sin_cnty = Math.sin(cnty);
        double cos_cnty = Math.cos(cnty);
        DirectPosition tmp = new DirectPosition();
        for (int i = 0; i < this.getResolution(); ++i) {
            this.m_dirs.getDirectPosition(i, tmp);
            double x = this.m_radius_meters * tmp.getX();
            double y = this.m_radius_meters * tmp.getY();
            coord.setX(cx + 180.0 * Math.atan2(x * sin_c, this.m_radius_meters * cos_cnty * cos_c - y * sin_cnty * sin_c) / Math.PI);
            coord.setY(180.0 * Math.asin(cos_c * sin_cnty + y * sin_c * cos_cnty / this.m_radius_meters) / Math.PI);
            points.add(coord);
        }
        points.add(points.getDirectPosition(0, new DirectPosition()));
        return points;
    }

    static void subDivide(List<DirectPosition> pts, DirectPosition pt1, DirectPosition pt2) {
        double maxY = Math.max(Math.abs(pt1.getY()), Math.abs(pt2.getY()));
        double minY = Math.min(Math.abs(pt1.getY()), Math.abs(pt2.getY()));
        if (pt1.getY() > 0.0 && pt2.getY() < 0.0 || pt1.getY() < 0.0 && pt2.getY() > 0.0) {
            minY = 0.0;
        }
        double maxOkY = Math.toDegrees(Math.acos(Math.cos(Math.toRadians(minY)) * 0.8));
        if (minY > 89.9 || maxOkY >= maxY) {
            pts.add(pt1);
        } else {
            DirectPosition split = new DirectPosition((pt1.getX() + pt2.getX()) / 2.0, (pt1.getY() + pt2.getY()) / 2.0, (pt1.getZ() + pt2.getZ()) / 2.0);
            LatLongBufferWidget.subDivide(pts, pt1, split);
            LatLongBufferWidget.subDivide(pts, split, pt2);
        }
    }

    @Override
    boolean buffer(ICurveSegment seg, boolean enclosable) {
        IDirectPositionList coords = seg.getControlPoints();
        if (coords.size() == 1) {
            super.buffer(seg.getSpatialInfo(), coords.getDirectPosition(0, new DirectPosition()));
            return true;
        }
        ArrayList<DirectPosition> pts = new ArrayList<DirectPosition>();
        int k = 0;
        while (k + 1 < coords.size()) {
            LatLongBufferWidget.subDivide(pts, coords.getDirectPosition(k, new DirectPosition()), coords.getDirectPosition(k + 1, new DirectPosition()));
            ++k;
        }
        pts.add(coords.getDirectPosition(coords.size() - 1, new DirectPosition()));
        this.setCoordsAdded(0);
        this.setTotalCoords(pts.size() - 1);
        DirectPosition pt1 = (DirectPosition)pts.get(0);
        IDirectPositionList ball1 = this.rawBuffer(pt1);
        for (int endIdx = 1; endIdx < pts.size(); ++endIdx) {
            DirectPosition pt2 = (DirectPosition)pts.get(endIdx);
            IDirectPositionList sausage = ball1;
            IDirectPositionList ball2 = this.rawBuffer(pt2);
            sausage.addAll(ball2);
            DirectPosition perpVec = new DirectPosition(pt2.getY() - pt1.getY(), -(pt2.getX() - pt1.getX()));
            double len = Math.sqrt(perpVec.getX() * perpVec.getX() + perpVec.getY() * perpVec.getY());
            if (len != 0.0) {
                perpVec.setX(perpVec.getX() / len);
                perpVec.setY(perpVec.getY() / len);
                sausage.add(LatLongBufferWidget.oneTrueOffset(pt1, perpVec, this.m_radius_meters));
                sausage.add(LatLongBufferWidget.oneTrueOffset(pt2, perpVec, this.m_radius_meters));
                perpVec = new DirectPosition(-perpVec.getX(), -perpVec.getY());
                sausage.add(LatLongBufferWidget.oneTrueOffset(pt1, perpVec, this.m_radius_meters));
                sausage.add(LatLongBufferWidget.oneTrueOffset(pt2, perpVec, this.m_radius_meters));
            }
            ConvexHull.compute(sausage);
            Assert.assertCondition(sausage.size() > 3);
            this.setCoordsAdded(this.getCoordsAdded() + 1);
            this.output(new Polygon(seg.getSpatialInfo(), new Ring(seg.getSpatialInfo(), new LineString(seg.getSpatialInfo(), sausage))), true, true, InputType.RingXOR);
            pt1 = pt2;
            ball1 = ball2;
        }
        Assert.assertCondition(this.getCoordsAdded() == this.getTotalCoords());
        return false;
    }

    @Override
    void parametersUpdated() {
        if (this.getWidth().getFirst() != this.getWidth().getSecond()) {
            throw new IllegalArgumentException("X & Y width  must match");
        }
        if (this.getWidth().getFirst() > 0.0) {
            this.setSign(1);
        } else if (this.getWidth().getFirst() < 0.0) {
            this.setSign(-1);
        } else {
            this.setSign(0);
        }
        this.m_dirs.clear();
        if (this.getSign() != 0) {
            for (int i = 0; i < this.getResolution(); ++i) {
                this.m_dirs.add(new DirectPosition(Math.cos(Math.PI * 2 * (double)i / (double)this.getResolution()), Math.sin(Math.PI * 2 * (double)i / (double)this.getResolution())));
            }
        }
        this.m_radius_meters = Math.abs(this.getWidth().getSecond());
    }
}

