/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.s2;

import com.mapinfo.midev.geometry.operations.s2.ActiveLine;
import com.mapinfo.midev.geometry.operations.s2.CutterType;
import com.mapinfo.midev.geometry.operations.s2.IActiveLineInfo;
import com.mapinfo.midev.geometry.operations.s2.PlaneSweep;
import com.mapinfo.midev.geometry.operations.s2.SkipListIterator;
import com.mapinfo.midev.geometry.operations.s2.Strand;
import com.mapinfo.midev.geometry.operations.s2.util.Assert;

class LineInfo
implements IActiveLineInfo {
    private Strand m_strand = null;
    private int m_insidedness = 0;
    private int m_cutterInsidedness = 0;
    private CutterType m_isCutter;
    private PlaneSweep.Type m_type;

    public LineInfo(CutterType isCutter, PlaneSweep.Type type) {
        this.m_isCutter = isCutter;
        this.m_type = type;
    }

    public Strand getStrand() {
        return this.m_strand;
    }

    public void setStrand(Strand strand) {
        this.m_strand = strand;
    }

    public int getInsidedness() {
        return this.m_insidedness;
    }

    public void setInsidedness(int insidedness) {
        this.m_insidedness = insidedness;
    }

    public int getCutterInsidedness() {
        return this.m_cutterInsidedness;
    }

    public void setCutterInsidedness(int cutterInsidedness) {
        this.m_cutterInsidedness = cutterInsidedness;
    }

    public PlaneSweep.Type getType() {
        return this.m_type;
    }

    public PlaneSweep.Flag getTypeFlag() {
        return this.m_type.getTypeFlag();
    }

    public void setTypeFlag(PlaneSweep.Type type) {
        this.m_type = type;
    }

    CutterType isCutter() {
        return this.m_isCutter;
    }

    CutterType isOutputEdgeCutter() {
        return this.m_isCutter;
    }

    boolean isOutputEdgeTarget() {
        return !this.m_isCutter.toBoolean();
    }

    @Override
    public int tieBreak(ActiveLine line1, ActiveLine line2) {
        if (line1.getGhostSlice() != null && line1.getGhostSlice().equals(line2.getGhostSlice())) {
            return 0;
        }
        LineInfo info1 = (LineInfo)line1.getLineInfo();
        LineInfo info2 = (LineInfo)line2.getLineInfo();
        if (info1.m_type == info2.m_type && info1.m_isCutter != info2.m_isCutter) {
            if (info1.m_type == PlaneSweep.Type.ExteriorTop) {
                return info1.m_isCutter.toBoolean() ? 1 : -1;
            }
            if (info1.m_type == PlaneSweep.Type.ExteriorBottom) {
                return info1.m_isCutter.toBoolean() ? -1 : 1;
            }
            if (info1.m_type == PlaneSweep.Type.HoleTop) {
                return info1.m_isCutter.toBoolean() ? -1 : 1;
            }
            if (info1.m_type == PlaneSweep.Type.HoleBottom) {
                return info1.m_isCutter.toBoolean() ? 1 : -1;
            }
            if (info1.m_type == PlaneSweep.Type.Linear) {
                return 0;
            }
            if (info1.m_type == PlaneSweep.Type.Point) {
                return 0;
            }
        }
        return info1.m_type.compareTo(info2.m_type);
    }

    @Override
    public void activatePair(ActiveLine loLine, ActiveLine hiLine) {
        int prevExistingCutterInsidedness;
        int prevExistingInsidedness;
        LineInfo prevInfo = null;
        Assert.assertCondition(loLine != null);
        SkipListIterator<ActiveLine> prevLine = loLine.getSweep().slice().prev(loLine.sliceNode());
        if (!prevLine.equals(loLine.getSweep().slice().rend())) {
            prevInfo = (LineInfo)prevLine.get().getLineInfo();
        }
        if (prevInfo == null) {
            prevExistingInsidedness = 0;
            prevExistingCutterInsidedness = 0;
        } else {
            prevExistingInsidedness = prevInfo.m_insidedness;
            prevExistingCutterInsidedness = prevInfo.m_cutterInsidedness;
        }
        LineInfo loInfo = (LineInfo)loLine.getLineInfo();
        if (loInfo.m_type.isRegion()) {
            Assert.assertCondition(hiLine != null);
            LineInfo hiInfo = (LineInfo)hiLine.getLineInfo();
            if (loLine.getGhostSlice() != null) {
                if (this.m_type.isHole()) {
                    loInfo.m_type = PlaneSweep.Type.HoleBottom;
                    hiInfo.m_type = PlaneSweep.Type.HoleTop;
                } else {
                    loInfo.m_type = PlaneSweep.Type.ExteriorBottom;
                    hiInfo.m_type = PlaneSweep.Type.ExteriorTop;
                }
                int prevGhostParity = 0;
                SkipListIterator<Object> prevExistingGhost = loLine.getGhostSlice().rend();
                if (loLine.getGhostSlice() != null) {
                    prevExistingGhost = loLine.getGhostSlice().prev(loLine.getGhostNode());
                }
                if (!prevExistingGhost.equals(loLine.getGhostSlice().rend())) {
                    prevGhostParity = ((ActiveLine)prevExistingGhost.get()).getGhostParity();
                }
                if (prevGhostParity & true) {
                    PlaneSweep.Type temp = loInfo.m_type;
                    loInfo.m_type = hiInfo.m_type;
                    hiInfo.m_type = temp;
                }
                loLine.setGhostParity(prevGhostParity + 1);
                hiLine.setGhostParity(loLine.getGhostParity() - 1);
                Assert.assertCondition(hiLine.getGhostParity() == prevGhostParity);
            }
            loInfo.m_insidedness = prevExistingInsidedness + loInfo.insidednessDiff();
            loInfo.m_cutterInsidedness = prevExistingCutterInsidedness + loInfo.cutterDiff();
            hiInfo.m_insidedness = loInfo.m_insidedness + hiInfo.insidednessDiff();
            hiInfo.m_cutterInsidedness = loInfo.m_cutterInsidedness + hiInfo.cutterDiff();
            Assert.assertCondition(hiInfo.m_insidedness == prevExistingInsidedness);
            Assert.assertCondition(hiInfo.m_cutterInsidedness == prevExistingCutterInsidedness);
        } else {
            loInfo.m_insidedness = prevExistingInsidedness;
            loInfo.m_cutterInsidedness = prevExistingCutterInsidedness;
            if (hiLine != null) {
                LineInfo hiInfo = (LineInfo)hiLine.getLineInfo();
                Assert.assertCondition(!hiInfo.m_type.isRegion());
                hiInfo.m_insidedness = prevExistingInsidedness;
                hiInfo.m_cutterInsidedness = prevExistingCutterInsidedness;
            }
            Assert.assertCondition(loLine.getGhostSlice() == null);
        }
    }

    @Override
    public boolean verifyAdjacentLines(ActiveLine loLine, ActiveLine hiLine) {
        return ((LineInfo)hiLine.getLineInfo()).m_insidedness == ((LineInfo)loLine.getLineInfo()).m_insidedness + ((LineInfo)hiLine.getLineInfo()).insidednessDiff() && ((LineInfo)hiLine.getLineInfo()).m_cutterInsidedness == ((LineInfo)loLine.getLineInfo()).m_cutterInsidedness + ((LineInfo)hiLine.getLineInfo()).cutterDiff();
    }

    @Override
    public int getEventBias() {
        return this.m_isCutter.toBoolean() ? -1 : 0;
    }

    int insidednessDiff() {
        if (this.m_isCutter.toBoolean()) {
            return 0;
        }
        switch (this.m_type) {
            case ExteriorTop: {
                return -1;
            }
            case ExteriorBottom: {
                return 1;
            }
            case HoleTop: {
                return 1;
            }
            case HoleBottom: {
                return -1;
            }
            case Linear: 
            case Point: {
                return 0;
            }
        }
        throw new IllegalStateException();
    }

    int cutterDiff() {
        if (!this.m_isCutter.toBoolean()) {
            return 0;
        }
        switch (this.m_isCutter) {
            case INTERIOR: {
                switch (this.m_type) {
                    case ExteriorTop: {
                        return -1;
                    }
                    case ExteriorBottom: {
                        return 1;
                    }
                    case HoleTop: {
                        return 1;
                    }
                    case HoleBottom: {
                        return -1;
                    }
                    case Linear: 
                    case Point: {
                        return 0;
                    }
                }
                break;
            }
            case EXTERIOR: {
                switch (this.m_type) {
                    case ExteriorTop: {
                        return 1;
                    }
                    case ExteriorBottom: {
                        return -1;
                    }
                    case HoleTop: {
                        return -1;
                    }
                    case HoleBottom: {
                        return 1;
                    }
                    case Linear: 
                    case Point: {
                        return 0;
                    }
                }
            }
        }
        throw new IllegalStateException();
    }

    boolean isOutputEdge() {
        if (this.m_type == PlaneSweep.Type.Linear || this.m_type == PlaneSweep.Type.Point) {
            return this.m_insidedness == 0 && this.m_cutterInsidedness == 0;
        }
        if (this.m_isCutter.toBoolean()) {
            if (this.m_insidedness <= 0) {
                return false;
            }
            return this.cutterDiff() == 1 && this.m_cutterInsidedness == 1 || this.cutterDiff() == -1 && this.m_cutterInsidedness == 0;
        }
        if (this.m_cutterInsidedness > 0) {
            return false;
        }
        return this.m_insidedness == 0 && (this.insidednessDiff() == -1 || this.insidednessDiff() == 0) || this.m_insidedness == 1 && this.insidednessDiff() == 1;
    }
}

