/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.s2;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.IDirectPositionList;
import com.mapinfo.midev.geometry.operations.s2.S2Utilities;

final class LoopList {
    private final IDirectPositionList m_backingList;
    private final int m_n;
    private final int[] m_prev;
    private final int[] m_next;
    private final boolean[] m_removed;
    private int m_numRemoved = 0;

    public LoopList(IDirectPositionList dpl) {
        this.m_backingList = dpl;
        this.m_n = this.m_backingList.size() - 1;
        this.m_prev = new int[this.m_n];
        this.m_next = new int[this.m_n];
        this.m_removed = new boolean[this.m_n];
        S2Utilities.assertClosed(dpl);
        for (int i = 0; i < this.m_n; ++i) {
            this.m_prev[i] = i - 1;
            this.m_next[i] = i + 1;
            this.m_removed[i] = false;
        }
        this.m_prev[0] = this.m_n - 1;
        this.m_next[this.m_n - 1] = 0;
    }

    DirectPosition getDirectPosition(int index, DirectPosition dp) {
        return this.m_backingList.getDirectPosition(index, dp);
    }

    void remove(int pos) {
        if (!this.removed(pos)) {
            this.m_next[this.m_prev[pos]] = this.m_next[pos];
            this.m_prev[this.m_next[pos]] = this.m_prev[pos];
            this.m_next[pos] = pos;
            this.m_prev[pos] = pos;
            this.m_removed[pos] = true;
            ++this.m_numRemoved;
        }
    }

    public int next(int pos) {
        return this.m_next[pos];
    }

    public int prev(int pos) {
        return this.m_prev[pos];
    }

    public int size() {
        return this.m_n - this.m_numRemoved;
    }

    public boolean removed(int pos) {
        return this.m_removed[pos];
    }

    public int numRemoved() {
        return this.m_numRemoved;
    }
}

