/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.s2;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.IDirectPositionList;
import com.mapinfo.midev.geometry.IFeatureGeometry;
import com.mapinfo.midev.geometry.IGeometry;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.impl.Curve;
import com.mapinfo.midev.geometry.impl.LineString;
import com.mapinfo.midev.geometry.impl.Point;
import com.mapinfo.midev.geometry.impl.Polygon;
import com.mapinfo.midev.geometry.impl.Ring;
import com.mapinfo.midev.geometry.operations.s2.ActiveLine;
import com.mapinfo.midev.geometry.operations.s2.ActiveLineList;
import com.mapinfo.midev.geometry.operations.s2.CutterType;
import com.mapinfo.midev.geometry.operations.s2.LineInfo;
import com.mapinfo.midev.geometry.operations.s2.PlaneSweep;
import com.mapinfo.midev.geometry.operations.s2.PointComparator;
import com.mapinfo.midev.geometry.operations.s2.S2Utilities;
import com.mapinfo.midev.geometry.operations.s2.SkipListIterator;
import com.mapinfo.midev.geometry.operations.s2.Strand;
import com.mapinfo.midev.geometry.operations.s2.SweepEventControlPoint;
import com.mapinfo.midev.geometry.operations.s2.util.Assert;
import com.mapinfo.midev.geometry.operations.s2.util.CIterator;
import com.mapinfo.midev.geometry.operations.s2.util.CListIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;

class PlaneSweepErase
extends PlaneSweep {
    private final SpatialInfo m_spatialInfo;
    private final List<Polygon> m_resultPolys = new ArrayList<Polygon>();
    private final List<Strand> m_targetStrands = new ArrayList<Strand>();
    private final List<Strand> m_cutterStrands = new ArrayList<Strand>();
    private final List<DirectPosition> m_targetPts = new ArrayList<DirectPosition>();
    private final List<DirectPosition> m_cutterPts = new ArrayList<DirectPosition>();
    private final List<DirectPosition> m_spuriousPts = new ArrayList<DirectPosition>();

    PlaneSweepErase(SpatialInfo spatialInfo, double tolerance) {
        super(tolerance);
        this.m_spatialInfo = spatialInfo;
    }

    SpatialInfo getSpatialInfo() {
        return this.m_spatialInfo;
    }

    @Override
    SweepEventControlPoint newMonotoneSection(IDirectPositionList posList, int left, int right, int dir, PlaneSweep.Type lineType, CutterType isCutter, ActiveLineList sourceID, boolean leftToRight) {
        LineInfo info = new LineInfo(isCutter, lineType);
        SweepEventControlPoint event = new SweepEventControlPoint(posList, left, right, dir, info, sourceID);
        event.setEventOrder(event.getEventOrder() + info.getEventBias());
        return event;
    }

    @Override
    IFeatureGeometry sweepCompleted() {
        DirectPosition dpStrand;
        ArrayList<IGeometry> resultGeoms = new ArrayList<IGeometry>(this.m_resultPolys.size() + this.m_targetPts.size() + this.m_targetStrands.size() / 2);
        this.m_spuriousPts.clear();
        ArrayList<Segment> targetSegs = new ArrayList<Segment>();
        for (Strand s : this.m_targetStrands) {
            if (s.Finished()) continue;
            s.setFinished(true);
            if (s.getTwin() != null) {
                s.getTwin().setFinished(true);
            }
            if (s.size() == 1) {
                if (s.getTypeFlag() != PlaneSweep.Flag.FLAG_POINT.getValue()) continue;
                dpStrand = s.get(0);
                this.m_targetPts.add(dpStrand);
                continue;
            }
            for (int i = 0; i < s.size() - 1; ++i) {
                DirectPosition dp1;
                DirectPosition dp0 = s.get(i);
                if (dp0.equalsXY(dp1 = s.get(i + 1))) {
                    this.m_targetPts.add(dp0);
                    continue;
                }
                targetSegs.add(new Segment(dp0, dp1));
                if (i == 0) {
                    this.m_targetPts.add(dp0);
                }
                this.m_targetPts.add(dp1);
            }
        }
        this.m_targetStrands.clear();
        Collections.sort(targetSegs);
        for (Strand s : this.m_cutterStrands) {
            s.setFinished(false);
        }
        ArrayList<Segment> cutterSegs = new ArrayList<Segment>();
        for (Strand s : this.m_cutterStrands) {
            if (s.Finished()) continue;
            s.setFinished(true);
            if (s.getTwin() != null) {
                s.getTwin().setFinished(true);
            }
            if (s.size() == 1) {
                dpStrand = s.get(0);
                this.m_cutterPts.add(dpStrand);
                continue;
            }
            for (int i = 0; i < s.size() - 1; ++i) {
                DirectPosition dp1;
                DirectPosition dp0 = s.get(i);
                if (dp0.equalsXY(dp1 = s.get(i + 1))) {
                    this.m_cutterPts.add(dp0);
                    continue;
                }
                cutterSegs.add(new Segment(dp0, dp1));
                if (i == 0) {
                    this.m_cutterPts.add(dp0);
                }
                this.m_cutterPts.add(dp1);
            }
        }
        this.m_cutterStrands.clear();
        Collections.sort(cutterSegs);
        List<Strand> cleanStrands = this.createStrandsForOutput(targetSegs, cutterSegs);
        if (this.m_targetPts.size() > 0) {
            Collections.sort(this.m_targetPts, PointComparator.INSTANCE);
        }
        if (this.m_spuriousPts.size() > 0) {
            Collections.sort(this.m_spuriousPts, PointComparator.INSTANCE);
        }
        if (this.m_cutterPts.size() > 0) {
            Collections.sort(this.m_cutterPts, PointComparator.INSTANCE);
        }
        DirectPosition dpPtPrev = new DirectPosition(Double.NaN, Double.NaN);
        Collections.sort(cleanStrands, new Comparator<Strand>(){

            @Override
            public int compare(Strand a, Strand b) {
                return PointComparator.INSTANCE.compare(a.get(0), b.get(0));
            }
        });
        CIterator<Strand> strandIter = CListIterator.begin(cleanStrands);
        dpStrand = new DirectPosition(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        CIterator<DirectPosition> spuriousIter = CListIterator.begin(this.m_spuriousPts);
        DirectPosition dpSpurious = new DirectPosition(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        CIterator<DirectPosition> cutterIter = CListIterator.begin(this.m_cutterPts);
        DirectPosition dpCutter = new DirectPosition(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        CIterator<DirectPosition> iter = CListIterator.begin(this.m_targetPts);
        while (!iter.isEnd()) {
            while (!strandIter.isEnd() && PointComparator.INSTANCE.compare(strandIter.get().get(0), iter.get()) < 0) {
                strandIter.next();
            }
            if (!strandIter.isEnd()) {
                dpStrand = strandIter.get().get(0);
            }
            while (!spuriousIter.isEnd() && PointComparator.INSTANCE.compare(spuriousIter.get(), iter.get()) < 0) {
                spuriousIter.next();
            }
            if (!spuriousIter.isEnd()) {
                dpSpurious = spuriousIter.get();
            }
            while (!cutterIter.isEnd() && PointComparator.INSTANCE.compare(cutterIter.get(), iter.get()) < 0) {
                cutterIter.next();
            }
            if (!cutterIter.isEnd()) {
                dpCutter = cutterIter.get();
            }
            if (!iter.get().equalsXY(dpPtPrev) && this.pointOutputtable(iter.get(), dpStrand, dpCutter, dpSpurious)) {
                resultGeoms.add(new Point(this.m_spatialInfo, iter.get()));
                dpPtPrev = iter.get();
            }
            iter.next();
        }
        ArrayList<Integer> metStrands = new ArrayList<Integer>();
        DirectPosition curPos = null;
        for (int curStrand = 0; curStrand < cleanStrands.size(); ++curStrand) {
            Strand strand = cleanStrands.get(curStrand);
            if (strand.Finished()) continue;
            if (metStrands.size() == 0) {
                metStrands.add(curStrand);
                curPos = strand.get(0);
                continue;
            }
            if (curPos != null && strand.get(0).equalsXY(curPos)) {
                metStrands.add(curStrand);
                continue;
            }
            Assert.assertCondition(PointComparator.INSTANCE.compare(strand.get(0), curPos) > 0);
            this.processStrandsAtCommonPoint(resultGeoms, cleanStrands, metStrands);
            metStrands.clear();
            metStrands.add(curStrand);
            curPos = strand.get(0);
        }
        this.processStrandsAtCommonPoint(resultGeoms, cleanStrands, metStrands);
        for (Polygon poly : this.m_resultPolys) {
            resultGeoms.add(poly);
        }
        return S2Utilities.toMinimalFeatureGeometry(this.m_spatialInfo, resultGeoms);
    }

    @Override
    void swapped(SkipListIterator<ActiveLine> lo, ActiveLine hi) {
        ActiveLine loLine = lo.get();
        LineInfo loInfo = (LineInfo)loLine.getLineInfo();
        LineInfo hiInfo = (LineInfo)hi.getLineInfo();
        if (!loInfo.getType().isRegion() && !hiInfo.getType().isRegion()) {
            this.swappedLinears(loLine, hi);
        } else if (loInfo.getType().isRegion() && hiInfo.getType().isRegion()) {
            this.swappedPolys(loLine, hi);
        } else {
            this.swappedMix(loLine, hi);
        }
    }

    @Override
    void swept(ActiveLine line) {
        LineInfo info = (LineInfo)line.getLineInfo();
        if (line.getHoles() != null && line.getHoles().size() > 0) {
            Assert.assertCondition(!info.getType().isRegion());
            Assert.assertCondition(this.aboveIsInside(line));
            this.mergeHolesInto(line, this.slice().prev(line.sliceNode()).get());
        }
        if (info.getStrand() != null) {
            this.outputStrand(info.getStrand(), info);
            info.setStrand(null);
        }
    }

    @Override
    public void sweptPair(ActiveLine line0, ActiveLine line1) {
        if (this.aboveIsInside(line1)) {
            this.connectPair(line0, line1, this.slice().prev(line0.sliceNode()).get());
        } else {
            this.connectPair(line0, line1, null);
        }
    }

    @Override
    void started(ActiveLine line) {
        LineInfo info = (LineInfo)line.getLineInfo();
        Assert.assertCondition(info.getStrand() == null);
        Assert.assertCondition(info.getStrand() == null);
        Assert.assertCondition(info.getType() == PlaneSweep.Type.Linear || info.getType() == PlaneSweep.Type.Point);
        if (info.isOutputEdge()) {
            Pair<Strand, Strand> end = Strand.newPair();
            ((LineInfo)line.getLineInfo()).setStrand((Strand)end.getLeft());
            ((Strand)end.getLeft()).pushXYdistinct(line.getPt()[0]);
            ((Strand)end.getLeft()).setTypeFlag(info.getTypeFlag().getValue());
            this.outputStrand((Strand)end.getRight(), info);
        }
    }

    @Override
    void startedPair(ActiveLine line0, ActiveLine line1) {
        Assert.assertCondition(line0.getPt()[0].equalsXY(line1.getPt()[0]));
        this.createStrandPair(line0, line1, line0.getPt()[0]);
    }

    @Override
    void sweepTo(ActiveLine line, DirectPosition newStart) {
        LineInfo info = (LineInfo)line.getLineInfo();
        Strand strand = info.getStrand();
        if (info.isOutputEdge()) {
            strand.pushXYdistinct(newStart);
            strand.setTypeFlag(info.getTypeFlag().getValue());
            SkipListIterator<ActiveLine> nextNode = line.getSweep().slice().next(line.sliceNode());
            SkipListIterator<ActiveLine> prevNode = line.getSweep().slice().prev(line.sliceNode());
            if (!nextNode.equals(line.getSweep().slice().end())) {
                ActiveLine nextLine = nextNode.get();
                LineInfo nextInfo = (LineInfo)nextLine.getLineInfo();
                this.checkIfErasable(line, info, nextLine, nextInfo);
            }
            if (!prevNode.equals(line.getSweep().slice().rend())) {
                ActiveLine prevLine = prevNode.get();
                LineInfo prevInfo = (LineInfo)prevLine.getLineInfo();
                this.checkIfErasable(prevLine, prevInfo, line, info);
            }
        }
    }

    void swappedLinears(ActiveLine loLine, ActiveLine hiLine) {
        Pair<Strand, Strand> end;
        DirectPosition commonPt = this.bringToCommonTime(loLine, hiLine);
        LineInfo loInfo = (LineInfo)loLine.getLineInfo();
        LineInfo hiInfo = (LineInfo)hiLine.getLineInfo();
        Strand strand = loInfo.getStrand();
        if (strand != null) {
            this.outputStrand(strand, loInfo);
            loInfo.setStrand(null);
            Assert.assertCondition(loLine.getHoles() == null || loLine.getHoles().size() == 0);
        }
        if ((strand = hiInfo.getStrand()) != null) {
            this.outputStrand(strand, hiInfo);
            hiInfo.setStrand(null);
            Assert.assertCondition(hiLine.getHoles() == null || hiLine.getHoles().size() == 0);
        }
        if (loInfo.isOutputEdge()) {
            end = Strand.newPair();
            loInfo.setStrand((Strand)end.getLeft());
            ((Strand)end.getLeft()).pushXYdistinct(commonPt);
            ((Strand)end.getLeft()).setTypeFlag(loInfo.getTypeFlag().getValue());
            this.outputStrand((Strand)end.getRight(), loInfo);
        }
        if (hiInfo.isOutputEdge()) {
            end = Strand.newPair();
            hiInfo.setStrand((Strand)end.getLeft());
            ((Strand)end.getLeft()).pushXYdistinct(commonPt);
            ((Strand)end.getLeft()).setTypeFlag(hiInfo.getTypeFlag().getValue());
            this.outputStrand((Strand)end.getRight(), hiInfo);
        }
    }

    void swappedPolys(ActiveLine loLine, ActiveLine hiLine) {
        boolean swap;
        boolean merge;
        LineInfo loInfo = (LineInfo)loLine.getLineInfo();
        LineInfo hiInfo = (LineInfo)hiLine.getLineInfo();
        Assert.assertCondition(this.slice().next(loLine.sliceNode()).equals(hiLine.sliceNode()));
        DirectPosition commonPt = this.bringToCommonTime(loLine, hiLine);
        Assert.assertCondition(hiInfo.getInsidedness() == loInfo.getInsidedness() + hiInfo.insidednessDiff());
        Assert.assertCondition(hiInfo.getCutterInsidedness() == loInfo.getCutterInsidedness() + hiInfo.cutterDiff());
        int insidednessBelow = loInfo.getInsidedness() - loInfo.insidednessDiff();
        int cutterInsidednessBelow = loInfo.getCutterInsidedness() - loInfo.cutterDiff();
        boolean contained = this.aboveIsInside(hiLine);
        if (loLine.getGhostSlice() != null && loLine.getGhostSlice().equals(hiLine.getGhostSlice())) {
            PlaneSweep.Type temp = loInfo.getType();
            loInfo.setTypeFlag(hiInfo.getType());
            hiInfo.setTypeFlag(temp);
        }
        hiInfo.setInsidedness(insidednessBelow + hiInfo.insidednessDiff());
        hiInfo.setCutterInsidedness(cutterInsidednessBelow + hiInfo.cutterDiff());
        loInfo.setInsidedness(hiInfo.getInsidedness() + loInfo.insidednessDiff());
        loInfo.setCutterInsidedness(hiInfo.getCutterInsidedness() + loInfo.cutterDiff());
        if (loInfo.getStrand() == null || hiInfo.getStrand() == null) {
            merge = false;
            swap = loInfo.getStrand() == null && loInfo.isOutputEdge() || hiInfo.getStrand() == null && hiInfo.isOutputEdge();
        } else if (!loInfo.isOutputEdge() || !hiInfo.isOutputEdge()) {
            merge = true;
            swap = false;
        } else if (contained) {
            merge = false;
            swap = true;
        } else {
            merge = true;
            swap = false;
        }
        if (merge) {
            if (contained) {
                this.connectPair(loLine, hiLine, this.slice().prev(loLine.sliceNode()).get());
            } else {
                this.connectPair(loLine, hiLine, null);
            }
        } else if (swap) {
            Strand temp = loInfo.getStrand();
            loInfo.setStrand(hiInfo.getStrand());
            hiInfo.setStrand(temp);
            List<IDirectPositionList> tempHoles = loLine.getHoles();
            loLine.setHoles(hiLine.getHoles());
            hiLine.setHoles(tempHoles);
        }
        if (loInfo.getStrand() == null && hiInfo.getStrand() == null) {
            this.createStrandPair(loLine, hiLine, commonPt);
        }
    }

    void swappedMix(ActiveLine loLine, ActiveLine hiLine) {
        ActiveLine poly;
        ActiveLine linear;
        LineInfo loInfo = (LineInfo)loLine.getLineInfo();
        LineInfo hiInfo = (LineInfo)hiLine.getLineInfo();
        LineInfo linearInfo = null;
        LineInfo polyInfo = null;
        Assert.assertCondition(this.slice().next(loLine.sliceNode()).equals(hiLine.sliceNode()));
        DirectPosition commonPt = this.bringToCommonTime(loLine, hiLine);
        if (hiInfo.getType().isRegion()) {
            linear = loLine;
            linearInfo = loInfo;
            poly = hiLine;
            polyInfo = hiInfo;
        } else {
            linear = hiLine;
            linearInfo = hiInfo;
            poly = loLine;
            polyInfo = loInfo;
        }
        Assert.assertCondition(!linearInfo.getType().isRegion());
        Assert.assertCondition(polyInfo.getType().isRegion());
        Assert.assertCondition(hiInfo.getInsidedness() == loInfo.getInsidedness() + hiInfo.insidednessDiff());
        Assert.assertCondition(hiInfo.getCutterInsidedness() == loInfo.getCutterInsidedness() + hiInfo.cutterDiff());
        int insidednessBelow = loInfo.getInsidedness() - loInfo.insidednessDiff();
        int cutterInsidednessBelow = loInfo.getCutterInsidedness() - loInfo.cutterDiff();
        if (linearInfo.getStrand() == null) {
            this.mergeHolesInto(linear, poly);
        } else {
            if (polyInfo.isOutputEdge()) {
                linearInfo.getStrand().setTypeFlag(polyInfo.getTypeFlag().getValue());
            }
            this.outputStrand(linearInfo.getStrand(), linearInfo);
            linearInfo.setStrand(null);
            Assert.assertCondition(linear.getHoles() == null || linear.getHoles().size() == 0);
        }
        hiInfo.setInsidedness(insidednessBelow + hiInfo.insidednessDiff());
        hiInfo.setCutterInsidedness(cutterInsidednessBelow + hiInfo.cutterDiff());
        loInfo.setInsidedness(hiInfo.getInsidedness() + loInfo.insidednessDiff());
        loInfo.setCutterInsidedness(hiInfo.getCutterInsidedness() + loInfo.cutterDiff());
        if (linearInfo.isOutputEdge()) {
            Pair<Strand, Strand> end = Strand.newPair();
            linearInfo.setStrand((Strand)end.getLeft());
            this.outputStrand((Strand)end.getRight(), linearInfo);
            linearInfo.getStrand().pushXYdistinct(commonPt);
            linearInfo.getStrand().setTypeFlag(linearInfo.getTypeFlag().getValue());
            if (polyInfo.isOutputEdge()) {
                linearInfo.getStrand().setTypeFlag(polyInfo.getTypeFlag().getValue());
            }
        }
    }

    DirectPosition bringToCommonTime(ActiveLine loLine, ActiveLine hiLine) {
        LineInfo hiInfo;
        DirectPosition commonPt = loLine.getPt()[0].equalsXY(hiLine.getPt()[0]) ? loLine.getPt()[0] : (loLine.getPt()[0].equalsXY(hiLine.getPt()[1]) ? loLine.getPt()[0] : (loLine.getPt()[1].equalsXY(hiLine.getPt()[0]) ? loLine.getPt()[1] : (loLine.getPt()[1].equalsXY(hiLine.getPt()[1]) ? loLine.getPt()[1] : (PointComparator.INSTANCE.compare(loLine.getPt()[0], hiLine.getPt()[0]) > 0 ? loLine.getPt()[0] : hiLine.getPt()[0]))));
        LineInfo loInfo = (LineInfo)loLine.getLineInfo();
        if (loInfo.getStrand() != null) {
            loInfo.getStrand().pushXYdistinct(commonPt);
            loInfo.getStrand().setTypeFlag(loInfo.getTypeFlag().getValue());
        }
        if ((hiInfo = (LineInfo)hiLine.getLineInfo()).getStrand() != null) {
            hiInfo.getStrand().pushXYdistinct(commonPt);
            hiInfo.getStrand().setTypeFlag(hiInfo.getTypeFlag().getValue());
        }
        return commonPt;
    }

    void outputStrand(Strand s, LineInfo info) {
        if (info.isOutputEdgeCutter() != CutterType.NONE) {
            this.m_cutterStrands.add(s);
        }
        if (info.isOutputEdgeTarget()) {
            this.m_targetStrands.add(s);
        }
    }

    boolean aboveIsInside(ActiveLine line) {
        LineInfo info = (LineInfo)line.getLineInfo();
        return info.getInsidedness() > 0 && info.getCutterInsidedness() == 0;
    }

    void mergeHolesInto(ActiveLine from, ActiveLine to) {
        if (from.getHoles() != null && from.getHoles().size() > 0) {
            if (to.getHoles() == null) {
                to.setHoles(from.getHoles());
            } else if (from.getHoles().size() < to.getHoles().size()) {
                for (IDirectPositionList pts : from.getHoles()) {
                    to.getHoles().add(pts);
                }
            } else {
                for (IDirectPositionList pts : to.getHoles()) {
                    from.getHoles().add(pts);
                }
                to.setHoles(from.getHoles());
            }
        }
        from.setHoles(null);
    }

    void mergeHolesInto(ActiveLine from, Strand to) {
        if (from.getHoles() != null && from.getHoles().size() > 0) {
            if (to.containedHoles() == null) {
                to.containedHoles(from.getHoles());
            } else if (from.getHoles().size() < to.containedHoles().size()) {
                for (IDirectPositionList pts : from.getHoles()) {
                    to.containedHoles().add(pts);
                }
            } else {
                for (IDirectPositionList pts : to.containedHoles()) {
                    from.getHoles().add(pts);
                }
                to.containedHoles(from.getHoles());
            }
        }
        from.setHoles(null);
    }

    void connectPair(ActiveLine line0, ActiveLine line1, ActiveLine holeLine) {
        LineInfo info0 = (LineInfo)line0.getLineInfo();
        LineInfo info1 = (LineInfo)line1.getLineInfo();
        Assert.assertCondition(info0.getType().isRegion() == info1.getType().isRegion());
        if (info0.getStrand() != null || info1.getStrand() != null) {
            Strand strand0 = info0.getStrand();
            Strand strand1 = info1.getStrand();
            Assert.assertCondition(strand0 != null);
            Strand twin0 = strand0 != null ? strand0.getTwin() : null;
            boolean loop = Strand.connect(strand0, strand1);
            info0.setStrand(null);
            info1.setStrand(null);
            if (loop) {
                strand0.mergeHolesFrom(strand1);
                if (line0.getHoles() == null) {
                    line0.setHoles(strand0.containedHoles());
                    strand0.containedHoles(null);
                } else if (strand0.containedHoles() != null) {
                    for (IDirectPositionList list : strand0.containedHoles()) {
                        line0.getHoles().add(list);
                    }
                    strand0.containedHoles(null);
                }
                this.mergeHolesInto(line1, line0);
                int order = PointComparator.INSTANCE.compare(strand0.get(0), strand1.get(0));
                if (order < 0) {
                    strand0.pushXYdistinct(strand1.get(0));
                    strand0.setTypeFlag(info0.getTypeFlag().getValue());
                } else if (order > 0) {
                    strand1.pushXYdistinct(strand0.get(0));
                    strand1.setTypeFlag(info1.getTypeFlag().getValue());
                }
                IDirectPositionList dpl = twin0.asCoordList(this.tol());
                if (holeLine != null) {
                    this.mergeHolesInto(line0, holeLine);
                    Assert.assertCondition(info1.getType().isRegion());
                    IDirectPositionList ring = this.refactorRing(dpl, null, null);
                    if (ring.size() != 0) {
                        if (holeLine.getHoles() == null) {
                            holeLine.setHoles(new ArrayList<IDirectPositionList>());
                        }
                        holeLine.getHoles().add(ring);
                    }
                } else if (info1.getType().isRegion()) {
                    IDirectPositionList ring = this.refactorRing(dpl, null, null);
                    if (ring.size() == 0) {
                        Assert.assertCondition(line0.getHoles() == null || line0.getHoles().size() <= 0);
                    } else if (line0.getHoles() != null && line0.getHoles().size() > 0) {
                        ArrayList<Ring> rings = new ArrayList<Ring>(line0.getHoles().size());
                        for (IDirectPositionList list : line0.getHoles()) {
                            rings.add(new Ring(this.m_spatialInfo, new LineString(this.m_spatialInfo, list)));
                        }
                        this.m_resultPolys.add(new Polygon(this.m_spatialInfo, new Ring(this.m_spatialInfo, new LineString(this.m_spatialInfo, ring)), rings));
                    } else {
                        this.m_resultPolys.add(new Polygon(this.m_spatialInfo, new Ring(this.m_spatialInfo, new LineString(this.m_spatialInfo, ring))));
                    }
                    line0.setHoles(null);
                } else {
                    Assert.assertCondition(info0.isCutter() == info1.isCutter());
                    this.outputStrand(strand0, info0);
                    this.outputStrand(strand1, info1);
                }
            } else {
                this.mergeHolesInto(line0, twin0);
                this.mergeHolesInto(line1, twin0);
            }
        }
        if (holeLine != null) {
            this.mergeHolesInto(line0, holeLine);
            this.mergeHolesInto(line1, holeLine);
        }
    }

    void createStrandPair(ActiveLine line0, ActiveLine line1, DirectPosition commonPt) {
        LineInfo info0 = (LineInfo)line0.getLineInfo();
        LineInfo info1 = (LineInfo)line1.getLineInfo();
        Assert.assertCondition(info0.getStrand() == null && info1.getStrand() == null);
        if (info0.isOutputEdge()) {
            Pair<Strand, Strand> end = Strand.newPair();
            info0.setStrand((Strand)end.getLeft());
            info1.setStrand((Strand)end.getRight());
            ((Strand)end.getLeft()).pushXYdistinct(commonPt);
            info0.getStrand().setTypeFlag(info0.getTypeFlag().getValue());
            info1.getStrand().setTypeFlag(info1.getTypeFlag().getValue());
        }
    }

    void checkIfErasable(ActiveLine loLine, LineInfo loInfo, ActiveLine hiLine, LineInfo hiInfo) {
        if (loLine.getGhostSlice() != null && Objects.equals(hiLine.getGhostSlice(), loLine.getGhostSlice()) && this.aboveIsInside(hiLine)) {
            this.checkForErasure(loLine, hiLine);
        } else if ((loInfo.getType().isHole() || hiInfo.getType().isHole()) && this.aboveIsInside(loLine) && !this.aboveIsInside(hiLine)) {
            this.checkForErasure(loLine, hiLine);
        }
    }

    void checkForErasure(ActiveLine line0, ActiveLine line1) {
        DirectPosition dp1;
        LineInfo info0 = (LineInfo)line0.getLineInfo();
        LineInfo info1 = (LineInfo)line1.getLineInfo();
        Strand strand0 = info0.getStrand();
        Strand strand1 = info1.getStrand();
        if (strand0 == null || strand1 == null) {
            return;
        }
        if (strand0.size() < 2 || strand1.size() < 2) {
            return;
        }
        DirectPosition dp0 = strand0.get(1);
        if (!dp0.equalsXY(dp1 = strand1.get(1))) {
            return;
        }
        dp0 = strand0.get(0);
        if (!dp0.equalsXY(dp1 = strand1.get(0))) {
            return;
        }
        if ((strand0.equals(strand1) || strand0.getTwin().equals(strand1)) && strand0.size() < 5) {
            while (strand0.size() > 1) {
                strand0.pop_back();
            }
            return;
        }
        strand0.pop_back();
        strand0.pop_back();
        strand1.pop_back();
        if (this.aboveIsInside(line1)) {
            this.connectPair(line0, line1, this.slice().prev(line0.sliceNode()).get());
        } else {
            this.connectPair(line0, line1, null);
        }
        Pair<Strand, Strand> pair = Strand.newPair();
        ((Strand)pair.getLeft()).pushXYdistinct(dp0);
        ((Strand)pair.getLeft()).setTypeFlag(info0.getTypeFlag().getValue());
        ((Strand)pair.getLeft()).setTypeFlag(info1.getTypeFlag().getValue());
        info0.setStrand((Strand)pair.getLeft());
        info1.setStrand((Strand)pair.getRight());
    }

    void processStrandsAtCommonPoint(List<IGeometry> resultGeoms, List<Strand> strandList, List<Integer> metStrands) {
        if (metStrands.size() == 2) {
            Strand twin = strandList.get(metStrands.get(0)).getTwin();
            if (Strand.connect(strandList.get(metStrands.get(0)), strandList.get(metStrands.get(1)))) {
                resultGeoms.add(new Curve(this.m_spatialInfo, new LineString(this.m_spatialInfo, twin.asCoordList(0.0))));
            } else {
                if (twin.Finished() && twin.getTwin().Finished()) {
                    resultGeoms.add(new Curve(this.m_spatialInfo, new LineString(this.m_spatialInfo, twin.asCoordList(0.0))));
                }
                strandList.set(metStrands.get(0), null);
                strandList.set(metStrands.get(1), null);
            }
        } else {
            for (int i : metStrands) {
                Strand outStrand = strandList.get(i);
                outStrand.setFinished(true);
                Strand twin = outStrand.getTwin();
                if (!twin.Finished()) continue;
                resultGeoms.add(new Curve(this.m_spatialInfo, new LineString(this.m_spatialInfo, outStrand.asCoordList(0.0))));
            }
        }
    }

    List<Strand> createStrandsForOutput(List<Segment> targetSegs, List<Segment> cutterSegs) {
        ArrayList<Strand> cleanStrands = new ArrayList<Strand>();
        CIterator<Segment> cutterIter = CListIterator.begin(cutterSegs);
        CIterator<Segment> prevSegIter = CListIterator.end(targetSegs);
        CIterator<Segment> targetIter = CListIterator.begin(targetSegs);
        while (!targetIter.isEnd()) {
            while (!cutterIter.isEnd() && cutterIter.get().lessThan(targetIter.get())) {
                cutterIter.next();
            }
            if (!(!cutterIter.isEnd() && targetIter.get().equals(cutterIter.get()) || !prevSegIter.isEnd() && targetIter.get().equals(prevSegIter.get()))) {
                prevSegIter = targetIter.getCopy();
                Pair<Strand, Strand> end = Strand.newPair();
                ((Strand)end.getLeft()).pushXYdistinct(targetIter.get().pos[0]);
                ((Strand)end.getLeft()).pushXYdistinct(targetIter.get().pos[1]);
                cleanStrands.add((Strand)end.getLeft());
                cleanStrands.add((Strand)end.getRight());
            }
            targetIter.next();
        }
        return cleanStrands;
    }

    boolean pointOutputtable(DirectPosition dpPt, DirectPosition dpStrand, DirectPosition dpCutter, DirectPosition dpSpurious) {
        if (dpPt.equalsXY(dpStrand)) {
            return false;
        }
        if (dpPt.equalsXY(dpSpurious)) {
            return false;
        }
        return !dpPt.equalsXY(dpCutter);
    }

    protected static class Segment
    implements Comparable<Segment> {
        private final DirectPosition[] pos = new DirectPosition[2];

        protected Segment(DirectPosition a, DirectPosition b) {
            if (PointComparator.INSTANCE.compare(a, b) < 0) {
                this.pos[0] = a;
                this.pos[1] = b;
            } else {
                this.pos[0] = b;
                this.pos[1] = a;
            }
        }

        public boolean lessThan(Segment otherSeg) {
            return this.compareTo(otherSeg) < 0;
        }

        public boolean equals(Segment otherSeg) {
            return this.pos[0].equalsXY(otherSeg.pos[0]) && this.pos[1].equalsXY(otherSeg.pos[1]);
        }

        @Override
        public int compareTo(Segment otherSeg) {
            int order = PointComparator.INSTANCE.compare(this.pos[0], otherSeg.pos[0]);
            if (order != 0) {
                return order;
            }
            return PointComparator.INSTANCE.compare(this.pos[1], otherSeg.pos[1]);
        }
    }
}

