/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.s2;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.IDirectPositionIterator;
import com.mapinfo.midev.geometry.IDirectPositionList;
import com.mapinfo.midev.geometry.IGeometry;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.impl.DirectPositionArray;
import com.mapinfo.midev.geometry.impl.LineString;
import com.mapinfo.midev.geometry.impl.Point;
import com.mapinfo.midev.geometry.impl.Polygon;
import com.mapinfo.midev.geometry.impl.Ring;
import com.mapinfo.midev.geometry.operations.s2.ActiveLine;
import com.mapinfo.midev.geometry.operations.s2.ActiveLineList;
import com.mapinfo.midev.geometry.operations.s2.CutterType;
import com.mapinfo.midev.geometry.operations.s2.InputType;
import com.mapinfo.midev.geometry.operations.s2.LineInfo;
import com.mapinfo.midev.geometry.operations.s2.PlaneSweep;
import com.mapinfo.midev.geometry.operations.s2.PlaneSweepErase;
import com.mapinfo.midev.geometry.operations.s2.PointComparator;
import com.mapinfo.midev.geometry.operations.s2.S2Utilities;
import com.mapinfo.midev.geometry.operations.s2.SkipListIterator;
import com.mapinfo.midev.geometry.operations.s2.Strand;
import com.mapinfo.midev.geometry.operations.s2.SweepEventControlPoint;
import com.mapinfo.midev.geometry.operations.s2.util.Assert;
import com.mapinfo.midev.geometry.operations.s2.util.CIterator;
import com.mapinfo.midev.geometry.operations.s2.util.CListIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class PlaneSweepMultiErase
extends PlaneSweepErase {
    private final List<List<Polygon>> m_resultPolys = new ArrayList<List<Polygon>>();
    private final List<List<Strand>> m_targetStrands = new ArrayList<List<Strand>>();
    private final List<Strand> m_cutterStrands = new ArrayList<Strand>();
    private final List<IDirectPositionList> m_targetPts = new ArrayList<IDirectPositionList>();
    private final List<DirectPosition> m_cutterPts = new ArrayList<DirectPosition>();
    private final List<DirectPosition> m_spuriousPts = new ArrayList<DirectPosition>();
    private int next_ID = 1;
    private int numTargets = 0;

    public PlaneSweepMultiErase(SpatialInfo spatialInfo, double tolerance) {
        super(spatialInfo, tolerance);
    }

    @Override
    SweepEventControlPoint newMonotoneSection(IDirectPositionList posList, int left, int right, int dir, PlaneSweep.Type lineType, CutterType isCutter, ActiveLineList sourceID, boolean leftToRight) {
        LineInfoEx info = isCutter.toBoolean() ? new LineInfoEx(isCutter, lineType, 0) : new LineInfoEx(isCutter, lineType, this.next_ID);
        SweepEventControlPoint event = new SweepEventControlPoint(posList, left, right, dir, info, sourceID);
        event.setEventOrder(event.getEventOrder() + info.getEventBias());
        return event;
    }

    @Override
    void swapped(SkipListIterator<ActiveLine> lo, ActiveLine hi) {
        ActiveLine loLine = lo.get();
        LineInfo loInfo = (LineInfo)loLine.getLineInfo();
        LineInfo hiInfo = (LineInfo)hi.getLineInfo();
        if (!loInfo.getType().isRegion() && !hiInfo.getType().isRegion()) {
            this.swappedLinears(loLine, hi);
        } else if (loInfo.getType().isRegion() && hiInfo.getType().isRegion()) {
            this.swappedPolysEx(loLine, hi);
        } else {
            this.swappedMix(loLine, hi);
        }
    }

    void sweep(List<IGeometry> result) {
        this.runSweep();
        this.multiSweepCompleted(result);
    }

    void multiSweepCompleted(List<IGeometry> result) {
        DirectPosition dpStrand;
        ArrayList<IGeometry> resultGeoms = new ArrayList<IGeometry>();
        for (Strand s : this.m_cutterStrands) {
            s.setFinished(false);
        }
        ArrayList<PlaneSweepErase.Segment> cutterSegs = new ArrayList<PlaneSweepErase.Segment>();
        for (Strand s : this.m_cutterStrands) {
            if (s.Finished()) continue;
            s.setFinished(true);
            if (s.getTwin() != null) {
                s.getTwin().setFinished(true);
            }
            if (s.size() == 1) {
                dpStrand = s.get(0);
                this.m_cutterPts.add(dpStrand);
                continue;
            }
            for (int i = 0; i < s.size() - 1; ++i) {
                DirectPosition dp1;
                DirectPosition dp0 = s.get(i);
                if (dp0.equalsXY(dp1 = s.get(i + 1))) {
                    this.m_cutterPts.add(dp0);
                    continue;
                }
                cutterSegs.add(new PlaneSweepErase.Segment(dp0, dp1));
                if (i == 0) {
                    this.m_cutterPts.add(dp0);
                }
                this.m_cutterPts.add(dp1);
            }
        }
        this.m_cutterStrands.clear();
        Collections.sort(cutterSegs);
        for (int i = 0; i < this.numTargets; ++i) {
            List<Polygon> m_resultPolys = this.m_resultPolys.get(i);
            IDirectPositionList m_targetPts = this.m_targetPts.get(i);
            List<Strand> m_targetStrands = this.m_targetStrands.get(i);
            ArrayList<PlaneSweepErase.Segment> targetSegs = new ArrayList<PlaneSweepErase.Segment>();
            for (Strand s : m_targetStrands) {
                if (s.Finished()) continue;
                s.setFinished(true);
                if (s.getTwin() != null) {
                    s.getTwin().setFinished(true);
                }
                if (s.size() == 1) {
                    if (s.getTypeFlag() != PlaneSweep.Flag.FLAG_POINT.getValue()) continue;
                    dpStrand = s.get(0);
                    m_targetPts.add(dpStrand);
                    continue;
                }
                for (int n = 0; n < s.size() - 1; ++n) {
                    DirectPosition dp1;
                    DirectPosition dp0 = s.get(n);
                    if (dp0.equalsXY(dp1 = s.get(n + 1))) {
                        m_targetPts.add(dp0);
                        continue;
                    }
                    targetSegs.add(new PlaneSweepErase.Segment(dp0, dp1));
                    if (n == 0) {
                        m_targetPts.add(dp0);
                    }
                    m_targetPts.add(dp1);
                }
            }
            m_targetStrands.clear();
            Collections.sort(targetSegs);
            List<Strand> cleanStrands = this.createStrandsForOutput(targetSegs, cutterSegs);
            if (m_targetPts.size() > 0) {
                m_targetPts = S2Utilities.sort(m_targetPts, PointComparator.INSTANCE);
            }
            if (this.m_spuriousPts.size() > 0) {
                Collections.sort(this.m_spuriousPts, PointComparator.INSTANCE);
            }
            if (this.m_cutterPts.size() > 0) {
                Collections.sort(this.m_cutterPts, PointComparator.INSTANCE);
            }
            DirectPosition dpPtPrev = new DirectPosition(Double.NaN, Double.NaN);
            class StrandEndPointCompare
            implements Comparator<Strand> {
                StrandEndPointCompare() {
                }

                @Override
                public int compare(Strand o1, Strand o2) {
                    return PointComparator.INSTANCE.compare(o1.get(0), o2.get(0));
                }
            }
            Collections.sort(cleanStrands, new StrandEndPointCompare());
            CIterator<Strand> strandIter = CListIterator.begin(cleanStrands);
            dpStrand = new DirectPosition(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
            CIterator<DirectPosition> spuriousIter = CListIterator.begin(this.m_spuriousPts);
            DirectPosition dpSpurious = new DirectPosition(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
            CIterator<DirectPosition> cutterIter = CListIterator.begin(this.m_cutterPts);
            DirectPosition dpCutter = new DirectPosition(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
            DirectPosition tmp = new DirectPosition();
            IDirectPositionIterator iter = m_targetPts.getDirectPositionIterator();
            while (iter.hasNext()) {
                iter.nextDirectPosition(tmp);
                while (!strandIter.isEnd() && PointComparator.INSTANCE.compare(strandIter.get().get(0), tmp) < 0) {
                    strandIter.next();
                }
                if (!strandIter.isEnd()) {
                    dpStrand = strandIter.get().get(0);
                }
                while (!spuriousIter.isEnd() && PointComparator.INSTANCE.compare(spuriousIter.get(), tmp) < 0) {
                    spuriousIter.next();
                }
                if (!spuriousIter.isEnd()) {
                    dpSpurious = spuriousIter.get();
                }
                while (!cutterIter.isEnd() && PointComparator.INSTANCE.compare(cutterIter.get(), tmp) < 0) {
                    cutterIter.next();
                }
                if (!cutterIter.isEnd()) {
                    dpCutter = cutterIter.get();
                }
                if (tmp.equalsXY(dpPtPrev) || !this.pointOutputtable(tmp, dpStrand, dpCutter, dpSpurious)) continue;
                resultGeoms.add(new Point(this.getSpatialInfo(), new DirectPosition(tmp)));
                dpPtPrev = tmp.getCopy();
            }
            ArrayList<Integer> metStrands = new ArrayList<Integer>();
            DirectPosition curPos = null;
            for (int curStrand = 0; curStrand < cleanStrands.size(); ++curStrand) {
                Strand strand = cleanStrands.get(curStrand);
                if (strand.Finished()) continue;
                if (metStrands.size() == 0) {
                    metStrands.add(curStrand);
                    curPos = strand.get(0);
                    continue;
                }
                if (strand.get(0).equalsXY(curPos)) {
                    metStrands.add(curStrand);
                    continue;
                }
                Assert.assertCondition(PointComparator.INSTANCE.compare(strand.get(0), curPos) > 0);
                this.processStrandsAtCommonPoint(resultGeoms, cleanStrands, metStrands);
                metStrands.clear();
                metStrands.add(curStrand);
                curPos = strand.get(0);
            }
            this.processStrandsAtCommonPoint(resultGeoms, cleanStrands, metStrands);
            for (Polygon poly : m_resultPolys) {
                resultGeoms.add(poly);
            }
            result.add(S2Utilities.toMinimalFeatureGeometry(this.getSpatialInfo(), resultGeoms));
            resultGeoms.clear();
        }
    }

    @Override
    public void addGeometry(IGeometry gg, CutterType isCutter, InputType model) {
        super.addGeometry(gg, isCutter, model);
        if (!isCutter.toBoolean()) {
            ++this.next_ID;
            ++this.numTargets;
            this.m_resultPolys.add(new ArrayList());
            this.m_targetStrands.add(new ArrayList());
            this.m_targetPts.add(new DirectPositionArray());
        }
    }

    @Override
    void outputStrand(Strand s, LineInfo info) {
        if (info.isOutputEdgeCutter().toBoolean()) {
            this.m_cutterStrands.add(s);
        }
        if (info.isOutputEdgeTarget() && this.m_targetStrands.size() > 0) {
            LineInfoEx infoex = (LineInfoEx)info;
            this.m_targetStrands.get(infoex.getParent_ID() - 1).add(s);
        }
    }

    @Override
    void connectPair(ActiveLine line0, ActiveLine line1, ActiveLine holeLine) {
        LineInfo info0 = (LineInfo)line0.getLineInfo();
        LineInfo info1 = (LineInfo)line1.getLineInfo();
        if (info0.getType().isRegion() != info1.getType().isRegion()) {
            throw new IllegalStateException();
        }
        if (info0.getStrand() != null || info1.getStrand() != null) {
            Strand strand0 = info0.getStrand();
            Strand strand1 = info1.getStrand();
            Assert.assertCondition(strand0 != null);
            Strand twin0 = strand0 != null ? strand0.getTwin() : null;
            boolean loop = Strand.connect(strand0, strand1);
            info0.setStrand(null);
            info1.setStrand(null);
            if (loop) {
                strand0.mergeHolesFrom(strand1);
                if (line0.getHoles() == null) {
                    line0.setHoles(strand0.containedHoles());
                    strand0.containedHoles(null);
                } else if (strand0.containedHoles() != null) {
                    for (IDirectPositionList list : strand0.containedHoles()) {
                        line0.getHoles().add(list);
                    }
                    strand0.containedHoles(null);
                }
                this.mergeHolesInto(line1, line0);
                int order = PointComparator.INSTANCE.compare(strand0.get(0), strand1.get(0));
                if (order < 0) {
                    strand0.pushXYdistinct(strand1.get(0));
                    strand0.setTypeFlag(info0.getTypeFlag().getValue());
                } else if (order > 0) {
                    strand1.pushXYdistinct(strand0.get(0));
                    strand1.setTypeFlag(info1.getTypeFlag().getValue());
                }
                IDirectPositionList dpl = twin0.asCoordList(this.tol());
                if (holeLine != null) {
                    this.mergeHolesInto(line0, holeLine);
                    Assert.assertCondition(info1.getType().isRegion());
                    IDirectPositionList ring = this.refactorRing(dpl, null, null);
                    if (ring.size() != 0) {
                        if (holeLine.getHoles() == null) {
                            holeLine.setHoles(new ArrayList<IDirectPositionList>());
                        }
                        holeLine.getHoles().add(ring);
                    }
                    strand0 = null;
                    strand1 = null;
                } else if (info1.getType().isRegion()) {
                    IDirectPositionList ring = this.refactorRing(dpl, null, null);
                    if (ring.size() == 0) {
                        if (line0.getHoles() != null && line0.getHoles().size() > 0) {
                            // empty if block
                        }
                    } else if (line0.getHoles() != null && line0.getHoles().size() > 0) {
                        ArrayList<Ring> rings = new ArrayList<Ring>(line0.getHoles().size());
                        for (IDirectPositionList list : line0.getHoles()) {
                            rings.add(new Ring(this.getSpatialInfo(), new LineString(this.getSpatialInfo(), list)));
                        }
                        if (this.m_resultPolys.size() > 0) {
                            LineInfoEx infoex = LineInfoEx.dynamic_cast(info0);
                            if (infoex.Parent_ID != 0) {
                                this.m_resultPolys.get(infoex.Parent_ID - 1).add(new Polygon(this.getSpatialInfo(), new Ring(this.getSpatialInfo(), new LineString(this.getSpatialInfo(), ring)), rings));
                            } else {
                                infoex = LineInfoEx.dynamic_cast(info1);
                                this.m_resultPolys.get(infoex.Parent_ID - 1).add(new Polygon(this.getSpatialInfo(), new Ring(this.getSpatialInfo(), new LineString(this.getSpatialInfo(), ring)), rings));
                            }
                        }
                    } else if (this.m_resultPolys.size() > 0) {
                        LineInfoEx infoex = LineInfoEx.dynamic_cast(info0);
                        if (infoex.Parent_ID != 0) {
                            this.m_resultPolys.get(infoex.Parent_ID - 1).add(new Polygon(this.getSpatialInfo(), new Ring(this.getSpatialInfo(), new LineString(this.getSpatialInfo(), ring))));
                        } else {
                            infoex = LineInfoEx.dynamic_cast(info1);
                            this.m_resultPolys.get(infoex.Parent_ID - 1).add(new Polygon(this.getSpatialInfo(), new Ring(this.getSpatialInfo(), new LineString(this.getSpatialInfo(), ring))));
                        }
                    }
                    line0.setHoles(null);
                    strand0 = null;
                    strand1 = null;
                } else {
                    Assert.assertCondition(info0.isCutter() == info1.isCutter());
                    this.outputStrand(strand0, info0);
                    this.outputStrand(strand1, info1);
                }
            } else {
                this.mergeHolesInto(line0, twin0);
                this.mergeHolesInto(line1, twin0);
            }
        }
        if (holeLine != null) {
            this.mergeHolesInto(line0, holeLine);
            this.mergeHolesInto(line1, holeLine);
        }
    }

    void swappedPolysEx(ActiveLine loLine, ActiveLine hiLine) {
        boolean swap;
        boolean merge;
        LineInfo loInfo = (LineInfo)loLine.getLineInfo();
        LineInfo hiInfo = (LineInfo)hiLine.getLineInfo();
        Assert.assertCondition(this.slice().next(loLine.sliceNode()).equals(hiLine.sliceNode()));
        DirectPosition commonPt = this.bringToCommonTime(loLine, hiLine);
        Assert.assertCondition(hiInfo.getInsidedness() == loInfo.getInsidedness() + hiInfo.insidednessDiff());
        Assert.assertCondition(hiInfo.getCutterInsidedness() == loInfo.getCutterInsidedness() + hiInfo.cutterDiff());
        int insidednessBelow = loInfo.getInsidedness() - loInfo.insidednessDiff();
        int cutterInsidednessBelow = loInfo.getCutterInsidedness() - loInfo.cutterDiff();
        int insidednessAbove = hiInfo.getInsidedness();
        int cutterInsidednessAbove = hiInfo.getCutterInsidedness();
        boolean contained = this.aboveIsInside(hiLine);
        if (loLine.getGhostSlice() != null && loLine.getGhostSlice().equals(hiLine.getGhostSlice())) {
            PlaneSweep.Type temp = loInfo.getType();
            loInfo.setTypeFlag(hiInfo.getType());
            hiInfo.setTypeFlag(temp);
        }
        hiInfo.setInsidedness(insidednessBelow + hiInfo.insidednessDiff());
        hiInfo.setCutterInsidedness(cutterInsidednessBelow + hiInfo.cutterDiff());
        loInfo.setInsidedness(hiInfo.getInsidedness() + loInfo.insidednessDiff());
        loInfo.setCutterInsidedness(hiInfo.getCutterInsidedness() + loInfo.cutterDiff());
        Assert.assertCondition(loInfo.getInsidedness() == insidednessAbove);
        Assert.assertCondition(loInfo.getCutterInsidedness() == cutterInsidednessAbove);
        if (loInfo.getStrand() == null || hiInfo.getStrand() == null) {
            merge = false;
            swap = loInfo.getStrand() == null && loInfo.isOutputEdge() || hiInfo.getStrand() == null && hiInfo.isOutputEdge();
        } else if (!loInfo.isOutputEdge() || !hiInfo.isOutputEdge()) {
            merge = true;
            swap = false;
        } else if (contained) {
            merge = false;
            swap = true;
        } else {
            merge = true;
            swap = false;
        }
        if (merge) {
            if (contained) {
                this.connectPair(loLine, hiLine, this.slice().prev(loLine.sliceNode()).get());
            } else {
                this.connectPair(loLine, hiLine, null);
            }
        } else if (swap) {
            LineInfoEx infoex1;
            LineInfoEx infoex;
            if (loInfo.isCutter().toBoolean()) {
                infoex = LineInfoEx.dynamic_cast(loInfo);
                infoex1 = LineInfoEx.dynamic_cast(hiInfo);
                infoex.Parent_ID = infoex1.Parent_ID;
            } else if (hiInfo.isCutter().toBoolean()) {
                infoex = LineInfoEx.dynamic_cast(loInfo);
                infoex1 = LineInfoEx.dynamic_cast(hiInfo);
                infoex1.Parent_ID = infoex.Parent_ID;
            }
            Strand temp = loInfo.getStrand();
            loInfo.setStrand(hiInfo.getStrand());
            hiInfo.setStrand(temp);
            List<IDirectPositionList> tempHoles = loLine.getHoles();
            loLine.setHoles(hiLine.getHoles());
            hiLine.setHoles(tempHoles);
        }
        if (loInfo.getStrand() == null && hiInfo.getStrand() == null) {
            this.createStrandPair(loLine, hiLine, commonPt);
        }
    }

    @Override
    IDirectPositionList refactorRing(IDirectPositionList dpl, IDirectPositionList outPts, List<IDirectPositionList> outStrands) {
        return super.refactorRing(dpl, null, null);
    }

    private static class LineInfoEx
    extends LineInfo {
        private int Parent_ID;

        public LineInfoEx(CutterType isCutter, PlaneSweep.Type type, int id) {
            super(isCutter, type);
            this.Parent_ID = id;
        }

        public int getParent_ID() {
            return this.Parent_ID;
        }

        public static LineInfoEx dynamic_cast(LineInfo lineInfo) {
            if (lineInfo instanceof LineInfoEx) {
                return (LineInfoEx)lineInfo;
            }
            return new LineInfoEx(lineInfo.isCutter(), lineInfo.getType(), 0);
        }

        @Override
        public void activatePair(ActiveLine loLine, ActiveLine hiLine) {
            super.activatePair(loLine, hiLine);
            LineInfo loInfo = (LineInfo)loLine.getLineInfo();
            if (loInfo.getType().isRegion() && loInfo.isCutter().toBoolean()) {
                LineInfo prevInfo = null;
                SkipListIterator<ActiveLine> prevLine = loLine.getSweep().slice().prev(loLine.sliceNode());
                if (!prevLine.equals(loLine.getSweep().slice().rend())) {
                    prevInfo = (LineInfo)prevLine.get().getLineInfo();
                }
                if (prevInfo != null) {
                    LineInfo hiInfo = (LineInfo)hiLine.getLineInfo();
                    LineInfoEx infoex0 = LineInfoEx.dynamic_cast(loInfo);
                    LineInfoEx infoex1 = LineInfoEx.dynamic_cast(hiInfo);
                    Assert.assertCondition(infoex1 != null);
                    LineInfoEx targetinfoex = LineInfoEx.dynamic_cast(prevInfo);
                    infoex0.Parent_ID = targetinfoex.Parent_ID;
                    infoex1.Parent_ID = targetinfoex.Parent_ID;
                }
            }
        }
    }
}

