/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.s2;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.operations.s2.PlaneSweep;
import com.mapinfo.midev.geometry.operations.s2.PointComparator;

abstract class SweepEvent
implements Comparable<SweepEvent> {
    private final DirectPosition m_time;
    private int m_eventOrder;

    public SweepEvent(int eventOrder) {
        this.m_time = new DirectPosition(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.m_eventOrder = eventOrder;
    }

    public SweepEvent(DirectPosition time) {
        this(time, 0);
    }

    public SweepEvent(DirectPosition time, int eventOrder) {
        this.m_time = time;
        this.m_eventOrder = eventOrder;
    }

    public DirectPosition getTime() {
        return this.m_time;
    }

    public void setTime(DirectPosition time) {
        this.m_time.set(time);
    }

    public int getEventOrder() {
        return this.m_eventOrder;
    }

    public void setEventOrder(int eventOrder) {
        this.m_eventOrder = eventOrder;
    }

    @Override
    public int compareTo(SweepEvent rhs) {
        int result = PointComparator.INSTANCE.compare(this.m_time, rhs.m_time);
        if (result == 0) {
            result = this.m_eventOrder - rhs.m_eventOrder;
        }
        return result;
    }

    public abstract boolean action(PlaneSweep var1);

    public static enum Type {
        MULTI_START_EVENT(10),
        LINE_PROGRESS_EVENT(20),
        MULTI_END_EVENT(30);

        private final int m_value;

        private Type(int value) {
            this.m_value = value;
        }

        public int getValue() {
            return this.m_value;
        }
    }
}

