/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.s2;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.operations.s2.ActiveLine;
import com.mapinfo.midev.geometry.operations.s2.PlaneSweep;
import com.mapinfo.midev.geometry.operations.s2.SkipListIterator;
import com.mapinfo.midev.geometry.operations.s2.SweepEvent;
import com.mapinfo.midev.geometry.operations.s2.util.Assert;

final class SweepEventEnd
extends SweepEvent {
    private final ActiveLine[] m_line = new ActiveLine[2];
    private int m_lineCount;

    public SweepEventEnd() {
        super(0);
    }

    ActiveLine getLine0() {
        return this.m_line[0];
    }

    void setMultiEnd(DirectPosition endTime, int bias) {
        this.setTime(endTime);
        this.setEventOrder(SweepEvent.Type.MULTI_END_EVENT.getValue() + bias);
    }

    void add(ActiveLine line) {
        this.m_line[this.m_lineCount] = line;
        ++this.m_lineCount;
    }

    @Override
    public boolean action(PlaneSweep sweep) {
        if (this.m_lineCount == 2) {
            int offset = this.m_line[1].sliceNode().subtract(this.m_line[0].sliceNode());
            if (offset < 0) {
                offset = -offset;
                ActiveLine temp = this.m_line[0];
                this.m_line[0] = this.m_line[1];
                this.m_line[1] = temp;
            }
            ActiveLine dirtyBottom = null;
            ActiveLine dirtyTop = null;
            if (offset != 1) {
                dirtyBottom = sweep.slice().next(this.m_line[0].sliceNode()).getElement().getDatum();
                dirtyTop = sweep.slice().prev(this.m_line[1].sliceNode()).getElement().getDatum();
                Assert.assertCondition(dirtyTop.sliceNode().subtract(dirtyBottom.sliceNode()) >= 0);
            }
            while (offset > 1) {
                SkipListIterator<ActiveLine> next = sweep.slice().next(this.m_line[0].sliceNode());
                this.m_line[0].swapWithNext(next, false);
                --offset;
            }
            Assert.assertCondition(this.m_line[1].sliceNode().subtract(this.m_line[0].sliceNode()) == 1);
            sweep.sweptPair(this.m_line[0], this.m_line[1]);
            ActiveLine.sweptPair(this.m_line[0], this.m_line[1]);
            if (dirtyBottom != null) {
                if (dirtyTop.sliceNode().subtract(dirtyBottom.sliceNode()) >= 0) {
                    ActiveLine.verifyOrdering(dirtyBottom, dirtyTop, false);
                } else {
                    ActiveLine.verifyOrdering(dirtyTop, dirtyBottom, false);
                }
            }
        } else if (this.m_lineCount == 1) {
            this.m_line[0].swept();
        } else {
            throw new IllegalStateException();
        }
        return false;
    }
}

