/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.s2;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.operations.s2.ActiveLine;
import com.mapinfo.midev.geometry.operations.s2.PlaneSweep;
import com.mapinfo.midev.geometry.operations.s2.SweepEvent;
import com.mapinfo.midev.geometry.operations.s2.SweepEventControlPoint;
import com.mapinfo.midev.geometry.operations.s2.util.Assert;

final class SweepEventStart
extends SweepEvent {
    private final SweepEventControlPoint[] m_lineEvent = new SweepEventControlPoint[2];
    private int m_lineCount;

    public SweepEventStart() {
        super(0);
    }

    void setMultiStart(DirectPosition startTime, int bias) {
        this.setTime(startTime);
        this.setEventOrder(SweepEvent.Type.MULTI_START_EVENT.getValue() + bias);
    }

    void add(SweepEventControlPoint lineEvent) {
        this.m_lineEvent[this.m_lineCount] = lineEvent;
        ++this.m_lineCount;
    }

    SweepEventControlPoint remove() {
        Assert.assertCondition(this.m_lineCount == 1);
        SweepEventControlPoint controlPoint = this.m_lineEvent[0];
        this.m_lineEvent[0] = null;
        this.m_lineCount = 0;
        return controlPoint;
    }

    @Override
    public boolean action(PlaneSweep sweep) {
        if (this.m_lineCount == 1) {
            ActiveLine line0 = this.m_lineEvent[0].getActiveLine();
            line0.activatePair(null, sweep);
            sweep.events().add(this.m_lineEvent[0]);
            this.m_lineEvent[0] = null;
        } else if (this.m_lineCount == 2) {
            ActiveLine line0 = this.m_lineEvent[0].getActiveLine();
            ActiveLine line1 = this.m_lineEvent[1].getActiveLine();
            line0.activatePair(line1, sweep);
            sweep.events().add(this.m_lineEvent[0]);
            this.m_lineEvent[0] = null;
            sweep.events().add(this.m_lineEvent[1]);
            this.m_lineEvent[1] = null;
        } else {
            throw new IllegalStateException();
        }
        return false;
    }
}

