/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.s2.util;

import com.mapinfo.midev.geometry.operations.s2.util.CIterator;
import java.util.List;
import java.util.NoSuchElementException;

public final class CListIterator<T>
implements CIterator<T> {
    private final List<T> m_list;
    private int m_index;

    private CListIterator(List<T> list, int index) {
        this.m_list = list;
        this.m_index = index;
    }

    public static <T> CIterator<T> begin(List<T> list) {
        return new CListIterator<T>(list, 0);
    }

    public static <T> CIterator<T> end(List<T> list) {
        return new CListIterator<T>(list, list.size());
    }

    @Override
    public T get() {
        return this.m_list.get(this.m_index);
    }

    @Override
    public void next() {
        if (this.m_index == this.m_list.size()) {
            throw new NoSuchElementException();
        }
        ++this.m_index;
    }

    @Override
    public void prev() {
        if (this.m_index == 0) {
            throw new NoSuchElementException();
        }
        --this.m_index;
    }

    @Override
    public boolean isEnd() {
        return this.m_index == this.m_list.size();
    }

    @Override
    public CIterator<T> getCopy() {
        return new CListIterator<T>(this.m_list, this.m_index);
    }
}

