/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.serial;

import com.mapinfo.midev.coordsys.factory.CoordSysFactory;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.GeometryType;
import com.mapinfo.midev.geometry.IDirectPositionIterator;
import com.mapinfo.midev.geometry.IDirectPositionList;
import com.mapinfo.midev.geometry.IGeometry;
import com.mapinfo.midev.geometry.ILegacyText;
import com.mapinfo.midev.geometry.IMultiFeatureGeometry;
import com.mapinfo.midev.geometry.MValue;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.impl.Curve;
import com.mapinfo.midev.geometry.impl.CurveSegment;
import com.mapinfo.midev.geometry.impl.DirectPositionArray;
import com.mapinfo.midev.geometry.impl.LegacyArc;
import com.mapinfo.midev.geometry.impl.LegacyEllipse;
import com.mapinfo.midev.geometry.impl.LegacyRoundedRectangle;
import com.mapinfo.midev.geometry.impl.LegacyText;
import com.mapinfo.midev.geometry.impl.LineString;
import com.mapinfo.midev.geometry.impl.MultiCurve;
import com.mapinfo.midev.geometry.impl.MultiFeatureGeometry;
import com.mapinfo.midev.geometry.impl.MultiPoint;
import com.mapinfo.midev.geometry.impl.MultiPolygon;
import com.mapinfo.midev.geometry.impl.Point;
import com.mapinfo.midev.geometry.impl.Polygon;
import com.mapinfo.midev.geometry.impl.Rectangle;
import com.mapinfo.midev.geometry.impl.Ring;
import com.mapinfo.midev.geometry.impl.XYDirectPositionArray;
import com.mapinfo.midev.unit.Angle;
import com.mapinfo.midev.unit.AngularUnit;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.unit.PaperLength;
import com.mapinfo.midev.unit.PaperUnit;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.lang3.SerializationUtils;

public final class GeometryBLOBReader {
    private static final GeometryType[] GEOMETRY_TYPES = GeometryType.values();
    private static final LinearUnit[] LINEAR_UNITS = LinearUnit.values();
    private static final AngularUnit[] ANGULAR_UNITS = AngularUnit.values();
    private static final ILegacyText.TextCalloutType[] TEXT_CALLOUT_TYPES = ILegacyText.TextCalloutType.values();
    private static final PaperUnit[] PAPER_UNITS = PaperUnit.values();

    private GeometryBLOBReader() {
    }

    public static IGeometry read(byte[] data) throws IOException {
        return GeometryBLOBReader.read(new ByteArrayInputStream(data));
    }

    public static IGeometry read(InputStream in) throws IOException {
        return GeometryBLOBReader.read(new DataInputStream(in));
    }

    private static IGeometry read(DataInputStream in) throws IOException {
        SpatialInfo spatialInfo = GeometryBLOBReader.readSpatialInfo(in);
        GeometryType type = GEOMETRY_TYPES[in.readInt()];
        switch (type) {
            case POINT: {
                return GeometryBLOBReader.readPoint(in, spatialInfo);
            }
            case MULTI_POINT: {
                return new MultiPoint(spatialInfo, GeometryBLOBReader.readDirectPositionList(in));
            }
            case MULTI_CURVE: {
                return GeometryBLOBReader.readMultiCurve(in, spatialInfo);
            }
            case MULTI_POLYGON: {
                return GeometryBLOBReader.readMultiPolygon(in, spatialInfo);
            }
            case MULTI_FEATURE_GEOMETRY: {
                return GeometryBLOBReader.readMultiFeatureGeometry(in, spatialInfo);
            }
            case POLYGON: {
                return GeometryBLOBReader.readPolygon(in, spatialInfo);
            }
            case CURVE: {
                return GeometryBLOBReader.readCurve(in, spatialInfo);
            }
            case RING: {
                return GeometryBLOBReader.readRing(in, spatialInfo);
            }
            case LINE_STRING: {
                return new LineString(spatialInfo, GeometryBLOBReader.readDirectPositionList(in));
            }
            case RECTANGLE: {
                return GeometryBLOBReader.readRectangle(in, spatialInfo);
            }
            case LEGACY_TEXT: {
                return GeometryBLOBReader.readLegacyText(in, spatialInfo);
            }
            case LEGACY_ARC: {
                return GeometryBLOBReader.readLegacyArc(in, spatialInfo);
            }
            case ROUNDED_RECTANGLE: {
                return GeometryBLOBReader.readRoundedRectangle(in, spatialInfo);
            }
            case ELLIPSE: {
                return GeometryBLOBReader.readEllipse(in, spatialInfo);
            }
        }
        return (IGeometry)SerializationUtils.deserialize((InputStream)in);
    }

    private static IMultiFeatureGeometry readMultiFeatureGeometry(DataInput in, SpatialInfo spatialInfo) throws IOException {
        int pointCount = in.readInt();
        ArrayList<Point> pointList = new ArrayList<Point>(pointCount);
        for (int n = 0; n < pointCount; ++n) {
            pointList.add(GeometryBLOBReader.readPoint(in, spatialInfo));
        }
        int multiPointCount = in.readInt();
        ArrayList<MultiPoint> multiPointList = new ArrayList<MultiPoint>(multiPointCount);
        for (int n = 0; n < multiPointCount; ++n) {
            multiPointList.add(new MultiPoint(spatialInfo, GeometryBLOBReader.readDirectPositionList(in)));
        }
        int multiCurveCount = in.readInt();
        ArrayList<MultiCurve> multiCurveList = new ArrayList<MultiCurve>(multiCurveCount);
        for (int n = 0; n < multiCurveCount; ++n) {
            multiCurveList.add(GeometryBLOBReader.readMultiCurve(in, spatialInfo));
        }
        int multiPolygonCount = in.readInt();
        ArrayList<MultiPolygon> multiPolygonList = new ArrayList<MultiPolygon>(multiPolygonCount);
        for (int n = 0; n < multiPolygonCount; ++n) {
            multiPolygonList.add(GeometryBLOBReader.readMultiPolygon(in, spatialInfo));
        }
        return new MultiFeatureGeometry(spatialInfo, pointList, multiPointList, multiCurveList, multiPolygonList);
    }

    private static MultiPolygon readMultiPolygon(DataInput in, SpatialInfo spatialInfo) throws IOException {
        int count = in.readInt();
        ArrayList<Polygon> result = new ArrayList<Polygon>(count);
        for (int n = 0; n < count; ++n) {
            result.add(GeometryBLOBReader.readPolygon(in, spatialInfo));
        }
        return new MultiPolygon(spatialInfo, result);
    }

    private static MultiCurve readMultiCurve(DataInput in, SpatialInfo spatialInfo) throws IOException {
        int count = in.readInt();
        ArrayList<Curve> result = new ArrayList<Curve>(count);
        for (int n = 0; n < count; ++n) {
            result.add(GeometryBLOBReader.readCurve(in, spatialInfo));
        }
        return new MultiCurve(spatialInfo, result);
    }

    private static Polygon readPolygon(DataInput in, SpatialInfo spatialInfo) throws IOException {
        Ring outerRing = GeometryBLOBReader.readRing(in, spatialInfo);
        int count = in.readInt();
        ArrayList<Ring> innerRings = new ArrayList<Ring>(count);
        for (int n = 0; n < count; ++n) {
            innerRings.add(GeometryBLOBReader.readRing(in, spatialInfo));
        }
        return new Polygon(spatialInfo, outerRing, innerRings);
    }

    private static Rectangle readRectangle(DataInput in, SpatialInfo spatialInfo) throws IOException {
        IDirectPositionList directPositionList = GeometryBLOBReader.readDirectPositionList(in);
        IDirectPositionIterator directPositionIterator = directPositionList.getDirectPositionIterator();
        DirectPosition ll = new DirectPosition();
        ll = directPositionIterator.nextDirectPosition(ll);
        DirectPosition ur = new DirectPosition();
        ur = directPositionIterator.nextDirectPosition(ur);
        return new Rectangle(spatialInfo, ll, ur);
    }

    private static LegacyRoundedRectangle readRoundedRectangle(DataInput in, SpatialInfo spatialInfo) throws IOException {
        DirectPosition ll = new DirectPosition();
        GeometryBLOBReader.readDirectPosition(in, ll, false, false);
        DirectPosition ur = new DirectPosition();
        GeometryBLOBReader.readDirectPosition(in, ur, false, false);
        PaperLength cornerRadiusX = new PaperLength(in.readDouble(), PAPER_UNITS[in.readInt()]);
        PaperLength cornerRadiusY = new PaperLength(in.readDouble(), PAPER_UNITS[in.readInt()]);
        return new LegacyRoundedRectangle(spatialInfo, ll, ur, cornerRadiusX, cornerRadiusY);
    }

    private static LegacyEllipse readEllipse(DataInput in, SpatialInfo spatialInfo) throws IOException {
        Rectangle rectangle = GeometryBLOBReader.readRectangle(in, spatialInfo);
        return new LegacyEllipse(rectangle);
    }

    private static LegacyArc readLegacyArc(DataInput in, SpatialInfo spatialInfo) throws IOException {
        Rectangle rectangle = GeometryBLOBReader.readRectangle(in, spatialInfo);
        Angle beginAngle = new Angle(in.readDouble(), ANGULAR_UNITS[in.readInt()]);
        Angle endAngle = new Angle(in.readDouble(), ANGULAR_UNITS[in.readInt()]);
        return new LegacyArc(rectangle, beginAngle, endAngle);
    }

    private static LegacyText readLegacyText(DataInput in, SpatialInfo spatialInfo) throws IOException {
        Rectangle rectangle = GeometryBLOBReader.readRectangle(in, spatialInfo);
        String text = in.readUTF();
        Angle angle = null;
        if (in.readBoolean()) {
            angle = new Angle(in.readDouble(), ANGULAR_UNITS[in.readInt()]);
        }
        ILegacyText.TextCalloutType textCalloutType = null;
        if (in.readBoolean()) {
            textCalloutType = TEXT_CALLOUT_TYPES[in.readInt()];
        }
        DirectPosition targetCallout = null;
        if (in.readBoolean()) {
            targetCallout = new DirectPosition();
            GeometryBLOBReader.readDirectPosition(in, targetCallout, false, false);
        }
        return new LegacyText(rectangle, text, angle, textCalloutType, targetCallout);
    }

    private static Ring readRing(DataInput in, SpatialInfo spatialInfo) throws IOException {
        int count = in.readInt();
        ArrayList<CurveSegment> result = new ArrayList<CurveSegment>(count);
        for (int n = 0; n < count; ++n) {
            result.add(new LineString(spatialInfo, GeometryBLOBReader.readDirectPositionList(in)));
        }
        return new Ring(spatialInfo, result);
    }

    private static Curve readCurve(DataInput in, SpatialInfo spatialInfo) throws IOException {
        int count = in.readInt();
        ArrayList<CurveSegment> result = new ArrayList<CurveSegment>(count);
        for (int n = 0; n < count; ++n) {
            result.add(new LineString(spatialInfo, GeometryBLOBReader.readDirectPositionList(in)));
        }
        return new Curve(spatialInfo, result);
    }

    private static IDirectPositionList readDirectPositionList(DataInput in) throws IOException {
        boolean hasZ = in.readBoolean();
        boolean hasM = in.readBoolean();
        int size = in.readInt();
        IDirectPositionList result = !hasZ && !hasM ? new XYDirectPositionArray(size) : new DirectPositionArray(size);
        DirectPosition tmp = new DirectPosition();
        for (int n = 0; n < size; ++n) {
            result.add(GeometryBLOBReader.readDirectPosition(in, tmp, hasZ, hasM));
        }
        return result;
    }

    private static Point readPoint(DataInput in, SpatialInfo spatialInfo) throws IOException {
        boolean hasZ = in.readBoolean();
        boolean hasM = in.readBoolean();
        return new Point(spatialInfo, GeometryBLOBReader.readDirectPosition(in, new DirectPosition(), hasZ, hasM));
    }

    private static DirectPosition readDirectPosition(DataInput in, DirectPosition dp, boolean hasZ, boolean hasM) throws IOException {
        dp.set(in.readDouble(), in.readDouble(), Double.NaN, null);
        if (hasZ) {
            dp.setZ(in.readDouble());
        }
        if (hasM && in.readBoolean()) {
            dp.setM(new MValue(in.readDouble()));
        }
        return dp;
    }

    private static SpatialInfo readSpatialInfo(DataInput in) throws IOException {
        String srsName = in.readUTF();
        LinearUnit zUnit = null;
        if (in.readBoolean()) {
            zUnit = LINEAR_UNITS[in.readInt()];
        }
        double tolerance = in.readDouble();
        return new SpatialInfo(CoordSysFactory.getDefaultCoordSysFactory().getCoordSys(srsName), zUnit, tolerance);
    }
}

