/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.serial;

import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.GeometryType;
import com.mapinfo.midev.geometry.ICurve;
import com.mapinfo.midev.geometry.ICurveSegment;
import com.mapinfo.midev.geometry.IDirectPositionIterator;
import com.mapinfo.midev.geometry.IDirectPositionList;
import com.mapinfo.midev.geometry.IFeatureGeometry;
import com.mapinfo.midev.geometry.IGeometry;
import com.mapinfo.midev.geometry.ILegacyArc;
import com.mapinfo.midev.geometry.ILegacyEllipse;
import com.mapinfo.midev.geometry.ILegacyRoundedRectangle;
import com.mapinfo.midev.geometry.ILegacyText;
import com.mapinfo.midev.geometry.IMultiCurve;
import com.mapinfo.midev.geometry.IMultiFeatureGeometry;
import com.mapinfo.midev.geometry.IMultiPoint;
import com.mapinfo.midev.geometry.IMultiPolygon;
import com.mapinfo.midev.geometry.IPoint;
import com.mapinfo.midev.geometry.IPolygon;
import com.mapinfo.midev.geometry.IRectangle;
import com.mapinfo.midev.geometry.IRing;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.impl.DirectPositionArray;
import com.mapinfo.midev.geometry.impl.Rectangle;
import com.mapinfo.midev.unit.Angle;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.unit.PaperLength;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import org.apache.commons.lang3.SerializationUtils;

public final class GeometryBLOBWriter {
    private GeometryBLOBWriter() {
    }

    public static byte[] write(IGeometry geometry) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            GeometryBLOBWriter.write(geometry, (DataOutput)dos);
            dos.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return baos.toByteArray();
    }

    private static void write(IGeometry geometry, DataOutput out) throws IOException {
        GeometryBLOBWriter.write(geometry.getSpatialInfo(), out);
        out.writeInt(geometry.getType().ordinal());
        switch (geometry.getType()) {
            case POINT: {
                GeometryBLOBWriter.write((IPoint)geometry, out);
                break;
            }
            case MULTI_POINT: {
                GeometryBLOBWriter.write(((IMultiPoint)geometry).getPositions(), out);
                break;
            }
            case MULTI_CURVE: {
                GeometryBLOBWriter.write((IMultiCurve)geometry, out);
                break;
            }
            case MULTI_POLYGON: {
                GeometryBLOBWriter.write((IMultiPolygon)geometry, out);
                break;
            }
            case MULTI_FEATURE_GEOMETRY: {
                GeometryBLOBWriter.write((IMultiFeatureGeometry)geometry, out);
                break;
            }
            case POLYGON: {
                GeometryBLOBWriter.write((IPolygon)geometry, out);
                break;
            }
            case CURVE: {
                GeometryBLOBWriter.write((ICurve)geometry, out);
                break;
            }
            case RING: {
                GeometryBLOBWriter.write((IRing)geometry, out);
                break;
            }
            case LINE_STRING: {
                GeometryBLOBWriter.write(((ICurveSegment)geometry).getControlPoints(), out);
                break;
            }
            case RECTANGLE: {
                GeometryBLOBWriter.write((IRectangle)geometry, out);
                break;
            }
            case LEGACY_TEXT: {
                GeometryBLOBWriter.write((ILegacyText)geometry, out);
                break;
            }
            case LEGACY_ARC: {
                GeometryBLOBWriter.write((ILegacyArc)geometry, out);
                break;
            }
            case ROUNDED_RECTANGLE: {
                GeometryBLOBWriter.write((ILegacyRoundedRectangle)geometry, out);
                break;
            }
            case ELLIPSE: {
                GeometryBLOBWriter.write((ILegacyEllipse)geometry, out);
                break;
            }
            default: {
                out.write(SerializationUtils.serialize((Serializable)geometry));
            }
        }
    }

    private static void write(IMultiFeatureGeometry multiFeatureGeometry, DataOutput out) throws IOException {
        out.writeInt(multiFeatureGeometry.getCount(GeometryType.POINT));
        Iterator<IFeatureGeometry> i = multiFeatureGeometry.getPointIterator();
        while (i.hasNext()) {
            GeometryBLOBWriter.write(i.next(), out);
        }
        out.writeInt(multiFeatureGeometry.getCount(GeometryType.MULTI_POINT));
        i = multiFeatureGeometry.getMultiPointIterator();
        while (i.hasNext()) {
            GeometryBLOBWriter.write(((IMultiPoint)i.next()).getPositions(), out);
        }
        out.writeInt(multiFeatureGeometry.getCount(GeometryType.MULTI_CURVE));
        i = multiFeatureGeometry.getMultiCurveIterator();
        while (i.hasNext()) {
            GeometryBLOBWriter.write((IMultiCurve)i.next(), out);
        }
        out.writeInt(multiFeatureGeometry.getCount(GeometryType.MULTI_POLYGON));
        i = multiFeatureGeometry.getMultiPolygonIterator();
        while (i.hasNext()) {
            GeometryBLOBWriter.write((IMultiPolygon)i.next(), out);
        }
    }

    private static void write(IPoint point, DataOutput out) throws IOException {
        boolean zSet = point.zSet();
        boolean mSet = point.mSet();
        out.writeBoolean(zSet);
        out.writeBoolean(mSet);
        GeometryBLOBWriter.write(point.getDirectPosition(), out, zSet, mSet);
    }

    private static void write(IMultiPolygon multiPolygon, DataOutput out) throws IOException {
        out.writeInt(multiPolygon.getPolygonCount());
        for (IPolygon polygon : multiPolygon) {
            GeometryBLOBWriter.write(polygon, out);
        }
    }

    private static void write(IPolygon polygon, DataOutput out) throws IOException {
        GeometryBLOBWriter.write(polygon.getExteriorRing(), out);
        out.writeInt(polygon.getInteriorRingCount());
        Iterator<IRing> i = polygon.getInteriorRingIterator();
        while (i.hasNext()) {
            GeometryBLOBWriter.write(i.next(), out);
        }
    }

    private static void write(IRectangle rectangle, DataOutput out) throws IOException {
        DirectPositionArray dpl = new DirectPositionArray(rectangle.getLowerLeft(), rectangle.getUpperRight());
        GeometryBLOBWriter.write(dpl, out);
    }

    private static void write(ILegacyRoundedRectangle rectangle, DataOutput out) throws IOException {
        GeometryBLOBWriter.write(rectangle.getLowerLeft(), out, false, false);
        GeometryBLOBWriter.write(rectangle.getUpperRight(), out, false, false);
        GeometryBLOBWriter.write(rectangle.getCornerRadiusX(), out);
        GeometryBLOBWriter.write(rectangle.getCornerRadiusY(), out);
    }

    private static void write(PaperLength paperLength, DataOutput out) throws IOException {
        out.writeDouble(paperLength.getValue());
        out.writeInt(paperLength.getUnit().ordinal());
    }

    private static void write(ILegacyEllipse ellipse, DataOutput out) throws IOException {
        Rectangle rectangle = new Rectangle(ellipse.getSpatialInfo(), ellipse.getLowerLeft(), ellipse.getUpperRight());
        GeometryBLOBWriter.write(rectangle, out);
    }

    private static void write(ILegacyText legacyText, DataOutput out) throws IOException {
        IRectangle rectangle = legacyText.getRectangle();
        GeometryBLOBWriter.write(rectangle, out);
        String text = legacyText.getText();
        out.writeUTF(text);
        Angle angle = legacyText.getAngle();
        if (angle != null) {
            out.writeBoolean(true);
            GeometryBLOBWriter.write(angle, out);
        } else {
            out.writeBoolean(false);
        }
        ILegacyText.TextCalloutType textCalloutType = legacyText.getTextCalloutType();
        if (textCalloutType != null) {
            out.writeBoolean(true);
            out.writeInt(textCalloutType.ordinal());
        } else {
            out.writeBoolean(false);
        }
        DirectPosition calloutTarget = legacyText.getCalloutTarget();
        if (calloutTarget != null) {
            out.writeBoolean(true);
            GeometryBLOBWriter.write(calloutTarget, out, false, false);
        } else {
            out.writeBoolean(false);
        }
    }

    private static void write(ILegacyArc legacyArc, DataOutput out) throws IOException {
        IRectangle rectangle = legacyArc.getRectangle();
        GeometryBLOBWriter.write(rectangle, out);
        GeometryBLOBWriter.write(legacyArc.getBeginAngle(), out);
        GeometryBLOBWriter.write(legacyArc.getEndAngle(), out);
    }

    private static void write(Angle angle, DataOutput out) throws IOException {
        out.writeDouble(angle.getValue());
        out.writeInt(angle.getUnit().ordinal());
    }

    private static void write(IRing ring, DataOutput out) throws IOException {
        out.writeInt(ring.getCurveSegmentCount());
        for (ICurveSegment curveSegment : ring) {
            GeometryBLOBWriter.write(curveSegment.getControlPoints(), out);
        }
    }

    private static void write(IMultiCurve multiCurve, DataOutput out) throws IOException {
        out.writeInt(multiCurve.getCurveCount());
        for (ICurve curve : multiCurve) {
            GeometryBLOBWriter.write(curve, out);
        }
    }

    private static void write(ICurve curve, DataOutput out) throws IOException {
        out.writeInt(curve.getCurveSegmentCount());
        for (ICurveSegment curveSegment : curve) {
            GeometryBLOBWriter.write(curveSegment.getControlPoints(), out);
        }
    }

    private static void write(IDirectPositionList directPositionList, DataOutput out) throws IOException {
        boolean zSet = directPositionList.zSet();
        boolean mSet = directPositionList.mSet();
        out.writeBoolean(zSet);
        out.writeBoolean(mSet);
        out.writeInt(directPositionList.size());
        IDirectPositionIterator i = directPositionList.getDirectPositionIterator();
        DirectPosition tmp = new DirectPosition();
        while (i.hasNext()) {
            i.nextDirectPosition(tmp);
            GeometryBLOBWriter.write(tmp, out, zSet, mSet);
        }
    }

    private static void write(DirectPosition dp, DataOutput out, boolean writeZ, boolean writeM) throws IOException {
        out.writeDouble(dp.getX());
        out.writeDouble(dp.getY());
        if (writeZ) {
            out.writeDouble(dp.getZ());
        }
        if (writeM) {
            if (dp.getM() != null) {
                out.writeBoolean(true);
                out.writeDouble(dp.getM().getDouble());
            } else {
                out.writeBoolean(false);
            }
        }
    }

    private static void write(SpatialInfo spatialInfo, DataOutput out) throws IOException {
        out.writeUTF(CoordSysUtilities.getSRSName((CoordSys)spatialInfo.getCoordSys()));
        LinearUnit zUnit = spatialInfo.getZUnit();
        if (zUnit != null) {
            out.writeBoolean(true);
            out.writeInt(zUnit.ordinal());
        } else {
            out.writeBoolean(false);
        }
        out.writeDouble(spatialInfo.getTolerance());
    }
}

