/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.util;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.ICurve;
import com.mapinfo.midev.geometry.ICurveSegment;
import com.mapinfo.midev.geometry.IDirectPositionIterator;
import com.mapinfo.midev.geometry.IFeatureGeometry;
import com.mapinfo.midev.geometry.IGeometry;
import com.mapinfo.midev.geometry.ILegacyArc;
import com.mapinfo.midev.geometry.ILegacyEllipse;
import com.mapinfo.midev.geometry.ILegacyRoundedRectangle;
import com.mapinfo.midev.geometry.ILegacyText;
import com.mapinfo.midev.geometry.ILineString;
import com.mapinfo.midev.geometry.IMultiCurve;
import com.mapinfo.midev.geometry.IMultiFeatureGeometry;
import com.mapinfo.midev.geometry.IMultiPoint;
import com.mapinfo.midev.geometry.IMultiPolygon;
import com.mapinfo.midev.geometry.IPoint;
import com.mapinfo.midev.geometry.IPolygon;
import com.mapinfo.midev.geometry.IRectangle;
import com.mapinfo.midev.geometry.IRing;
import com.mapinfo.midev.geometry.util.IGeometryVisitor;
import com.mapinfo.midev.geometry.util.VisitorResult;
import java.util.Iterator;

public final class GeometryVisitor {
    private GeometryVisitor() {
    }

    public static void visit(IGeometry geometry, IGeometryVisitor visitor) {
        GeometryVisitor._visit(geometry, visitor);
    }

    private static VisitorResult _visit(IGeometry geometry, IGeometryVisitor visitor) {
        switch (geometry.getType()) {
            case POINT: {
                return visitor.points(((IPoint)geometry).getDirectPosition());
            }
            case MULTI_POINT: {
                IDirectPositionIterator i = ((IMultiPoint)geometry).getDirectPositionIterator();
                DirectPosition tmp = new DirectPosition();
                while (i.hasNext()) {
                    i.nextDirectPosition(tmp);
                    if (visitor.points(tmp) != VisitorResult.STOP) continue;
                    return VisitorResult.STOP;
                }
                return VisitorResult.CONTINUE;
            }
            case MULTI_CURVE: {
                for (ICurve curve : (IMultiCurve)geometry) {
                    if (GeometryVisitor._visit(curve, visitor) != VisitorResult.STOP) continue;
                    return VisitorResult.STOP;
                }
                return VisitorResult.CONTINUE;
            }
            case MULTI_POLYGON: {
                for (IPolygon polygon : (IMultiPolygon)geometry) {
                    if (GeometryVisitor._visit(polygon, visitor) != VisitorResult.STOP) continue;
                    return VisitorResult.STOP;
                }
                return VisitorResult.CONTINUE;
            }
            case MULTI_FEATURE_GEOMETRY: {
                for (IFeatureGeometry fg : (IMultiFeatureGeometry)geometry) {
                    if (GeometryVisitor._visit(fg, visitor) != VisitorResult.STOP) continue;
                    return VisitorResult.STOP;
                }
                return VisitorResult.CONTINUE;
            }
            case RECTANGLE: {
                if (GeometryVisitor._visit(((IRectangle)geometry).asMultiPolygon(), visitor) == VisitorResult.STOP) {
                    return VisitorResult.STOP;
                }
                return VisitorResult.CONTINUE;
            }
            case ROUNDED_RECTANGLE: {
                if (GeometryVisitor._visit(((ILegacyRoundedRectangle)geometry).asMultiPolygon(), visitor) == VisitorResult.STOP) {
                    return VisitorResult.STOP;
                }
                return VisitorResult.CONTINUE;
            }
            case ELLIPSE: {
                if (GeometryVisitor._visit(((ILegacyEllipse)geometry).asMultiPolygon(), visitor) == VisitorResult.STOP) {
                    return VisitorResult.STOP;
                }
                return VisitorResult.CONTINUE;
            }
            case LEGACY_ARC: {
                if (GeometryVisitor._visit(((ILegacyArc)geometry).asLineString(), visitor) == VisitorResult.STOP) {
                    return VisitorResult.STOP;
                }
                return VisitorResult.CONTINUE;
            }
            case POLYGON: {
                IPolygon polygon = (IPolygon)geometry;
                if (GeometryVisitor._visit(polygon.getExteriorRing(), visitor) == VisitorResult.STOP) {
                    return VisitorResult.STOP;
                }
                Iterator<IRing> ringIterator = polygon.getInteriorRingIterator();
                while (ringIterator.hasNext()) {
                    if (GeometryVisitor._visit(ringIterator.next(), visitor) != VisitorResult.STOP) continue;
                    return VisitorResult.STOP;
                }
                return VisitorResult.CONTINUE;
            }
            case CURVE: {
                for (ICurveSegment cs : (ICurve)geometry) {
                    if (visitor.edges(cs.getControlPoints()) != VisitorResult.STOP) continue;
                    return VisitorResult.STOP;
                }
                return VisitorResult.CONTINUE;
            }
            case RING: {
                for (ICurveSegment cs : (IRing)geometry) {
                    if (visitor.edges(cs.getControlPoints()) != VisitorResult.STOP) continue;
                    return VisitorResult.STOP;
                }
                return VisitorResult.CONTINUE;
            }
            case LINE_STRING: {
                if (visitor.edges(((ILineString)geometry).getControlPoints()) == VisitorResult.STOP) {
                    return VisitorResult.STOP;
                }
                return VisitorResult.CONTINUE;
            }
            case LEGACY_TEXT: {
                if (visitor.points(((ILegacyText)geometry).getRepresentativePoint()) == VisitorResult.STOP) {
                    return VisitorResult.STOP;
                }
                return VisitorResult.CONTINUE;
            }
        }
        throw new UnsupportedOperationException();
    }
}

