/*
 * Decompiled with CFR 0.152.
 */
package com.pb.spectrum.gav.engine;

import com.pb.addressing.CandidateCase;
import com.pb.addressing.ExceptionCode;
import com.pb.addressing.ValidateAddress;
import com.pb.addressing.ValidationException;
import com.pb.addressing.api.Address;
import com.pb.addressing.api.AddressValidator;
import com.pb.addressing.api.ICandidateCase;
import com.pb.addressing.api.MatchFields;
import com.pb.addressing.api.MatchMode;
import com.pb.addressing.api.Preferences;
import com.pb.addressing.api.ResponseAPI;
import com.pb.addressing.api.StandardMatchMode;
import com.pb.addressing.api.ValidatedCandidate;
import com.pb.addressing.api.ValidationLevel;
import com.pb.addressing.api.ValidationMatchFields;
import com.pb.addressing.api.ValidationPreferences;
import com.pb.addressing.util.ValidationUtils;
import com.pb.spectrum.gav.data.AddressConfigurationOptions;
import com.pb.spectrum.gav.data.GAVException;
import com.pb.spectrum.gav.data.InputAddress;
import com.pb.spectrum.gav.data.Options;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GavEngine {
    public static final String MULTI_MATCH_COUNT = "MultimatchCount";
    private static final Log log = LogFactory.getLog(GavEngine.class);
    private HashMap<String, List<String>> countryLicenseMap = new HashMap();
    private HashMap<String, Date> expirationInfoMap = new HashMap();
    private AddressValidator gavAddressApi;
    private Preferences preferences;
    private String homeCountry;

    public GavEngine(HashMap<String, List<String>> dataDictionaryMap) {
        try {
            this.gavAddressApi = new AddressValidator(dataDictionaryMap);
            this.initializeLicenseList();
            this.initializeExpirationInfo();
        }
        catch (ValidationException | GAVException e) {
            e.printStackTrace();
        }
    }

    public HashMap<String, Object> cleanup(boolean b) throws GAVException {
        try {
            return this.gavAddressApi.cleanup(b);
        }
        catch (ValidationException e) {
            ExceptionCode exceptionCode = e.getFaultInfo();
            throw new GAVException(e.getMessage(), exceptionCode.toString(), e.getCause());
        }
    }

    public ArrayList<Map<String, Object>> validateAddress(HashMap<String, String> inputAddress, HashMap<String, String> optionAddress) throws GAVException {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        if (inputAddress.get(InputAddress.COUNTRY.getValue()) == null || inputAddress.get(InputAddress.COUNTRY.getValue()).isEmpty()) {
            inputAddress.put(InputAddress.COUNTRY.getValue(), optionAddress.get(Options.HOME_COUNTRY.getValue()));
        }
        long startTime = System.currentTimeMillis();
        try {
            ResponseAPI responseMap = this.gavAddressApi.validate((Address)this.getAddress(inputAddress), ValidationLevel.ADDRESS, this.getPreferences(optionAddress));
            List validatedCandidates = responseMap.getCandidates();
            for (ValidatedCandidate validatedCandidate : validatedCandidates) {
                HashMap<String, String> responseCandidate = new HashMap<String, String>();
                responseCandidate.put(MULTI_MATCH_COUNT, String.valueOf(responseMap.getMultimatchCount()));
                responseCandidate.putAll(validatedCandidate.getCandidateMap());
                if (this.ifOptionChecked(optionAddress.get(Options.RETURN_INPUT_ADDRESS.getValue()))) {
                    responseCandidate.putAll(responseMap.getInputAddress());
                }
                if (this.ifOptionChecked(optionAddress.get(Options.RETURN_PARSED_ADDRESS.getValue()))) {
                    responseCandidate.putAll(responseMap.getParsedInput());
                }
                resultList.add(responseCandidate);
            }
        }
        catch (ValidationException e) {
            ExceptionCode exceptionCode = e.getFaultInfo();
            throw new GAVException(e.getMessage(), exceptionCode.toString(), e.getCause());
        }
        long endTime = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Time taken by Validation API :: " + (endTime - startTime)));
        }
        return resultList;
    }

    public ArrayList<Map<String, Object>> validateAddress(HashMap<String, String> inputAddress) throws GAVException {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        if (inputAddress.get(InputAddress.COUNTRY.getValue()) == null) {
            inputAddress.put(InputAddress.COUNTRY.getValue(), this.homeCountry);
        }
        try {
            ResponseAPI responseMap = this.gavAddressApi.validate((Address)this.getAddress(inputAddress), ValidationLevel.ADDRESS, this.preferences);
            List validatedCandidates = responseMap.getCandidates();
            for (ValidatedCandidate validatedCandidate : validatedCandidates) {
                HashMap<String, String> responseCandidate = new HashMap<String, String>();
                responseCandidate.put(MULTI_MATCH_COUNT, String.valueOf(responseMap.getMultimatchCount()));
                responseCandidate.putAll(validatedCandidate.getCandidateMap());
                responseCandidate.putAll(responseMap.getInputAddress());
                responseCandidate.putAll(responseMap.getParsedInput());
                resultList.add(responseCandidate);
            }
        }
        catch (ValidationException e) {
            ExceptionCode exceptionCode = e.getFaultInfo();
            throw new GAVException(e.getMessage(), exceptionCode.toString(), e.getCause());
        }
        return resultList;
    }

    public void setPreferences(AddressConfigurationOptions optionAddress) {
        if (optionAddress != null) {
            this.homeCountry = optionAddress.getDefaultCountry();
            this.preferences = this.getPreferences(this.mapGavOptions(optionAddress));
        }
    }

    private HashMap<String, String> mapGavOptions(AddressConfigurationOptions optionSetter) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(Options.HOME_COUNTRY.getValue(), this.homeCountry);
        options.put(Options.CASING_OPTION.getValue(), optionSetter.getCasing());
        options.put(Options.RETURN_PARSED_ADDRESS.getValue(), Boolean.toString(optionSetter.isReturnParsedAddress()));
        options.put(Options.RETURN_INPUT_ADDRESS.getValue(), Boolean.toString(optionSetter.isReturnInputAddress()));
        options.put(Options.CITY_FALLBACK.getValue(), Boolean.toString(optionSetter.isCityFallback()));
        options.put(Options.POSTAL_FALLBACK.getValue(), Boolean.toString(optionSetter.isPostalFallback()));
        options.put(Options.MAXIMUM_RESULTS.getValue(), Integer.toString(optionSetter.getMaximumResults()));
        options.put(Options.RETURN_PRECISION_CODE.getValue(), Boolean.toString(optionSetter.isReturnPrecisionCode()));
        options.put(Options.RETURN_COUNTRY_SPECIFIC_FIELDS.getValue(), Boolean.toString(optionSetter.isReturnCountrySpecificFields()));
        options.put(Options.PREFER_POSTALCODE_OVER_CITY.getValue(), Boolean.toString(optionSetter.isPreferPostalOverCity()));
        options.put(Options.MATCH_MODE.getValue(), optionSetter.getMatchMode());
        if (null != optionSetter.getMatchMode()) {
            options.put(Options.MUSTMATCH_ADDRESSNUMBER.getValue(), Boolean.toString(optionSetter.isMustMatchAddressNumber()));
            options.put(Options.MUSTMATCH_STREET.getValue(), Boolean.toString(optionSetter.isMustMatchStreet()));
            options.put(Options.MUSTMATCH_CITY.getValue(), Boolean.toString(optionSetter.isMustMatchCity()));
            options.put(Options.MUSTMATCH_LOCALITY.getValue(), Boolean.toString(optionSetter.isMustMatchLocality()));
            options.put(Options.MUSTMATCH_STATE.getValue(), Boolean.toString(optionSetter.isMustMatchState()));
            options.put(Options.MUSTMATCH_STATEPROVINCE.getValue(), Boolean.toString(optionSetter.isMustMatchStateProvince()));
            options.put(Options.MUSTMATCH_POSTALCODE.getValue(), Boolean.toString(optionSetter.isMustMatchPostCode()));
        }
        return options;
    }

    private ValidateAddress getAddress(Map<String, String> inputAddress) {
        ValidateAddress address = new ValidateAddress();
        address.setAddressLine1(inputAddress.get(InputAddress.MAIN_ADDRESS_LINE.getValue()));
        address.setAddressLine2(inputAddress.get(InputAddress.ADDRESS_LINE_2.getValue()));
        address.setFirmName(inputAddress.get(InputAddress.PLACE_NAME.getValue()));
        address.setLastLine(inputAddress.get(InputAddress.ADDRESS_LASTLINE.getValue()));
        address.setStateProvince(inputAddress.get(InputAddress.STATE_PROVINCE.getValue()));
        address.setStateProvinceSubdivision(inputAddress.get(InputAddress.STATE_PROVINCE_SUBDIVISION.getValue()));
        address.setCity(inputAddress.get(InputAddress.CITY.getValue()));
        address.setCitySubdivision(inputAddress.get(InputAddress.CITY_SUBDIVISION.getValue()));
        address.setPostalCode(inputAddress.get(InputAddress.POSTCODE.getValue()));
        address.setCountry(inputAddress.get(InputAddress.COUNTRY.getValue()));
        address.setAddressLine3(inputAddress.get(InputAddress.ADDRESS_LINE_3.getValue()));
        address.setAddressLine4(inputAddress.get(InputAddress.ADDRESS_LINE_4.getValue()));
        address.setAddressLine5(inputAddress.get(InputAddress.ADDRESS_LINE_5.getValue()));
        address.setAddressLine6(inputAddress.get(InputAddress.ADDRESS_LINE_6.getValue()));
        return address;
    }

    private String convertToOnOff(Object option) {
        if (option == null) {
            return "OFF";
        }
        if (option.equals("Y")) {
            return "ON";
        }
        return "OFF";
    }

    private Preferences getPreferences(Map<String, String> optionsAddress) {
        ValidationPreferences preferences = new ValidationPreferences();
        if (optionsAddress.get(Options.MATCH_MODE.getValue()).equals("Relaxed") && !optionsAddress.get(Options.MAXIMUM_RESULTS.getValue()).equals(1)) {
            preferences.setMaxReturnedCandidates(Integer.parseInt(optionsAddress.get(Options.MAXIMUM_RESULTS.getValue())));
        } else {
            preferences.setMaxReturnedCandidates(1);
        }
        preferences.setMaxReturnedRangeUnits(1);
        preferences.setMaxReturnedRanges(1);
        preferences.setPreferPostCodeOverCity(this.ifOptionChecked(optionsAddress.get(Options.PREFER_POSTALCODE_OVER_CITY.getValue())));
        preferences.setMatchMode((MatchMode)this.getMatchMode(optionsAddress, (Preferences)preferences));
        if (optionsAddress.get(Options.HOME_COUNTRY.getValue()).equals("World") || optionsAddress.get(Options.HOME_COUNTRY.getValue()).equals("XWG")) {
            preferences.setFallbackToGeographic(true);
            preferences.setFallbackToPostal(true);
        } else {
            preferences.setFallbackToGeographic(this.ifOptionChecked(optionsAddress.get(Options.CITY_FALLBACK.getValue())));
            preferences.setFallbackToPostal(this.ifOptionChecked(optionsAddress.get(Options.POSTAL_FALLBACK.getValue())));
        }
        preferences.setFallBackToWorld(true);
        if (optionsAddress.get(Options.CASING_OPTION.getValue()) != null) {
            switch (optionsAddress.get(Options.CASING_OPTION.getValue())) {
                case "Mixed": {
                    preferences.setCasing((ICandidateCase)CandidateCase.MIXED);
                    break;
                }
                case "Lower": {
                    preferences.setCasing((ICandidateCase)CandidateCase.LOWER);
                    break;
                }
                case "Upper": {
                    preferences.setCasing((ICandidateCase)CandidateCase.UPPER);
                    break;
                }
                default: {
                    preferences.setCasing((ICandidateCase)CandidateCase.MIXED);
                }
            }
        }
        preferences.setReturnCountrySpecificFields(this.ifOptionChecked(optionsAddress.get(Options.RETURN_COUNTRY_SPECIFIC_FIELDS.getValue())));
        preferences.setReturnUnitInfo(true);
        preferences.setReturnInputAddress(this.ifOptionChecked(optionsAddress.get(Options.RETURN_INPUT_ADDRESS.getValue())));
        preferences.setReturnPasedInputAddress(this.ifOptionChecked(optionsAddress.get(Options.RETURN_PARSED_ADDRESS.getValue())));
        preferences.setReturnPrecisionCode(this.ifOptionChecked(optionsAddress.get(Options.RETURN_PRECISION_CODE.getValue())));
        preferences.setPreferPOBoxOverStreet(this.ifOptionChecked(optionsAddress.get(Options.PREFER_POBOX_OVER_STREET.getValue())));
        preferences.setAll_Street_Matching(this.convertToOnOff(optionsAddress.get("All_Street_Matching")));
        preferences.setAssign_Abbr_City(this.convertToOnOff(optionsAddress.get("Assign_Abbr_City")));
        preferences.setAssign_LOT(this.convertToOnOff(optionsAddress.get("Assign_LOT")));
        preferences.setCASS_FLAG(this.convertToOnOff(optionsAddress.get("CASS_Flag")));
        preferences.setConvert_Sec_To_PMB(this.convertToOnOff(optionsAddress.get("Convert_Sec_To_PMB")));
        preferences.setDPV(this.convertToOnOff(optionsAddress.get("DPV_")));
        preferences.setDPV_CMRA(this.convertToOnOff(optionsAddress.get("DPV_CMRA")));
        preferences.setDPV_DNA(this.convertToOnOff(optionsAddress.get("DPV_DNA")));
        preferences.setDPV_Indicator(optionsAddress.get("DPV_Indicator"));
        preferences.setDPV_NDD(this.convertToOnOff(optionsAddress.get("DPV_NDD")));
        preferences.setDPV_NSL(this.convertToOnOff(optionsAddress.get("DPV_NSL")));
        preferences.setDPV_No_Stat(this.convertToOnOff(optionsAddress.get("DPV_No_Stat")));
        preferences.setDPV_PBSA(this.convertToOnOff(optionsAddress.get("DPV_PBSA")));
        preferences.setDPV_Throwback(this.convertToOnOff(optionsAddress.get("DPV_Throwback")));
        preferences.setDPV_Tie_Break(this.convertToOnOff(optionsAddress.get("DPV_Tie_Break")));
        preferences.setDPV_Vacant(this.convertToOnOff(optionsAddress.get("DPV_Vacant")));
        preferences.setDual_Address(optionsAddress.get("Dual_Address"));
        preferences.setEarly_Warning_System(this.convertToOnOff(optionsAddress.get("Early_Warning_System")));
        preferences.setLACSLink_Indicator(this.convertToOnOff(optionsAddress.get("LACSLink_Indicator")));
        preferences.setLog_Level(optionsAddress.get("Log_Level"));
        preferences.setMailerAddress(optionsAddress.get("MailerAddress"));
        preferences.setMailerAddress2(optionsAddress.get("MailerAddress2"));
        preferences.setMailerAddress3(optionsAddress.get("MailerAddress3"));
        preferences.setMailerAddress4(optionsAddress.get("MailerAddress4"));
        preferences.setMailerCityLine(optionsAddress.get("MailerCityLine"));
        preferences.setMailerName(optionsAddress.get("MailerName"));
        preferences.setProcessing(optionsAddress.get("Processing Mode"));
        preferences.setR777_Deliverable(this.convertToOnOff(optionsAddress.get("R777_Deliverable")));
        preferences.setRemove_Noise_Chars(this.convertToOnOff(optionsAddress.get("Remove_Noise_Chars")));
        preferences.setResidential_Delivery_Indicator(this.convertToOnOff(optionsAddress.get("Residential_Delivery_Indicator")));
        preferences.setReturn_Alias_Street(optionsAddress.get("Return_Alias_Street"));
        preferences.setReturn_Input_Firm(this.convertToOnOff(optionsAddress.get("Return_Input_Firm")));
        preferences.setReturn_SLK_Secondary(this.convertToOnOff(optionsAddress.get("Return_SLK_Secondary")));
        preferences.setStandAlonePMB(this.convertToOnOff(optionsAddress.get("StandAlonePMB")));
        preferences.setStandAloneUnit(this.convertToOnOff(optionsAddress.get("StandAloneUnit")));
        preferences.setSuiteLink_Indicator(this.convertToOnOff(optionsAddress.get("SuiteLink_Indicator")));
        preferences.setVM_Datablock(this.convertToOnOff(optionsAddress.get("VM_Datablock")));
        preferences.setdataBlocks(this.convertToOnOff(optionsAddress.get("dataBlocks")));
        preferences.setreturn3553Data(this.convertToOnOff(optionsAddress.get("return3553Data")));
        preferences.setreturnAdsInfo(this.convertToOnOff(optionsAddress.get("returnAdsInfo")));
        preferences.setreturnAlternate(this.convertToOnOff(optionsAddress.get("returnAlternate")));
        preferences.setreturnRunStatistics(this.convertToOnOff(optionsAddress.get("returnRunStatistics")));
        preferences.setreturnSetupInfo(this.convertToOnOff(optionsAddress.get("returnSetupInfo")));
        preferences.setReturnLine1(this.getSecureData(optionsAddress.get("ReturnLine1")));
        preferences.setReturnLine2(this.getSecureData(optionsAddress.get("ReturnLine2")));
        preferences.setSpecialOption(this.getSecureData(optionsAddress.get("SpecialOption")));
        preferences.setPreventPound(this.getSecureData(optionsAddress.get("PreventPound")));
        preferences.setPreventPeriod(this.getSecureData(optionsAddress.get("PreventPeriod")));
        preferences.setPreventDangling(this.getSecureData(optionsAddress.get("PreventDangling")));
        preferences.setSkipMerge(this.getSecureData(optionsAddress.get("SkipMerge")));
        preferences.setSkipFirm(this.getSecureData(optionsAddress.get("SkipFirm")));
        preferences.setSkipURB(this.getSecureData(optionsAddress.get("SkipURB")));
        preferences.setSkipCityState(this.getSecureData(optionsAddress.get("SkipCityState")));
        preferences.setReturnLineOrder(this.getSecureData(optionsAddress.get("ReturnLineOrder")));
        return preferences;
    }

    private String getSecureData(String dat) {
        if (dat == null) {
            return "";
        }
        return dat;
    }

    private boolean ifOptionChecked(String opt) {
        return "Y".equalsIgnoreCase(opt);
    }

    private StandardMatchMode getMatchMode(Map<String, String> optionAddress, Preferences preferences) {
        if (optionAddress.get(Options.MATCH_MODE.getValue()).equals("Standard")) {
            return StandardMatchMode.STANDARD;
        }
        if (optionAddress.get(Options.MATCH_MODE.getValue()).equals("Exact")) {
            return StandardMatchMode.EXACT;
        }
        if (optionAddress.get(Options.MATCH_MODE.getValue()).equals("Relaxed")) {
            return StandardMatchMode.RELAXED;
        }
        if (optionAddress.get(Options.MATCH_MODE.getValue()).equals("Custom")) {
            this.getMustMatchFields(optionAddress, preferences);
            return StandardMatchMode.CUSTOM;
        }
        return StandardMatchMode.EXACT;
    }

    private void getMustMatchFields(Map<String, String> optionAddress, Preferences preferences) {
        ValidationMatchFields fieldsMatching = new ValidationMatchFields();
        if (null != optionAddress.get(Options.MATCH_MODE.getValue())) {
            if (this.ifOptionChecked(optionAddress.get(Options.MUSTMATCH_ADDRESSNUMBER.getValue()))) {
                fieldsMatching.setMatchOnHouseNumber(true);
            }
            if (this.ifOptionChecked(optionAddress.get(Options.MUSTMATCH_STREET.getValue()))) {
                fieldsMatching.setMatchOnStreetName(true);
            }
            if (this.ifOptionChecked(optionAddress.get(Options.MUSTMATCH_CITY.getValue()))) {
                fieldsMatching.setMatchOnCity(true);
            }
            if (this.ifOptionChecked(optionAddress.get(Options.MUSTMATCH_LOCALITY.getValue()))) {
                fieldsMatching.setMatchOnCitySubdivision(true);
            }
            if (this.ifOptionChecked(optionAddress.get(Options.MUSTMATCH_STATE.getValue()))) {
                fieldsMatching.setMatchOnStateProvince(true);
            }
            if (this.ifOptionChecked(optionAddress.get(Options.MUSTMATCH_STATEPROVINCE.getValue()))) {
                fieldsMatching.setMatchOnStateProvinceSubdivision(true);
            }
            if (this.ifOptionChecked(optionAddress.get(Options.MUSTMATCH_POSTALCODE.getValue()))) {
                fieldsMatching.setMatchOnPostalCode(true);
            }
        }
        preferences.setMustMatchFields((MatchFields)fieldsMatching);
    }

    public Map<String, Set<String>> getVersion() throws GAVException {
        Map versionInformation = null;
        try {
            if (this.gavAddressApi.getVersionInformation() != null) {
                versionInformation = this.gavAddressApi.getVersionInformation();
            }
        }
        catch (ValidationException validationException) {
            validationException.printStackTrace();
        }
        return versionInformation;
    }

    public HashMap<String, Date> getGAMExpirationInfo() {
        return this.expirationInfoMap;
    }

    public HashMap<String, List<String>> getCountryLicenseList() {
        return this.countryLicenseMap;
    }

    public ArrayList<String> getGAVConfiguredCountries() {
        ArrayList gavConfiguredCountries = null;
        try {
            gavConfiguredCountries = (ArrayList)this.gavAddressApi.getConfiguredCountries();
        }
        catch (ValidationException validationException) {
            validationException.printStackTrace();
        }
        return gavConfiguredCountries;
    }

    private void initializeExpirationInfo() throws GAVException {
        try {
            this.expirationInfoMap = this.gavAddressApi.getExpirationInfo();
        }
        catch (ValidationException e) {
            ExceptionCode exceptionCode = e.getFaultInfo();
            throw new GAVException(e.getMessage(), exceptionCode.toString(), e.getCause());
        }
    }

    private HashMap<String, List<String>> initializeLicenseList() {
        try {
            this.countryLicenseMap = this.gavAddressApi.getLicenseMap();
        }
        catch (ValidationException | IOException e) {
            e.printStackTrace();
        }
        return this.countryLicenseMap;
    }

    private static boolean isValidDataDirectory(File file, String fileName) {
        File file1 = new File(file.getAbsolutePath() + "/" + fileName);
        boolean isthere = false;
        if (file1.exists()) {
            isthere = true;
        }
        return isthere;
    }

    public String getValidCountry(String inputCountry, boolean flag) {
        if (flag) {
            return ValidationUtils.getFullCountryName((String)inputCountry);
        }
        return ValidationUtils.getISO3Country((String)inputCountry);
    }

    public ArrayList<Map<String, Object>> dbLookup(HashMap<String, String> optionsMap, HashMap<String, String> inputAddress) throws GAVException {
        Object responseMap = null;
        ArrayList resultList = new ArrayList();
        try {
            resultList = this.gavAddressApi.dbLookup(optionsMap, inputAddress);
        }
        catch (ValidationException e) {
            ExceptionCode exceptionCode = e.getFaultInfo();
            throw new GAVException(e.getMessage(), exceptionCode.toString(), e.getCause());
        }
        return resultList;
    }
}

