/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.ARG.matcher;

import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.MatchingOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.address.PostCode;
import com.mapinfo.mapmarker.cgge.address.ScoringItem;
import com.mapinfo.mapmarker.cgge.matcher.CGGEMatcher1;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import java.util.List;
import java.util.Map;

public class ARGMatcher
extends CGGEMatcher1 {
    @Override
    protected FieldScore scorePostCode(ScoringItem addr, ParsedAddress parsedAddr, Map<FieldType, FieldScore> currentScores, MatchingOptions matchingOptions, ICGGEScorer scorer) {
        FieldScore score = super.scorePostCode(addr, parsedAddr, currentScores, matchingOptions, scorer);
        AddressWord[] parsedPC = (AddressWord[])parsedAddr.getField(FieldType.POST_CODE_FIELD_TYPE);
        InternalFieldValue candPostcode = (InternalFieldValue)addr.getField(FieldType.POST_CODE_FIELD_TYPE);
        List<PostCode> probablePCList = parsedAddr.getProbablePostcodes();
        int probableCount = probablePCList == null ? 0 : probablePCList.size();
        AddressWord pcWord = null;
        if (candPostcode != null) {
            pcWord = ((AddressWord[])candPostcode.getFieldValue())[0];
        }
        if (pcWord != null && score.m_value == 0.0) {
            if (parsedPC == null) {
                for (int i = 0; i < probableCount; ++i) {
                    PostCode probablePC = probablePCList.get(i);
                    AddressWord[] probablePCWords = probablePC.getWords();
                    if (probablePCWords == null || probablePCWords.length != 1) continue;
                    this.setPCScore(score, probablePCWords[0], pcWord);
                }
            } else if (parsedPC.length == 1) {
                this.setPCScore(score, parsedPC[0], pcWord);
            }
        }
        return score;
    }

    private void setPCScore(FieldScore score, AddressWord inputPC, AddressWord candPC) {
        if (candPC.getWord().contains(inputPC.getWord())) {
            score.m_value = 1.0;
            score.m_matched = true;
        }
    }

    @Override
    public boolean calculateCloseMatch(InternalScoringAddress scoringAddr, ParsedAddress parsedAddr, GeocodeOptions options, MatchingOptions matchOptions) throws CGGEInternalException {
        FieldScore score;
        boolean isCloseMatch = super.calculateCloseMatch(scoringAddr, parsedAddr, options, matchOptions);
        if (isCloseMatch && (score = scoringAddr.getFieldScore(FieldType.POST_CODE_FIELD_TYPE)) != null && score.m_value == 1.0) {
            double combinedScore = scoringAddr.getCombinedScore();
            if (combinedScore < 1.0) {
                combinedScore += 1.0E-4;
            }
            scoringAddr.setCombinedScore(combinedScore);
        }
        return isCloseMatch;
    }
}

