/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUT.matcher;

import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.CGGERuntimeException;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.MatchingOptions;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.matcher.CGGEMatcher1;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import java.util.List;

public class AUT_Matcher
extends CGGEMatcher1 {
    @Override
    public void scoreStreetFields(InternalScoringAddress scoringAddr, ParsedAddress pAddr, MatchingOptions matchingOptions, ICGGEScorer scorer) {
        super.scoreStreetFields(scoringAddr, pAddr, matchingOptions, scorer);
        if ("ISRURAL".equalsIgnoreCase((String)pAddr.getInputAddress().getField(FieldType.GENERIC_FIELD_4_FIELD_TYPE))) {
            InternalFieldValue streetName = (InternalFieldValue)scoringAddr.getField(FieldType.STREET_NAME_FIELD_TYPE);
            InternalFieldValue areaName4 = (InternalFieldValue)scoringAddr.getField(FieldType.AREA_NAME_4_FIELD_TYPE);
            InternalFieldValue areaName3 = (InternalFieldValue)scoringAddr.getField(FieldType.AREA_NAME_3_FIELD_TYPE);
            if (null != streetName) {
                boolean demoteStreet = true;
                if (null != areaName4 && streetName.toString().equalsIgnoreCase(areaName4.toString())) {
                    demoteStreet = false;
                }
                if (null != areaName3 && streetName.toString().equalsIgnoreCase(areaName3.toString())) {
                    demoteStreet = false;
                }
                if (demoteStreet) {
                    this.demoteStreetScore(scoringAddr);
                }
            }
        }
    }

    private void demoteStreetScore(InternalScoringAddress scoringAddr) {
        FieldScore streetnameScore = scoringAddr.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
        if (streetnameScore != null) {
            streetnameScore.m_value = 0.01;
            scoringAddr.setFieldScore(FieldType.STREET_NAME_FIELD_TYPE, streetnameScore);
        }
    }

    @Override
    public int matchAndOrderCandidates(ParsedAddress parsedAddress, InternalCandidateList candList, GeocodeOptions options, IDataManager dataManager) throws CGGERuntimeException, CGGEInternalException {
        InternalScoringAddress best;
        FieldScore addressNumScore;
        int closeMatchCount = super.matchAndOrderCandidates(parsedAddress, candList, options, dataManager);
        if (closeMatchCount > 1 && (addressNumScore = (best = candList.getIndexedCandidate(0)).getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE)) != null && !addressNumScore.m_matched) {
            for (int i = 1; i < closeMatchCount; ++i) {
                InternalScoringAddress other = candList.getIndexedCandidate(i);
                FieldScore otherAddressNumScore = other.getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
                if (otherAddressNumScore == null || !otherAddressNumScore.m_matched || !this.isBetterIgnoringAreaName4(best, other)) continue;
                List<InternalScoringAddress> l = candList.getCandidateList();
                l.remove(i);
                l.add(0, other);
                break;
            }
        }
        return closeMatchCount;
    }

    public boolean isBetterIgnoringAreaName4(InternalScoringAddress best, InternalScoringAddress other) {
        FieldType[] fields;
        FieldScore bestAreaName4 = best.getFieldScore(FieldType.AREA_NAME_4_FIELD_TYPE);
        FieldScore otherAreaName4 = other.getFieldScore(FieldType.AREA_NAME_4_FIELD_TYPE);
        if (bestAreaName4 == null) {
            return false;
        }
        if (otherAreaName4 != null && bestAreaName4.m_value < otherAreaName4.m_value) {
            return false;
        }
        for (FieldType field : fields = new FieldType[]{FieldType.STREET_NAME_FIELD_TYPE, FieldType.AREA_NAME_1_FIELD_TYPE, FieldType.AREA_NAME_2_FIELD_TYPE, FieldType.AREA_NAME_3_FIELD_TYPE, FieldType.POST_CODE_FIELD_TYPE, FieldType.POST_DIRECTIONAL_FIELD_TYPE, FieldType.POST_THOROUGHFARE_FIELD_TYPE, FieldType.PRE_DIRECTIONAL_FIELD_TYPE, FieldType.PRE_THOROUGHFARE_FIELD_TYPE}) {
            if (this.scoresAlign(field, best, other)) continue;
            return false;
        }
        return true;
    }

    public boolean scoresAlign(FieldType field, InternalScoringAddress best, InternalScoringAddress other) {
        FieldScore bestScore = best.getFieldScore(field);
        FieldScore otherScore = other.getFieldScore(field);
        if (bestScore == null && otherScore == null) {
            return true;
        }
        if (bestScore == null || otherScore == null) {
            return false;
        }
        return !(bestScore.m_value < otherScore.m_value);
    }

    @Override
    public void mergeCandidates(InternalCandidateList candList1, InternalCandidateList candList2) {
        InternalScoringAddress best;
        FieldScore bestAddressNumScore;
        boolean bBothHadContents = candList1.hasCandidates() && candList2.hasCandidates();
        super.mergeCandidates(candList1, candList2);
        if (bBothHadContents && candList1.hasCloseCandidates() && (bestAddressNumScore = (best = candList1.getIndexedCandidate(0)).getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE)) != null && !bestAddressNumScore.m_matched) {
            for (int i = 1; i < candList1.getNumberOfCloseMatches(); ++i) {
                InternalScoringAddress other = candList1.getIndexedCandidate(i);
                FieldScore otherAddressNumScore = other.getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
                if (otherAddressNumScore == null || !otherAddressNumScore.m_matched || !this.isBetterIgnoringAreaName4(best, other)) continue;
                List<InternalScoringAddress> l = candList1.getCandidateList();
                l.remove(i);
                l.add(0, other);
                break;
            }
        }
    }
}

