/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.BRA;

import com.mapinfo.mapmarker.BRA.BRA_Address;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.user.InputAddress;
import com.mapinfo.mapmarker.utils.ISO3166;
import java.util.Map;

public final class BRA_UserInputAddress
implements InputAddress,
BRA_Address {
    private String m_postAddress = null;
    private String m_preAddress = null;
    private String m_addressNumber = null;
    private String m_postCode1 = null;
    private String m_postCode2 = null;
    private String m_mainAddress = null;
    private String m_areaName1 = null;
    private String m_areaName2 = null;
    private String m_areaName3 = null;
    private String m_areaName4 = null;
    private String m_genericField1 = null;
    private String m_genericField2 = null;
    private String m_genericField3 = null;
    private String m_genericField4 = null;
    private String m_placeName = null;
    private String m_postDirectional = null;
    private String m_postThoroughfareType = null;
    private String m_preDirectional = null;
    private String m_preThoroughfareType = null;
    private String m_unitType = null;
    private String m_unitValue = null;
    private String m_CountryString = null;
    private ISO3166 m_Country = null;
    private Map m_additionalFields = null;

    public BRA_UserInputAddress(String housenumber, String street, String postcode, String town, String state, String shortState, String postaddress) {
        this.setCountry("BRA");
        this.setPostAddress(postaddress);
        this.setHouseNumber(housenumber);
        this.setTown(town);
        this.setPostcode(postcode);
        this.setStreet(street);
        this.setState(state);
        this.setShortProvince(shortState);
    }

    public BRA_UserInputAddress() {
        this(null, null, null, null, null, null, null);
    }

    public void setShortProvince(String shortprovince) {
        this.m_genericField1 = shortprovince;
    }

    public String getShortState() {
        return this.m_genericField1;
    }

    @Override
    public void setPostAddress(String postaddress) {
        this.m_postAddress = postaddress;
    }

    public void setPreAddress(String preaddress) {
        this.m_preAddress = preaddress;
    }

    @Override
    public void setPlaceName(String placeName) {
        this.m_placeName = placeName;
    }

    @Override
    public String getPlaceName() {
        return this.m_placeName;
    }

    public void setLocality(String areaName4) {
        this.m_areaName4 = areaName4;
    }

    @Override
    public String getLocality() {
        return this.m_areaName4;
    }

    @Override
    public String getPostAddress() {
        return this.m_postAddress;
    }

    @Override
    public void setHouseNumber(String housenumber) {
        this.m_addressNumber = housenumber;
    }

    @Override
    public String getHouseNumber() {
        return this.m_addressNumber;
    }

    @Override
    public void setTown(String town) {
        this.m_areaName3 = town;
    }

    @Override
    public String getTown() {
        return this.m_areaName3;
    }

    @Override
    public void setPostcode(String postcode) {
        this.m_postCode1 = postcode;
    }

    @Override
    public String getPostcode() {
        return this.m_postCode1;
    }

    @Override
    public void setStreet(String street) {
        this.m_mainAddress = street;
    }

    @Override
    public String getStreet() {
        return this.m_mainAddress;
    }

    public void setState(String state) {
        this.m_areaName1 = state;
    }

    @Override
    public void setRegion(String region) {
    }

    @Override
    public String getState() {
        return this.m_areaName1;
    }

    @Override
    public void setProvince(String province) {
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("\nHouseNumber: " + this.getHouseNumber());
        buff.append("\nStreet: " + this.getStreet());
        buff.append("\nPostcode: " + this.getPostcode());
        buff.append("\nTown: " + this.getTown());
        buff.append("\nShort State: " + this.getShortState());
        buff.append("\nState: " + this.getState());
        buff.append("\nPostAddress: " + this.getPostAddress());
        buff.append("\nCountry: " + this.getCountry());
        return buff.toString();
    }

    public final String getCountry() {
        return this.m_CountryString;
    }

    public final void setCountry(String countrycode) {
        if (countrycode == null) {
            return;
        }
        this.m_Country = null;
        int len = countrycode.length();
        if (len == 2) {
            this.m_Country = ISO3166.findCountryByISO2((String)countrycode);
        } else if (len == 3) {
            this.m_Country = ISO3166.findCountryByISO3((String)countrycode);
        }
        if (this.m_Country == null) {
            this.m_Country = ISO3166.findCountryByNumber((String)countrycode);
        }
        if (this.m_Country == null) {
            this.m_Country = ISO3166.findCountryByName((String)countrycode);
        }
        this.m_CountryString = this.m_Country == null ? countrycode.toUpperCase() : this.m_Country.getISO3Country();
    }

    public final Address convert() {
        AddressImpl address = new AddressImpl();
        address.setCountry(this.trimString(this.getCountry()));
        address.setAddressNumber(this.trimString(this.m_addressNumber));
        address.setAreaName1(this.trimString(this.m_areaName1));
        address.setAreaName2(this.trimString(this.m_areaName2));
        address.setAreaName3(this.trimString(this.m_areaName3));
        address.setAreaName4(this.trimString(this.m_areaName4));
        address.setGenericField1(this.trimString(this.m_genericField1));
        address.setGenericField2(this.trimString(this.m_genericField2));
        address.setGenericField3(this.trimString(this.m_genericField3));
        address.setGenericField4(this.trimString(this.m_genericField4));
        address.setMainAddress(this.trimString(this.m_mainAddress));
        address.setPlaceName(this.trimString(this.m_placeName));
        address.setPostAddress(this.trimString(this.m_postAddress));
        address.setPostCode1(this.trimString(this.m_postCode1));
        address.setPostCode2(this.trimString(this.m_postCode2));
        address.setPostDirectional(this.trimString(this.m_postDirectional));
        address.setPostThoroughfareType(this.trimString(this.m_postThoroughfareType));
        address.setPreAddress(this.trimString(this.m_preAddress));
        address.setPreDirectional(this.trimString(this.m_preDirectional));
        address.setPreThoroughfareType(this.trimString(this.m_preThoroughfareType));
        address.setUnitType(this.trimString(this.m_unitType));
        address.setUnitValue(this.trimString(this.m_unitValue));
        if (this.m_additionalFields != null && !this.m_additionalFields.isEmpty()) {
            address.getAdditionalFields().putAll(this.m_additionalFields);
        }
        return address;
    }

    private String trimString(String input) {
        if (input == null) {
            return input;
        }
        if ((input = input.trim()).length() == 0) {
            return null;
        }
        return input;
    }
}

