/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHN;

import com.mapinfo.mapmarker.cgge.CGGECandidateFilter;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.CGGERuntimeException;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import java.util.List;

public class CHN_CandidateFilter
extends CGGECandidateFilter {
    @Override
    public void filterMultipleCloseCandidates(InternalCandidateList internalCandList, ParsedAddress addr, GeocodeOptions options) throws CGGERuntimeException, CGGEInternalException {
        super.filterMultipleCloseCandidates(internalCandList, addr, options);
        this.filterMultipleOnStreetNameVariance(internalCandList);
    }

    private void filterMultipleOnStreetNameVariance(InternalCandidateList internalCandList) {
        int closeMatchCount = internalCandList.getNumberOfCloseMatches();
        if (closeMatchCount > 1) {
            List<InternalScoringAddress> candList = internalCandList.getCandidateList();
            InternalScoringAddress bestCand = candList.get(0);
            FieldScore currBestStreetScore = bestCand.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
            double currBestCombinedScore = bestCand.getCombinedScore();
            for (int candNdx = 1; candNdx < closeMatchCount; ++candNdx) {
                InternalScoringAddress cand = candList.get(candNdx);
                FieldScore streetScore = cand.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
                if (currBestCombinedScore != cand.getCombinedScore() || streetScore == null || streetScore.m_value != currBestStreetScore.m_value) break;
                int c = this.compareCandStreetWithBestStreet(streetScore, currBestStreetScore, currBestCombinedScore);
                if (c < 0) {
                    this.degradeAllFrom(internalCandList, candNdx);
                    break;
                }
                if (c <= 0) continue;
                this.moveCandToTopAndDegradeAllOthers(internalCandList, candNdx);
                break;
            }
        }
    }

    private void degradeAllFrom(InternalCandidateList internalCandList, int fromNdx) {
        int closeMatchCount = internalCandList.getNumberOfCloseMatches();
        if (fromNdx < closeMatchCount) {
            List<InternalScoringAddress> candList = internalCandList.getCandidateList();
            for (int candNdx = fromNdx; candNdx < closeMatchCount; ++candNdx) {
                candList.get(candNdx).setCloseMatch(false);
            }
            internalCandList.setNumberOfCloseMatches(fromNdx);
        }
    }

    private void moveCandToTopAndDegradeAllOthers(InternalCandidateList internalCandList, int atNdx) {
        List<InternalScoringAddress> candList = internalCandList.getCandidateList();
        candList.add(candList.remove(atNdx));
        this.degradeAllFrom(internalCandList, 1);
    }

    private int compareCandStreetWithBestStreet(FieldScore streetScore, FieldScore currBestStreetScore, double currBestCombinedScore) {
        return this.deltaOfMatchedWords(currBestStreetScore) - this.deltaOfMatchedWords(streetScore);
    }

    private int deltaOfMatchedWords(FieldScore score) {
        return Math.abs(IntArray.size(score.m_matchedInputWords) - IntArray.size(score.m_matchedCandWords));
    }
}

