/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHN.helper;

import com.mapinfo.mapmarker.CHN.CHN_Utils;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.address.WordAlternate;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.DataSetInfo;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAddressWord;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAreaTermItem;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.helper.CGGEStreetGeocodingHelper;
import com.mapinfo.mapmarker.cgge.utils.AddressWordArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class CHN_StreetGeocodingHelper
extends CGGEStreetGeocodingHelper {
    private ParsedAddress localParsedAddrRef;
    private boolean m_searchOnStreet = true;
    private double m_minStreetSearchQuality = 0.8;

    @Override
    protected List<DictionaryAddressWord> getSearchableWords(AddressWord[] searchWords, FieldType type, IDataManager dataManager, double minQuality, GeocodeOptions options) throws CGGEInternalException, DataNotInitialisedException, DataFetchException {
        List<DictionaryAddressWord> dictAddressWords = super.getSearchableWords(searchWords, type, dataManager, minQuality, options);
        if (minQuality < 1.0 && dictAddressWords != null) {
            this.removeUnMatchedNonSignificantWords(dictAddressWords);
        }
        return dictAddressWords;
    }

    @Override
    public InternalCandidateList searchNextCase(IDataManager dataManager, ParsedAddress parsedAddress, GeocodeOptions options, InternalCandidateList curCandList) throws CGGEInternalException, DataFetchException, DataNotInitialisedException {
        this.localParsedAddrRef = parsedAddress;
        return super.searchNextCase(dataManager, parsedAddress, options, curCandList);
    }

    @Override
    protected List<DictionaryAreaTermItem> findAreaList(AddressWord[] searchWords, FieldType areaType, double minQuality, IDataManager dataManager, GeocodeOptions options) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        searchWords = this.filterAreaSearchWords(searchWords, areaType);
        return super.findAreaList(searchWords, areaType, minQuality, dataManager, options);
    }

    private AddressWord[] filterAreaSearchWords(AddressWord[] searchWords, FieldType areaType) {
        int ndx;
        if (searchWords != null && this.localParsedAddrRef.isEmpty(areaType) && (ndx = CHN_Utils.indexOfAreaDescriptorWord(searchWords, areaType)) > 0) {
            return Arrays.copyOfRange(searchWords, Math.max(0, ndx - 3), ndx + 1);
        }
        return searchWords;
    }

    @Override
    protected AddressWord[] filterSearchWords(AddressWord[] words, boolean includeNormalWords, boolean combineAlphaNumeric, boolean noMultipleStreetTypeFiltering, int includeMask) {
        AddressWord[] filterWords = this.doLocalFilter(words, includeMask);
        return super.filterSearchWords(filterWords, includeNormalWords, combineAlphaNumeric, noMultipleStreetTypeFiltering, includeMask);
    }

    @Override
    protected boolean generateStreetSubTries(IDataManager dataManager, ParsedAddress parsedAddress, GeocodeOptions options, InternalCandidateList candidateList) throws CGGEInternalException, DataNotInitialisedException, DataFetchException {
        if (parsedAddress.isIntersectionCase() || parsedAddress.isNearByFeature()) {
            return this.generateStreetSubTriesForIntersection(dataManager, parsedAddress, options, candidateList);
        }
        AddressWord[] searchWords = null;
        List<DictionaryAddressWord> searchWordList = null;
        if (this.m_streetTryCaseMap == null) {
            this.m_streetTryCaseMap = new HashMap(9);
        }
        List dataSetList = (List)options.get("allowed_datasets_list");
        if (parsedAddress.getField(FieldType.PLACE_NAME_FIELD_TYPE) == null && ((DataSetInfo)dataSetList.get(0)).getName().contains("POI")) {
            return false;
        }
        switch (this.m_streetSubTryCount) {
            case 0: {
                ++this.m_streetSubTryCount;
                if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                    return true;
                }
                this.m_searchOnStreet = this.isAddressSearchableField(FieldType.STREET_NAME_FIELD_TYPE);
                if (this.m_searchOnStreet) {
                    this.m_searchOnStreet = parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE) != null;
                    AddressWord[] streetWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
                    AddressWord[] filteredWords = this.filterSearchWords(streetWords, true, 0);
                    List<DictionaryAddressWord> addressSearchWords = this.getSearchableWords(filteredWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.m_minStreetSearchQuality, options);
                    this.setAddressSearchWordList(addressSearchWords);
                    searchWordList = this.filterSearchWords(this.getAddressSearchWordList(), true, 0);
                    break;
                }
            }
            case 1: {
                ++this.m_streetSubTryCount;
                if (this.m_searchOnStreet) {
                    if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                        return true;
                    }
                    this.m_searchOnStreet = parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE) != null;
                    AddressWord[] streetWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
                    AddressWord[] filteredWords = this.filterSearchWords(streetWords, false, 12);
                    List<DictionaryAddressWord> searchableWords = this.getSearchableWords(filteredWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.m_minStreetSearchQuality, options);
                    if (this.getAddressSearchWordList() != null) {
                        if (searchableWords != null) {
                            this.getAddressSearchWordList().addAll(searchableWords);
                        }
                    } else {
                        this.setAddressSearchWordList(searchableWords);
                    }
                    searchWordList = this.filterSearchWords(this.getAddressSearchWordList(), true, 1792);
                    break;
                }
            }
            case 2: {
                ++this.m_streetSubTryCount;
                if (this.m_searchOnStreet) {
                    if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                        return true;
                    }
                    AddressWord[] streetWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
                    AddressWord[] filteredWords = this.filterSearchWords(streetWords, false, 256);
                    List<DictionaryAddressWord> searchableWords = this.getSearchableWords(filteredWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.m_minStreetSearchQuality, options);
                    if (this.getAddressSearchWordList() != null) {
                        if (searchableWords != null) {
                            this.getAddressSearchWordList().addAll(searchableWords);
                        }
                    } else {
                        this.setAddressSearchWordList(searchableWords);
                    }
                    searchWordList = this.filterSearchWords(searchableWords, true, 1536);
                    break;
                }
            }
            case 3: {
                ++this.m_streetSubTryCount;
                if (this.m_searchOnStreet) {
                    if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                        return true;
                    }
                    AddressWord[] streetWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
                    AddressWord[] filteredWords = this.filterSearchWords(streetWords, false, 2560);
                    List<DictionaryAddressWord> searchableWords = this.getSearchableWords(filteredWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.m_minStreetSearchQuality, options);
                    if (this.getAddressSearchWordList() != null) {
                        if (searchableWords != null) {
                            this.getAddressSearchWordList().addAll(searchableWords);
                        }
                    } else {
                        this.setAddressSearchWordList(searchableWords);
                    }
                    searchWordList = this.filterSearchWords(searchableWords, true, 1024);
                    break;
                }
            }
            case 4: {
                ++this.m_streetSubTryCount;
                if (this.m_searchOnStreet) {
                    if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                        return true;
                    }
                    AddressWord[] words = this.getCombinedPossibles((AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE));
                    searchWords = this.filterSearchWords(words, true, 0);
                    searchWordList = this.getSearchableWords(searchWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, 1.0, options);
                    break;
                }
            }
            case 5: {
                ++this.m_streetSubTryCount;
                if (!this.m_searchOnStreet || this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE))) break;
                if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                    return true;
                }
                searchWordList = this.filterSearchWords(this.getAddressSearchWordList(), false, 1792);
                break;
            }
            case 6: {
                ++this.m_streetSubTryCount;
                if (!this.m_searchOnStreet || this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE))) break;
                if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                    return true;
                }
                AddressWord[] words = this.getCombinedPossibles((AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE));
                searchWords = this.filterSearchWords(words, true, 0);
                searchWordList = this.getSearchableWords(searchWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.m_minStreetSearchQuality, options);
                break;
            }
            case 7: {
                ++this.m_streetSubTryCount;
                if (this.m_searchOnStreet) {
                    if (!this.getAllowWrongCharChecks() || this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE))) break;
                    if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                        return true;
                    }
                    AddressWord[] words = this.filterSearchWords((AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE), true, 0);
                    if (words == null) break;
                    ArrayList<AddressWord> list = new ArrayList<AddressWord>(10);
                    for (int i = 0; i < words.length; ++i) {
                        AddressWord codedWord = words[i];
                        List<AddressWord> l = this.makeAlternateWords(codedWord, 16);
                        if (l == null) continue;
                        list.addAll(l);
                    }
                    if (list.size() <= 0) break;
                    searchWords = list.toArray(new AddressWord[list.size()]);
                    searchWordList = this.getSearchableWords(searchWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.m_minStreetSearchQuality, options);
                    break;
                }
            }
            case 8: {
                ++this.m_streetSubTryCount;
                if (this.m_searchOnStreet && this.getAllowTransposedCharChecks() && (!this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) || !this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE) && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE))) {
                    if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                        return true;
                    }
                    AddressWord[] words = this.filterSearchWords((AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE), true, 0);
                    if (words == null) break;
                    ArrayList<AddressWord> list = new ArrayList<AddressWord>(10);
                    for (int i = 0; i < words.length; ++i) {
                        AddressWord codedWord = words[i];
                        List<AddressWord> l = this.makeAlternateWords(codedWord, 8);
                        if (l == null) continue;
                        list.addAll(l);
                    }
                    if (list.size() <= 0) break;
                    searchWords = list.toArray(new AddressWord[list.size()]);
                    searchWordList = this.getSearchableWords(searchWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.m_minStreetSearchQuality, options);
                    break;
                }
            }
            case 9: {
                List<DictionaryAreaTermItem> areaList;
                ++this.m_streetSubTryCount;
                if (this.m_searchOnStreet && this.getAllowAddedCharChecks() && this.m_areaSubTryCount < 24 && (!this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) || !this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE) && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE))) {
                    areaList = this.getSearchAreaList();
                    if (this.m_areaSubTryCount < 16 || this.hasGoodQualityAreas(areaList, 0.9)) {
                        if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                            return true;
                        }
                        AddressWord[] words = this.filterSearchWords((AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE), true, 0);
                        if ((words = this.filterWordsInAreaList(words, areaList)) == null) break;
                        ArrayList<AddressWord> list = new ArrayList<AddressWord>(10);
                        for (int i = 0; i < words.length; ++i) {
                            AddressWord codedWord = words[i];
                            List<AddressWord> l = this.makeAlternateWords(codedWord, 4);
                            if (l == null) continue;
                            list.addAll(l);
                        }
                        if (list.size() <= 0) break;
                        searchWords = list.toArray(new AddressWord[list.size()]);
                        searchWordList = this.getSearchableWords(searchWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.m_minStreetSearchQuality, options);
                        break;
                    }
                }
            }
            case 10: {
                List<DictionaryAreaTermItem> areaList;
                ++this.m_streetSubTryCount;
                if (this.m_searchOnStreet && this.getAllowMissingCharChecks() && this.m_areaSubTryCount < 24 && (!this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) || !this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE) && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE))) {
                    areaList = this.getSearchAreaList();
                    if (this.m_areaSubTryCount < 16 || this.hasGoodQualityAreas(areaList, 0.9)) {
                        if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                            return true;
                        }
                        AddressWord[] words = this.filterSearchWords((AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE), true, 0);
                        if ((words = this.filterWordsInAreaList(words, areaList)) == null) break;
                        ArrayList<AddressWord> list = new ArrayList<AddressWord>(10);
                        for (int i = 0; i < words.length; ++i) {
                            AddressWord codedWord = words[i];
                            List<AddressWord> l = this.makeAlternateWords(codedWord, 2);
                            if (l == null) continue;
                            list.addAll(l);
                        }
                        if (list.size() <= 0) break;
                        searchWords = list.toArray(new AddressWord[list.size()]);
                        searchWordList = this.getSearchableWords(searchWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.m_minStreetSearchQuality, options);
                        break;
                    }
                }
            }
            case 11: {
                ++this.m_streetSubTryCount;
                if (this.m_searchOnStreet && this.m_areaSubTryCount < 16) {
                    if (this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE))) break;
                    if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                        return true;
                    }
                    searchWordList = this.filterSearchWords(this.getAddressSearchWordList(), true, 2828);
                    break;
                }
            }
            case 12: {
                ++this.m_streetSubTryCount;
                if (this.m_searchOnStreet && this.getAllowSearchOnSplitWord()) {
                    if (this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE))) break;
                    if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                        return true;
                    }
                    searchWordList = this.getSearchableWordsOnSplitInputWords((AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE), FieldType.STREET_NAME_FIELD_TYPE, 1.0, dataManager, options);
                    break;
                }
            }
            case 13: {
                ++this.m_streetSubTryCount;
                if (this.m_searchOnStreet && this.getAllowSearchOnSplitWord()) {
                    if (this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE))) break;
                    if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                        return true;
                    }
                    searchWordList = this.getSearchableWordsOnSplitInputWords((AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE), FieldType.STREET_NAME_FIELD_TYPE, 0.95, dataManager, options);
                    break;
                }
            }
            case 14: {
                ++this.m_streetSubTryCount;
                if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                    return true;
                }
                List<FieldType> streetSearchFields = this.getAddressSearchFields();
                if (streetSearchFields != null) {
                    for (FieldType searchType : streetSearchFields) {
                        if (searchType == FieldType.STREET_NAME_FIELD_TYPE) continue;
                        searchWords = null;
                        if (searchType.getLevel() == FieldType.FieldLevel.LEVEL_POSTAL) {
                            if (searchType == FieldType.POST_CODE_FIELD_TYPE) {
                                searchWords = (AddressWord[])parsedAddress.getField(FieldType.POST_CODE_FIELD_TYPE);
                            }
                            if (searchWords == null) {
                                searchWords = parsedAddress.isSeparateAreaFields() ? (AddressWord[])parsedAddress.getField(searchType) : (AddressWord[])parsedAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
                            }
                        } else {
                            searchWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
                        }
                        if (searchWords == null) continue;
                        List<DictionaryAddressWord> list = this.getSearchableWords(searchWords, searchType, dataManager, 1.0, options);
                        if (searchWordList == null) {
                            searchWordList = list;
                            continue;
                        }
                        if (list == null) continue;
                        searchWordList.addAll(list);
                    }
                    break;
                }
            }
            case 15: {
                ++this.m_streetSubTryCount;
                if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                    return true;
                }
                List<FieldType> streetSearchFields = this.getAddressSearchFields();
                if (streetSearchFields != null) {
                    for (FieldType searchType : streetSearchFields) {
                        if (searchType == FieldType.STREET_NAME_FIELD_TYPE) continue;
                        searchWords = null;
                        if (searchType.getLevel() == FieldType.FieldLevel.LEVEL_POSTAL) {
                            if (searchType == FieldType.POST_CODE_FIELD_TYPE) {
                                searchWords = (AddressWord[])parsedAddress.getField(FieldType.POST_CODE_FIELD_TYPE);
                            }
                            if (searchWords == null) {
                                searchWords = parsedAddress.isSeparateAreaFields() ? (AddressWord[])parsedAddress.getField(searchType) : (AddressWord[])parsedAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
                            }
                        } else {
                            searchWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
                        }
                        if (searchWords == null) continue;
                        List<DictionaryAddressWord> list = this.getSearchableWords(searchWords, searchType, dataManager, this.m_minStreetSearchQuality, options);
                        if (searchWordList == null) {
                            searchWordList = list;
                            continue;
                        }
                        if (list == null) continue;
                        searchWordList.addAll(list);
                    }
                    break;
                }
            }
            case 16: {
                ++this.m_streetSubTryCount;
                AddressWord[] placeWords = (AddressWord[])parsedAddress.getField(FieldType.PLACE_NAME_FIELD_TYPE);
                if (placeWords == null) break;
                searchWordList = this.getSearchableWords(placeWords, FieldType.PLACE_NAME_FIELD_TYPE, dataManager, 1.0, options);
                break;
            }
            default: {
                return false;
            }
        }
        this.m_streetTryCaseMap.put(this.m_streetSubTryCount - 1, searchWordList);
        this.setSearchWordList(searchWordList);
        return true;
    }

    private AddressWord[] doLocalFilter(AddressWord[] words, int includeMask) {
        if (words != null) {
            words = this.removeWordsAfterStreetType(words);
            words = this.removeAreas(words);
            words = this.addCombinedWordAlts(words);
            if ((includeMask & 0x200) == 0) {
                words = this.removeThoroughfareTypeWords(words);
            }
            words = this.addSplitWords(words);
        }
        return words;
    }

    private AddressWord[] addCombinedWordAlts(AddressWord[] words) {
        int typeEndPos = CHN_Utils.indexOfLastThoroughfareTypeWord(words);
        while (typeEndPos > 0) {
            AddressWord[] partialWords = Arrays.copyOfRange(words, Math.max(0, typeEndPos - 5), typeEndPos);
            AddressWord[] combinedWords = super.getCombinedPossibles(partialWords);
            if (combinedWords != null) {
                words = AddressWordArray.combineArrays(words, combinedWords);
            }
            typeEndPos = CHN_Utils.indexOfLastThoroughfareTypeWord(partialWords);
        }
        return words;
    }

    private AddressWord[] addSplitWords(AddressWord[] words) {
        if (words.length > 0) {
            ArrayList<AddressWord> wordList = new ArrayList<AddressWord>(Arrays.asList(words));
            HashSet<AddressWord> addedWords = new HashSet<AddressWord>();
            for (AddressWord word : words) {
                if (!word.hasAlternates()) continue;
                for (WordAlternate wordAlt : word.getAlternates()) {
                    if (wordAlt.getAltType() != WordAlternate.ALT_TYPE.MULTI_WORD_ABBREVIATION) continue;
                    for (AddressWord splitWord : wordAlt.getAltWords()) {
                        if (!AddressWord.isSignificantWord(splitWord) || splitWord.getWordLength() <= 2 || !addedWords.add(splitWord)) continue;
                        wordList.add(splitWord);
                    }
                }
            }
            if (wordList.size() > words.length) {
                return wordList.toArray(new AddressWord[wordList.size()]);
            }
        }
        return words;
    }

    private AddressWord[] removeThoroughfareTypeWords(AddressWord[] words) {
        int c = words.length;
        if (c > 0) {
            AddressWord[] filteredWords = new AddressWord[c];
            int added = 0;
            for (int i = 0; i < c; ++i) {
                if (CodedWord.isThoroughfareTypeWord(words[i].getAttributes())) continue;
                filteredWords[added++] = words[i];
            }
            if (added != c) {
                return Arrays.copyOf(filteredWords, added);
            }
        }
        return words;
    }

    private AddressWord[] removeAreas(AddressWord[] words) {
        int c = words.length;
        if (c > 1) {
            AddressWord[] filteredWords = new AddressWord[c];
            int added = 0;
            for (int i = 0; i < c; ++i) {
                if (CHN_Utils.isAreaDescriptorWord(words[i])) {
                    if (added <= 0) continue;
                    --added;
                    continue;
                }
                filteredWords[added++] = words[i];
            }
            return added < c ? Arrays.copyOf(filteredWords, added) : filteredWords;
        }
        return words;
    }

    private AddressWord[] removeWordsAfterStreetType(AddressWord[] words) {
        int typeEndPos = CHN_Utils.indexOfLastThoroughfareTypeWord(words);
        return typeEndPos > -1 ? Arrays.copyOf(words, typeEndPos + 1) : words;
    }

    private void removeUnMatchedNonSignificantWords(List<DictionaryAddressWord> dictAddressWords) {
        Iterator<DictionaryAddressWord> it = dictAddressWords.iterator();
        while (it.hasNext()) {
            AddressWord searchWord;
            DictionaryAddressWord dictAddrWord = it.next();
            if (!(dictAddrWord.getMatchQuality() < 1.0) || AddressWord.isSignificantWord(searchWord = dictAddrWord.getSearchWord()) && searchWord.getWordLength() >= 4) continue;
            it.remove();
        }
    }

    private boolean setSavedSearchWordForSubTry(int trycase) {
        if (this.m_streetTryCaseMap != null && this.m_streetTryCaseMap.containsKey(trycase)) {
            this.setSearchWordList((List)this.m_streetTryCaseMap.get(trycase));
            return true;
        }
        return false;
    }

    private boolean hasGoodQualityAreas(List<DictionaryAreaTermItem> areaList, double minimumQuality) {
        if (areaList != null) {
            for (DictionaryAreaTermItem areaItem : areaList) {
                if (!(areaItem.m_quality >= minimumQuality)) continue;
                return true;
            }
        }
        return false;
    }

    private AddressWord[] filterWordsInAreaList(AddressWord[] words, List<DictionaryAreaTermItem> areaList) {
        if (words != null && words.length > 0 && areaList != null && areaList.size() > 0) {
            int removed = 0;
            Iterator<DictionaryAreaTermItem> it = areaList.iterator();
            int wc = words.length;
            while (it.hasNext()) {
                DictionaryAreaTermItem areaItem = it.next();
                if (!(areaItem.m_quality >= 1.0)) continue;
                DictionaryAddressWord[] searchedWords = areaItem.getMatchedWords();
                int wc1 = searchedWords == null ? 0 : searchedWords.length;
                block1: for (int i = 0; i < wc1; ++i) {
                    DictionaryAddressWord searchWord = searchedWords[i];
                    if (searchWord == null) continue;
                    for (int j = 0; j < wc; ++j) {
                        if (words[j] == null || searchWord.getSearchWord() != words[j]) continue;
                        words[j] = null;
                        ++removed;
                        continue block1;
                    }
                }
            }
            if (removed > 0) {
                int remaining = wc - removed;
                if (remaining > 0) {
                    AddressWord[] filterdWords = new AddressWord[remaining];
                    int added = 0;
                    for (int j = 0; j < wc; ++j) {
                        if (words[j] == null) continue;
                        filterdWords[added++] = words[j];
                    }
                    return filterdWords;
                }
                return null;
            }
        }
        return words;
    }
}

