/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHN.helper;

import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.DataSetInfo;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAddressWord;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAreaTermItem;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.helper.CGGEStreetGeocodingHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class CHN_ZH_StreetGeocodingHelper
extends CGGEStreetGeocodingHelper {
    private boolean m_searchOnStreet = true;
    private double m_minStreetSearchQuality = 0.8;
    private boolean m_allowMisalignedAn1An2 = false;
    private boolean m_allowMisalignedAn1An3 = false;
    private boolean m_allowMisalignedAn1An4 = false;
    private boolean m_allowMisalignedAn2An3 = false;
    private boolean m_allowMisalignedAn2An4 = false;
    private boolean m_allowMisalignedAn3An4 = false;

    @Override
    protected boolean generateStreetSubTries(IDataManager dataManager, ParsedAddress parsedAddress, GeocodeOptions options, InternalCandidateList candidateList) throws CGGEInternalException, DataNotInitialisedException, DataFetchException {
        if (parsedAddress.isIntersectionCase() || parsedAddress.isNearByFeature()) {
            return this.generateStreetSubTriesForIntersection(dataManager, parsedAddress, options, candidateList);
        }
        AddressWord[] searchWords = null;
        List<DictionaryAddressWord> searchWordList = null;
        if (this.m_streetTryCaseMap == null) {
            this.m_streetTryCaseMap = new HashMap(9);
        }
        List dataSetList = (List)options.get("allowed_datasets_list");
        if (parsedAddress.getField(FieldType.PLACE_NAME_FIELD_TYPE) == null && ((DataSetInfo)dataSetList.get(0)).getName().contains("POI")) {
            return false;
        }
        switch (this.m_streetSubTryCount) {
            case 0: {
                ++this.m_streetSubTryCount;
                if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                    return true;
                }
                this.m_searchOnStreet = this.isAddressSearchableField(FieldType.STREET_NAME_FIELD_TYPE);
                if (this.m_searchOnStreet) {
                    this.m_searchOnStreet = parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE) != null;
                    AddressWord[] streetWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
                    AddressWord[] filteredWords = this.filterSearchWords(streetWords, true, 0);
                    List<DictionaryAddressWord> addressSearchWords = this.getSearchableWords(filteredWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.m_minStreetSearchQuality, options);
                    this.setAddressSearchWordList(addressSearchWords);
                    searchWordList = this.filterSearchWords(this.getAddressSearchWordList(), true, 0);
                    break;
                }
            }
            case 1: {
                ++this.m_streetSubTryCount;
                if (this.m_searchOnStreet) {
                    if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                        return true;
                    }
                    this.m_searchOnStreet = parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE) != null;
                    AddressWord[] streetWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
                    AddressWord[] filteredWords = this.filterSearchWords(streetWords, false, 12);
                    List<DictionaryAddressWord> searchableWords = this.getSearchableWords(filteredWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.m_minStreetSearchQuality, options);
                    if (this.getAddressSearchWordList() != null) {
                        if (searchableWords != null) {
                            this.getAddressSearchWordList().addAll(searchableWords);
                        }
                    } else {
                        this.setAddressSearchWordList(searchableWords);
                    }
                    searchWordList = this.filterSearchWords(this.getAddressSearchWordList(), true, 1792);
                    break;
                }
            }
            case 2: {
                ++this.m_streetSubTryCount;
                if (this.m_searchOnStreet) {
                    if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                        return true;
                    }
                    AddressWord[] streetWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
                    AddressWord[] filteredWords = this.filterSearchWords(streetWords, false, 256);
                    List<DictionaryAddressWord> searchableWords = this.getSearchableWords(filteredWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.m_minStreetSearchQuality, options);
                    if (this.getAddressSearchWordList() != null) {
                        if (searchableWords != null) {
                            this.getAddressSearchWordList().addAll(searchableWords);
                        }
                    } else {
                        this.setAddressSearchWordList(searchableWords);
                    }
                    searchWordList = this.filterSearchWords(searchableWords, true, 1536);
                    break;
                }
            }
            case 3: {
                ++this.m_streetSubTryCount;
                if (this.m_searchOnStreet) {
                    if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                        return true;
                    }
                    AddressWord[] streetWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
                    AddressWord[] filteredWords = this.filterSearchWords(streetWords, false, 2560);
                    List<DictionaryAddressWord> searchableWords = this.getSearchableWords(filteredWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.m_minStreetSearchQuality, options);
                    if (this.getAddressSearchWordList() != null) {
                        if (searchableWords != null) {
                            this.getAddressSearchWordList().addAll(searchableWords);
                        }
                    } else {
                        this.setAddressSearchWordList(searchableWords);
                    }
                    searchWordList = this.filterSearchWords(searchableWords, true, 1024);
                    break;
                }
            }
            case 4: {
                ++this.m_streetSubTryCount;
                if (this.m_searchOnStreet) {
                    if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                        return true;
                    }
                    AddressWord[] words = this.getCombinedPossibles((AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE));
                    searchWords = this.filterSearchWords(words, true, 0);
                    searchWordList = this.getSearchableWords(searchWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, 1.0, options);
                    break;
                }
            }
            case 5: {
                ++this.m_streetSubTryCount;
                if (!this.m_searchOnStreet || this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE))) break;
                if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                    return true;
                }
                searchWordList = this.filterSearchWords(this.getAddressSearchWordList(), false, 1792);
                break;
            }
            case 6: {
                ++this.m_streetSubTryCount;
                if (!this.m_searchOnStreet || this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE))) break;
                if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                    return true;
                }
                AddressWord[] words = this.getCombinedPossibles((AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE));
                searchWords = this.filterSearchWords(words, true, 0);
                searchWordList = this.getSearchableWords(searchWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.m_minStreetSearchQuality, options);
                break;
            }
            case 7: {
                ++this.m_streetSubTryCount;
                if (this.m_searchOnStreet) {
                    if (!this.getAllowWrongCharChecks() || this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE))) break;
                    if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                        return true;
                    }
                    AddressWord[] words = this.filterSearchWords((AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE), true, 0);
                    if (words == null) break;
                    ArrayList<AddressWord> list = new ArrayList<AddressWord>(10);
                    for (int i = 0; i < words.length; ++i) {
                        AddressWord codedWord = words[i];
                        List<AddressWord> l = this.makeAlternateWords(codedWord, 16);
                        if (l == null) continue;
                        list.addAll(l);
                    }
                    if (list.size() <= 0) break;
                    searchWords = list.toArray(new AddressWord[list.size()]);
                    searchWordList = this.getSearchableWords(searchWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.m_minStreetSearchQuality, options);
                    break;
                }
            }
            case 8: {
                ++this.m_streetSubTryCount;
                if (this.m_searchOnStreet && this.getAllowTransposedCharChecks() && (!this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) || !this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE) && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE))) {
                    if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                        return true;
                    }
                    AddressWord[] words = this.filterSearchWords((AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE), true, 0);
                    if (words == null) break;
                    ArrayList<AddressWord> list = new ArrayList<AddressWord>(10);
                    for (int i = 0; i < words.length; ++i) {
                        AddressWord codedWord = words[i];
                        List<AddressWord> l = this.makeAlternateWords(codedWord, 8);
                        if (l == null) continue;
                        list.addAll(l);
                    }
                    if (list.size() <= 0) break;
                    searchWords = list.toArray(new AddressWord[list.size()]);
                    searchWordList = this.getSearchableWords(searchWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.m_minStreetSearchQuality, options);
                    break;
                }
            }
            case 9: {
                List<DictionaryAreaTermItem> areaList;
                ++this.m_streetSubTryCount;
                if (this.m_searchOnStreet && this.getAllowAddedCharChecks() && this.m_areaSubTryCount < 24 && (!this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) || !this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE) && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE))) {
                    areaList = this.getSearchAreaList();
                    if (this.m_areaSubTryCount < 16 || this.hasGoodQualityAreas(areaList, 0.9)) {
                        if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                            return true;
                        }
                        AddressWord[] words = this.filterSearchWords((AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE), true, 0);
                        if ((words = this.filterWordsInAreaList(words, areaList)) == null) break;
                        ArrayList<AddressWord> list = new ArrayList<AddressWord>(10);
                        for (int i = 0; i < words.length; ++i) {
                            AddressWord codedWord = words[i];
                            List<AddressWord> l = this.makeAlternateWords(codedWord, 4);
                            if (l == null) continue;
                            list.addAll(l);
                        }
                        if (list.size() <= 0) break;
                        searchWords = list.toArray(new AddressWord[list.size()]);
                        searchWordList = this.getSearchableWords(searchWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.m_minStreetSearchQuality, options);
                        break;
                    }
                }
            }
            case 10: {
                List<DictionaryAreaTermItem> areaList;
                ++this.m_streetSubTryCount;
                if (this.m_searchOnStreet && this.getAllowMissingCharChecks() && this.m_areaSubTryCount < 24 && (!this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) || !this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE) && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE))) {
                    areaList = this.getSearchAreaList();
                    if (this.m_areaSubTryCount < 16 || this.hasGoodQualityAreas(areaList, 0.9)) {
                        if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                            return true;
                        }
                        AddressWord[] words = this.filterSearchWords((AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE), true, 0);
                        if ((words = this.filterWordsInAreaList(words, areaList)) == null) break;
                        ArrayList<AddressWord> list = new ArrayList<AddressWord>(10);
                        for (int i = 0; i < words.length; ++i) {
                            AddressWord codedWord = words[i];
                            List<AddressWord> l = this.makeAlternateWords(codedWord, 2);
                            if (l == null) continue;
                            list.addAll(l);
                        }
                        if (list.size() <= 0) break;
                        searchWords = list.toArray(new AddressWord[list.size()]);
                        searchWordList = this.getSearchableWords(searchWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.m_minStreetSearchQuality, options);
                        break;
                    }
                }
            }
            case 11: {
                ++this.m_streetSubTryCount;
                if (this.m_searchOnStreet && this.m_areaSubTryCount < 16) {
                    if (this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE))) break;
                    if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                        return true;
                    }
                    searchWordList = this.filterSearchWords(this.getAddressSearchWordList(), true, 2828);
                    break;
                }
            }
            case 12: {
                ++this.m_streetSubTryCount;
                if (this.m_searchOnStreet && this.getAllowSearchOnSplitWord()) {
                    if (this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE))) break;
                    if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                        return true;
                    }
                    searchWordList = this.getSearchableWordsOnSplitInputWords((AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE), FieldType.STREET_NAME_FIELD_TYPE, 1.0, dataManager, options);
                    break;
                }
            }
            case 13: {
                ++this.m_streetSubTryCount;
                if (this.m_searchOnStreet && this.getAllowSearchOnSplitWord()) {
                    if (this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE))) break;
                    if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                        return true;
                    }
                    searchWordList = this.getSearchableWordsOnSplitInputWords((AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE), FieldType.STREET_NAME_FIELD_TYPE, 0.95, dataManager, options);
                    break;
                }
            }
            case 14: {
                ++this.m_streetSubTryCount;
                if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                    return true;
                }
                List<FieldType> streetSearchFields = this.getAddressSearchFields();
                if (streetSearchFields != null) {
                    for (FieldType searchType : streetSearchFields) {
                        if (searchType == FieldType.STREET_NAME_FIELD_TYPE) continue;
                        searchWords = null;
                        if (searchType.getLevel() == FieldType.FieldLevel.LEVEL_POSTAL) {
                            if (searchType == FieldType.POST_CODE_FIELD_TYPE) {
                                searchWords = (AddressWord[])parsedAddress.getField(FieldType.POST_CODE_FIELD_TYPE);
                            }
                            if (searchWords == null) {
                                searchWords = parsedAddress.isSeparateAreaFields() ? (AddressWord[])parsedAddress.getField(searchType) : (AddressWord[])parsedAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
                            }
                        } else {
                            searchWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
                        }
                        if (searchWords == null) continue;
                        List<DictionaryAddressWord> list = this.getSearchableWords(searchWords, searchType, dataManager, 1.0, options);
                        if (searchWordList == null) {
                            searchWordList = list;
                            continue;
                        }
                        if (list == null) continue;
                        searchWordList.addAll(list);
                    }
                    break;
                }
            }
            case 15: {
                ++this.m_streetSubTryCount;
                if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                    return true;
                }
                List<FieldType> streetSearchFields = this.getAddressSearchFields();
                if (streetSearchFields != null) {
                    for (FieldType searchType : streetSearchFields) {
                        if (searchType == FieldType.STREET_NAME_FIELD_TYPE) continue;
                        searchWords = null;
                        if (searchType.getLevel() == FieldType.FieldLevel.LEVEL_POSTAL) {
                            if (searchType == FieldType.POST_CODE_FIELD_TYPE) {
                                searchWords = (AddressWord[])parsedAddress.getField(FieldType.POST_CODE_FIELD_TYPE);
                            }
                            if (searchWords == null) {
                                searchWords = parsedAddress.isSeparateAreaFields() ? (AddressWord[])parsedAddress.getField(searchType) : (AddressWord[])parsedAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
                            }
                        } else {
                            searchWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
                        }
                        if (searchWords == null) continue;
                        List<DictionaryAddressWord> list = this.getSearchableWords(searchWords, searchType, dataManager, this.m_minStreetSearchQuality, options);
                        if (searchWordList == null) {
                            searchWordList = list;
                            continue;
                        }
                        if (list == null) continue;
                        searchWordList.addAll(list);
                    }
                    break;
                }
            }
            case 16: {
                ++this.m_streetSubTryCount;
                AddressWord[] placeWords = (AddressWord[])parsedAddress.getField(FieldType.PLACE_NAME_FIELD_TYPE);
                if (placeWords == null) break;
                searchWordList = this.getSearchableWords(placeWords, FieldType.PLACE_NAME_FIELD_TYPE, dataManager, 1.0, options);
                break;
            }
            default: {
                return false;
            }
        }
        this.m_streetTryCaseMap.put(this.m_streetSubTryCount - 1, searchWordList);
        this.setSearchWordList(searchWordList);
        return true;
    }

    protected AddressWord[] separateAN1word(AddressWord[] wordsToSearch, int idx, int numCharsToSep) {
        String first = null;
        String other = null;
        int soundexFirst = -1;
        int soundexOther = -1;
        CodedWord cwFirst = null;
        CodedWord cwOther = null;
        AddressWord wordFirst = null;
        AddressWord wordOther = null;
        if (idx > -1 && wordsToSearch[idx].getWord().length() > numCharsToSep) {
            first = wordsToSearch[idx].getWord().substring(0, numCharsToSep);
            other = wordsToSearch[idx].getWord().substring(numCharsToSep);
        }
        if (first != null && other != null) {
            soundexFirst = this.getHelperSoundex().getSoundex(first);
            cwFirst = new CodedWord(first, soundexFirst, -1);
            wordFirst = new AddressWord(cwFirst);
            soundexOther = this.getHelperSoundex().getSoundex(other);
            cwOther = new CodedWord(other, soundexOther, -1);
            wordOther = new AddressWord(cwOther);
            ArrayList<AddressWord> tempList = new ArrayList<AddressWord>();
            for (int j = 0; j < wordsToSearch.length; ++j) {
                if (j == idx) {
                    tempList.add(wordFirst);
                    tempList.add(wordOther);
                    continue;
                }
                tempList.add(wordsToSearch[j]);
            }
            AddressWord[] newWords = tempList.toArray(new AddressWord[tempList.size()]);
            return newWords;
        }
        return wordsToSearch;
    }

    @Override
    protected boolean generateAreaSubTries(IDataManager dataManager, ParsedAddress parsedAddress, GeocodeOptions options, InternalCandidateList candidateList) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        int currentAreaSize;
        boolean separateAreaFields = parsedAddress.isSeparateAreaFields();
        boolean usePerfectPostcodeAreas = true;
        boolean useImPerfectPostcodeAreas = false;
        boolean pcAndAreaIntersectionFlag = this.m_pcAreaList != null;
        this.m_filterSearchedAreaItemAndWordCombo = true;
        boolean areaSearchWasLocality = false;
        List<DictionaryAreaTermItem> areaList = null;
        switch (this.m_areaSubTryCount) {
            case 0: {
                ++this.m_areaSubTryCount;
                this.m_areaTryCaseMap = new HashMap(15);
                this.findPCAreaList(dataManager, parsedAddress, false, options);
                pcAndAreaIntersectionFlag = this.m_pcAreaList != null;
            }
            case 1: {
                ++this.m_areaSubTryCount;
                if (!this.isSacSearchableField(FieldType.AREA_NAME_3_FIELD_TYPE)) break;
                AddressWord[] lookUpAreaWords = null;
                lookUpAreaWords = separateAreaFields ? (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_3_FIELD_TYPE) : this.filterAreaWords((AddressWord[])parsedAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE));
                areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_3_FIELD_TYPE, 1.0, dataManager, options);
                break;
            }
            case 2: {
                ++this.m_areaSubTryCount;
                if (!this.isSacSearchableField(FieldType.AREA_NAME_4_FIELD_TYPE)) break;
                AddressWord[] lookUpAreaWords = null;
                lookUpAreaWords = separateAreaFields ? (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_4_FIELD_TYPE) : this.filterAreaWords((AddressWord[])parsedAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE));
                areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_4_FIELD_TYPE, 1.0, dataManager, options);
                areaSearchWasLocality = true;
                break;
            }
            case 3: {
                List<DictionaryAreaTermItem> areaList1;
                AddressWord[] lookUpAreaWords;
                ++this.m_areaSubTryCount;
                if (!separateAreaFields || !this.m_allowMisalignedAn3An4 || (this.m_pcAreaList == null || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)) && this.doesBestCandidateHasGoodStreetScore(candidateList) && (this.doesBestCandidateHasPerfectAreaField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE, parsedAddress) || this.doesBestCandidateHasPerfectAreaField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE, parsedAddress))) break;
                if (this.isSacSearchableField(FieldType.AREA_NAME_4_FIELD_TYPE) && (lookUpAreaWords = (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_3_FIELD_TYPE)) != null) {
                    areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_4_FIELD_TYPE, 1.0, dataManager, options);
                }
                if (this.isSacSearchableField(FieldType.AREA_NAME_3_FIELD_TYPE) && (lookUpAreaWords = (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_4_FIELD_TYPE)) != null) {
                    areaList1 = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_3_FIELD_TYPE, 1.0, dataManager, options);
                    if (areaList == null) {
                        areaList = areaList1;
                    } else if (areaList1 != null && areaList1.size() > 0) {
                        areaList.addAll(areaList1);
                    }
                }
                areaSearchWasLocality = true;
                break;
            }
            case 4: {
                AddressWord[] lookUpAreaWords;
                ++this.m_areaSubTryCount;
                if (!separateAreaFields || !this.m_allowMisalignedAn1An2 || (this.m_pcAreaList == null || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE))) break;
                if (this.isSacSearchableField(FieldType.AREA_NAME_1_FIELD_TYPE) && (lookUpAreaWords = (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_2_FIELD_TYPE)) != null) {
                    areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_1_FIELD_TYPE, 1.0, dataManager, options);
                }
                if (!this.isSacSearchableField(FieldType.AREA_NAME_2_FIELD_TYPE) || (lookUpAreaWords = (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_1_FIELD_TYPE)) == null) break;
                List<DictionaryAreaTermItem> areaList1 = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_2_FIELD_TYPE, 1.0, dataManager, options);
                if (areaList == null) {
                    areaList = areaList1;
                    break;
                }
                if (areaList1 == null || areaList1.size() <= 0) break;
                areaList.addAll(areaList1);
                break;
            }
            case 5: {
                List<DictionaryAreaTermItem> areaList1;
                AddressWord[] lookUpAreaWords;
                ++this.m_areaSubTryCount;
                if (this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE))) break;
                for (FieldType type : this.getSacSearchFields()) {
                    if (type == FieldType.AREA_NAME_3_FIELD_TYPE || type == FieldType.AREA_NAME_4_FIELD_TYPE || type == FieldType.POST_CODE_FIELD_TYPE) continue;
                    lookUpAreaWords = null;
                    lookUpAreaWords = separateAreaFields ? this.filterAreaWords((AddressWord[])parsedAddress.getField(type)) : this.filterAreaWords((AddressWord[])parsedAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE));
                    if (lookUpAreaWords == null) continue;
                    areaList1 = dataManager.findAreaTerms(1, lookUpAreaWords, type, 1.0, options);
                    if (areaList == null) {
                        areaList = areaList1;
                        continue;
                    }
                    if (areaList1 == null) continue;
                    areaList.addAll(areaList1);
                }
                pcAndAreaIntersectionFlag = false;
                break;
            }
            case 6: {
                List<DictionaryAreaTermItem> areaList1;
                AddressWord[] lookUpAreaWords;
                ++this.m_areaSubTryCount;
                if (this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE))) break;
                for (FieldType type : this.getSacSearchFields()) {
                    if (type == FieldType.AREA_NAME_3_FIELD_TYPE || type == FieldType.AREA_NAME_4_FIELD_TYPE || type == FieldType.POST_CODE_FIELD_TYPE) continue;
                    lookUpAreaWords = null;
                    lookUpAreaWords = separateAreaFields ? this.filterAreaWords((AddressWord[])parsedAddress.getField(type)) : this.filterAreaWords((AddressWord[])parsedAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE));
                    if (lookUpAreaWords == null) continue;
                    areaList1 = dataManager.findAreaTerms(1, lookUpAreaWords, type, this.getMinimumAreaSearchQuality(), options);
                    if (areaList == null) {
                        areaList = areaList1;
                        continue;
                    }
                    if (areaList1 == null) continue;
                    areaList.addAll(areaList1);
                }
                pcAndAreaIntersectionFlag = false;
                break;
            }
            case 7: {
                AddressWord[] lookUpAreaWords;
                ++this.m_areaSubTryCount;
                if (!separateAreaFields || !this.m_allowMisalignedAn1An3 || (this.m_pcAreaList == null || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_1_FIELD_TYPE))) break;
                if (this.isSacSearchableField(FieldType.AREA_NAME_3_FIELD_TYPE) && (lookUpAreaWords = (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_1_FIELD_TYPE)) != null) {
                    areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_3_FIELD_TYPE, 1.0, dataManager, options);
                }
                if (!this.isSacSearchableField(FieldType.AREA_NAME_1_FIELD_TYPE) || (lookUpAreaWords = (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_3_FIELD_TYPE)) == null) break;
                List<DictionaryAreaTermItem> areaList1 = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_1_FIELD_TYPE, 1.0, dataManager, options);
                if (areaList == null) {
                    areaList = areaList1;
                    break;
                }
                if (areaList1 == null || areaList1.size() <= 0) break;
                areaList.addAll(areaList1);
                break;
            }
            case 8: {
                AddressWord[] lookUpAreaWords;
                ++this.m_areaSubTryCount;
                if (!separateAreaFields || !this.m_allowMisalignedAn1An4 || (this.m_pcAreaList == null || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_1_FIELD_TYPE))) break;
                if (this.isSacSearchableField(FieldType.AREA_NAME_4_FIELD_TYPE) && (lookUpAreaWords = (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_1_FIELD_TYPE)) != null) {
                    areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_4_FIELD_TYPE, 1.0, dataManager, options);
                }
                if (!this.isSacSearchableField(FieldType.AREA_NAME_1_FIELD_TYPE) || (lookUpAreaWords = (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_4_FIELD_TYPE)) == null) break;
                List<DictionaryAreaTermItem> areaList1 = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_1_FIELD_TYPE, 1.0, dataManager, options);
                if (areaList == null) {
                    areaList = areaList1;
                    break;
                }
                if (areaList1 == null || areaList1.size() <= 0) break;
                areaList.addAll(areaList1);
                break;
            }
            case 9: {
                AddressWord[] lookUpAreaWords;
                ++this.m_areaSubTryCount;
                if (!separateAreaFields || !this.m_allowMisalignedAn2An3 || (this.m_pcAreaList == null || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_1_FIELD_TYPE))) break;
                if (this.isSacSearchableField(FieldType.AREA_NAME_3_FIELD_TYPE) && (lookUpAreaWords = (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_2_FIELD_TYPE)) != null) {
                    areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_3_FIELD_TYPE, 1.0, dataManager, options);
                }
                if (!this.isSacSearchableField(FieldType.AREA_NAME_2_FIELD_TYPE) || (lookUpAreaWords = (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_3_FIELD_TYPE)) == null) break;
                List<DictionaryAreaTermItem> areaList1 = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_2_FIELD_TYPE, 1.0, dataManager, options);
                if (areaList == null) {
                    areaList = areaList1;
                    break;
                }
                if (areaList1 == null || areaList1.size() <= 0) break;
                areaList.addAll(areaList1);
                break;
            }
            case 10: {
                AddressWord[] lookUpAreaWords;
                ++this.m_areaSubTryCount;
                if (!separateAreaFields || !this.m_allowMisalignedAn2An4 || (this.m_pcAreaList == null || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_1_FIELD_TYPE))) break;
                if (this.isSacSearchableField(FieldType.AREA_NAME_4_FIELD_TYPE) && (lookUpAreaWords = (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_2_FIELD_TYPE)) != null) {
                    areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_4_FIELD_TYPE, 1.0, dataManager, options);
                }
                if (!this.isSacSearchableField(FieldType.AREA_NAME_2_FIELD_TYPE) || (lookUpAreaWords = (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_4_FIELD_TYPE)) == null) break;
                List<DictionaryAreaTermItem> areaList1 = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_2_FIELD_TYPE, 1.0, dataManager, options);
                if (areaList == null) {
                    areaList = areaList1;
                    break;
                }
                if (areaList1 == null || areaList1.size() <= 0) break;
                areaList.addAll(areaList1);
                break;
            }
            case 11: {
                ++this.m_areaSubTryCount;
                if ((this.m_pcAreaList == null || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE)) || this.m_pcAreaList == null) break;
                pcAndAreaIntersectionFlag = false;
                this.m_filterSearchedAreaItemAndWordCombo = false;
                usePerfectPostcodeAreas = true;
                break;
            }
            case 12: {
                ++this.m_areaSubTryCount;
                if ((this.m_pcAreaList == null || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE)) || this.m_pcAreaList == null) break;
                pcAndAreaIntersectionFlag = false;
                this.m_filterSearchedAreaItemAndWordCombo = false;
                usePerfectPostcodeAreas = false;
                useImPerfectPostcodeAreas = true;
                break;
            }
            case 13: {
                ++this.m_areaSubTryCount;
                if ((this.m_pcAreaList == null || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)) && this.doesBestCandidateHasGoodStreetScore(candidateList) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE)) || this.m_pcAreaList == null) break;
                pcAndAreaIntersectionFlag = false;
                usePerfectPostcodeAreas = false;
                useImPerfectPostcodeAreas = false;
                areaList = (List<DictionaryAreaTermItem>)this.m_areaTryCaseMap.get(new Integer(1));
                this.m_filterSearchedAreaItemAndWordCombo = false;
                break;
            }
            case 14: {
                ++this.m_areaSubTryCount;
                if ((this.m_pcAreaList == null || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)) && this.doesBestCandidateHasGoodStreetScore(candidateList) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE)) || this.m_pcAreaList == null) break;
                pcAndAreaIntersectionFlag = false;
                usePerfectPostcodeAreas = false;
                useImPerfectPostcodeAreas = false;
                areaList = (List)this.m_areaTryCaseMap.get(new Integer(2));
                this.m_filterSearchedAreaItemAndWordCombo = false;
                break;
            }
            case 15: {
                ++this.m_areaSubTryCount;
                if ((this.m_pcAreaList == null || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE)) || this.m_pcAreaList == null) break;
                pcAndAreaIntersectionFlag = false;
                usePerfectPostcodeAreas = false;
                useImPerfectPostcodeAreas = false;
                areaList = (List)this.m_areaTryCaseMap.get(new Integer(3));
                this.m_filterSearchedAreaItemAndWordCombo = false;
                break;
            }
            case 16: {
                ++this.m_areaSubTryCount;
                if ((this.m_pcAreaList == null || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE)) || this.m_pcAreaList == null) break;
                pcAndAreaIntersectionFlag = false;
                usePerfectPostcodeAreas = false;
                useImPerfectPostcodeAreas = false;
                areaList = (List)this.m_areaTryCaseMap.get(new Integer(4));
                this.m_filterSearchedAreaItemAndWordCombo = false;
                break;
            }
            case 17: {
                ++this.m_areaSubTryCount;
                if ((this.m_pcAreaList == null || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE)) || this.m_pcAreaList == null) break;
                pcAndAreaIntersectionFlag = false;
                usePerfectPostcodeAreas = false;
                useImPerfectPostcodeAreas = false;
                areaList = (List)this.m_areaTryCaseMap.get(new Integer(5));
                this.m_filterSearchedAreaItemAndWordCombo = false;
                break;
            }
            case 18: {
                ++this.m_areaSubTryCount;
                if ((this.m_pcAreaList == null || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE)) || this.m_pcAreaList == null) break;
                pcAndAreaIntersectionFlag = false;
                usePerfectPostcodeAreas = false;
                useImPerfectPostcodeAreas = false;
                areaList = (List)this.m_areaTryCaseMap.get(new Integer(6));
                this.m_filterSearchedAreaItemAndWordCombo = false;
                break;
            }
            case 19: {
                ++this.m_areaSubTryCount;
                if ((this.m_pcAreaList == null || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE)) || this.m_pcAreaList == null) break;
                pcAndAreaIntersectionFlag = false;
                usePerfectPostcodeAreas = false;
                useImPerfectPostcodeAreas = false;
                areaList = (List)this.m_areaTryCaseMap.get(new Integer(7));
                this.m_filterSearchedAreaItemAndWordCombo = false;
                break;
            }
            case 20: {
                ++this.m_areaSubTryCount;
                if ((this.m_pcAreaList == null || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE)) || this.m_pcAreaList == null) break;
                pcAndAreaIntersectionFlag = false;
                usePerfectPostcodeAreas = false;
                useImPerfectPostcodeAreas = false;
                areaList = (List)this.m_areaTryCaseMap.get(new Integer(8));
                this.m_filterSearchedAreaItemAndWordCombo = false;
                break;
            }
            case 21: {
                ++this.m_areaSubTryCount;
                if ((this.m_pcAreaList == null || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE)) || this.m_pcAreaList == null) break;
                pcAndAreaIntersectionFlag = false;
                usePerfectPostcodeAreas = false;
                useImPerfectPostcodeAreas = false;
                areaList = (List)this.m_areaTryCaseMap.get(new Integer(9));
                this.m_filterSearchedAreaItemAndWordCombo = false;
                break;
            }
            case 22: {
                AddressWord[] lookUpAreaWords;
                ++this.m_areaSubTryCount;
                if (!((this.m_pcAreaList == null && this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE)) || !this.isSacSearchableField(FieldType.AREA_NAME_3_FIELD_TYPE))) {
                    lookUpAreaWords = null;
                    lookUpAreaWords = separateAreaFields ? (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_3_FIELD_TYPE) : this.filterAreaWords((AddressWord[])parsedAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE));
                    areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_3_FIELD_TYPE, this.getMinimumAreaSearchQuality(), dataManager, options);
                }
                pcAndAreaIntersectionFlag = false;
                usePerfectPostcodeAreas = false;
                useImPerfectPostcodeAreas = false;
                break;
            }
            case 23: {
                AddressWord[] lookUpAreaWords;
                ++this.m_areaSubTryCount;
                if ((this.m_pcAreaList != null && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE) || !this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE)) && this.m_pcAreaList != null && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE)) && this.isSacSearchableField(FieldType.AREA_NAME_4_FIELD_TYPE)) {
                    lookUpAreaWords = null;
                    lookUpAreaWords = separateAreaFields ? (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_4_FIELD_TYPE) : this.filterAreaWords((AddressWord[])parsedAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE));
                    areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_4_FIELD_TYPE, this.getMinimumAreaSearchQuality(), dataManager, options);
                }
                pcAndAreaIntersectionFlag = false;
                usePerfectPostcodeAreas = false;
                useImPerfectPostcodeAreas = false;
                break;
            }
            case 24: {
                AddressWord[] lookUpAreaWords;
                ++this.m_areaSubTryCount;
                if ((this.m_pcAreaList != null && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE) || !this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE)) && this.isSacSearchableField(FieldType.AREA_NAME_4_FIELD_TYPE) && (lookUpAreaWords = (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_3_FIELD_TYPE)) != null) {
                    areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_4_FIELD_TYPE, this.getMinimumAreaSearchQuality(), dataManager, options);
                }
                pcAndAreaIntersectionFlag = false;
                usePerfectPostcodeAreas = false;
                useImPerfectPostcodeAreas = false;
                break;
            }
            case 25: {
                AddressWord[] lookUpAreaWords;
                ++this.m_areaSubTryCount;
                if ((this.m_pcAreaList != null && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE) || !this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE)) && this.isSacSearchableField(FieldType.AREA_NAME_3_FIELD_TYPE) && (lookUpAreaWords = (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_4_FIELD_TYPE)) != null) {
                    areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_3_FIELD_TYPE, this.getMinimumAreaSearchQuality(), dataManager, options);
                }
                pcAndAreaIntersectionFlag = false;
                usePerfectPostcodeAreas = false;
                useImPerfectPostcodeAreas = false;
                break;
            }
            case 26: {
                List<DictionaryAreaTermItem> areaList1;
                AddressWord[] lookUpAreaWords;
                ++this.m_areaSubTryCount;
                if (this.m_pcAreaList != null && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE) || !this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE)) {
                    for (FieldType type : this.getSacSearchFields()) {
                        if (type == FieldType.AREA_NAME_3_FIELD_TYPE && type == FieldType.AREA_NAME_4_FIELD_TYPE) continue;
                        lookUpAreaWords = this.filterAreaWords((AddressWord[])parsedAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE));
                        lookUpAreaWords = separateAreaFields ? this.filterAreaWords((AddressWord[])parsedAddress.getField(type)) : this.filterAreaWords((AddressWord[])parsedAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE));
                        if (lookUpAreaWords == null) continue;
                        areaList1 = dataManager.findAreaTerms(1, lookUpAreaWords, type, 1.0, options);
                        if (areaList == null) {
                            areaList = areaList1;
                            continue;
                        }
                        if (areaList1 == null) continue;
                        areaList.addAll(areaList1);
                    }
                }
                pcAndAreaIntersectionFlag = false;
                usePerfectPostcodeAreas = false;
                useImPerfectPostcodeAreas = false;
                break;
            }
            case 27: {
                List<DictionaryAreaTermItem> areaList1;
                AddressWord[] lookUpAreaWords;
                ++this.m_areaSubTryCount;
                if (this.getAllowSearchOnSplitWord()) {
                    if ((this.m_pcAreaList != null && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE) || !this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE)) && separateAreaFields) {
                        for (FieldType type : this.getSacSearchFields()) {
                            lookUpAreaWords = this.getSplitWords((AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_3_FIELD_TYPE));
                            areaList1 = dataManager.findAreaTerms(1, lookUpAreaWords, type, 1.0, options);
                            if (areaList == null) {
                                areaList = areaList1;
                                continue;
                            }
                            if (areaList1 == null) continue;
                            areaList.addAll(areaList1);
                        }
                    }
                    pcAndAreaIntersectionFlag = false;
                    usePerfectPostcodeAreas = false;
                    useImPerfectPostcodeAreas = false;
                    break;
                }
            }
            default: {
                this.setSearchAreaList(null);
                return false;
            }
        }
        if (areaList != null && areaList.size() > 0) {
            ArrayList savedAreaList = new ArrayList(areaList);
            this.m_areaTryCaseMap.put(this.m_areaSubTryCount - 1, savedAreaList);
        } else {
            this.m_areaTryCaseMap.put(this.m_areaSubTryCount - 1, areaList);
        }
        int n = currentAreaSize = areaList == null ? 0 : areaList.size();
        if (this.m_pcAreaList != null && (usePerfectPostcodeAreas || useImPerfectPostcodeAreas)) {
            if (areaList == null) {
                areaList = new ArrayList<DictionaryAreaTermItem>(5);
            }
            for (DictionaryAreaTermItem pcArea : this.m_pcAreaList) {
                if (pcArea.m_quality >= 1.0) {
                    if (!usePerfectPostcodeAreas) continue;
                    areaList.add(pcArea);
                    continue;
                }
                if (!useImPerfectPostcodeAreas) continue;
                areaList.add(pcArea);
            }
        } else if (areaList != null && !usePerfectPostcodeAreas && !useImPerfectPostcodeAreas) {
            Iterator<DictionaryAreaTermItem> it = areaList.iterator();
            while (it.hasNext()) {
                DictionaryAreaTermItem dt = it.next();
                if (dt.getFieldType() != FieldType.POST_CODE_FIELD_TYPE) continue;
                it.remove();
            }
        }
        if (pcAndAreaIntersectionFlag) {
            int areaListSize = areaList == null ? 0 : areaList.size();
            boolean bl = pcAndAreaIntersectionFlag = areaListSize > currentAreaSize;
        }
        if (this.m_areaSacIntersectionFieldList == null) {
            this.m_areaSacIntersectionFieldList = new ArrayList(2);
        }
        this.m_areaSacIntersectionFieldList.clear();
        if (pcAndAreaIntersectionFlag) {
            this.m_areaSacIntersectionFieldList.add(FieldType.POST_CODE_FIELD_TYPE);
            if (areaSearchWasLocality) {
                this.m_areaSacIntersectionFieldList.add(FieldType.AREA_NAME_4_FIELD_TYPE);
            } else {
                this.m_areaSacIntersectionFieldList.add(FieldType.AREA_NAME_3_FIELD_TYPE);
            }
        }
        if (areaList != null && areaList.size() > 0) {
            this.setSearchAreaList(areaList);
        } else {
            this.setSearchAreaList(null);
        }
        return true;
    }

    private boolean doesBestCandidateHasGoodStreetScore(InternalCandidateList candList) {
        InternalScoringAddress candAddr;
        return candList != null && candList.getCandidateCount() > 0 && (candAddr = candList.getIndexedCandidate(0)).getCombinedStreetScore() > 0.6;
    }

    private boolean setSavedSearchWordForSubTry(int trycase) {
        if (this.m_streetTryCaseMap != null && this.m_streetTryCaseMap.containsKey(trycase)) {
            this.setSearchWordList((List)this.m_streetTryCaseMap.get(trycase));
            return true;
        }
        return false;
    }

    private boolean hasGoodQualityAreas(List<DictionaryAreaTermItem> areaList, double minimumQuality) {
        if (areaList != null) {
            for (DictionaryAreaTermItem areaItem : areaList) {
                if (!(areaItem.m_quality >= minimumQuality)) continue;
                return true;
            }
        }
        return false;
    }

    private AddressWord[] filterWordsInAreaList(AddressWord[] words, List<DictionaryAreaTermItem> areaList) {
        if (words != null && words.length > 0 && areaList != null && areaList.size() > 0) {
            int removed = 0;
            Iterator<DictionaryAreaTermItem> it = areaList.iterator();
            int wc = words.length;
            while (it.hasNext()) {
                DictionaryAreaTermItem areaItem = it.next();
                if (!(areaItem.m_quality >= 1.0)) continue;
                DictionaryAddressWord[] searchedWords = areaItem.getMatchedWords();
                int wc1 = searchedWords == null ? 0 : searchedWords.length;
                block1: for (int i = 0; i < wc1; ++i) {
                    DictionaryAddressWord searchWord = searchedWords[i];
                    if (searchWord == null) continue;
                    for (int j = 0; j < wc; ++j) {
                        if (words[j] == null || searchWord.getSearchWord() != words[j]) continue;
                        words[j] = null;
                        ++removed;
                        continue block1;
                    }
                }
            }
            if (removed > 0) {
                int remaining = wc - removed;
                if (remaining > 0) {
                    AddressWord[] filterdWords = new AddressWord[remaining];
                    int added = 0;
                    for (int j = 0; j < wc; ++j) {
                        if (words[j] == null) continue;
                        filterdWords[added++] = words[j];
                    }
                    return filterdWords;
                }
                return null;
            }
        }
        return words;
    }
}

