/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHN.matcher;

import com.mapinfo.mapmarker.CHN.CHN_Utils;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.ICGGECandidateFilter;
import com.mapinfo.mapmarker.cgge.MatchingOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.matcher.CGGEMatcher1;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.cgge.utils.IntArray;

public class CHN_Matcher
extends CGGEMatcher1 {
    @Override
    public boolean isFirstABetterScore(FieldScore score1, FieldScore score2, FieldType inputType, FieldType candType1, FieldType candType2) {
        if (this.scoreDeltaPercentage(score1, score2) < 15) {
            if (candType1 == FieldType.STREET_NAME_FIELD_TYPE) {
                if (this.isMatchFollowedByAreaDescriptor(score2)) {
                    return false;
                }
                if (this.hasThoroughfareTypeMatch(score1)) {
                    return true;
                }
            } else if (candType2 == FieldType.STREET_NAME_FIELD_TYPE) {
                if (this.isMatchFollowedByAreaDescriptor(score1)) {
                    return true;
                }
                if (this.hasThoroughfareTypeMatch(score2)) {
                    return false;
                }
            }
        }
        return super.isFirstABetterScore(score1, score2, inputType, candType1, candType2);
    }

    @Override
    protected FieldScore scoreAddressWords(AddressWord[] parserWords, InternalFieldValue fieldValue, FieldType type, FieldScore score, ICGGEScorer scorer) {
        score = super.scoreAddressWords(parserWords, fieldValue, type, score, scorer);
        this.adjustAreaFieldScore(score, type);
        return score;
    }

    @Override
    public void scoreCandidate(ParsedAddress parsedAddr, InternalScoringAddress addr, MatchingOptions matchingOptions, ICGGEScorer scorer, IDataManager dataManager) throws CGGEInternalException {
        Object streetWordsSaved = null;
        if (addr.getAddressType() == 1 && !addr.isEmpty(FieldType.STREET_NAME_FIELD_TYPE)) {
            this.scoreFieldsAtLevel(parsedAddr, addr, FieldType.FieldLevel.LEVEL_STREET, matchingOptions, scorer);
            FieldScore score = addr.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
            if (!this.passMinimumStreetThreshold(score)) {
                return;
            }
            addr.setFieldScores(null);
        }
        super.scoreCandidate(parsedAddr, addr, matchingOptions, scorer, dataManager);
    }

    boolean passMinimumStreetThreshold(FieldScore score) throws CGGEInternalException {
        if (score != null) {
            ICGGECandidateFilter filter = this.getFilter();
            return score.m_value >= filter.getStreetAddressCutoff(1);
        }
        return false;
    }

    void adjustAreaFieldScore(FieldScore score, FieldType type) {
        double scorevalue;
        if (score != null && (type == FieldType.AREA_NAME_4_FIELD_TYPE || type == FieldType.AREA_NAME_3_FIELD_TYPE) && (scorevalue = score.m_value) > 0.7) {
            if (scorevalue < 1.0) {
                this.checkDescriptorMatch(score, type);
            }
            this.addAreaDesciptorWordsInMatchedWords(score, type);
        }
    }

    private void checkDescriptorMatch(FieldScore score, FieldType type) {
        AddressWord lastWord;
        IntArray matchedCandWordNdx;
        AddressWord[] candWords = score.getCandidateWords();
        int lastWordNdx = candWords.length - 1;
        if (lastWordNdx > 0 && (matchedCandWordNdx = score.m_matchedCandWords) != null && !matchedCandWordNdx.contains(lastWordNdx) && CHN_Utils.isAreaDescriptorWord(lastWord = candWords[lastWordNdx], type) && this.allWordsExceptLastMatchedPerfectly(score) && this.verifyCorrectInputType(score, type)) {
            score.m_value = Math.max(1.0, score.m_value + (double)lastWord.m_weight * 0.01);
            score.m_matched = score.m_value == 1.0;
            matchedCandWordNdx.add(lastWordNdx);
            score.m_perfectCandWords = CHN_Utils.addToArray(score.m_perfectCandWords, lastWordNdx);
        }
    }

    private boolean verifyCorrectInputType(FieldScore score, FieldType type) {
        AddressWord descriptorWord = this.getAreaDescriptorInputWord(score);
        return descriptorWord == null || CHN_Utils.isAreaDescriptorWord(descriptorWord, type);
    }

    private boolean allWordsExceptLastMatchedPerfectly(FieldScore score) {
        AddressWord[] words = score.getCandidateWords();
        IntArray exactMatchedWordNdxs = score.m_perfectCandWords;
        if (IntArray.size(exactMatchedWordNdxs) > 0) {
            for (int wordNdx = words.length - 2; wordNdx >= 0; --wordNdx) {
                if (words[wordNdx].m_weight <= 0 || exactMatchedWordNdxs.contains(wordNdx)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void addIfMissing(IntArray m_perfectCandWords, int n) {
        if (m_perfectCandWords != null && !m_perfectCandWords.contains(n)) {
            m_perfectCandWords.add(n);
        }
    }

    private void addAreaDesciptorWordsInMatchedWords(FieldScore score, FieldType type) {
        AddressWord postMatchWord;
        int lastMatchedWordNdx = this.getLastMatchedWordNdx(score);
        AddressWord[] words = score.getInputWords();
        if (++lastMatchedWordNdx > -1 && lastMatchedWordNdx < words.length - 1 && !this.isIgnoredWord(postMatchWord = words[lastMatchedWordNdx]) && CHN_Utils.isAreaDescriptorWord(postMatchWord, type)) {
            this.addIfMissing(score.m_perfectInputWords, lastMatchedWordNdx);
            this.addIfMissing(score.m_matchedInputWords, lastMatchedWordNdx);
        }
    }

    private boolean isIgnoredWord(AddressWord word) {
        return word.getSoundex() == 0;
    }

    private boolean isMatchFollowedByAreaDescriptor(FieldScore score) {
        int lastMatchedWordNdx = this.getLastMatchedWordNdx(score);
        AddressWord[] words = score.getInputWords();
        if (lastMatchedWordNdx > -1 && lastMatchedWordNdx < words.length - 1) {
            return CHN_Utils.isAreaDescriptorWord(words[lastMatchedWordNdx + 1]);
        }
        return false;
    }

    private AddressWord getAreaDescriptorInputWord(FieldScore score) {
        AddressWord wordAfterMatch;
        int lastMatchedWordNdx = this.getLastMatchedWordNdx(score);
        AddressWord[] words = score.getInputWords();
        if (CHN_Utils.isAreaDescriptorWord(words[lastMatchedWordNdx])) {
            return words[lastMatchedWordNdx];
        }
        if (lastMatchedWordNdx < words.length - 1 && CHN_Utils.isAreaDescriptorWord(wordAfterMatch = words[lastMatchedWordNdx + 1])) {
            return wordAfterMatch;
        }
        return null;
    }

    private boolean hasThoroughfareTypeMatch(FieldScore score) {
        AddressWord word = this.getLastMatchedInputWord(score);
        return word != null && CodedWord.isThoroughfareTypeWord(word.getAttributes());
    }

    private int getLastMatchedWordNdx(FieldScore score) {
        IntArray matchedInputWords = score.m_matchedInputWords;
        if (IntArray.size(matchedInputWords) > 0) {
            return matchedInputWords.max();
        }
        return -1;
    }

    private AddressWord getLastMatchedInputWord(FieldScore score) {
        int lastMatchedWordNdx = this.getLastMatchedWordNdx(score);
        return lastMatchedWordNdx > -1 ? score.getInputWords()[lastMatchedWordNdx] : null;
    }

    private int scoreDeltaPercentage(FieldScore score1, FieldScore score2) {
        return (int)(Math.abs(score1.m_value - score2.m_value) * 100.0);
    }
}

