/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHN.parser;

import com.mapinfo.mapmarker.CHN.CHN_Utils;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InputAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.parser.CGGEParser1;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.cgge.soundex.ICGGESoundex;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CHN_ZH_Parser
extends CGGEParser1 {
    private static final char PROVINCE_IDENTIFIER = '\u7701';
    private static final char CITY_IDENTIFIER = '\u5e02';
    private static final char TOWN_IDENTIFIER = '\u9547';
    private static final char COUNTY_IDENTIFIER = '\u53bf';
    private static final char DISTRICT_IDENTIFIER = '\u533a';
    private static final char VILLAGE_IDENTIFIER = '\u6751';
    private static final char POSTYPE_STREET = '\u8857';
    private static final char POSTTYPE_ROAD = '\u8def';
    private static final char POSTTYPE_BRIDGE = '\u6865';
    private static final char POSTTYPE_BYWAY = '\u9053';
    private static final char POSTTYPE_ALLEY = '\u5df7';
    private static final String COUNTYHWY = "\u53bf\u9053";
    private static final String TOWNSHIPHWY = "\u4e61\u9053";
    private static final String PROVINCEHWY = "\u7701\u9053";
    private static final String VILLAGEHWY = "\u6751\u9053";
    private static final char NORTH = '\u5317';
    private static final char SOUTH = '\u5357';
    private static final char EAST = '\u4e1c';
    private static final char WEST = '\u897f';
    private static final char ROOM_IDENTIFIER1 = '\u623f';
    private static final char ROOM_IDENTIFIER2 = '\u5ba4';
    private static final char BUILDING_IDENTIFIER2 = '\u680b';
    private static final char NUMBER_IDENTIFIER = '\u53f7';
    private static final String UNIT_IDENTIFIER_STR = "\u5355\u5143";
    public static Set<Character> AREA_IDENTIFIERS = new HashSet<Character>();
    private static Set<Character> STREET_TYPES_SINGLECHAR = new HashSet<Character>();
    private static Set<Character> DIRECTIONALS = new HashSet<Character>();
    private static Set<Character> UNIT_RELATED_CHAR = new HashSet<Character>();
    private static Set<String> HWY_STREET_TYPES = new HashSet<String>();
    private static final int SEPARATE_POSTADDRESS_WORDS = 0;
    private static final int SEPARATE_SINGLELINE_WORDS = 1;
    private static final int SEPARATE_STREET_WORDS = 2;

    @Override
    public ParsedAddress[] parse(InputAddress inputAddress, ICGGEScorer scorer) {
        if (inputAddress.getField(FieldType.GENERIC_FIELD_3_FIELD_TYPE) != null) {
            inputAddress.setField(FieldType.STREET_NAME_FIELD_TYPE, inputAddress.getField(FieldType.GENERIC_FIELD_3_FIELD_TYPE));
        }
        String origPostAddresswords = (String)inputAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
        String origStreetFieldWords = (String)inputAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
        boolean SingleLine = false;
        if (origStreetFieldWords != null && origPostAddresswords == null && inputAddress.getField(FieldType.AREA_NAME_1_FIELD_TYPE) == null && inputAddress.getField(FieldType.AREA_NAME_2_FIELD_TYPE) == null && inputAddress.getField(FieldType.AREA_NAME_3_FIELD_TYPE) == null && inputAddress.getField(FieldType.AREA_NAME_4_FIELD_TYPE) == null && inputAddress.getField(FieldType.POST_CODE_FIELD_TYPE) == null) {
            SingleLine = true;
        }
        if (origPostAddresswords != null) {
            this.separateByIdentifier(inputAddress, origPostAddresswords, 0);
        }
        if (origStreetFieldWords != null) {
            if (SingleLine) {
                this.separateByIdentifier(inputAddress, origStreetFieldWords, 1);
            } else {
                this.separateByIdentifier(inputAddress, origStreetFieldWords, 2);
            }
            if (inputAddress.getField(FieldType.GENERIC_FIELD_3_FIELD_TYPE) == null) {
                inputAddress.setField(FieldType.GENERIC_FIELD_3_FIELD_TYPE, origStreetFieldWords);
            }
        }
        ParsedAddress[] parsedAddresses = super.parse(inputAddress, scorer);
        if (!SingleLine) {
            AddressWord[] streetWords = (AddressWord[])parsedAddresses[0].getField(FieldType.STREET_NAME_FIELD_TYPE);
            int idx = CHN_Utils.determinePossibleWrdToSplitByAN(streetWords, 1);
            this.separateAN4fromStreet(streetWords, parsedAddresses[0], idx);
        } else {
            this.adjustStreetWithNumberAtEnd(origStreetFieldWords, parsedAddresses[0]);
            this.adjustForEmbeddedAreaIDInStreetName(parsedAddresses[0]);
            AddressWord[] newPostAddWords = null;
            AddressWord[] initialPostAddWords = (AddressWord[])parsedAddresses[0].getField(FieldType.POST_ADDRESS_FIELD_TYPE);
            int idx = CHN_Utils.determinePossibleWrdToSplitByAN(initialPostAddWords, 0);
            ArrayList fullList = new ArrayList();
            if (idx > -1 && (newPostAddWords = this.separateAN1word(initialPostAddWords, idx, 2)) != null) {
                Collections.addAll(fullList, initialPostAddWords);
                Collections.addAll(fullList, newPostAddWords);
                newPostAddWords = this.separateAN1word(initialPostAddWords, idx, 3);
                if (newPostAddWords != null) {
                    Collections.addAll(fullList, newPostAddWords);
                }
                AddressWord[] retArray = fullList.toArray(new AddressWord[fullList.size()]);
                parsedAddresses[0].setField(FieldType.STREET_NAME_FIELD_TYPE, retArray);
                parsedAddresses[0].setField(FieldType.POST_ADDRESS_FIELD_TYPE, retArray);
            }
        }
        return parsedAddresses;
    }

    @Override
    protected String cleanString(String str) {
        String cleaned = CHN_Utils.zhTrim(str);
        if (cleaned != null) {
            cleaned = super.cleanString(cleaned);
        }
        return cleaned;
    }

    protected void separateByIdentifier(InputAddress inAddr, String wordsToSep, int type) {
        int ctr;
        if (wordsToSep == null) {
            return;
        }
        int lastTypePos = -1;
        if (type != 0) {
            Iterator<Character> itr = STREET_TYPES_SINGLECHAR.iterator();
            for (char ch : STREET_TYPES_SINGLECHAR) {
                int typepos = wordsToSep.lastIndexOf(ch);
                if (typepos <= lastTypePos) continue;
                lastTypePos = typepos;
            }
        }
        char[] wordChars = wordsToSep.toCharArray();
        StringBuilder buf = new StringBuilder();
        if (type == 1 && wordChars.length > 3 && Character.isDigit(wordChars[0]) && Character.isDigit(wordChars[3])) {
            for (ctr = 0; ctr < wordChars.length && Character.isDigit(wordChars[ctr]); ++ctr) {
                buf.append(wordChars[ctr]);
            }
            buf.append(' ');
        }
        int idx = ctr;
        char cPrev = '*';
        int spacesAdded = 0;
        while (idx < wordChars.length) {
            boolean okaytoSepNum;
            char c = wordChars[idx];
            char cNext = '*';
            if (idx + 1 < wordChars.length) {
                cNext = wordChars[idx + 1];
            }
            boolean bl = okaytoSepNum = lastTypePos > 0 && idx >= lastTypePos;
            if (okaytoSepNum && type != 0 && c == '\u53f7' && !STREET_TYPES_SINGLECHAR.contains(Character.valueOf(cNext)) && Character.isDigit(cPrev)) {
                buf.append(' ');
                buf.append(c);
                buf.append(' ');
            } else {
                if (okaytoSepNum && type != 0 && STREET_TYPES_SINGLECHAR.contains(Character.valueOf(c)) && Character.isDigit(cNext)) {
                    buf.append(c);
                    buf.append(' ');
                    ++idx;
                    while (idx < wordChars.length && Character.isDigit(wordChars[idx])) {
                        buf.append(wordChars[idx]);
                        ++idx;
                    }
                    buf.append(' ');
                    cPrev = wordChars[idx - 1];
                    ++spacesAdded;
                    continue;
                }
                if (type != 2 && spacesAdded <= 2 && cPrev != ' ' && AREA_IDENTIFIERS.contains(Character.valueOf(c)) && !AREA_IDENTIFIERS.contains(Character.valueOf(cNext)) && idx + 1 != lastTypePos) {
                    buf.append(c);
                    buf.append(' ');
                    ++spacesAdded;
                } else {
                    buf.append(c);
                }
            }
            if (c == ' ') {
                ++spacesAdded;
            }
            cPrev = c;
            ++idx;
        }
        String processedString = buf.toString().trim();
        if (type == 0) {
            inAddr.setField(FieldType.POST_ADDRESS_FIELD_TYPE, processedString.trim());
        } else {
            inAddr.setField(FieldType.STREET_NAME_FIELD_TYPE, processedString.trim());
        }
    }

    protected void separateAN4fromStreet(AddressWord[] wordsToSearch, ParsedAddress parsed, int idx) {
        ICGGESoundex altSoundex = this.getSoundex();
        String first = null;
        String other = null;
        int soundexFirst = -1;
        int soundexOther = -1;
        AddressWord wordFirst = null;
        AddressWord wordOther = null;
        if (idx > -1 && wordsToSearch[idx].getWord().length() > 2) {
            String tmpstr = wordsToSearch[idx].getWord();
            Iterator<Character> itr = AREA_IDENTIFIERS.iterator();
            int pos = -1;
            while (itr.hasNext() && (pos = tmpstr.indexOf(itr.next().charValue())) <= -1) {
            }
            if (pos > -1) {
                first = wordsToSearch[idx].getWord().substring(0, pos + 1);
                other = wordsToSearch[idx].getWord().substring(pos + 1);
            }
        }
        if (first != null) {
            soundexFirst = altSoundex.getSoundex(first);
            CodedWord cwFirst = new CodedWord(first, soundexFirst, -1);
            wordFirst = new AddressWord(cwFirst);
            soundexOther = altSoundex.getSoundex(other);
            if (soundexOther > 0) {
                CodedWord cwOther = new CodedWord(other, soundexOther, -1);
                wordOther = new AddressWord(cwOther);
            }
            ArrayList<AddressWord> tempList = new ArrayList<AddressWord>();
            for (int j = 0; j < wordsToSearch.length; ++j) {
                if (j == idx) {
                    tempList.add(wordFirst);
                    if (wordOther != null) {
                        tempList.add(wordOther);
                    }
                    tempList.add(wordsToSearch[j]);
                    continue;
                }
                tempList.add(wordsToSearch[j]);
            }
            AddressWord[] newWords = tempList.toArray(new AddressWord[tempList.size()]);
            parsed.setField(FieldType.STREET_NAME_FIELD_TYPE, newWords);
        }
    }

    protected void adjustStreetWithNumberAtEnd(String origStreetWords, ParsedAddress parsedAddress) {
        boolean digitNextToLastNoSpace;
        if (StringUtilities.isEmpty((String)origStreetWords) || origStreetWords.length() < 2) {
            return;
        }
        int len = origStreetWords.length();
        boolean digitAtEndNoSpace = Character.isDigit(origStreetWords.charAt(len - 1)) && origStreetWords.charAt(len - 2) != ' ';
        boolean digitWithNumIndicatorAtEndNoSpace = origStreetWords.charAt(len - 1) == '\u53f7' && Character.isDigit(origStreetWords.charAt(len - 2));
        boolean bl = digitNextToLastNoSpace = !Character.isDigit(origStreetWords.charAt(len - 1)) && Character.isDigit(origStreetWords.charAt(len - 2));
        if (digitAtEndNoSpace || digitWithNumIndicatorAtEndNoSpace || digitNextToLastNoSpace) {
            ICGGESoundex altSoundex = this.getSoundex();
            AddressWord[] streetWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
            if (streetWords.length > 1) {
                String wordOther = null;
                String wordEnd = streetWords[streetWords.length - 1].getWord();
                String wordNextTolast = streetWords[streetWords.length - 2].getWord();
                if (streetWords.length > 2) {
                    wordOther = streetWords[streetWords.length - 3].getWord();
                }
                AddressWord newWord2 = null;
                StringBuilder buf1 = new StringBuilder(wordNextTolast);
                StringBuilder buf2 = new StringBuilder();
                buf1.append(wordEnd);
                if (wordOther != null) {
                    buf2.append(wordOther);
                    buf2.append(wordNextTolast);
                    buf2.append(wordEnd);
                }
                String newWordStr = buf1.toString();
                int soundex = altSoundex.getSoundex(newWordStr);
                CodedWord cw = new CodedWord(newWordStr, soundex, -1);
                AddressWord newWord = new AddressWord(cw);
                if (buf2.length() > 0) {
                    newWordStr = buf2.toString();
                    soundex = altSoundex.getSoundex(newWordStr);
                    cw = new CodedWord(newWordStr, soundex, -1);
                    newWord2 = new AddressWord(cw);
                }
                int allocLen = streetWords.length + 1;
                if (newWord2 != null) {
                    ++allocLen;
                }
                AddressWord[] newStreetWords = new AddressWord[allocLen];
                int ctr = 0;
                AddressWord[] addressWordArray = streetWords;
                int n = addressWordArray.length;
                for (int i = 0; i < n; ++i) {
                    AddressWord theword;
                    newStreetWords[ctr] = theword = addressWordArray[i];
                    ++ctr;
                }
                newStreetWords[ctr] = newWord;
                if (newWord2 != null) {
                    newStreetWords[++ctr] = newWord2;
                }
                parsedAddress.setField(FieldType.STREET_NAME_FIELD_TYPE, newStreetWords);
            }
        }
    }

    protected void adjustForEmbeddedAreaIDInStreetName(ParsedAddress parsedAddress) {
        AddressWord[] streetwords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
        if (streetwords != null && streetwords.length > 1) {
            boolean useThird = false;
            boolean thirdHasDbleAN = false;
            boolean nextHasDbleAN = false;
            String thirdFromEnd = null;
            String lastWord = streetwords[streetwords.length - 1].getWord();
            String nextToLastWord = streetwords[streetwords.length - 2].getWord();
            if (nextToLastWord.length() > 0 && AREA_IDENTIFIERS.contains(Character.valueOf(nextToLastWord.charAt(nextToLastWord.length() - 1)))) {
                AddressWord newWord;
                CodedWord cw;
                String newWordStr = null;
                String newWordStr2 = null;
                int soundex = -1;
                int soundex2 = -1;
                AddressWord newWord2 = null;
                if (streetwords.length > 3 && (thirdFromEnd = streetwords[streetwords.length - 3].getWord()).length() > 0 && AREA_IDENTIFIERS.contains(Character.valueOf(thirdFromEnd.charAt(thirdFromEnd.length() - 1)))) {
                    useThird = true;
                    if (thirdFromEnd.length() > 2 && AREA_IDENTIFIERS.contains(Character.valueOf(thirdFromEnd.charAt(thirdFromEnd.length() - 2)))) {
                        thirdHasDbleAN = true;
                    }
                }
                if (nextToLastWord.length() > 2 && AREA_IDENTIFIERS.contains(Character.valueOf(nextToLastWord.charAt(nextToLastWord.length() - 2)))) {
                    nextHasDbleAN = true;
                }
                String newANwordStr = null;
                if (nextHasDbleAN || thirdHasDbleAN) {
                    StringBuilder buf;
                    if (nextHasDbleAN) {
                        newANwordStr = nextToLastWord.substring(0, nextToLastWord.length() - 1);
                        buf = new StringBuilder();
                        buf.append(nextToLastWord.charAt(nextToLastWord.length() - 1));
                        buf.append(lastWord);
                        lastWord = buf.toString();
                        useThird = false;
                        thirdHasDbleAN = false;
                    } else {
                        newANwordStr = thirdFromEnd.substring(0, thirdFromEnd.length() - 1);
                        buf = new StringBuilder();
                        buf.append(thirdFromEnd.charAt(thirdFromEnd.length() - 1));
                        buf.append(nextToLastWord);
                        nextToLastWord = buf.toString();
                        buf.append(lastWord);
                        lastWord = buf.toString();
                        useThird = false;
                    }
                }
                if (nextHasDbleAN) {
                    soundex = this.getSoundex().getSoundex(lastWord);
                    cw = new CodedWord(lastWord, soundex, -1);
                    newWord = new AddressWord(cw);
                } else if (thirdHasDbleAN) {
                    soundex = this.getSoundex().getSoundex(nextToLastWord);
                    cw = new CodedWord(nextToLastWord, soundex, -1);
                    newWord = new AddressWord(cw);
                    soundex = this.getSoundex().getSoundex(lastWord);
                    cw = new CodedWord(lastWord, soundex, -1);
                    newWord2 = new AddressWord(cw);
                } else if (useThird) {
                    newWordStr = thirdFromEnd + nextToLastWord + lastWord;
                    soundex = this.getSoundex().getSoundex(newWordStr);
                    newWordStr2 = nextToLastWord + lastWord;
                    soundex2 = this.getSoundex().getSoundex(newWordStr2);
                    cw = new CodedWord(newWordStr, soundex, -1);
                    newWord = new AddressWord(cw);
                    cw = new CodedWord(newWordStr2, soundex2, -1);
                    newWord2 = new AddressWord(cw);
                } else {
                    newWordStr = nextToLastWord + lastWord;
                    soundex = this.getSoundex().getSoundex(newWordStr);
                    cw = new CodedWord(newWordStr, soundex, -1);
                    newWord = new AddressWord(cw);
                }
                int allocSize = streetwords.length + 1;
                if (newWord2 != null) {
                    ++allocSize;
                }
                if (newANwordStr != null) {
                    ++allocSize;
                }
                AddressWord[] newStreetWords = new AddressWord[allocSize];
                int ctr = 0;
                AddressWord[] addressWordArray = streetwords;
                int n = addressWordArray.length;
                for (int i = 0; i < n; ++i) {
                    AddressWord theword;
                    newStreetWords[ctr] = theword = addressWordArray[i];
                    ++ctr;
                }
                if (newANwordStr != null) {
                    soundex = this.getSoundex().getSoundex(newANwordStr);
                    cw = new CodedWord(newANwordStr, soundex, -1);
                    newStreetWords[ctr++] = new AddressWord(cw);
                }
                newStreetWords[ctr] = newWord;
                if (newWord2 != null) {
                    newStreetWords[ctr + 1] = newWord2;
                }
                parsedAddress.setField(FieldType.STREET_NAME_FIELD_TYPE, newStreetWords);
                parsedAddress.setField(FieldType.POST_ADDRESS_FIELD_TYPE, newStreetWords);
            }
        }
    }

    protected void separateANFromAN3(ParsedAddress parsedAddress) {
        int cntr = 0;
        int startwordIdx = 0;
        AddressWord[] postAddWords = (AddressWord[])parsedAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
        if (parsedAddress.getProbablePostcodes() != null && parsedAddress.getProbablePostcodes().size() > 0) {
            startwordIdx = 1;
        }
        for (cntr = startwordIdx; cntr < postAddWords.length; ++cntr) {
            if (postAddWords[cntr].getWordLength() <= 3) continue;
            startwordIdx = cntr;
            break;
        }
        AddressWord addressWord = postAddWords[startwordIdx];
        String word = addressWord.getWord();
        ArrayList<AddressWord> list = new ArrayList<AddressWord>();
        if (word.length() > 3) {
            String split2 = null;
            String split2_pt2 = null;
            String split1 = word.substring(0, 2);
            String split1_pt2 = word.substring(2);
            int soundex = this.getSoundex().getSoundex(split1);
            CodedWord cw = new CodedWord(split1, soundex, -1);
            AddressWord newWord = new AddressWord(cw);
            list.add(newWord);
            soundex = this.getSoundex().getSoundex(split1_pt2);
            cw = new CodedWord(split1_pt2, soundex, -1);
            newWord = new AddressWord(cw);
            list.add(newWord);
            if (word.length() > 4) {
                split2 = word.substring(0, 3);
                split2_pt2 = word.substring(3);
                soundex = this.getSoundex().getSoundex(split2);
                cw = new CodedWord(split2, soundex, -1);
                newWord = new AddressWord(cw);
                list.add(newWord);
                soundex = this.getSoundex().getSoundex(split2_pt2);
                cw = new CodedWord(split2_pt2, soundex, -1);
                newWord = new AddressWord(cw);
                list.add(newWord);
            }
            ArrayList<AddressWord> fullList = new ArrayList<AddressWord>();
            Collections.addAll(fullList, postAddWords);
            fullList.addAll(list);
            AddressWord[] retArray = fullList.toArray(new AddressWord[fullList.size()]);
            parsedAddress.setField(FieldType.STREET_NAME_FIELD_TYPE, retArray);
            parsedAddress.setField(FieldType.POST_ADDRESS_FIELD_TYPE, retArray);
        }
    }

    protected AddressWord[] separateAN1word(AddressWord[] wordsToSearch, int idx, int numCharsToSep) {
        String first = null;
        String other = null;
        int soundexFirst = -1;
        int soundexOther = -1;
        CodedWord cwFirst = null;
        CodedWord cwOther = null;
        AddressWord wordFirst = null;
        AddressWord wordOther = null;
        if (idx > -1 && wordsToSearch[idx].getWordLength() > numCharsToSep + 2) {
            first = wordsToSearch[idx].getWord().substring(0, numCharsToSep);
            other = wordsToSearch[idx].getWord().substring(numCharsToSep);
        }
        if (first != null && other != null) {
            soundexFirst = this.getSoundex().getSoundex(first);
            cwFirst = new CodedWord(first, soundexFirst, -1);
            wordFirst = new AddressWord(cwFirst);
            soundexOther = this.getSoundex().getSoundex(other);
            cwOther = new CodedWord(other, soundexOther, -1);
            wordOther = new AddressWord(cwOther);
            AddressWord[] newWords = new AddressWord[]{wordFirst, wordOther};
            return newWords;
        }
        return null;
    }

    static {
        AREA_IDENTIFIERS.add(Character.valueOf('\u7701'));
        AREA_IDENTIFIERS.add(Character.valueOf('\u5e02'));
        AREA_IDENTIFIERS.add(Character.valueOf('\u533a'));
        AREA_IDENTIFIERS.add(Character.valueOf('\u53bf'));
        AREA_IDENTIFIERS.add(Character.valueOf('\u9547'));
        AREA_IDENTIFIERS = Collections.unmodifiableSet(AREA_IDENTIFIERS);
        STREET_TYPES_SINGLECHAR.add(Character.valueOf('\u8def'));
        STREET_TYPES_SINGLECHAR.add(Character.valueOf('\u8857'));
        STREET_TYPES_SINGLECHAR.add(Character.valueOf('\u6865'));
        STREET_TYPES_SINGLECHAR.add(Character.valueOf('\u9053'));
        STREET_TYPES_SINGLECHAR.add(Character.valueOf('\u5df7'));
        STREET_TYPES_SINGLECHAR = Collections.unmodifiableSet(STREET_TYPES_SINGLECHAR);
        HWY_STREET_TYPES.add(COUNTYHWY);
        HWY_STREET_TYPES.add(PROVINCEHWY);
        HWY_STREET_TYPES.add(TOWNSHIPHWY);
        HWY_STREET_TYPES.add(VILLAGEHWY);
        HWY_STREET_TYPES.add(UNIT_IDENTIFIER_STR);
        HWY_STREET_TYPES = Collections.unmodifiableSet(HWY_STREET_TYPES);
        UNIT_RELATED_CHAR.add(Character.valueOf('\u623f'));
        UNIT_RELATED_CHAR.add(Character.valueOf('\u5ba4'));
        UNIT_RELATED_CHAR.add(Character.valueOf('\u680b'));
        UNIT_RELATED_CHAR.add(Character.valueOf('\u53f7'));
        UNIT_RELATED_CHAR = Collections.unmodifiableSet(UNIT_RELATED_CHAR);
    }
}

