/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.COL.dp.builder.reader.postgresql;

import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.address.AddressFieldValue;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.RawAddress;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.jdbc.postgresql.PostgreSQL_Reader;
import com.mapinfo.midev.geometry.DirectPosition;

public class COL_PostgreSQLReader
extends PostgreSQL_Reader {
    private static final String LEFT_SECOND_KEY = "secondary_street_left";
    private static final String RIGHT_SECOND_KEY = "secondary_street_right";
    private static final String SECOND_STREET_FIELD_NAME = "secondary_street";
    private static final FieldType secondaryFieldType = new FieldType(30, FieldType.FieldLevel.LEVEL_STREET, "secondary_street");

    @Override
    public RawAddress getNextLeftAddress(DirectPosition[] coordinates) {
        RawAddress address = super.getNextLeftAddress(coordinates);
        String leftSecond = this.getFieldValue(LEFT_SECOND_KEY);
        if (leftSecond != null) {
            address.setField((FieldType)additionalFieldNames.get(SECOND_STREET_FIELD_NAME), new AddressFieldValue(leftSecond));
        }
        return address;
    }

    @Override
    public RawAddress getNextRightAddress(DirectPosition[] coordinates) {
        RawAddress address = super.getNextRightAddress(coordinates);
        String rightSecond = this.getFieldValue(RIGHT_SECOND_KEY);
        if (rightSecond != null) {
            address.setField((FieldType)additionalFieldNames.get(SECOND_STREET_FIELD_NAME), new AddressFieldValue(rightSecond));
        }
        return address;
    }

    @Override
    protected boolean considerRightAddress(RawAddress left, RawAddress right) {
        boolean useRight = super.considerRightAddress(left, right);
        if (!useRight && !this.bothValuesSame((AddressFieldValue)left.getField(secondaryFieldType), (AddressFieldValue)right.getField(secondaryFieldType))) {
            return true;
        }
        return useRight;
    }
}

