/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.COL.matcher;

import com.mapinfo.mapmarker.COL.matcher.COLInternalScoringAddressComparator;
import com.mapinfo.mapmarker.COL.utils.COL_Utils;
import com.mapinfo.mapmarker.cgge.CGGEHandler;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.CGGERuntimeException;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.MatchingOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.dp.DataSetInfo;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.matcher.CGGEMatcher1;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParser;
import com.mapinfo.mapmarker.cgge.parser.ICGGEThoroughfareTypeHandler;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class COL_Matcher
extends CGGEMatcher1 {
    public static FieldType secondaryStreetField = FieldType.UNKNOWN_FIELD_TYPE;
    private ICGGEParser m_parser;
    private static final String dirPatString = "(SUD|SUR|OESTE|NORTE|ESTE|NOROESTE|SUROESTE|SUDOESTE|NORESTE|SURESTE|SUDESTE)\\b";
    private static final String dirWithAbbrevsPatString = "(SUD|SUR|OESTE|NORTE|ESTE|NOROESTE|SUROESTE|SUDOESTE|NORESTE|SURESTE|SUDESTE|N|E|O|S|NE|NO|SE|SO)\\b";
    private static final Pattern dirPattern = Pattern.compile("(SUD|SUR|OESTE|NORTE|ESTE|NOROESTE|SUROESTE|SUDOESTE|NORESTE|SURESTE|SUDESTE)\\b", 2);
    private static final Pattern dirPatternWithAbbrevs = Pattern.compile("(SUD|SUR|OESTE|NORTE|ESTE|NOROESTE|SUROESTE|SUDOESTE|NORESTE|SURESTE|SUDESTE|N|E|O|S|NE|NO|SE|SO)\\b", 2);

    @Override
    protected void scoreStreetFields(InternalScoringAddress scoringAddr, ParsedAddress pAddr, MatchingOptions matchingOptions, ICGGEScorer scorer) {
        super.scoreStreetFields(scoringAddr, pAddr, matchingOptions, scorer);
        this.checkSecondaryFieldScore(scoringAddr, pAddr);
    }

    @Override
    public void scoreCandidate(ParsedAddress parsedAddr, InternalScoringAddress addr, MatchingOptions matchingOptions, ICGGEScorer scorer, IDataManager dataManager) throws CGGEInternalException {
        GeocodeOptions options = matchingOptions.getGeocodeOptions();
        if (options.getGeocodeType() == 1 && this.shouldModifyParsedStreet(parsedAddr, addr)) {
            ParsedAddress revParsed = new ParsedAddress("COL", "es");
            revParsed.copy(parsedAddr);
            AddressWord[] parsedSt = (AddressWord[])parsedAddr.getField(FieldType.STREET_NAME_FIELD_TYPE);
            InternalFieldValue ifv = (InternalFieldValue)addr.getField(FieldType.STREET_NAME_FIELD_TYPE);
            AddressWord[] streetWords = (AddressWord[])ifv.getFieldValue();
            AddressWord[] newStreet = new AddressWord[streetWords.length];
            newStreet[0] = parsedSt[0];
            for (int i = 1; i < streetWords.length; ++i) {
                newStreet[i] = streetWords[i];
            }
            revParsed.setField(FieldType.STREET_NAME_FIELD_TYPE, newStreet);
            super.scoreCandidate(revParsed, addr, matchingOptions, scorer, dataManager);
        } else {
            super.scoreCandidate(parsedAddr, addr, matchingOptions, scorer, dataManager);
        }
    }

    void checkSecondaryFieldScore(InternalScoringAddress scoringAddr, ParsedAddress pAddr) {
        Map<FieldType, FieldScore> fieldScores;
        if (COL_Utils.containsSecondaryStreet(pAddr) && (fieldScores = scoringAddr.getFieldScores()) != null) {
            FieldScore secondaryStreetScore = scoringAddr.getFieldScore(secondaryStreetField);
            if (secondaryStreetScore == null) {
                secondaryStreetScore = new FieldScore();
                fieldScores.put(secondaryStreetField, secondaryStreetScore);
            }
            secondaryStreetScore.m_inputFieldPresent = true;
        }
    }

    @Override
    protected void scorePostalFields(InternalScoringAddress scoringAddr, ParsedAddress pAddr, MatchingOptions matchingOptions, ICGGEScorer scorer) {
        super.scorePostalFields(scoringAddr, pAddr, matchingOptions, scorer);
        this.adjustStateLevelScore(scoringAddr);
    }

    void adjustStateLevelScore(InternalScoringAddress scoringAddr) {
        FieldScore areaName3Score = scoringAddr.getFieldScore(FieldType.AREA_NAME_3_FIELD_TYPE);
        FieldScore areaName4Score = scoringAddr.getFieldScore(FieldType.AREA_NAME_4_FIELD_TYPE);
        FieldScore areaName1Score = scoringAddr.getFieldScore(FieldType.AREA_NAME_1_FIELD_TYPE);
        if (areaName3Score == null && areaName1Score != null && areaName4Score == null) {
            areaName1Score.m_value = 0.01;
            Map<FieldType, FieldScore> fieldScores = scoringAddr.getFieldScores();
            fieldScores.put(FieldType.AREA_NAME_1_FIELD_TYPE, areaName1Score);
        }
    }

    @Override
    public MatchingOptions getMatchingOptions(GeocodeOptions options, DataSetInfo dataSetInfo) throws CGGERuntimeException, CGGEInternalException {
        MatchingOptions matchOptions = super.getMatchingOptions(options, dataSetInfo);
        this.setSecondaryStreetName(dataSetInfo);
        return matchOptions;
    }

    @Override
    public boolean calculateCloseMatch(InternalScoringAddress scoringAddr, ParsedAddress parsedAddr, GeocodeOptions options, MatchingOptions matchOptions) throws CGGEInternalException {
        boolean close = super.calculateCloseMatch(scoringAddr, parsedAddr, options, matchOptions);
        FieldScore an3score = scoringAddr.getFieldScore(FieldType.AREA_NAME_3_FIELD_TYPE);
        FieldScore an4score = scoringAddr.getFieldScore(FieldType.AREA_NAME_4_FIELD_TYPE);
        double anCutoff = matchOptions.getAreaFieldCutoff();
        if (options.getGeocodeType() == 1 && close) {
            if (an3score != null && an3score.m_value < anCutoff && (an4score == null || an4score.m_value < anCutoff)) {
                close = false;
            }
            if (close) {
                close = this.doThoroughfareTypesMatch(scoringAddr, parsedAddr);
            }
            if (close) {
                close = this.checkDirAlphasCloseMatch(parsedAddr, scoringAddr, true);
                FieldScore secStScore = scoringAddr.getFieldScore(secondaryStreetField);
                if (close && secStScore != null && secStScore.m_value > 0.0 && !(close = this.checkDirAlphasCloseMatch(parsedAddr, scoringAddr, false))) {
                    scoringAddr.getFieldScore((FieldType)COL_Matcher.secondaryStreetField).m_value = 0.5;
                }
            }
            if (!close) {
                scoringAddr.setCloseMatch(false);
            }
        }
        return close;
    }

    @Override
    public void mergeCandidates(InternalCandidateList candList1, InternalCandidateList candList2) {
        if (candList2 == null) {
            return;
        }
        int candCount1 = candList1.getCandidateCount();
        int candCount2 = candList2.getCandidateCount();
        if (candCount1 == 0) {
            candList1.setCandidateList(candList2.getCandidateList());
            candList1.setNumberOfCloseMatches(candList2.getNumberOfCloseMatches());
        } else if (candCount2 > 0) {
            List<InternalScoringAddress> internalList1 = candList1.getCandidateList();
            List<InternalScoringAddress> internalList2 = candList2.getCandidateList();
            LinkedList<InternalScoringAddress> tempCombinedList = new LinkedList<InternalScoringAddress>(internalList1);
            Comparator<InternalScoringAddress> reverseComparator = MMUtils.getReverseComparator(new COLInternalScoringAddressComparator());
            for (int i = 0; i < candCount2; ++i) {
                InternalScoringAddress scoringAddr = internalList2.get(i);
                int ndx = MMUtils.nextInsertPosition(tempCombinedList, scoringAddr, reverseComparator);
                tempCombinedList.add(ndx, scoringAddr);
            }
            internalList1.clear();
            internalList1.addAll(tempCombinedList);
            candList1.setNumberOfCloseMatches(candList1.getNumberOfCloseMatches() + candList2.getNumberOfCloseMatches());
        }
    }

    private dirAlphaCheckHolder makeStreetWordsCompareString(ParsedAddress parsed, InternalScoringAddress scoringAddress, boolean isPrimary) {
        InternalFieldValue ifv;
        AddressWord[] parsedSt;
        dirAlphaCheckHolder holder = new dirAlphaCheckHolder();
        if (isPrimary) {
            parsedSt = (AddressWord[])parsed.getField(FieldType.STREET_NAME_FIELD_TYPE);
            ifv = (InternalFieldValue)scoringAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
        } else {
            parsedSt = (AddressWord[])parsed.getField(FieldType.GENERIC_FIELD_3_FIELD_TYPE);
            ifv = (InternalFieldValue)scoringAddress.getField(secondaryStreetField);
        }
        AddressWord[] streetWords = (AddressWord[])ifv.getFieldValue();
        StringBuilder sbParsed = new StringBuilder();
        StringBuilder sbISA = new StringBuilder();
        for (AddressWord word : parsedSt) {
            if (CodedWord.isThoroughfareTypeWord(word.getAttributes())) continue;
            sbParsed.append(word.getWord());
            sbParsed.append(" ");
        }
        for (AddressWord word : streetWords) {
            if (CodedWord.isThoroughfareTypeWord(word.getAttributes())) continue;
            sbISA.append(word.getWord());
            sbISA.append(" ");
        }
        String parsedStr = sbParsed.toString().trim();
        String candStr = sbISA.toString().trim();
        holder.setParsedStr(parsedStr);
        holder.setCandStr(candStr);
        return holder;
    }

    private void doScoringDirectionalWork(InternalScoringAddress scoringAddr, dirAlphaCheckHolder holder, boolean scoring) {
        String dirabbrev;
        if (!scoring) {
            return;
        }
        boolean parsedIsAbbrev = false;
        if (!holder.getParsedFullDirMatched() && holder.getDirMatcherFullDirWithAbbrevParsed().find()) {
            parsedIsAbbrev = true;
        }
        if (holder.getParsedFullDirMatched() || parsedIsAbbrev) {
            dirabbrev = parsedIsAbbrev ? holder.getDirMatcherFullDirWithAbbrevParsed().group(1) : (holder.getDirMatcherFullDirParsed().group(1).length() > 2 ? this.getParser().getParserTerms().getAbbreviations(holder.getDirMatcherFullDirParsed().group(1)).get(0) : holder.getDirMatcherFullDirParsed().group(1));
            scoringAddr.setAdditionalInfo("PARSED_HAS_DIR", dirabbrev);
        }
        if (holder.getCandFullDirMatched()) {
            dirabbrev = holder.getDirMatcheFullCand().group(1).length() > 2 ? this.getParser().getParserTerms().getAbbreviations(holder.getDirMatcheFullCand().group(1)).get(0) : holder.getDirMatcheFullCand().group(1);
            scoringAddr.setAdditionalInfo("CAND_HAS_DIR", dirabbrev);
        }
    }

    private boolean checkTheStreetStrings(boolean scoring, dirAlphaCheckHolder holder) {
        boolean didRep = false;
        String parsedStr = holder.getParsedStr();
        String candStr = holder.getCandStr();
        if (holder.getParsedFullDirMatched() && !holder.getCandFullDirMatched()) {
            parsedStr = parsedStr.replace(holder.getDirMatcherFullDirParsed().group(1), this.getParser().getParserTerms().getAbbreviations(holder.getDirMatcherFullDirParsed().group(1)).get(0));
            parsedStr = parsedStr.replaceAll(" ", "");
            didRep = true;
        } else if (!holder.getParsedFullDirMatched() && holder.getCandFullDirMatched()) {
            String dir = holder.getDirMatcheFullCand().group(1);
            candStr = candStr.replace(dir, this.getParser().getParserTerms().getAbbreviations(dir).get(0));
            didRep = true;
        }
        if (didRep && candStr.replaceAll(" ", "").equals(parsedStr.replaceAll(" ", ""))) {
            return true;
        }
        return !scoring && candStr.replaceAll(" ", "").equals(parsedStr.replaceAll(" ", ""));
    }

    protected boolean shouldModifyParsedStreet(ParsedAddress parsed, InternalScoringAddress scoringAddress) {
        dirAlphaCheckHolder holder = this.makeStreetWordsCompareString(parsed, scoringAddress, true);
        holder.setupMatchers();
        this.doScoringDirectionalWork(scoringAddress, holder, true);
        return this.checkTheStreetStrings(true, holder);
    }

    protected boolean checkDirAlphasCloseMatch(ParsedAddress parsed, InternalScoringAddress scoringAddress, boolean isPrimary) {
        dirAlphaCheckHolder holder = this.makeStreetWordsCompareString(parsed, scoringAddress, isPrimary);
        holder.setupMatchers();
        this.doScoringDirectionalWork(scoringAddress, holder, false);
        return this.checkTheStreetStrings(false, holder);
    }

    protected boolean doThoroughfareTypesMatch(InternalScoringAddress addr, ParsedAddress pa) {
        InternalFieldValue fvStreet = (InternalFieldValue)addr.getField(FieldType.STREET_NAME_FIELD_TYPE);
        AddressWord[] candStreetWords = (AddressWord[])fvStreet.getFieldValue();
        AddressWord candTypeWord = null;
        for (AddressWord candStWord : candStreetWords) {
            if (!candStWord.m_wordType.equals(FieldType.POST_THOROUGHFARE_FIELD_TYPE)) continue;
            candTypeWord = candStWord;
            break;
        }
        String inType = null;
        AddressWord[] streetWords = (AddressWord[])pa.getField(FieldType.STREET_NAME_FIELD_TYPE);
        ICGGEThoroughfareTypeHandler typeHandler = this.getParser().getThoroughfareTypeHandler();
        for (AddressWord swParsed : streetWords) {
            String str = swParsed.getWord();
            if (!typeHandler.isThoroughfareType(str)) continue;
            inType = typeHandler.getProperTypeName(str);
            break;
        }
        if (candStreetWords.length == 1 && streetWords.length == 1 && candTypeWord == null && inType != null && candStreetWords[0].getWord().trim().equalsIgnoreCase(streetWords[0].getWord().trim())) {
            return true;
        }
        if (inType == null && candTypeWord != null || inType != null && candTypeWord == null || candTypeWord != null && inType != null && !candTypeWord.getWord().equals(inType)) {
            addr.setCloseMatch(false);
            return false;
        }
        if (candTypeWord != null && inType != null && !candTypeWord.getWord().equals(inType)) {
            addr.setCloseMatch(false);
            return false;
        }
        return true;
    }

    protected ICGGEParser getParser() {
        if (this.m_parser == null) {
            this.m_parser = CGGEHandler.getInstance(this.getDataSetInfo(), "COL", "es").getParser();
        }
        return this.m_parser;
    }

    private void setSecondaryStreetName(DataSetInfo dataSetInfo) {
        FieldType type = dataSetInfo.getMetaData().getFieldForName("secondary_street");
        if (type != null) {
            secondaryStreetField = type;
        }
    }

    private class dirAlphaCheckHolder {
        private String parsedStr;
        private String candStr;
        private Matcher dirMatcherFullDirParsed;
        private Matcher dirMatcherFullDirWithAbbrevParsed;
        private Matcher dirMatcheFullCand;
        boolean parsedFullDirMatched;
        boolean candFullDirMatched;

        private dirAlphaCheckHolder() {
        }

        public void setParsedStr(String strVal) {
            this.parsedStr = strVal;
        }

        public String getParsedStr() {
            return this.parsedStr;
        }

        public void setCandStr(String strVal) {
            this.candStr = strVal;
        }

        public String getCandStr() {
            return this.candStr;
        }

        public void setupMatchers() {
            this.dirMatcherFullDirParsed = dirPattern.matcher(this.parsedStr);
            this.dirMatcherFullDirWithAbbrevParsed = dirPatternWithAbbrevs.matcher(this.parsedStr);
            this.dirMatcheFullCand = dirPattern.matcher(this.candStr);
            this.parsedFullDirMatched = this.dirMatcherFullDirParsed.find();
            this.candFullDirMatched = this.dirMatcheFullCand.find();
        }

        public boolean getParsedFullDirMatched() {
            return this.parsedFullDirMatched;
        }

        public boolean getCandFullDirMatched() {
            return this.candFullDirMatched;
        }

        public Matcher getDirMatcherFullDirParsed() {
            return this.dirMatcherFullDirParsed;
        }

        public Matcher getDirMatcherFullDirWithAbbrevParsed() {
            return this.dirMatcherFullDirWithAbbrevParsed;
        }

        public Matcher getDirMatcheFullCand() {
            return this.dirMatcheFullCand;
        }
    }
}

