/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.COL.utils;

import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.dp.DataSetInfo;
import com.mapinfo.mapmarker.cgge.utils.AddressWordArray;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.utils.StringUtilities;

public class COL_Utils {
    public static final String SECONDARY_STREET_DATA_FIELD_NAME = "secondary_street";
    public static final FieldType SECONDARY_INPUT_FIELD = FieldType.GENERIC_FIELD_3_FIELD_TYPE;

    public static boolean containsSecondaryStreet(ParsedAddress parsedAddress) {
        return !parsedAddress.isEmpty(SECONDARY_INPUT_FIELD);
    }

    public static int getNumericValueOnly(String str) {
        if (!StringUtilities.isEmpty((String)str) && str.matches(".*\\d+.*")) {
            return Integer.parseInt(str.replaceAll("[^0-9]", ""));
        }
        return -1;
    }

    public static String getStartingDigits(AddressWord[] words) {
        if (AddressWordArray.size(words) > 0) {
            return COL_Utils.getStartingDigits(words[0]);
        }
        return null;
    }

    public static String getStartingDigits(AddressWord word) {
        return MMUtils.getStartingNumberPart(word.getWord());
    }

    public static boolean isStreetCandidate(InternalScoringAddress cand) {
        return cand.getDataSetInfo().getGeocodeType() == 1;
    }

    public static FieldType getSecondaryStreetNameField(DataSetInfo dataSetInfo) {
        return dataSetInfo.getMetaData().getFieldForName(SECONDARY_STREET_DATA_FIELD_NAME);
    }

    public static boolean hasSameStartingDigits(AddressWord word1, AddressWord word2) {
        String numStr1 = COL_Utils.getStartingDigits(word1);
        return numStr1 != null && numStr1.equals(COL_Utils.getStartingDigits(word2));
    }
}

