/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.ESP.helper;

import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAddressWord;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAreaSacs;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAreaTermItem;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.helper.AbstractGeocodingHelper;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParser;
import com.mapinfo.mapmarker.cgge.soundex.ICGGESoundex;
import com.mapinfo.mapmarker.cgge.utils.AddressWordArray;
import com.mapinfo.mapmarker.cgge.utils.CGGEResourceBundle;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.cgge.utils.PropertiesUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESPStreetGeocodingHelper
extends AbstractGeocodingHelper {
    static final Logger logger = LoggerFactory.getLogger(ESPStreetGeocodingHelper.class);
    private int m_tryCount;
    protected int m_streetSubTryCount;
    protected int m_areaSubTryCount;
    protected List<DictionaryAreaTermItem> m_pcAreaList;
    protected Map<Integer, List<DictionaryAddressWord>> m_streetTryCaseMap;
    protected Map<Integer, List<DictionaryAreaTermItem>> m_areaTryCaseMap;
    protected List<FieldType> m_areaSacIntersectionFieldList;
    private List<DictionaryAddressWord> m_addressSearchWords;
    public static String KEY_FILTER_CANDIDATES_ON_MATCHED_AREAS = "filter_cands_on_matched_areas";
    public static String KEY_ALLOW_TRANSPOSED_CHARACTER_CHECKS = "allow_transposed_character_checks";
    public static String KEY_ALLOW_MISSING_CHARACTER_CHECKS = "allow_missing_character_checks";
    public static String KEY_ALLOW_WRONG_CHARACTER_CHECKS = "allow_wrong_character_checks";
    public static String KEY_ALLOW_ADDED_CHARACTER_CHECKS = "allow_added_character_checks";
    public static String KEY_ALLOW_MISALIGNED_AN1_AN2_INPUT = "allow_misaligned_an1_an2_input";
    public static String KEY_ALLOW_MISALIGNED_AN1_AN3_INPUT = "allow_misaligned_an1_an3_input";
    public static String KEY_ALLOW_MISALIGNED_AN1_AN4_INPUT = "allow_misaligned_an1_an4_input";
    public static String KEY_ALLOW_MISALIGNED_AN2_AN3_INPUT = "allow_misaligned_an2_an3_input";
    public static String KEY_ALLOW_MISALIGNED_AN2_AN4_INPUT = "allow_misaligned_an2_an4_input";
    public static String KEY_ALLOW_MISALIGNED_AN3_AN4_INPUT = "allow_misaligned_an3_an4_input";
    public static String KEY_ALLOW_SEARCH_ON_SPLIT_WORDS = "allow_search_on_split_words";
    public static String KEY_ALLOW_SEARCH_ON_SPLIT_AREA_WORDS = "allow_search_on_split_area_words";
    public static String KEY_MIN_AREA_SEARCH_WORD_QUALITY = "minimum_area_search_word_quality";
    public static String KEY_MIN_STREET_SEARCH_WORD_QUALITY = "minimum_street_search_word_quality";
    public static String KEY_MIN_POSTCODE_SEARCH_QUALITY = "minimum_post_code_search_quality";
    private double m_minStreetSearchQuality = 0.8;
    private double m_minAreaSearchQuality = 0.75;
    private double m_minPostCodeSearchQuality = 0.85;
    private boolean m_filterCandidateOnMatchedAreas = false;
    private boolean m_allowTransposedCharChecks = true;
    private boolean m_allowMissingCharChecks = true;
    private boolean m_allowWrongCharChecks = true;
    private boolean m_allowAddedCharChecks = true;
    private boolean m_allowMisalignedAn1An2 = false;
    private boolean m_allowMisalignedAn1An3 = false;
    private boolean m_allowMisalignedAn1An4 = false;
    private boolean m_allowMisalignedAn2An3 = false;
    private boolean m_allowMisalignedAn2An4 = false;
    private boolean m_allowMisalignedAn3An4 = false;
    private boolean m_searchOnStreet = true;
    private boolean m_allowSearchOnSplitWord = false;
    private boolean m_allowSearchOnSplitAreaWord = false;
    private static HashMap<String, Properties> m_countryConfigs = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getCountryConfig(String country, String language) {
        StringBuilder sb = new StringBuilder(15);
        if (country != null) {
            sb.append(country);
        }
        sb.append('_');
        if (language != null) {
            sb.append(language);
        }
        String key = sb.toString();
        HashMap<String, Properties> hashMap = m_countryConfigs;
        synchronized (hashMap) {
            Properties prop = m_countryConfigs.get(key);
            if (prop == null) {
                try {
                    prop = CGGEResourceBundle.getBundle("/com/mapinfo/mapmarker/" + country + "/config/" + country + "_StreetGeocodingHelper", language);
                }
                catch (CGGEInternalException e) {
                    prop = new Properties();
                }
                m_countryConfigs.put(key, prop);
            }
            return prop;
        }
    }

    @Override
    public boolean init(String country, String language) {
        super.init(country, language);
        this.setGeocodeType(1);
        this.m_tryCount = 0;
        this.m_streetSubTryCount = 0;
        this.m_areaSubTryCount = 0;
        Properties prop = ESPStreetGeocodingHelper.getCountryConfig(this.getCountry(), this.getLanguage());
        this.m_minStreetSearchQuality = PropertiesUtil.getDoublePropetyValue(prop, KEY_MIN_STREET_SEARCH_WORD_QUALITY, 0.8);
        this.m_minAreaSearchQuality = PropertiesUtil.getDoublePropetyValue(prop, KEY_MIN_AREA_SEARCH_WORD_QUALITY, 0.75);
        this.m_minPostCodeSearchQuality = PropertiesUtil.getDoublePropetyValue(prop, KEY_MIN_POSTCODE_SEARCH_QUALITY, 0.85);
        this.m_filterCandidateOnMatchedAreas = PropertiesUtil.getBooleanPropertyValue(prop, KEY_FILTER_CANDIDATES_ON_MATCHED_AREAS, false);
        this.m_allowTransposedCharChecks = PropertiesUtil.getBooleanPropertyValue(prop, KEY_ALLOW_TRANSPOSED_CHARACTER_CHECKS, true);
        this.m_allowMissingCharChecks = PropertiesUtil.getBooleanPropertyValue(prop, KEY_ALLOW_MISSING_CHARACTER_CHECKS, true);
        this.m_allowWrongCharChecks = PropertiesUtil.getBooleanPropertyValue(prop, KEY_ALLOW_WRONG_CHARACTER_CHECKS, true);
        this.m_allowAddedCharChecks = PropertiesUtil.getBooleanPropertyValue(prop, KEY_ALLOW_ADDED_CHARACTER_CHECKS, true);
        this.m_allowMisalignedAn1An2 = PropertiesUtil.getBooleanPropertyValue(prop, KEY_ALLOW_MISALIGNED_AN1_AN2_INPUT, false);
        this.m_allowMisalignedAn1An3 = PropertiesUtil.getBooleanPropertyValue(prop, KEY_ALLOW_MISALIGNED_AN1_AN3_INPUT, false);
        this.m_allowMisalignedAn1An4 = PropertiesUtil.getBooleanPropertyValue(prop, KEY_ALLOW_MISALIGNED_AN1_AN4_INPUT, false);
        this.m_allowMisalignedAn2An3 = PropertiesUtil.getBooleanPropertyValue(prop, KEY_ALLOW_MISALIGNED_AN2_AN3_INPUT, false);
        this.m_allowMisalignedAn2An4 = PropertiesUtil.getBooleanPropertyValue(prop, KEY_ALLOW_MISALIGNED_AN2_AN4_INPUT, false);
        this.m_allowMisalignedAn3An4 = PropertiesUtil.getBooleanPropertyValue(prop, KEY_ALLOW_MISALIGNED_AN3_AN4_INPUT, true);
        this.m_allowSearchOnSplitWord = PropertiesUtil.getBooleanPropertyValue(prop, KEY_ALLOW_SEARCH_ON_SPLIT_WORDS, false);
        this.m_allowSearchOnSplitAreaWord = PropertiesUtil.getBooleanPropertyValue(prop, KEY_ALLOW_SEARCH_ON_SPLIT_AREA_WORDS, false);
        return true;
    }

    protected boolean findPCAreaList(IDataManager dataManager, ParsedAddress parsedAddr, boolean bPerfectArea, GeocodeOptions options) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        double minQuality = bPerfectArea ? 1.0 : this.m_minPostCodeSearchQuality;
        List<DictionaryAreaTermItem> pcAreaList = super.findPCAreaList(dataManager, parsedAddr, minQuality, options);
        this.m_pcAreaList = pcAreaList;
        return this.m_pcAreaList != null;
    }

    protected List<DictionaryAreaTermItem> getPCAreaList() {
        return this.m_pcAreaList;
    }

    private boolean generateCases(IDataManager dataManager, ParsedAddress parsedAddr, GeocodeOptions options, InternalCandidateList candidateList) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        switch (this.m_tryCount) {
            case 0: {
                ++this.m_tryCount;
                if (this.getSacSearchFields() == null || this.getSacSearchFields() == null) {
                    this.initSacAndStreetSearchFields(dataManager);
                }
                this.generateAreaSubTries(dataManager, parsedAddr, options, candidateList);
                this.generateStreetSubTries(dataManager, parsedAddr, options, candidateList);
                return true;
            }
            case 1: {
                boolean canTry = false;
                do {
                    if (this.generateStreetSubTries(dataManager, parsedAddr, options, candidateList)) {
                        canTry = true;
                    }
                    if (canTry) break;
                    this.m_streetSubTryCount = 0;
                } while (this.generateAreaSubTries(dataManager, parsedAddr, options, candidateList));
                if (canTry) {
                    return true;
                }
                ++this.m_tryCount;
            }
        }
        return false;
    }

    private AddressWord[] filterAreaWords(AddressWord[] areaWords) {
        return this.filterAreaWords(areaWords, true);
    }

    private AddressWord[] filterAreaWords(AddressWord[] areaWords, boolean includeTypes) {
        int wordCount;
        AddressWord[] resultWords = null;
        int n = wordCount = areaWords == null ? 0 : areaWords.length;
        if (wordCount > 0) {
            ArrayList<AddressWord> areaWordList = new ArrayList<AddressWord>(wordCount);
            for (int wordNdx = 0; wordNdx < wordCount; ++wordNdx) {
                AddressWord areaWord = areaWords[wordNdx];
                short wordAttribs = areaWord.getAttributes();
                if (CodedWord.isDelimiter(wordAttribs)) {
                    AddressWord combinedWord;
                    int areaListSize;
                    if (!"%".equals(areaWord.getWord()) || (areaListSize = areaWordList.size()) <= 0) continue;
                    StringBuilder builder = new StringBuilder();
                    builder.append(((AddressWord)areaWordList.get(areaListSize - 1)).getWordChars());
                    builder.append(areaWords[wordNdx + 1].getWordChars());
                    areaWord = combinedWord = this.getHelperParser().convertToAddressWord(builder.toString(), this.getHelperSoundex());
                    areaWordList.set(areaWordList.size() - 1, combinedWord);
                    ++wordNdx;
                    continue;
                }
                if (!includeTypes && CodedWord.isThoroughfareTypeWord(wordAttribs)) continue;
                areaWordList.add(areaWord);
            }
            if (areaWordList.size() > 0) {
                resultWords = areaWordList.toArray(new AddressWord[areaWordList.size()]);
            }
        }
        return resultWords;
    }

    protected boolean generateAreaSubTries(IDataManager dataManager, ParsedAddress parsedAddress, GeocodeOptions options, InternalCandidateList candidateList) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        int currentAreaSize;
        boolean separateAreaFields = parsedAddress.isSeparateAreaFields();
        boolean usePerfectPostcodeAreas = true;
        boolean useImPerfectPostcodeAreas = false;
        boolean pcAndAreaIntersectionFlag = this.m_pcAreaList != null;
        this.m_filterSearchedAreaItemAndWordCombo = true;
        boolean areaSearchWasLocality = false;
        List<DictionaryAreaTermItem> areaList = null;
        switch (this.m_areaSubTryCount) {
            case 0: {
                ++this.m_areaSubTryCount;
                this.m_areaTryCaseMap = new HashMap<Integer, List<DictionaryAreaTermItem>>(15);
                this.findPCAreaList(dataManager, parsedAddress, false, options);
                pcAndAreaIntersectionFlag = this.m_pcAreaList != null;
            }
            case 1: {
                AddressWord[] lookUpAreaWords;
                ++this.m_areaSubTryCount;
                if (this.isSacSearchableField(FieldType.AREA_NAME_3_FIELD_TYPE)) {
                    lookUpAreaWords = null;
                    lookUpAreaWords = separateAreaFields ? (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_3_FIELD_TYPE) : this.filterAreaWords((AddressWord[])parsedAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE));
                    areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_3_FIELD_TYPE, 1.0, dataManager, options);
                }
                pcAndAreaIntersectionFlag = false;
                break;
            }
            case 2: {
                ++this.m_areaSubTryCount;
                if (!this.isSacSearchableField(FieldType.AREA_NAME_3_FIELD_TYPE)) break;
                AddressWord[] lookUpAreaWords = null;
                lookUpAreaWords = separateAreaFields ? (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_3_FIELD_TYPE) : this.filterAreaWords((AddressWord[])parsedAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE));
                areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_3_FIELD_TYPE, 1.0, dataManager, options);
                useImPerfectPostcodeAreas = false;
                break;
            }
            case 3: {
                ++this.m_areaSubTryCount;
                if (!this.isSacSearchableField(FieldType.AREA_NAME_4_FIELD_TYPE)) break;
                AddressWord[] lookUpAreaWords = null;
                lookUpAreaWords = separateAreaFields ? (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_4_FIELD_TYPE) : this.filterAreaWords((AddressWord[])parsedAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE));
                areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_4_FIELD_TYPE, 1.0, dataManager, options);
                areaSearchWasLocality = true;
                break;
            }
            case 4: {
                AddressWord[] lookUpAreaWords;
                ++this.m_areaSubTryCount;
                if (!separateAreaFields || !this.m_allowMisalignedAn3An4 || (this.m_pcAreaList == null || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)) && this.doesBestCandidateHasGoodStreetScore(candidateList) && (this.doesBestCandidateHasPerfectAreaField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE, parsedAddress) || this.doesBestCandidateHasPerfectAreaField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE, parsedAddress))) break;
                if (this.isSacSearchableField(FieldType.AREA_NAME_4_FIELD_TYPE) && (lookUpAreaWords = (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_3_FIELD_TYPE)) != null) {
                    areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_4_FIELD_TYPE, 1.0, dataManager, options);
                }
                if (this.isSacSearchableField(FieldType.AREA_NAME_3_FIELD_TYPE) && (lookUpAreaWords = (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_4_FIELD_TYPE)) != null) {
                    List<DictionaryAreaTermItem> list = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_3_FIELD_TYPE, 1.0, dataManager, options);
                    if (areaList == null) {
                        areaList = list;
                    } else if (list != null && list.size() > 0) {
                        areaList.addAll(list);
                    }
                }
                areaSearchWasLocality = true;
                break;
            }
            case 5: {
                AddressWord[] lookUpAreaWords;
                ++this.m_areaSubTryCount;
                if (!separateAreaFields || !this.m_allowMisalignedAn1An2 || (this.m_pcAreaList == null || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE))) break;
                if (this.isSacSearchableField(FieldType.AREA_NAME_1_FIELD_TYPE) && (lookUpAreaWords = (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_2_FIELD_TYPE)) != null) {
                    areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_1_FIELD_TYPE, 1.0, dataManager, options);
                }
                if (!this.isSacSearchableField(FieldType.AREA_NAME_2_FIELD_TYPE) || (lookUpAreaWords = (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_1_FIELD_TYPE)) == null) break;
                List<DictionaryAreaTermItem> list = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_2_FIELD_TYPE, 1.0, dataManager, options);
                if (areaList == null) {
                    areaList = list;
                    break;
                }
                if (list == null || list.size() <= 0) break;
                areaList.addAll(list);
                break;
            }
            case 6: {
                List<DictionaryAreaTermItem> areaList1;
                AddressWord[] lookUpAreaWords;
                ++this.m_areaSubTryCount;
                if (this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE))) break;
                for (FieldType fieldType : this.getSacSearchFields()) {
                    if (fieldType == FieldType.AREA_NAME_3_FIELD_TYPE || fieldType == FieldType.AREA_NAME_4_FIELD_TYPE || fieldType == FieldType.POST_CODE_FIELD_TYPE) continue;
                    lookUpAreaWords = null;
                    lookUpAreaWords = separateAreaFields ? this.filterAreaWords((AddressWord[])parsedAddress.getField(fieldType)) : this.filterAreaWords((AddressWord[])parsedAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE));
                    if (lookUpAreaWords == null) continue;
                    areaList1 = dataManager.findAreaTerms(1, lookUpAreaWords, fieldType, 1.0, options);
                    if (areaList == null) {
                        areaList = areaList1;
                        continue;
                    }
                    if (areaList1 == null) continue;
                    areaList.addAll(areaList1);
                }
                pcAndAreaIntersectionFlag = false;
                break;
            }
            case 7: {
                List<DictionaryAreaTermItem> areaList1;
                AddressWord[] lookUpAreaWords;
                ++this.m_areaSubTryCount;
                if (this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE))) break;
                for (FieldType fieldType : this.getSacSearchFields()) {
                    if (fieldType == FieldType.AREA_NAME_3_FIELD_TYPE || fieldType == FieldType.AREA_NAME_4_FIELD_TYPE || fieldType == FieldType.POST_CODE_FIELD_TYPE) continue;
                    lookUpAreaWords = null;
                    lookUpAreaWords = separateAreaFields ? this.filterAreaWords((AddressWord[])parsedAddress.getField(fieldType)) : this.filterAreaWords((AddressWord[])parsedAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE));
                    if (lookUpAreaWords == null) continue;
                    areaList1 = dataManager.findAreaTerms(1, lookUpAreaWords, fieldType, this.m_minAreaSearchQuality, options);
                    if (areaList == null) {
                        areaList = areaList1;
                        continue;
                    }
                    if (areaList1 == null) continue;
                    areaList.addAll(areaList1);
                }
                pcAndAreaIntersectionFlag = false;
                break;
            }
            case 8: {
                AddressWord[] lookUpAreaWords;
                ++this.m_areaSubTryCount;
                if (!separateAreaFields || !this.m_allowMisalignedAn1An3 || (this.m_pcAreaList == null || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_1_FIELD_TYPE))) break;
                if (this.isSacSearchableField(FieldType.AREA_NAME_3_FIELD_TYPE) && (lookUpAreaWords = (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_1_FIELD_TYPE)) != null) {
                    areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_3_FIELD_TYPE, 1.0, dataManager, options);
                }
                if (!this.isSacSearchableField(FieldType.AREA_NAME_1_FIELD_TYPE) || (lookUpAreaWords = (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_3_FIELD_TYPE)) == null) break;
                List<DictionaryAreaTermItem> list = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_1_FIELD_TYPE, 1.0, dataManager, options);
                if (areaList == null) {
                    areaList = list;
                    break;
                }
                if (list == null || list.size() <= 0) break;
                areaList.addAll(list);
                break;
            }
            case 9: {
                AddressWord[] lookUpAreaWords;
                ++this.m_areaSubTryCount;
                if (!separateAreaFields || !this.m_allowMisalignedAn1An4 || (this.m_pcAreaList == null || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_1_FIELD_TYPE))) break;
                if (this.isSacSearchableField(FieldType.AREA_NAME_4_FIELD_TYPE) && (lookUpAreaWords = (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_1_FIELD_TYPE)) != null) {
                    areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_4_FIELD_TYPE, 1.0, dataManager, options);
                }
                if (!this.isSacSearchableField(FieldType.AREA_NAME_1_FIELD_TYPE) || (lookUpAreaWords = (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_4_FIELD_TYPE)) == null) break;
                List<DictionaryAreaTermItem> list = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_1_FIELD_TYPE, 1.0, dataManager, options);
                if (areaList == null) {
                    areaList = list;
                    break;
                }
                if (list == null || list.size() <= 0) break;
                areaList.addAll(list);
                break;
            }
            case 10: {
                AddressWord[] lookUpAreaWords;
                ++this.m_areaSubTryCount;
                if (!separateAreaFields || !this.m_allowMisalignedAn2An3 || (this.m_pcAreaList == null || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_1_FIELD_TYPE))) break;
                if (this.isSacSearchableField(FieldType.AREA_NAME_3_FIELD_TYPE) && (lookUpAreaWords = (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_2_FIELD_TYPE)) != null) {
                    areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_3_FIELD_TYPE, 1.0, dataManager, options);
                }
                if (!this.isSacSearchableField(FieldType.AREA_NAME_2_FIELD_TYPE) || (lookUpAreaWords = (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_3_FIELD_TYPE)) == null) break;
                List<DictionaryAreaTermItem> list = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_2_FIELD_TYPE, 1.0, dataManager, options);
                if (areaList == null) {
                    areaList = list;
                    break;
                }
                if (list == null || list.size() <= 0) break;
                areaList.addAll(list);
                break;
            }
            case 11: {
                AddressWord[] lookUpAreaWords;
                ++this.m_areaSubTryCount;
                if (!separateAreaFields || !this.m_allowMisalignedAn2An4 || (this.m_pcAreaList == null || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_1_FIELD_TYPE))) break;
                if (this.isSacSearchableField(FieldType.AREA_NAME_4_FIELD_TYPE) && (lookUpAreaWords = (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_2_FIELD_TYPE)) != null) {
                    areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_4_FIELD_TYPE, 1.0, dataManager, options);
                }
                if (!this.isSacSearchableField(FieldType.AREA_NAME_2_FIELD_TYPE) || (lookUpAreaWords = (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_4_FIELD_TYPE)) == null) break;
                List<DictionaryAreaTermItem> list = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_2_FIELD_TYPE, 1.0, dataManager, options);
                if (areaList == null) {
                    areaList = list;
                    break;
                }
                if (list == null || list.size() <= 0) break;
                areaList.addAll(list);
                break;
            }
            case 12: {
                ++this.m_areaSubTryCount;
                if ((this.m_pcAreaList == null || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE)) || this.m_pcAreaList == null) break;
                pcAndAreaIntersectionFlag = false;
                this.m_filterSearchedAreaItemAndWordCombo = false;
                usePerfectPostcodeAreas = true;
                break;
            }
            case 13: {
                ++this.m_areaSubTryCount;
                if ((this.m_pcAreaList == null || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE)) || this.m_pcAreaList == null) break;
                pcAndAreaIntersectionFlag = false;
                this.m_filterSearchedAreaItemAndWordCombo = false;
                usePerfectPostcodeAreas = false;
                useImPerfectPostcodeAreas = true;
                break;
            }
            case 14: {
                ++this.m_areaSubTryCount;
                if ((this.m_pcAreaList == null || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)) && this.doesBestCandidateHasGoodStreetScore(candidateList) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE)) || this.m_pcAreaList == null) break;
                pcAndAreaIntersectionFlag = false;
                usePerfectPostcodeAreas = false;
                useImPerfectPostcodeAreas = false;
                areaList = this.m_areaTryCaseMap.get(new Integer(1));
                this.m_filterSearchedAreaItemAndWordCombo = false;
                break;
            }
            case 15: {
                ++this.m_areaSubTryCount;
                if ((this.m_pcAreaList == null || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)) && this.doesBestCandidateHasGoodStreetScore(candidateList) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE)) || this.m_pcAreaList == null) break;
                pcAndAreaIntersectionFlag = false;
                usePerfectPostcodeAreas = false;
                useImPerfectPostcodeAreas = false;
                areaList = this.m_areaTryCaseMap.get(new Integer(2));
                this.m_filterSearchedAreaItemAndWordCombo = false;
                break;
            }
            case 16: {
                ++this.m_areaSubTryCount;
                if ((this.m_pcAreaList == null || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE)) || this.m_pcAreaList == null) break;
                pcAndAreaIntersectionFlag = false;
                usePerfectPostcodeAreas = false;
                useImPerfectPostcodeAreas = false;
                areaList = this.m_areaTryCaseMap.get(new Integer(3));
                this.m_filterSearchedAreaItemAndWordCombo = false;
                break;
            }
            case 17: {
                ++this.m_areaSubTryCount;
                if ((this.m_pcAreaList == null || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE)) || this.m_pcAreaList == null) break;
                pcAndAreaIntersectionFlag = false;
                usePerfectPostcodeAreas = false;
                useImPerfectPostcodeAreas = false;
                areaList = this.m_areaTryCaseMap.get(new Integer(4));
                this.m_filterSearchedAreaItemAndWordCombo = false;
                break;
            }
            case 18: {
                ++this.m_areaSubTryCount;
                if ((this.m_pcAreaList == null || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE)) || this.m_pcAreaList == null) break;
                pcAndAreaIntersectionFlag = false;
                usePerfectPostcodeAreas = false;
                useImPerfectPostcodeAreas = false;
                areaList = this.m_areaTryCaseMap.get(new Integer(5));
                this.m_filterSearchedAreaItemAndWordCombo = false;
                break;
            }
            case 19: {
                ++this.m_areaSubTryCount;
                if ((this.m_pcAreaList == null || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE)) || this.m_pcAreaList == null) break;
                pcAndAreaIntersectionFlag = false;
                usePerfectPostcodeAreas = false;
                useImPerfectPostcodeAreas = false;
                areaList = this.m_areaTryCaseMap.get(new Integer(6));
                this.m_filterSearchedAreaItemAndWordCombo = false;
                break;
            }
            case 20: {
                ++this.m_areaSubTryCount;
                if ((this.m_pcAreaList == null || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE)) || this.m_pcAreaList == null) break;
                pcAndAreaIntersectionFlag = false;
                usePerfectPostcodeAreas = false;
                useImPerfectPostcodeAreas = false;
                areaList = this.m_areaTryCaseMap.get(new Integer(7));
                this.m_filterSearchedAreaItemAndWordCombo = false;
                break;
            }
            case 21: {
                ++this.m_areaSubTryCount;
                if ((this.m_pcAreaList == null || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE)) || this.m_pcAreaList == null) break;
                pcAndAreaIntersectionFlag = false;
                usePerfectPostcodeAreas = false;
                useImPerfectPostcodeAreas = false;
                areaList = this.m_areaTryCaseMap.get(new Integer(8));
                this.m_filterSearchedAreaItemAndWordCombo = false;
                break;
            }
            case 22: {
                ++this.m_areaSubTryCount;
                if ((this.m_pcAreaList == null || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE)) || this.m_pcAreaList == null) break;
                pcAndAreaIntersectionFlag = false;
                usePerfectPostcodeAreas = false;
                useImPerfectPostcodeAreas = false;
                areaList = this.m_areaTryCaseMap.get(new Integer(9));
                this.m_filterSearchedAreaItemAndWordCombo = false;
                break;
            }
            case 23: {
                AddressWord[] lookUpAreaWords;
                ++this.m_areaSubTryCount;
                if (!((this.m_pcAreaList == null && this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE)) || !this.isSacSearchableField(FieldType.AREA_NAME_3_FIELD_TYPE))) {
                    lookUpAreaWords = null;
                    lookUpAreaWords = separateAreaFields ? (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_3_FIELD_TYPE) : this.filterAreaWords((AddressWord[])parsedAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE));
                    areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_3_FIELD_TYPE, this.m_minAreaSearchQuality, dataManager, options);
                }
                pcAndAreaIntersectionFlag = false;
                usePerfectPostcodeAreas = false;
                useImPerfectPostcodeAreas = false;
                break;
            }
            case 24: {
                AddressWord[] lookUpAreaWords;
                ++this.m_areaSubTryCount;
                if ((this.m_pcAreaList != null && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE) || !this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE)) && this.m_pcAreaList != null && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE)) && this.isSacSearchableField(FieldType.AREA_NAME_4_FIELD_TYPE)) {
                    lookUpAreaWords = null;
                    lookUpAreaWords = separateAreaFields ? (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_4_FIELD_TYPE) : this.filterAreaWords((AddressWord[])parsedAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE));
                    areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_4_FIELD_TYPE, this.m_minAreaSearchQuality, dataManager, options);
                }
                pcAndAreaIntersectionFlag = false;
                usePerfectPostcodeAreas = false;
                useImPerfectPostcodeAreas = false;
                break;
            }
            case 25: {
                AddressWord[] lookUpAreaWords;
                ++this.m_areaSubTryCount;
                if ((this.m_pcAreaList != null && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE) || !this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE)) && this.isSacSearchableField(FieldType.AREA_NAME_4_FIELD_TYPE) && (lookUpAreaWords = (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_3_FIELD_TYPE)) != null) {
                    areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_4_FIELD_TYPE, this.m_minAreaSearchQuality, dataManager, options);
                }
                pcAndAreaIntersectionFlag = false;
                usePerfectPostcodeAreas = false;
                useImPerfectPostcodeAreas = false;
                break;
            }
            case 26: {
                AddressWord[] lookUpAreaWords;
                ++this.m_areaSubTryCount;
                if ((this.m_pcAreaList != null && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE) || !this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE)) && this.isSacSearchableField(FieldType.AREA_NAME_3_FIELD_TYPE) && (lookUpAreaWords = (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_4_FIELD_TYPE)) != null) {
                    areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_3_FIELD_TYPE, this.m_minAreaSearchQuality, dataManager, options);
                }
                pcAndAreaIntersectionFlag = false;
                usePerfectPostcodeAreas = false;
                useImPerfectPostcodeAreas = false;
                break;
            }
            case 27: {
                List<DictionaryAreaTermItem> areaList1;
                AddressWord[] lookUpAreaWords;
                ++this.m_areaSubTryCount;
                if (this.m_pcAreaList != null && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE) || !this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE)) {
                    for (FieldType fieldType : this.getSacSearchFields()) {
                        if (fieldType == FieldType.AREA_NAME_3_FIELD_TYPE && fieldType == FieldType.AREA_NAME_4_FIELD_TYPE) continue;
                        lookUpAreaWords = this.filterAreaWords((AddressWord[])parsedAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE));
                        lookUpAreaWords = separateAreaFields ? this.filterAreaWords((AddressWord[])parsedAddress.getField(fieldType)) : this.filterAreaWords((AddressWord[])parsedAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE));
                        if (lookUpAreaWords == null) continue;
                        areaList1 = dataManager.findAreaTerms(1, lookUpAreaWords, fieldType, 1.0, options);
                        if (areaList == null) {
                            areaList = areaList1;
                            continue;
                        }
                        if (areaList1 == null) continue;
                        areaList.addAll(areaList1);
                    }
                }
                pcAndAreaIntersectionFlag = false;
                usePerfectPostcodeAreas = false;
                useImPerfectPostcodeAreas = false;
                break;
            }
            case 28: {
                List<DictionaryAreaTermItem> areaList1;
                AddressWord[] lookUpAreaWords;
                ++this.m_areaSubTryCount;
                if (this.m_allowSearchOnSplitAreaWord) {
                    if ((this.m_pcAreaList != null && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE) || !this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE)) && separateAreaFields) {
                        for (FieldType fieldType : this.getSacSearchFields()) {
                            lookUpAreaWords = this.getSplitWords((AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_3_FIELD_TYPE));
                            areaList1 = dataManager.findAreaTerms(1, lookUpAreaWords, fieldType, 1.0, options);
                            if (areaList == null) {
                                areaList = areaList1;
                                continue;
                            }
                            if (areaList1 == null) continue;
                            areaList.addAll(areaList1);
                        }
                    }
                    pcAndAreaIntersectionFlag = false;
                    usePerfectPostcodeAreas = false;
                    useImPerfectPostcodeAreas = false;
                    break;
                }
            }
            case 29: {
                AddressWord[] lookUpAreaWords;
                ++this.m_areaSubTryCount;
                if (this.isSacSearchableField(FieldType.AREA_NAME_3_FIELD_TYPE)) {
                    lookUpAreaWords = null;
                    if (separateAreaFields && parsedAddress != null && parsedAddress.getFields() != null) {
                        for (FieldType key : parsedAddress.getFields().keySet()) {
                            if (key == null || !key.toString().equalsIgnoreCase("shortAN3")) continue;
                            lookUpAreaWords = (AddressWord[])parsedAddress.getFields().get(key);
                            parsedAddress.setField(FieldType.AREA_NAME_3_FIELD_TYPE, lookUpAreaWords);
                        }
                    } else {
                        lookUpAreaWords = this.filterAreaWords((AddressWord[])parsedAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE));
                    }
                    areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_3_FIELD_TYPE, 1.0, dataManager, options);
                }
                pcAndAreaIntersectionFlag = false;
                break;
            }
            default: {
                this.setSearchAreaList(null);
                return false;
            }
        }
        if (areaList != null && areaList.size() > 0) {
            ArrayList savedAreaList = new ArrayList(areaList);
            this.m_areaTryCaseMap.put(this.m_areaSubTryCount - 1, savedAreaList);
        } else {
            this.m_areaTryCaseMap.put(this.m_areaSubTryCount - 1, areaList);
        }
        int n = currentAreaSize = areaList == null ? 0 : areaList.size();
        if (this.m_pcAreaList != null && (usePerfectPostcodeAreas || useImPerfectPostcodeAreas)) {
            if (areaList == null) {
                areaList = new ArrayList<DictionaryAreaTermItem>(5);
            }
            for (DictionaryAreaTermItem pcArea : this.m_pcAreaList) {
                if (pcArea.m_quality >= 1.0) {
                    if (!usePerfectPostcodeAreas) continue;
                    areaList.add(pcArea);
                    continue;
                }
                if (!useImPerfectPostcodeAreas) continue;
                areaList.add(pcArea);
            }
        } else if (areaList != null && !usePerfectPostcodeAreas && !useImPerfectPostcodeAreas) {
            Iterator<DictionaryAreaTermItem> iterator = areaList.iterator();
            while (iterator.hasNext()) {
                DictionaryAreaTermItem dt = iterator.next();
                if (dt.getFieldType() != FieldType.POST_CODE_FIELD_TYPE) continue;
                iterator.remove();
            }
        }
        if (pcAndAreaIntersectionFlag) {
            int n2 = areaList == null ? 0 : areaList.size();
            boolean bl = pcAndAreaIntersectionFlag = n2 > currentAreaSize;
        }
        if (this.m_areaSacIntersectionFieldList == null) {
            this.m_areaSacIntersectionFieldList = new ArrayList<FieldType>(2);
        }
        this.m_areaSacIntersectionFieldList.clear();
        if (pcAndAreaIntersectionFlag) {
            this.m_areaSacIntersectionFieldList.add(FieldType.POST_CODE_FIELD_TYPE);
            if (areaSearchWasLocality) {
                this.m_areaSacIntersectionFieldList.add(FieldType.AREA_NAME_4_FIELD_TYPE);
            } else {
                this.m_areaSacIntersectionFieldList.add(FieldType.AREA_NAME_3_FIELD_TYPE);
            }
        }
        if (areaList != null && areaList.size() > 0) {
            this.setSearchAreaList(areaList);
        } else {
            this.setSearchAreaList(null);
        }
        return true;
    }

    protected boolean doesBestCandidateHasPerfectField(InternalCandidateList candList, FieldType type) {
        InternalScoringAddress candAddr;
        FieldScore score;
        return candList != null && candList.getCandidateCount() > 0 && (score = (candAddr = candList.getIndexedCandidate(0)).getFieldScore(type)) != null && score.m_value >= 1.0;
    }

    protected boolean doesBestCandidateHasPerfectAreaField(InternalCandidateList candList, FieldType type, ParsedAddress parsedAddr) {
        AddressWord[] inputWords;
        IntArray matchedInputWords;
        InternalScoringAddress candAddr;
        FieldScore score;
        if (candList != null && candList.getCandidateCount() > 0 && (score = (candAddr = candList.getIndexedCandidate(0)).getFieldScore(type)) != null && score.m_value >= 1.0 && parsedAddr.isSeparateAreaFields() && (matchedInputWords = score.m_matchedInputWords) != null && (inputWords = score.m_inputWords) != null) {
            int len = inputWords.length;
            for (int wordNdx = 0; wordNdx < inputWords.length; ++wordNdx) {
                AddressWord word = inputWords[wordNdx];
                if (CodedWord.isDelimiter(word.getAttributes()) || word.getSoundex() <= 0 || matchedInputWords.contains(wordNdx)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean doesBestCandidateHasGoodStreetScore(InternalCandidateList candList) {
        InternalScoringAddress candAddr;
        return candList != null && candList.getCandidateCount() > 0 && (candAddr = candList.getIndexedCandidate(0)).getCombinedStreetScore() > 0.6;
    }

    private AddressWord[] filterWordsInAreaList(AddressWord[] words, List<DictionaryAreaTermItem> areaList) {
        if (words != null && words.length > 0 && areaList != null && areaList.size() > 0) {
            int removed = 0;
            Iterator<DictionaryAreaTermItem> it = areaList.iterator();
            int wc = words.length;
            while (it.hasNext()) {
                DictionaryAreaTermItem areaItem = it.next();
                if (!(areaItem.m_quality >= 1.0)) continue;
                DictionaryAddressWord[] searchedWords = areaItem.getMatchedWords();
                int wc1 = searchedWords == null ? 0 : searchedWords.length;
                block1: for (int i = 0; i < wc1; ++i) {
                    DictionaryAddressWord searchWord = searchedWords[i];
                    if (searchWord == null) continue;
                    for (int j = 0; j < wc; ++j) {
                        if (words[j] == null || searchWord.getSearchWord() != words[j]) continue;
                        words[j] = null;
                        ++removed;
                        continue block1;
                    }
                }
            }
            if (removed > 0) {
                int remaining = wc - removed;
                if (remaining > 0) {
                    AddressWord[] filterdWords = new AddressWord[remaining];
                    int added = 0;
                    for (int j = 0; j < wc; ++j) {
                        if (words[j] == null) continue;
                        filterdWords[added++] = words[j];
                    }
                    return filterdWords;
                }
                return null;
            }
        }
        return words;
    }

    protected boolean generateStreetSubTriesForIntersection(IDataManager dataManager, ParsedAddress parsedAddress, GeocodeOptions options, InternalCandidateList candidateList) throws CGGEInternalException, DataNotInitialisedException, DataFetchException {
        switch (this.m_streetSubTryCount) {
            case 0: {
                ++this.m_streetSubTryCount;
                List<DictionaryAddressWord> searchWordList = this.getSearchableWords((AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE), FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.m_minStreetSearchQuality, options);
                this.setSearchWordList(searchWordList);
                return true;
            }
        }
        return false;
    }

    @Override
    public List<DictionaryAddressWord> getSearchableWordsOnSplitInputWords(AddressWord[] inWords, FieldType searchType, double minQuality, IDataManager dataManager, GeocodeOptions options) throws CGGEInternalException, DataNotInitialisedException, DataFetchException {
        if (inWords != null) {
            AddressWord[] newSearchWords = this.getSplitWords(inWords);
            return this.getSearchableWords(newSearchWords, searchType, dataManager, minQuality, options);
        }
        return null;
    }

    private boolean setSavedSearchWordForSubTry(int trycase) {
        if (this.m_streetTryCaseMap != null && this.m_streetTryCaseMap.containsKey(trycase)) {
            this.setSearchWordList(this.m_streetTryCaseMap.get(trycase));
            return true;
        }
        return false;
    }

    protected boolean generateStreetSubTries(IDataManager dataManager, ParsedAddress parsedAddress, GeocodeOptions options, InternalCandidateList candidateList) throws CGGEInternalException, DataNotInitialisedException, DataFetchException {
        if (parsedAddress.isIntersectionCase() || parsedAddress.isNearByFeature()) {
            return this.generateStreetSubTriesForIntersection(dataManager, parsedAddress, options, candidateList);
        }
        AddressWord[] searchWords = null;
        List<DictionaryAddressWord> searchWordList = null;
        if (this.m_streetTryCaseMap == null) {
            this.m_streetTryCaseMap = new HashMap<Integer, List<DictionaryAddressWord>>(9);
        }
        switch (this.m_streetSubTryCount) {
            case 0: {
                ++this.m_streetSubTryCount;
                if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                    return true;
                }
                this.m_searchOnStreet = this.isAddressSearchableField(FieldType.STREET_NAME_FIELD_TYPE);
                if (this.m_searchOnStreet) {
                    this.m_searchOnStreet = parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE) != null;
                    AddressWord[] streetWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
                    AddressWord[] filteredWords = this.filterSearchWords(streetWords, true, 0);
                    this.m_addressSearchWords = this.getSearchableWords(filteredWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.m_minStreetSearchQuality, options);
                    searchWordList = this.filterSearchWords(this.m_addressSearchWords, true, 0);
                    break;
                }
            }
            case 1: {
                ++this.m_streetSubTryCount;
                if (this.m_searchOnStreet) {
                    if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                        return true;
                    }
                    this.m_searchOnStreet = parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE) != null;
                    AddressWord[] streetWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
                    AddressWord[] filteredWords = this.filterSearchWords(streetWords, false, 12);
                    List<DictionaryAddressWord> searchableWords = this.getSearchableWords(filteredWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.m_minStreetSearchQuality, options);
                    if (this.m_addressSearchWords != null) {
                        if (searchableWords != null) {
                            this.m_addressSearchWords.addAll(searchableWords);
                        }
                    } else {
                        this.m_addressSearchWords = searchableWords;
                    }
                    searchWordList = this.filterSearchWords(this.m_addressSearchWords, true, 1792);
                    break;
                }
            }
            case 2: {
                ++this.m_streetSubTryCount;
                if (this.m_searchOnStreet) {
                    if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                        return true;
                    }
                    AddressWord[] streetWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
                    AddressWord[] filteredWords = this.filterSearchWords(streetWords, false, 256);
                    List<DictionaryAddressWord> searchableWords = this.getSearchableWords(filteredWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.m_minStreetSearchQuality, options);
                    if (this.m_addressSearchWords != null) {
                        if (searchableWords != null) {
                            this.m_addressSearchWords.addAll(searchableWords);
                        }
                    } else {
                        this.m_addressSearchWords = searchableWords;
                    }
                    searchWordList = this.filterSearchWords(searchableWords, true, 1536);
                    break;
                }
            }
            case 3: {
                ++this.m_streetSubTryCount;
                if (this.m_searchOnStreet) {
                    if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                        return true;
                    }
                    AddressWord[] streetWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
                    AddressWord[] filteredWords = this.filterSearchWords(streetWords, false, 2560);
                    List<DictionaryAddressWord> searchableWords = this.getSearchableWords(filteredWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.m_minStreetSearchQuality, options);
                    if (this.m_addressSearchWords != null) {
                        if (searchableWords != null) {
                            this.m_addressSearchWords.addAll(searchableWords);
                        }
                    } else {
                        this.m_addressSearchWords = searchableWords;
                    }
                    searchWordList = this.filterSearchWords(searchableWords, true, 1024);
                    break;
                }
            }
            case 4: {
                ++this.m_streetSubTryCount;
                if (this.m_searchOnStreet) {
                    if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                        return true;
                    }
                    AddressWord[] words = this.getCombinedPossibles((AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE));
                    searchWords = this.filterSearchWords(words, true, 0);
                    searchWordList = this.getSearchableWords(searchWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, 1.0, options);
                    break;
                }
            }
            case 5: {
                ++this.m_streetSubTryCount;
                if (!this.m_searchOnStreet || this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE))) break;
                if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                    return true;
                }
                searchWordList = this.filterSearchWords(this.m_addressSearchWords, false, 1792);
                break;
            }
            case 6: {
                ++this.m_streetSubTryCount;
                if (!this.m_searchOnStreet || this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE))) break;
                if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                    return true;
                }
                AddressWord[] words = this.getCombinedPossibles((AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE));
                searchWords = this.filterSearchWords(words, true, 0);
                searchWordList = this.getSearchableWords(searchWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.m_minStreetSearchQuality, options);
                break;
            }
            case 7: {
                ++this.m_streetSubTryCount;
                if (this.m_searchOnStreet) {
                    if (!this.m_allowWrongCharChecks || this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE))) break;
                    if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                        return true;
                    }
                    AddressWord[] words = this.filterSearchWords((AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE), true, 0);
                    if (words == null) break;
                    ArrayList<AddressWord> list = new ArrayList<AddressWord>(10);
                    for (int i = 0; i < words.length; ++i) {
                        AddressWord codedWord = words[i];
                        List<AddressWord> l = this.makeAlternateWords(codedWord, 16);
                        if (l == null) continue;
                        list.addAll(l);
                    }
                    if (list.size() <= 0) break;
                    searchWords = list.toArray(new AddressWord[list.size()]);
                    searchWordList = this.getSearchableWords(searchWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.m_minStreetSearchQuality, options);
                    break;
                }
            }
            case 8: {
                ++this.m_streetSubTryCount;
                if (this.m_searchOnStreet && this.m_allowTransposedCharChecks && (!this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) || !this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE) && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE))) {
                    if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                        return true;
                    }
                    AddressWord[] words = this.filterSearchWords((AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE), true, 0);
                    if (words == null) break;
                    ArrayList<AddressWord> list = new ArrayList<AddressWord>(10);
                    for (int i = 0; i < words.length; ++i) {
                        AddressWord codedWord = words[i];
                        List<AddressWord> l = this.makeAlternateWords(codedWord, 8);
                        if (l == null) continue;
                        list.addAll(l);
                    }
                    if (list.size() <= 0) break;
                    searchWords = list.toArray(new AddressWord[list.size()]);
                    searchWordList = this.getSearchableWords(searchWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.m_minStreetSearchQuality, options);
                    break;
                }
            }
            case 9: {
                List<DictionaryAreaTermItem> areaList;
                ++this.m_streetSubTryCount;
                if (this.m_searchOnStreet && this.m_allowAddedCharChecks && this.m_areaSubTryCount < 24 && (!this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) || !this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE) && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE))) {
                    areaList = this.getSearchAreaList();
                    if (this.m_areaSubTryCount < 16 || this.hasGoodQualityAreas(areaList, 0.9)) {
                        if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                            return true;
                        }
                        AddressWord[] words = this.filterSearchWords((AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE), true, 0);
                        if ((words = this.filterWordsInAreaList(words, areaList)) == null) break;
                        ArrayList<AddressWord> list = new ArrayList<AddressWord>(10);
                        for (int i = 0; i < words.length; ++i) {
                            AddressWord codedWord = words[i];
                            List<AddressWord> l = this.makeAlternateWords(codedWord, 4);
                            if (l == null) continue;
                            list.addAll(l);
                        }
                        if (list.size() <= 0) break;
                        searchWords = list.toArray(new AddressWord[list.size()]);
                        searchWordList = this.getSearchableWords(searchWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.m_minStreetSearchQuality, options);
                        break;
                    }
                }
            }
            case 10: {
                List<DictionaryAreaTermItem> areaList;
                ++this.m_streetSubTryCount;
                if (this.m_searchOnStreet && this.m_allowMissingCharChecks && this.m_areaSubTryCount < 24 && (!this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) || !this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE) && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE))) {
                    areaList = this.getSearchAreaList();
                    if (this.m_areaSubTryCount < 16 || this.hasGoodQualityAreas(areaList, 0.9)) {
                        if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                            return true;
                        }
                        AddressWord[] words = this.filterSearchWords((AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE), true, 0);
                        if ((words = this.filterWordsInAreaList(words, areaList)) == null) break;
                        ArrayList<AddressWord> list = new ArrayList<AddressWord>(10);
                        for (int i = 0; i < words.length; ++i) {
                            AddressWord codedWord = words[i];
                            List<AddressWord> l = this.makeAlternateWords(codedWord, 2);
                            if (l == null) continue;
                            list.addAll(l);
                        }
                        if (list.size() <= 0) break;
                        searchWords = list.toArray(new AddressWord[list.size()]);
                        searchWordList = this.getSearchableWords(searchWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.m_minStreetSearchQuality, options);
                        break;
                    }
                }
            }
            case 11: {
                ++this.m_streetSubTryCount;
                if (this.m_searchOnStreet && this.m_areaSubTryCount < 16) {
                    if (this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE))) break;
                    if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                        return true;
                    }
                    searchWordList = this.filterSearchWords(this.m_addressSearchWords, true, 2828);
                    break;
                }
            }
            case 12: {
                ++this.m_streetSubTryCount;
                if (this.m_searchOnStreet && this.m_allowSearchOnSplitWord) {
                    if (this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE))) break;
                    if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                        return true;
                    }
                    searchWordList = this.getSearchableWordsOnSplitInputWords((AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE), FieldType.STREET_NAME_FIELD_TYPE, 1.0, dataManager, options);
                    break;
                }
            }
            case 13: {
                ++this.m_streetSubTryCount;
                if (this.m_searchOnStreet && this.m_allowSearchOnSplitWord) {
                    if (this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE))) break;
                    if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                        return true;
                    }
                    searchWordList = this.getSearchableWordsOnSplitInputWords((AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE), FieldType.STREET_NAME_FIELD_TYPE, 0.95, dataManager, options);
                    break;
                }
            }
            case 14: {
                ++this.m_streetSubTryCount;
                if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                    return true;
                }
                List<FieldType> streetSearchFields = this.getAddressSearchFields();
                if (streetSearchFields != null) {
                    for (FieldType searchType : streetSearchFields) {
                        if (searchType == FieldType.STREET_NAME_FIELD_TYPE) continue;
                        searchWords = null;
                        if (searchType.getLevel() == FieldType.FieldLevel.LEVEL_POSTAL) {
                            if (searchType == FieldType.POST_CODE_FIELD_TYPE) {
                                searchWords = (AddressWord[])parsedAddress.getField(FieldType.POST_CODE_FIELD_TYPE);
                            }
                            if (searchWords == null) {
                                searchWords = parsedAddress.isSeparateAreaFields() ? (AddressWord[])parsedAddress.getField(searchType) : (AddressWord[])parsedAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
                            }
                        } else {
                            searchWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
                        }
                        if (searchWords == null) continue;
                        List<DictionaryAddressWord> list = this.getSearchableWords(searchWords, searchType, dataManager, 1.0, options);
                        if (searchWordList == null) {
                            searchWordList = list;
                            continue;
                        }
                        if (list == null) continue;
                        searchWordList.addAll(list);
                    }
                    break;
                }
            }
            case 15: {
                ++this.m_streetSubTryCount;
                if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                    return true;
                }
                List<FieldType> streetSearchFields = this.getAddressSearchFields();
                if (streetSearchFields != null) {
                    for (FieldType searchType : streetSearchFields) {
                        if (searchType == FieldType.STREET_NAME_FIELD_TYPE) continue;
                        searchWords = null;
                        if (searchType.getLevel() == FieldType.FieldLevel.LEVEL_POSTAL) {
                            if (searchType == FieldType.POST_CODE_FIELD_TYPE) {
                                searchWords = (AddressWord[])parsedAddress.getField(FieldType.POST_CODE_FIELD_TYPE);
                            }
                            if (searchWords == null) {
                                searchWords = parsedAddress.isSeparateAreaFields() ? (AddressWord[])parsedAddress.getField(searchType) : (AddressWord[])parsedAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
                            }
                        } else {
                            searchWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
                        }
                        if (searchWords == null) continue;
                        List<DictionaryAddressWord> list = this.getSearchableWords(searchWords, searchType, dataManager, this.m_minStreetSearchQuality, options);
                        if (searchWordList == null) {
                            searchWordList = list;
                            continue;
                        }
                        if (list == null) continue;
                        searchWordList.addAll(list);
                    }
                    break;
                }
            }
            case 16: {
                List<DictionaryAreaTermItem> areaList;
                ++this.m_streetSubTryCount;
                if (this.m_searchOnStreet && this.m_allowAddedCharChecks && this.m_areaSubTryCount < 24 && (!this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) || !this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE) && !this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE))) {
                    areaList = this.getSearchAreaList();
                    if (this.m_areaSubTryCount < 16 || this.hasGoodQualityAreas(areaList, 0.9)) {
                        int i;
                        short wordAttribs;
                        if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                            return true;
                        }
                        AddressWord[] words = this.filterSearchWords((AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE), true, 12);
                        AddressWord[] word = new AddressWord[26];
                        boolean isSingleNumber = false;
                        if (words != null && words.length == 1 && CodedWord.isNumber(wordAttribs = words[0].getAttributes())) {
                            isSingleNumber = true;
                            for (i = 0; i < 26; ++i) {
                                CodedWord cod = new CodedWord(words[0].getWord(), 65 + i, -1);
                                word[i] = new AddressWord(cod);
                            }
                        }
                        if (!isSingleNumber || (words = this.filterWordsInAreaList(word, areaList)) == null) break;
                        ArrayList<AddressWord> list = new ArrayList<AddressWord>(10);
                        for (i = 0; i < word.length; ++i) {
                            list.add(word[i]);
                        }
                        if (list.size() <= 0) break;
                        searchWords = list.toArray(new AddressWord[list.size()]);
                        searchWordList = this.getSearchableWords(searchWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.m_minStreetSearchQuality, options);
                        break;
                    }
                }
            }
            default: {
                return false;
            }
        }
        this.m_streetTryCaseMap.put(this.m_streetSubTryCount - 1, searchWordList);
        this.setSearchWordList(searchWordList);
        return true;
    }

    private boolean hasGoodQualityAreas(List<DictionaryAreaTermItem> areaList, double minimumQuality) {
        if (areaList != null) {
            for (DictionaryAreaTermItem areaItem : areaList) {
                if (!(areaItem.m_quality >= minimumQuality)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public InternalCandidateList searchNextCase(IDataManager dataManager, ParsedAddress parsedAddress, GeocodeOptions options, InternalCandidateList curCandList) throws CGGEInternalException, DataFetchException, DataNotInitialisedException {
        if (this.continueRetrying(parsedAddress, curCandList)) {
            if (this.generateCases(dataManager, parsedAddress, options, curCandList)) {
                return this.retrieveCandidates(dataManager, parsedAddress, this.getSearchAreaList(), this.getSearchWordList(), options);
            }
            this.finishRetries();
        } else {
            this.finishRetries();
        }
        return null;
    }

    protected InternalCandidateList retrieveCandidates(IDataManager dataManager, ParsedAddress parsedAddress, List<DictionaryAreaTermItem> areaList, List<DictionaryAddressWord> searchWordList, GeocodeOptions options) throws CGGEInternalException, DataFetchException, DataNotInitialisedException {
        InternalCandidateList candList = null;
        if (areaList != null && searchWordList != null) {
            Collection<InternalScoringAddress> cands;
            areaList = new ArrayList<DictionaryAreaTermItem>(areaList);
            searchWordList = new ArrayList<DictionaryAddressWord>(searchWordList);
            this.filterSearchedAreaItemAndSearchWord(areaList, searchWordList);
            List<DictionaryAreaSacs> areaSacList = dataManager.getSacsForAreas(1, areaList, options);
            if (areaSacList != null && this.m_areaSacIntersectionFieldList != null && this.m_areaSacIntersectionFieldList.size() > 0) {
                this.filterSacsForAreaIntersection(areaSacList, this.m_areaSacIntersectionFieldList);
            }
            if (areaSacList != null) {
                this.filterSearchedSacs(areaSacList, searchWordList);
            }
            if (areaSacList != null && (cands = dataManager.findCandidates(this.getGeocodeType(), areaSacList, searchWordList, options)) != null) {
                candList = new InternalCandidateList();
                candList.addCandidates(cands);
            }
        }
        return candList;
    }

    private boolean containsAreaType(List<DictionaryAreaTermItem> areaList, FieldType type) {
        if (areaList != null) {
            for (DictionaryAreaTermItem areaItem : areaList) {
                if (areaItem.getFieldType() != type) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean continueRetrying(ParsedAddress pAddr, InternalCandidateList currentList) {
        int closeMatchCount;
        int n = closeMatchCount = currentList == null ? 0 : currentList.getNumberOfCloseMatches();
        if (pAddr.isIntersectionCase()) {
            if (closeMatchCount > 1) {
                for (int candNdx = 0; candNdx < closeMatchCount - 1; ++candNdx) {
                    InternalScoringAddress cand1 = currentList.getIndexedCandidate(candNdx);
                    FieldScore streetScore1 = cand1.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
                    if (streetScore1 == null || streetScore1.m_matchedInputWords == null) continue;
                    int firstMatchedWord1 = streetScore1.m_matchedInputWords.min();
                    int lastMatchedWord1 = streetScore1.m_matchedInputWords.max();
                    for (int candNdx1 = candNdx + 1; candNdx1 < closeMatchCount; ++candNdx1) {
                        InternalScoringAddress cand2 = currentList.getIndexedCandidate(candNdx1);
                        FieldScore streetScore2 = cand2.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
                        if (streetScore2 == null || streetScore2.m_matchedInputWords == null) continue;
                        int firstMatchedWord2 = streetScore2.m_matchedInputWords.min();
                        int lastMatchedWord2 = streetScore2.m_matchedInputWords.max();
                        if (lastMatchedWord2 >= firstMatchedWord1 && firstMatchedWord2 <= lastMatchedWord1) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        if (closeMatchCount > 0) {
            InternalScoringAddress cand = currentList.getIndexedCandidate(0);
            if (!pAddr.isSeperatePostAddressFields() && this.m_areaSubTryCount < 5 && this.m_streetSubTryCount < 4) {
                FieldScore score = cand.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
                if (score != null && score.m_value < 0.8) {
                    return true;
                }
                List<DictionaryAreaTermItem> areaList = this.getSearchAreaList();
                if (this.containsAreaType(areaList, FieldType.POST_CODE_FIELD_TYPE) && ((score = cand.getFieldScore(FieldType.POST_CODE_FIELD_TYPE)) == null || score.m_value < 0.8)) {
                    return true;
                }
                if (this.containsAreaType(areaList, FieldType.AREA_NAME_3_FIELD_TYPE) && ((score = cand.getFieldScore(FieldType.AREA_NAME_3_FIELD_TYPE)) == null || score.m_value < 0.8)) {
                    return true;
                }
            }
            List<AddressWord> searchWords = cand.getSearchWords();
            for (AddressWord searchWord : searchWords) {
                if (!AddressWord.isSignificantWord(searchWord)) {
                    FieldScore score = cand.getFieldScore(searchWord.m_wordType);
                    if (score == null || !(score.m_value > 0.9)) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    @Override
    protected AddressWord[] filterSearchWords(AddressWord[] words, boolean includeNormalWords, int includeMask) {
        return this.filterSearchWords(words, includeNormalWords, false, includeMask);
    }

    @Override
    protected AddressWord[] filterSearchWords(AddressWord[] words, boolean includeNormalWords, boolean combineAlphaNumeric, int includeMask) {
        return this.filterSearchWords(words, includeNormalWords, combineAlphaNumeric, true, includeMask);
    }

    @Override
    protected AddressWord[] filterSearchWords(AddressWord[] words, boolean includeNormalWords, boolean combineAlphaNumeric, boolean noMultipleStreetTypeFiltering, int includeMask) {
        int wordsLen;
        AddressWord[] retAddressWords = null;
        int n = wordsLen = words == null ? 0 : words.length;
        if (wordsLen > 0) {
            if (wordsLen == 1) {
                retAddressWords = AddressWordArray.clone(words);
            } else {
                ICGGEParser parser = this.getHelperParser();
                ICGGESoundex soundex = this.getHelperSoundex();
                boolean containsTypeSeparator = false;
                ArrayList<AddressWord> filteredWordList = new ArrayList<AddressWord>(wordsLen);
                int typeCount = 0;
                if (noMultipleStreetTypeFiltering) {
                    for (int wordNdx = 0; wordNdx < wordsLen; ++wordNdx) {
                        AddressWord addrWord = words[wordNdx];
                        if (!CodedWord.isThoroughfareTypeWord(addrWord.getAttributes())) continue;
                        ++typeCount;
                    }
                }
                boolean filterTypes = typeCount < 2 && (includeMask & 0x200) != 512;
                boolean filterCommonWord = (includeMask & 0x100) != 256;
                boolean filterArticles = (includeMask & 0x400) != 1024;
                boolean filterNumbers = (includeMask & 4) != 4;
                boolean filterNumerics = (includeMask & 8) != 8;
                for (int wordNdx = 0; wordNdx < wordsLen; ++wordNdx) {
                    boolean isNormalWord;
                    AddressWord addrWord = words[wordNdx];
                    short wordAttribs = addrWord.getAttributes();
                    boolean filter = true;
                    if (CodedWord.isDelimiter(wordAttribs)) {
                        if (!"%".equals(addrWord.getWord())) continue;
                        containsTypeSeparator = true;
                        continue;
                    }
                    boolean bl = isNormalWord = !CodedWord.isNumber(wordAttribs) && !CodedWord.isNumeric(wordAttribs) && !CodedWord.isProbableRomanNumeral(wordAttribs) && !CodedWord.isThoroughfareTypeWord(wordAttribs) && !CodedWord.isArticleWord(wordAttribs) && !CodedWord.isCommonWord(wordAttribs) && !MMUtils.containsDigits(addrWord.getWordChars());
                    if (isNormalWord) {
                        if (includeNormalWords) {
                            filter = false;
                        }
                    } else {
                        if (!filterNumbers && CodedWord.isNumber(wordAttribs)) {
                            filter = false;
                        }
                        if (!filterNumerics && (CodedWord.isNumeric(wordAttribs) || CodedWord.isProbableRomanNumeral(wordAttribs) || MMUtils.containsDigits(addrWord.getWordChars()))) {
                            filter = false;
                        }
                        if (!filterTypes && CodedWord.isThoroughfareTypeWord(wordAttribs)) {
                            filter = false;
                        }
                        if (!filterArticles && CodedWord.isArticleWord(wordAttribs)) {
                            filter = false;
                        }
                        if (!filterCommonWord && CodedWord.isCommonWord(wordAttribs)) {
                            filter = false;
                        }
                    }
                    if (filter) continue;
                    filteredWordList.add(addrWord);
                }
                if (containsTypeSeparator) {
                    StringBuilder builder = new StringBuilder();
                    for (int searchWordNdx = 1; searchWordNdx < wordsLen - 1; ++searchWordNdx) {
                        AddressWord searchWord = words[searchWordNdx];
                        if (!CodedWord.isDelimiter(searchWord.getAttributes()) || !"%".equals(searchWord.getWord())) continue;
                        builder.append(words[searchWordNdx - 1].getWord());
                        builder.append(words[searchWordNdx + 1].getWord());
                        filteredWordList.add(parser.convertToAddressWord(builder.toString(), soundex));
                        builder.delete(0, builder.length());
                    }
                }
                if (combineAlphaNumeric) {
                    StringBuilder builder = new StringBuilder();
                    for (int wordNdx = 1; wordNdx < wordsLen; ++wordNdx) {
                        AddressWord preWord;
                        AddressWord word = words[wordNdx];
                        if (!CodedWord.isNumber(word.getAttributes()) || CodedWord.isNumber((preWord = words[wordNdx - 1]).getAttributes()) || CodedWord.isDelimiter(preWord.getAttributes())) continue;
                        builder.append(preWord.getWordChars());
                        builder.append(word.getWordChars());
                        filteredWordList.add(parser.convertToAddressWord(builder.toString(), soundex));
                        builder.delete(0, builder.length());
                        ++wordNdx;
                    }
                }
                if (filteredWordList.size() > 0) {
                    retAddressWords = filteredWordList.toArray(new AddressWord[filteredWordList.size()]);
                }
            }
        }
        return retAddressWords;
    }

    private List<AddressWord> makeAlternateWords(AddressWord addrWord, int altSoundexMask) {
        int altSoundCount;
        ICGGESoundex soundex = this.getHelperSoundex();
        int[] altsoundes = soundex.getAlternateSoundexes(addrWord.getWord(), altSoundexMask);
        int n = altSoundCount = altsoundes == null ? 0 : altsoundes.length;
        if (altSoundCount > 0) {
            ArrayList<AddressWord> list = new ArrayList<AddressWord>(altSoundCount);
            for (int j = 0; j < altSoundCount; ++j) {
                CodedWord altCodedWord = new CodedWord(addrWord.getCodedWord());
                altCodedWord.setSoundex(altsoundes[j]);
                AddressWord altWord = new AddressWord(addrWord);
                altWord.setCodedWord(altCodedWord);
                list.add(altWord);
            }
            return list;
        }
        return null;
    }

    protected double getMinimumAreaSearchQuality() {
        return this.m_minAreaSearchQuality;
    }

    protected double getMinimumStreetSearchQuality() {
        return this.m_minStreetSearchQuality;
    }

    protected double getMinimumPostCodeSearchQuality() {
        return this.m_minPostCodeSearchQuality;
    }

    protected List<DictionaryAddressWord> getAddressSearchWordList() {
        return this.m_addressSearchWords;
    }

    protected void setAddressSearchWordList(List<DictionaryAddressWord> addressSearchWordList) {
        this.m_addressSearchWords = addressSearchWordList;
    }
}

