/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.ESP.matcher;

import com.mapinfo.mapmarker.ESP.address.ESP_ParsedAddress;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.CGGERuntimeException;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.MatchingOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.IDictionaryMetaData;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.matcher.CGGEInternalScoringAddressComparator;
import com.mapinfo.mapmarker.cgge.matcher.CGGEMatcher1;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class ESPMatcher
extends CGGEMatcher1 {
    @Override
    protected void scoreStreetFields(InternalScoringAddress scoringAddr, ParsedAddress pAddr, MatchingOptions matchingOptions, ICGGEScorer scorer) {
        int i;
        super.scoreStreetFields(scoringAddr, pAddr, matchingOptions, scorer);
        if (pAddr.isIntersectionCase()) {
            return;
        }
        AddressWord candThoroughfare = null;
        AddressWord inputThoroughfare = null;
        double adjustScoreForThoroughfareMatch = 0.0;
        double adjustScoreForNearSignificantWordsMatch = 0.0;
        int countWordInInput = 0;
        AddressWord[] inpAddressWords = (AddressWord[])pAddr.getField(FieldType.STREET_NAME_FIELD_TYPE);
        InternalFieldValue ifv = (InternalFieldValue)scoringAddr.getField(FieldType.STREET_NAME_FIELD_TYPE);
        if (null == ifv || null == inpAddressWords) {
            return;
        }
        AddressWord[] streetAddressWords = (AddressWord[])ifv.getFieldValue();
        FieldScore score = scoringAddr.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
        for (i = 0; i < streetAddressWords.length; ++i) {
            short wordAttribs;
            AddressWord streetWord = streetAddressWords[i];
            String word = streetWord.getWord();
            if (AddressWord.isSignificantWord(streetWord) || !CodedWord.isThoroughfareTypeWord(wordAttribs = streetWord.getAttributes())) continue;
            candThoroughfare = streetWord;
        }
        for (i = 0; i < streetAddressWords.length; ++i) {
            boolean applyPenalty = true;
            AddressWord streetWord = streetAddressWords[i];
            String word = streetWord.getWord();
            if (!AddressWord.isSignificantWord(streetWord)) {
                short wordAttribs = streetWord.getAttributes();
                if (!CodedWord.isThoroughfareTypeWord(wordAttribs)) continue;
                candThoroughfare = streetWord;
            }
            for (AddressWord addressWord : inpAddressWords) {
                String searchWord = addressWord.getWord();
                short wordAttribs = addressWord.getAttributes();
                if (AddressWord.isSignificantWord(addressWord) && StringUtilities.findFirstNumeric((String)addressWord.getWord()) != 0) {
                    ++countWordInInput;
                }
                if (AddressWord.isSignificantWord(streetWord) && AddressWord.isSignificantWord(addressWord) && scorer.scoreAddressWords(streetWord, addressWord) > 0.9 && scorer.scoreAddressWords(streetWord, addressWord) < 1.0) {
                    adjustScoreForNearSignificantWordsMatch += 0.002;
                }
                if (CodedWord.isThoroughfareTypeWord(wordAttribs)) {
                    inputThoroughfare = addressWord;
                }
                if (!searchWord.contains(word)) continue;
                applyPenalty = false;
            }
            if (inputThoroughfare != null) {
                adjustScoreForThoroughfareMatch = candThoroughfare != null ? (candThoroughfare.equals(inputThoroughfare) || candThoroughfare.getWord().equals(inputThoroughfare.getWord()) || candThoroughfare.isRelatedWord(inputThoroughfare) ? (adjustScoreForThoroughfareMatch += 0.02) : (adjustScoreForThoroughfareMatch -= 0.02)) : (adjustScoreForThoroughfareMatch -= 0.03);
            }
            if (score == null || !applyPenalty) continue;
            score.m_value -= 0.001;
        }
        if (score != null) {
            AddressWord searchWord;
            short searchWordAttribs;
            score.m_value += adjustScoreForThoroughfareMatch;
            score.m_value += adjustScoreForNearSignificantWordsMatch;
            if (score.m_value >= 1.0) {
                score.m_matched = true;
                score.m_value /= 1.0 + adjustScoreForThoroughfareMatch + adjustScoreForNearSignificantWordsMatch;
            }
            if (scoringAddr.getSearchWords() != null && !scoringAddr.getSearchWords().isEmpty() && scoringAddr.getSearchWords().size() == 1 && (CodedWord.isNumber(searchWordAttribs = (searchWord = scoringAddr.getSearchWords().get(0)).getAttributes()) || CodedWord.isNumeric(searchWordAttribs)) && countWordInInput > 0 && pAddr.isSeperatePostAddressFields()) {
                score.m_value = 0.02;
            }
        }
    }

    public double calculateCombinedAddressScoreBeforeOrderingCandidates(InternalScoringAddress scoringAddr, MatchingOptions matchOptions) {
        Collection<FieldScore> fscores;
        double scorePossible = matchOptions.getPostAddressWeight();
        scorePossible += matchOptions.getStreetAddressWeight();
        scorePossible += matchOptions.getRangeAddressWeight();
        double score = scoringAddr.getCombinedPostalScore() * matchOptions.getPostAddressWeight();
        score += scoringAddr.getCombinedStreetScore() * matchOptions.getStreetAddressWeight();
        if (scoringAddr.getRangeCount() > 0) {
            score += scoringAddr.getRangeAt(0).getCombinedScore() * matchOptions.getRangeAddressWeight();
        }
        if (scorePossible > 0.0) {
            score /= scorePossible;
        }
        if ((fscores = scoringAddr.getFieldScoreList()) != null) {
            for (FieldScore fieldScore : fscores) {
                if (fieldScore == null || fieldScore.m_value != 1.0) continue;
                score += 0.001;
            }
        }
        FieldScore an3Score = scoringAddr.getFieldScore(FieldType.AREA_NAME_3_FIELD_TYPE);
        FieldScore pcScore = scoringAddr.getFieldScore(FieldType.POST_CODE_FIELD_TYPE);
        if (null != an3Score && an3Score.m_value < 0.5 && scoringAddr.getCombinedPostalScore() < 0.75 && null != pcScore && pcScore.m_value != 1.0) {
            score = 0.02;
        }
        scoringAddr.setCombinedScore(score);
        return score;
    }

    @Override
    public int matchAndOrderCandidates(ParsedAddress parsedAddress, InternalCandidateList candList, GeocodeOptions options, IDataManager dataManager) throws CGGERuntimeException, CGGEInternalException {
        List<InternalScoringAddress> internalList = candList == null ? null : candList.getCandidateList();
        int candCount = internalList == null ? 0 : internalList.size();
        int closeMatchCount = 0;
        LinkedList<InternalScoringAddress> sortedCands = new LinkedList<InternalScoringAddress>();
        if (candCount > 0) {
            CGGEInternalScoringAddressComparator c = new CGGEInternalScoringAddressComparator();
            Comparator<InternalScoringAddress> reverseComparator = MMUtils.getReverseComparator(c);
            for (int i = 0; i < candCount; ++i) {
                InternalScoringAddress scoringAddr = internalList.get(i);
                int geoType = scoringAddr.getAddressType();
                IDictionaryMetaData metaData = dataManager.getMetaData(scoringAddr.getDataSetInfo());
                MatchingOptions matchOptions = this.getMatchingOptions(options, scoringAddr.getDataSetInfo());
                this.calculateCombinedAddressScoreBeforeOrderingCandidates(scoringAddr, matchOptions);
                if (this.calculateCloseMatch(scoringAddr, parsedAddress, options, matchOptions)) {
                    String mustMatch2DigitPostCode = options.getGeocodeConstraints().getCustomString("MustMatch2DigitPostcode");
                    if (!StringUtilities.isEmpty((String)mustMatch2DigitPostCode) && Boolean.parseBoolean(mustMatch2DigitPostCode)) {
                        String candidatePostCode;
                        InternalFieldValue key = (InternalFieldValue)scoringAddr.getFields().get(FieldType.POST_CODE_FIELD_TYPE);
                        if (key != null && !StringUtilities.isEmpty((String)(candidatePostCode = key.toString())) && candidatePostCode.length() > 2) {
                            ESP_ParsedAddress espParsedAddress;
                            String firstTwoDigitCandidatePostCode = candidatePostCode.substring(0, 2);
                            if (firstTwoDigitCandidatePostCode.equalsIgnoreCase((espParsedAddress = (ESP_ParsedAddress)parsedAddress).getTwoDigitPostcode())) {
                                ++closeMatchCount;
                            } else {
                                scoringAddr.setCloseMatch(false);
                            }
                        }
                    } else {
                        ++closeMatchCount;
                    }
                }
                int ndx = MMUtils.nextInsertPosition(sortedCands, scoringAddr, reverseComparator);
                sortedCands.add(ndx, scoringAddr);
            }
            internalList.clear();
            internalList.addAll(sortedCands);
            this.orderHNRMatchCandOnTopIfStreetNonPerfectMatch(parsedAddress, candList);
            candList.setNumberOfCloseMatches(closeMatchCount);
        }
        return closeMatchCount;
    }

    protected void orderHNRMatchCandOnTopIfStreetNonPerfectMatch(ParsedAddress parsedAddress, InternalCandidateList candList) {
        int candCount;
        List<InternalScoringAddress> internalList = candList == null ? null : candList.getCandidateList();
        int n = candCount = internalList == null ? 0 : internalList.size();
        if (!parsedAddress.isSeperatePostAddressFields()) {
            return;
        }
        LinkedList sortedCands = new LinkedList();
        HashMap<String, AddressWord> map = new HashMap<String, AddressWord>();
        boolean inputHasCommonWords = false;
        int countWordInInput = 0;
        AddressWord[] inpAddressWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
        if (inpAddressWords == null) {
            return;
        }
        for (AddressWord addressWord : inpAddressWords) {
            short wordAttribs = addressWord.getAttributes();
            String inpCommonWord = addressWord.getWord();
            if (AddressWord.isSignificantWord(addressWord) || CodedWord.isThoroughfareTypeWord(wordAttribs)) {
                ++countWordInInput;
            }
            if (!CodedWord.isCommonWord(wordAttribs) && !CodedWord.isArticleWord(wordAttribs)) continue;
            map.put(inpCommonWord, addressWord);
            inputHasCommonWords = true;
        }
        if (candCount > 0) {
            AddressWord[] topCandWords;
            InternalScoringAddress scoringAddrFirstCand = internalList.get(0);
            if (scoringAddrFirstCand.getRangeAt(0).isCloseMatch()) {
                return;
            }
            double maxCombinedScore = scoringAddrFirstCand.getCombinedScore();
            double maxPostalScore = scoringAddrFirstCand.getCombinedPostalScore();
            FieldScore score = scoringAddrFirstCand.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
            InternalFieldValue ifv = (InternalFieldValue)scoringAddrFirstCand.getField(FieldType.STREET_NAME_FIELD_TYPE);
            if (null == ifv) {
                return;
            }
            for (AddressWord addressWord : topCandWords = (AddressWord[])ifv.getFieldValue()) {
                String candCommonWord = addressWord.getWord();
                short wordAttribs = addressWord.getAttributes();
                if (!CodedWord.isCommonWord(wordAttribs) && !CodedWord.isArticleWord(wordAttribs)) continue;
                map.remove(candCommonWord);
            }
            if (inputHasCommonWords && map.isEmpty()) {
                return;
            }
            boolean goodStreetScore = false;
            if (score != null && score.m_value > 0.98) {
                goodStreetScore = true;
            }
            for (int i = 1; i < candCount; ++i) {
                FieldScore streetScore;
                boolean isCandHasCommonWords;
                InternalScoringAddress scoringAddr = internalList.get(i);
                if (scoringAddr.getCombinedPostalScore() < 0.75) {
                    return;
                }
                double combinedScore = scoringAddr.getCombinedPostalScore();
                if (!scoringAddr.getRangeAt(0).isCloseMatch() || !(maxPostalScore - combinedScore < 0.05) || ESPMatcher.logicalXOR(inputHasCommonWords, isCandHasCommonWords = this.candidateHasCommonWords(scoringAddr)) && (inputHasCommonWords || countWordInInput != 1) || (streetScore = scoringAddr.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE)) != null && goodStreetScore && streetScore.m_value < 0.97) continue;
                scoringAddr.setCombinedScore(maxCombinedScore + 0.001);
                internalList.remove(i);
                internalList.add(0, scoringAddr);
                break;
            }
        }
    }

    private boolean candidateHasCommonWords(InternalScoringAddress scoringAddr) {
        InternalFieldValue ifv = (InternalFieldValue)scoringAddr.getField(FieldType.STREET_NAME_FIELD_TYPE);
        if (null == ifv) {
            return false;
        }
        AddressWord[] streetAddressWords = (AddressWord[])ifv.getFieldValue();
        for (int i = 0; i < streetAddressWords.length; ++i) {
            short wordAttribs = streetAddressWords[i].getAttributes();
            if (!CodedWord.isCommonWord(wordAttribs) && !CodedWord.isArticleWord(wordAttribs) || streetAddressWords.length <= 3) continue;
            return true;
        }
        return false;
    }

    public static boolean logicalXOR(boolean x, boolean y) {
        return !(!x && !y || x && y);
    }
}

