/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.GBR;

import com.mapinfo.mapmarker.GBR.GBR_Utils;
import com.mapinfo.mapmarker.cgge.CGGEDataIntializationException;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringRange;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataManager;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.utils.CandidateS3Determinator;
import java.util.List;
import java.util.Map;

public class GBRCandidateOrderAdjuster {
    private final IDataManager dm = DataManager.getInstance("GBR");
    private final InternalCandidateList internalCandList;

    GBRCandidateOrderAdjuster(InternalCandidateList candList) throws CGGEDataIntializationException {
        this.internalCandList = candList;
    }

    boolean adjustS8OverS5() throws DataFetchException, CGGEDataIntializationException {
        int pointCandNdx;
        if (this.dm.getDictionaryCount() > 1 && (pointCandNdx = this.getFirstAddressPointCand(this.internalCandList)) > 0 && this.isPointCandComparableToRangeCand(this.internalCandList.getIndexedCandidate(pointCandNdx), this.internalCandList.getIndexedCandidate(0))) {
            this.moveCandToTopAndDegradeOthers(pointCandNdx, this.internalCandList);
            return true;
        }
        return false;
    }

    boolean adjustS3CandidateRank() throws CGGEDataIntializationException, DataFetchException {
        int nonS3CandNdx;
        if (this.dm.getDictionaryCount() > 1 && (nonS3CandNdx = this.getFirstNonS3CloseCandNdx(this.internalCandList)) > 0 && this.isComparableToS3Cand(this.internalCandList.getIndexedCandidate(0), this.internalCandList.getIndexedCandidate(nonS3CandNdx))) {
            this.moveCandToTopAndDegradeOthers(nonS3CandNdx, this.internalCandList);
            return true;
        }
        return false;
    }

    private boolean isPointCandComparableToRangeCand(InternalScoringAddress pointCand, InternalScoringAddress rangeCand) {
        if (pointCand.getMatchedRange() != null) {
            int comp = this.compareExactPostCodeAndRangeMatch(pointCand, rangeCand);
            if (comp > 0) {
                return true;
            }
            if (comp < 0) {
                return false;
            }
            double pcScore = this.getFieldScore(pointCand, FieldType.POST_CODE_FIELD_TYPE);
            if (pcScore >= this.getFieldScore(rangeCand, FieldType.POST_CODE_FIELD_TYPE)) {
                if (this.getFieldScore(pointCand, FieldType.STREET_NAME_FIELD_TYPE) >= this.getFieldScore(rangeCand, FieldType.STREET_NAME_FIELD_TYPE)) {
                    return pcScore >= 1.0 || this.getFieldScore(pointCand, FieldType.AREA_NAME_3_FIELD_TYPE) >= this.getFieldScore(rangeCand, FieldType.AREA_NAME_3_FIELD_TYPE);
                }
                if (this.isExactMatch(pointCand, FieldType.POST_CODE_FIELD_TYPE) && this.hasExactRangeFieldMatch(pointCand) && !this.isExactMatch(rangeCand, FieldType.POST_CODE_FIELD_TYPE)) {
                    return true;
                }
            }
        }
        return false;
    }

    private int compareExactPostCodeAndRangeMatch(InternalScoringAddress cand1, InternalScoringAddress cand2) {
        return this.countPostCodeAndRangeMatch(cand1) - this.countPostCodeAndRangeMatch(cand2);
    }

    private int countPostCodeAndRangeMatch(InternalScoringAddress cand) {
        int c = 0;
        if (this.isExactMatch(cand, FieldType.POST_CODE_FIELD_TYPE)) {
            ++c;
        }
        if (this.hasExactRangeFieldMatch(cand)) {
            ++c;
        }
        return c;
    }

    private boolean isExactMatch(InternalScoringAddress cand, FieldType type) {
        return this.getFieldScore(cand, type) >= 1.0;
    }

    private boolean hasExactRangeFieldMatch(InternalScoringAddress cand) {
        InternalScoringRange range = cand.getMatchedRange();
        if (range != null) {
            Map<FieldType, FieldScore> scores = range.getFieldScores();
            for (Map.Entry<FieldType, FieldScore> scoreEn : scores.entrySet()) {
                FieldScore score;
                if (scoreEn.getKey().getLevel() != FieldType.FieldLevel.LEVEL_RANGE || (score = scoreEn.getValue()) == null || !(score.m_value >= 1.0)) continue;
                return true;
            }
        }
        return false;
    }

    private int getFirstAddressPointCand(InternalCandidateList internalCandList) throws DataFetchException, CGGEDataIntializationException {
        int closeMatchCount = internalCandList.getNumberOfCloseMatches();
        for (int candNdx = 0; candNdx < closeMatchCount; ++candNdx) {
            if (GBR_Utils.isStreetRangeRecord(this.dm, internalCandList.getIndexedCandidate(candNdx))) continue;
            return candNdx;
        }
        return -1;
    }

    private void moveCandToTopAndDegradeOthers(int candAt, InternalCandidateList internalCandList) {
        List<InternalScoringAddress> candList = internalCandList.getCandidateList();
        InternalScoringAddress candToMove = candList.remove(candAt);
        candList.add(0, candToMove);
        int closeCandCount = internalCandList.getNumberOfCloseMatches();
        for (int candNdx = 1; candNdx < closeCandCount; ++candNdx) {
            internalCandList.getIndexedCandidate(candNdx).setCloseMatch(false);
        }
        internalCandList.setNumberOfCloseMatches(candToMove.isCloseMatch() ? 1 : 0);
    }

    private boolean isComparableToS3Cand(InternalScoringAddress s3Cand, InternalScoringAddress nonS3Cand) {
        if (s3Cand.getMatchedRange() != null) {
            return GBR_Utils.hasCloseMatchingField(nonS3Cand, FieldType.POST_CODE_FIELD_TYPE) && this.hasExactRangeFieldMatch(nonS3Cand);
        }
        if (GBR_Utils.hasCloseMatchingField(nonS3Cand, FieldType.STREET_NAME_FIELD_TYPE) && GBR_Utils.hasCloseMatchingField(nonS3Cand, FieldType.POST_CODE_FIELD_TYPE)) {
            return true;
        }
        if (GBR_Utils.hasCloseMatchingField(s3Cand, FieldType.STREET_NAME_FIELD_TYPE) && GBR_Utils.hasCloseMatchingField(s3Cand, FieldType.POST_CODE_FIELD_TYPE)) {
            return false;
        }
        return this.compareStreetCityAndPostcode(s3Cand, nonS3Cand);
    }

    private boolean compareStreetCityAndPostcode(InternalScoringAddress cand1, InternalScoringAddress cand2) {
        return this.getCombinedStreetCityAndPostcodeScore(cand2) < this.getCombinedStreetCityAndPostcodeScore(cand1) * 0.9;
    }

    private double getCombinedStreetCityAndPostcodeScore(InternalScoringAddress cand) {
        return this.getFieldScore(cand, FieldType.STREET_NAME_FIELD_TYPE) + this.getFieldScore(cand, FieldType.AREA_NAME_3_FIELD_TYPE) + this.getFieldScore(cand, FieldType.POST_CODE_FIELD_TYPE);
    }

    private double getFieldScore(InternalScoringAddress cand, FieldType type) {
        FieldScore score = cand.getFieldScore(type);
        return score == null ? 0.0 : score.m_value;
    }

    private int getFirstNonS3CloseCandNdx(InternalCandidateList internalCandList) throws DataFetchException, CGGEDataIntializationException {
        int closeMatchCount = internalCandList.getNumberOfCloseMatches();
        if (closeMatchCount > 0) {
            for (int nonS3CandNdx = 0; nonS3CandNdx < closeMatchCount; ++nonS3CandNdx) {
                if (this.isS3Cand(internalCandList.getIndexedCandidate(nonS3CandNdx), this.dm)) continue;
                return nonS3CandNdx;
            }
        }
        return -1;
    }

    private boolean isS3Cand(InternalScoringAddress cand, IDataManager dm) throws DataFetchException {
        boolean isS3 = CandidateS3Determinator.isS3(dm, cand);
        if (isS3 && GBR_Utils.getPointCount(dm, cand) > 0 && GBR_Utils.doesAllRangesHasSameUPRN(cand, dm)) {
            isS3 = false;
        } else {
            cand.setIsS3(isS3);
        }
        return isS3;
    }
}

