/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.GBR.convertor;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.GBR.GBR_Utils;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.cgge.AddressNumberScore;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.address.AdditionalFields;
import com.mapinfo.mapmarker.cgge.address.AddressNumber;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalAddress;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringRange;
import com.mapinfo.mapmarker.cgge.address.ScoringItem;
import com.mapinfo.mapmarker.cgge.convertor.CGGECandidateConvertor;
import com.mapinfo.mapmarker.cgge.convertor.CGGEFormatter;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import java.util.HashMap;
import java.util.Map;

public class GBR_CandidateConverter
extends CGGECandidateConvertor {
    private static final String BNG_COORDINATE = "epsg:27700";
    private static FieldType BNG_LONGITUDE = null;
    private static FieldType BNG_LATITUDE = null;

    @Override
    protected String getMatchedAddressNumber(InternalScoringRange range, AddressNumber inputNum, AddressNumberScore addrNumScore) {
        AddressNumber rangeNum = range.getFrom();
        return rangeNum == null ? null : rangeNum.toString();
    }

    @Override
    protected void copyMatchFlags(CandidateAddress candAddr, InternalScoringAddress scoringAddr, boolean isIntersection) {
        FieldScore score = scoringAddr.getFieldScore(FieldType.POST_CODE_FIELD_TYPE);
        if (score != null && score.m_matched) {
            AddressWord word;
            InternalFieldValue candValue = (InternalFieldValue)scoringAddr.getField(FieldType.POST_CODE_EX_FIELD_TYPE);
            AddressWord addressWord = word = score.m_matchedAltIndex >= 0 ? ((AddressWord[][])candValue.getAlternateValues())[score.m_matchedAltIndex][0] : ((AddressWord[])candValue.getFieldValue())[0];
            if (word == null || word.getWordLength() < 3) {
                score.m_matched = false;
            }
        }
        super.copyMatchFlags(candAddr, scoringAddr, isIntersection);
        this.recalculateAddressNumberMatch(candAddr, scoringAddr);
        this.checkDependentStreet(candAddr, scoringAddr, isIntersection);
    }

    void recalculateAddressNumberMatch(CandidateAddress candAddr, InternalScoringAddress scoringAddr) {
        FieldScore addrNumScore;
        if (!(candAddr.doesAddressNumberMatch() || (addrNumScore = scoringAddr.getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE)) != null && addrNumScore.m_candidateFieldPresent || !this.hasExactRangeMatch(scoringAddr))) {
            candAddr.setAddressNumberMatched();
        }
    }

    void checkDependentStreet(CandidateAddress candAddr, InternalScoringAddress scoringAddr, boolean isIntersection) {
        if (!candAddr.doesStreetNameMatch() && candAddr.getAdditionalFieldForKey("DEPENDENT_STREET") != null) {
            for (FieldType type : scoringAddr.getFieldScores().keySet()) {
                if (!"DEPENDENT_STREET".equals(type.getName())) continue;
                FieldScore score = scoringAddr.getFieldScore(type);
                this.handleStreetNameMatchFlags(score, candAddr, isIntersection);
                break;
            }
        }
    }

    boolean hasExactRangeMatch(InternalScoringAddress scoredAddr) {
        FieldType firmType;
        FieldType subBuildingField;
        boolean atLeastOneRangeFieldAvailable = false;
        FieldScore score = scoredAddr.getFieldScore(FieldType.RANGE_PLACE_NAME_FIELD_TYPE);
        if (!this.isMissingField(score)) {
            atLeastOneRangeFieldAvailable = true;
            if (!score.m_matched) {
                return false;
            }
        }
        if ((subBuildingField = this.getSubBuildingFieldType(scoredAddr)) != null && !this.isMissingField(score = scoredAddr.getFieldScore(subBuildingField))) {
            if (!(score.m_matched || atLeastOneRangeFieldAvailable && this.considerInputAsMissing(score))) {
                return false;
            }
            atLeastOneRangeFieldAvailable = true;
        }
        if (!(atLeastOneRangeFieldAvailable || this.hasAddressNumber(scoredAddr) || (firmType = this.getFirmNameFieldType(scoredAddr)) == null || this.isMissingField(score = scoredAddr.getFieldScore(firmType)))) {
            if (!(score.m_matched || atLeastOneRangeFieldAvailable && this.considerInputAsMissing(score))) {
                return false;
            }
            atLeastOneRangeFieldAvailable = true;
        }
        return atLeastOneRangeFieldAvailable;
    }

    private boolean hasAddressNumber(InternalScoringAddress addr) {
        if (addr.getRangeCount() > 0) {
            InternalScoringRange range = addr.getRangeAt(0);
            return range.getFrom() != null;
        }
        return false;
    }

    FieldType getSubBuildingFieldType(InternalScoringAddress addr) {
        return addr.getDataSetInfo().getMetaData().getFieldForName("sub_building_name");
    }

    FieldType getFirmNameFieldType(InternalScoringAddress addr) {
        return addr.getDataSetInfo().getMetaData().getFieldForName("firm_name");
    }

    private boolean isMissingField(FieldScore score) {
        return score == null || !score.m_candidateFieldPresent;
    }

    private boolean considerInputAsMissing(FieldScore score) {
        return score == null || score.m_value < 0.5;
    }

    @Override
    protected boolean doS3(CandidateAddress cand, IDataManager dataManager, InternalScoringAddress scoringAddress, boolean doS3) throws Exception {
        boolean s3cand = super.doS3(cand, dataManager, scoringAddress, doS3);
        if (this.shouldCheckAllRangesHasSameUPRN(s3cand, scoringAddress) && GBR_Utils.doesAllRangesHasSameUPRN(scoringAddress, dataManager)) {
            s3cand = false;
            cand.getAdditionalFields().remove("HASGEOM");
        }
        return s3cand;
    }

    protected boolean shouldCheckAllRangesHasSameUPRN(boolean isS3cand, InternalScoringAddress scoringAddress) {
        boolean hasPCFieldscore;
        if (!isS3cand) {
            return false;
        }
        boolean bl = hasPCFieldscore = scoringAddress.getFieldScore(FieldType.POST_CODE_FIELD_TYPE) != null;
        return !hasPCFieldscore || !(scoringAddress.getFieldScore((FieldType)FieldType.POST_CODE_FIELD_TYPE).m_value < 0.9);
    }

    @Override
    protected void interpolate(CandidateAddress candAddr, InternalScoringAddress scoringAddress, IDataManager dataManager, InternalScoringRange scoringRange, IConstraints constraints) throws Exception {
        boolean isCoordSysConverted = false;
        CoordSys toSys = constraints.getClientCoordinateSystemObject();
        String isBNGCoordSys = CoordSysUtilities.getSRSName((CoordSys)toSys);
        if (scoringAddress.getAddressType() == 1 && isBNGCoordSys.equalsIgnoreCase(BNG_COORDINATE)) {
            String[] coordinates = this.getBNGCoordinatesFromAdditioanlFields(scoringAddress, scoringRange, dataManager, this.getBNGLongtitueFieldType(scoringAddress));
            isCoordSysConverted = this.assignBNGCoordSysToWGS(candAddr, scoringRange, constraints, coordinates);
        }
        if (!isCoordSysConverted) {
            super.interpolate(candAddr, scoringAddress, dataManager, scoringRange, constraints);
        }
    }

    private String[] getBNGCoordinatesFromAdditioanlFields(InternalScoringAddress candAddress, InternalScoringRange scoringRange, IDataManager manager, FieldType additionalFieldKey) throws DataFetchException {
        InternalAddress add;
        AdditionalFields addFields;
        if (BNG_LONGITUDE == null && BNG_LATITUDE == null) {
            BNG_LONGITUDE = this.getBNGLongtitueFieldType(candAddress);
            BNG_LATITUDE = this.getBNGLatitudeFieldType(candAddress);
        }
        if ((addFields = manager.getAdditionalFields(add = scoringRange.getInternalAddress())) != null) {
            Map<Object, Object> field = new HashMap();
            field = addFields.getAdditionalFields();
            if (field != null) {
                String[] coordinates = new String[]{(String)field.get(BNG_LONGITUDE), (String)field.get(BNG_LATITUDE)};
                return coordinates;
            }
        }
        return null;
    }

    FieldType getBNGLongtitueFieldType(InternalScoringAddress addr) {
        return addr.getDataSetInfo().getMetaData().getFieldForName("LONGITUDE_BNG_X");
    }

    FieldType getBNGLatitudeFieldType(InternalScoringAddress addr) {
        return addr.getDataSetInfo().getMetaData().getFieldForName("LATITUDE_BNG_Y");
    }

    private boolean assignBNGCoordSysToWGS(CandidateAddress candAddr, InternalScoringRange scoringRange, IConstraints constraints, String[] coordinates) {
        if (coordinates[0] != null && coordinates[1] != null) {
            DirectPosition point = new DirectPosition();
            point.setX(Double.parseDouble(coordinates[0]));
            point.setY(Double.parseDouble(coordinates[1]));
            candAddr.setCoordSysString(BNG_COORDINATE);
            candAddr.setLocation(point);
            candAddr.setLocationPrecision(16);
            return true;
        }
        return false;
    }

    @Override
    protected void copyAddressFields(CandidateAddress candAddr, InternalScoringAddress scoringAddr, CGGEFormatter formatter, IDataManager dataManager, boolean intersection) throws DataFetchException, CGGEInternalException {
        this.checkPC(scoringAddr);
        super.copyAddressFields(candAddr, scoringAddr, formatter, dataManager, intersection);
    }

    private void checkPC(ScoringItem scoringAddr) {
        FieldScore pcScore = scoringAddr.getFieldScore(FieldType.POST_CODE_FIELD_TYPE);
        if (pcScore != null && pcScore.m_matchedAltIndex >= 0) {
            FieldScore score = new FieldScore();
            score.m_value = 1.0;
            score.m_matchedAltIndex = this.getBestAltPCUnit(pcScore, scoringAddr);
            scoringAddr.setFieldScore(FieldType.POST_CODE_EX_FIELD_TYPE, score);
        }
    }

    private int getBestAltPCUnit(FieldScore pcScore, ScoringItem scoringAddr) {
        if (!pcScore.m_matched && !GBR_Utils.hasFullPostCode(scoringAddr.getInternalAddress())) {
            return -1;
        }
        return pcScore.m_matchedAltIndex;
    }

    @Override
    protected CandidateAddress convertCandidate(InternalScoringAddress scoringAddress, IDataManager dataManager, CGGEFormatter formatter, IConstraints constraints) throws Exception {
        if ("true".equals(scoringAddress.getAdditionalInfo("POBOX_MATCH_IN_PROGRESS")) && !"true".equals(constraints.getCustomString("POBOX_MATCH_IN_PROGRESS"))) {
            constraints.setCustomString("POBOX_MATCH_IN_PROGRESS", "true");
        }
        return super.convertCandidate(scoringAddress, dataManager, formatter, constraints);
    }
}

